/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.Output;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.DayPeriodInfo;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PluralRulesUtil;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class LogicalGrouping {
    static final SupplementalDataInfo supplementalData = CLDRConfig.getInstance().getSupplementalDataInfo();
    public static final ImmutableSet<String> metazonesDSTSet = ImmutableSet.of("Acre", "Africa_Western", "Alaska", "Almaty", "Amazon", "America_Central", new String[]{"America_Eastern", "America_Mountain", "America_Pacific", "Anadyr", "Apia", "Aqtau", "Aqtobe", "Arabian", "Argentina", "Argentina_Western", "Armenia", "Atlantic", "Australia_Central", "Australia_CentralWestern", "Australia_Eastern", "Australia_Western", "Azerbaijan", "Azores", "Bangladesh", "Brasilia", "Cape_Verde", "Chatham", "Chile", "China", "Choibalsan", "Colombia", "Cook", "Cuba", "Easter", "Europe_Central", "Europe_Eastern", "Europe_Western", "Falkland", "Fiji", "Georgia", "Greenland_Eastern", "Greenland_Western", "Hawaii_Aleutian", "Hong_Kong", "Hovd", "Iran", "Irkutsk", "Israel", "Japan", "Kamchatka", "Korea", "Krasnoyarsk", "Lord_Howe", "Macau", "Magadan", "Mauritius", "Mexico_Northwest", "Mexico_Pacific", "Mongolia", "Moscow", "New_Caledonia", "New_Zealand", "Newfoundland", "Norfolk", "Noronha", "Novosibirsk", "Omsk", "Pakistan", "Paraguay", "Peru", "Philippines", "Pierre_Miquelon", "Qyzylorda", "Sakhalin", "Samara", "Samoa", "Taipei", "Tonga", "Turkmenistan", "Uruguay", "Uzbekistan", "Vanuatu", "Vladivostok", "Volgograd", "Yakutsk", "Yekaterinburg"});
    public static final ImmutableList<String> days = ImmutableList.of("sun", "mon", "tue", "wed", "thu", "fri", "sat");
    public static final ImmutableSet<String> calendarsWith13Months = ImmutableSet.of("coptic", "ethiopic", "hebrew");
    public static final ImmutableSet<String> compactDecimalFormatLengths = ImmutableSet.of("short", "long");
    private static final ImmutableSet<String> ampm = ImmutableSet.of("am", "pm");
    private static final ImmutableSet<String> nowUnits = ImmutableSet.of("second", "second-short", "second-narrow", "minute", "minute-short", "minute-narrow", new String[]{"hour", "hour-short", "hour-narrow"});
    private static Multimap<String, String> cachePathToLogicalGroup = ArrayListMultimap.create();
    private static ConcurrentHashMap<Pair<String, String>, Set<String>> cacheLocaleAndPathToLogicalGroup = new ConcurrentHashMap();
    public static final boolean GET_TYPE_COUNTS = false;
    public static final ConcurrentHashMap<String, Long> typeCount = null;
    private static final boolean GET_TYPE_FROM_PARTS = false;

    public static Set<String> getPaths(CLDRFile cldrFile, String path, Output<PathType> pathTypeOut) {
        if (path == null) {
            return null;
        }
        XPathParts parts = null;
        PathType pathType = null;
        pathType = PathType.getPathTypeFromPath(path);
        if (pathTypeOut != null) {
            pathTypeOut.value = pathType;
        }
        if (pathType == PathType.SINGLETON) {
            TreeSet<String> set = new TreeSet<String>();
            set.add(path);
            return set;
        }
        parts = XPathParts.getFrozenInstance(path).cloneAsThawed();
        if (PathType.isLocaleDependent(pathType)) {
            String locale = cldrFile.getLocaleID();
            Pair<String, String> key = new Pair<String, String>(locale, path);
            if (cacheLocaleAndPathToLogicalGroup.containsKey(key)) {
                return new TreeSet<String>((Collection)cacheLocaleAndPathToLogicalGroup.get(key));
            }
            TreeSet<String> set = new TreeSet<String>();
            pathType.addPaths(set, cldrFile, path, parts);
            cacheLocaleAndPathToLogicalGroup.put(key, set);
            return set;
        }
        if (cachePathToLogicalGroup.containsKey(path)) {
            return new TreeSet<String>(cachePathToLogicalGroup.get(path));
        }
        TreeSet<String> set = new TreeSet<String>();
        pathType.addPaths(set, cldrFile, path, parts);
        cachePathToLogicalGroup.putAll(path, set);
        return set;
    }

    public static Set<String> getPaths(CLDRFile cldrFile, String path) {
        return LogicalGrouping.getPaths(cldrFile, path, null);
    }

    private static SupplementalDataInfo.PluralInfo getPluralInfo(CLDRFile cldrFile) {
        return supplementalData.getPlurals(SupplementalDataInfo.PluralType.cardinal, cldrFile.getLocaleID());
    }

    public static boolean isOptional(CLDRFile cldrFile, String path) {
        PluralRulesUtil.KeywordStatus status;
        String pluralType;
        XPathParts parts = XPathParts.getFrozenInstance(path);
        if (parts.containsElement("relative")) {
            String fieldType = parts.findAttributeValue("field", "type");
            String relativeType = parts.findAttributeValue("relative", "type");
            Integer relativeValue = relativeType == null ? 999 : Integer.valueOf(relativeType);
            if (fieldType != null && fieldType.startsWith("day") && Math.abs(relativeValue) >= 2) {
                return true;
            }
        }
        if (!path.contains("[@count=")) {
            return false;
        }
        switch (pluralType = parts.getAttributeValue(-1, "count")) {
            case "0": 
            case "1": {
                return true;
            }
            case "zero": 
            case "one": {
                break;
            }
            default: {
                return false;
            }
        }
        parts = parts.cloneAsThawed();
        PluralRules pluralRules = LogicalGrouping.getPluralInfo(cldrFile).getPluralRules();
        parts.setAttribute(-1, "count", "0");
        HashSet<Double> explicits = new HashSet<Double>();
        if (cldrFile.isHere(parts.toString())) {
            explicits.add(0.0);
        }
        parts.setAttribute(-1, "count", "1");
        if (cldrFile.isHere(parts.toString())) {
            explicits.add(1.0);
        }
        return !explicits.isEmpty() && (status = PluralRulesUtil.getKeywordStatus(pluralRules, pluralType, 0, explicits, true)) == PluralRulesUtil.KeywordStatus.SUPPRESSED;
    }

    private static /* synthetic */ Long lambda$getPaths$0(String k, Long v) {
        return v == null ? 1L : v + 1L;
    }

    public static enum PathType {
        SINGLETON{

            @Override
            void addPaths(Set<String> set, CLDRFile cldrFile, String path, XPathParts parts) {
            }
        }
        ,
        METAZONE{

            @Override
            void addPaths(Set<String> set, CLDRFile cldrFile, String path, XPathParts parts) {
                String metazoneName = parts.getAttributeValue(3, "type");
                if (metazonesDSTSet.contains(metazoneName)) {
                    for (String str : ImmutableSet.of("generic", "standard", "daylight")) {
                        set.add(path.substring(0, path.lastIndexOf(47) + 1) + str);
                    }
                }
            }
        }
        ,
        DAYS{

            @Override
            void addPaths(Set<String> set, CLDRFile cldrFile, String path, XPathParts parts) {
                String dayName;
                String string = dayName = parts.size() > 7 ? parts.getAttributeValue(7, "type") : null;
                if (dayName != null && days.contains(dayName)) {
                    for (String str : days) {
                        parts.setAttribute("day", "type", str);
                        set.add(parts.toString());
                    }
                }
            }
        }
        ,
        DAY_PERIODS{

            @Override
            void addPaths(Set<String> set, CLDRFile cldrFile, String path, XPathParts parts) {
                block3: {
                    DayPeriodInfo.DayPeriod thisDayPeriod;
                    String dayPeriodType;
                    block4: {
                        block2: {
                            if (!parts.containsElement("alias")) break block2;
                            set.add(path);
                            break block3;
                        }
                        dayPeriodType = parts.findAttributeValue("dayPeriod", "type");
                        if (!ampm.contains(dayPeriodType)) break block4;
                        for (String s2 : ampm) {
                            parts.setAttribute("dayPeriod", "type", s2);
                            set.add(parts.toString());
                        }
                        break block3;
                    }
                    DayPeriodInfo.Type dayPeriodContext = DayPeriodInfo.Type.fromString(parts.findAttributeValue("dayPeriodContext", "type"));
                    DayPeriodInfo dpi = supplementalData.getDayPeriods(dayPeriodContext, cldrFile.getLocaleID());
                    List<DayPeriodInfo.DayPeriod> dayPeriods = dpi.getPeriods();
                    if (!dayPeriods.contains((Object)(thisDayPeriod = DayPeriodInfo.DayPeriod.fromString(dayPeriodType)))) break block3;
                    for (DayPeriodInfo.DayPeriod d : dayPeriods) {
                        parts.setAttribute("dayPeriod", "type", d.name());
                        set.add(parts.toString());
                    }
                }
            }
        }
        ,
        QUARTERS{

            @Override
            void addPaths(Set<String> set, CLDRFile cldrFile, String path, XPathParts parts) {
                String quarterName = parts.size() > 7 ? parts.getAttributeValue(7, "type") : null;
                Integer quarter = quarterName == null ? 0 : Integer.valueOf(quarterName);
                if (quarter > 0 && quarter <= 4) {
                    Integer i = 1;
                    while (i <= 4) {
                        parts.setAttribute("quarter", "type", i.toString());
                        set.add(parts.toString());
                        Integer n = i;
                        i = i + 1;
                    }
                }
            }
        }
        ,
        MONTHS{

            @Override
            void addPaths(Set<String> set, CLDRFile cldrFile, String path, XPathParts parts) {
                int calendarMonthMax;
                String calType = parts.size() > 3 ? parts.getAttributeValue(3, "type") : null;
                String monthName = parts.size() > 7 ? parts.getAttributeValue(7, "type") : null;
                Integer month = monthName == null ? 0 : Integer.valueOf(monthName);
                int n = calendarMonthMax = calendarsWith13Months.contains(calType) ? 13 : 12;
                if (month > 0 && month <= calendarMonthMax) {
                    Integer i = 1;
                    while (i <= calendarMonthMax) {
                        parts.setAttribute("month", "type", i.toString());
                        if ("hebrew".equals(calType)) {
                            parts.removeAttribute("month", "yeartype");
                        }
                        set.add(parts.toString());
                        Integer n2 = i;
                        i = i + 1;
                    }
                    if ("hebrew".equals(calType)) {
                        parts.setAttribute("month", "type", Integer.toString(7));
                        parts.setAttribute("month", "yeartype", "leap");
                        set.add(parts.toString());
                    }
                }
            }
        }
        ,
        RELATIVE{

            @Override
            void addPaths(Set<String> set, CLDRFile cldrFile, String path, XPathParts parts) {
                String fieldType = parts.findAttributeValue("field", "type");
                String relativeType = parts.findAttributeValue("relative", "type");
                Integer relativeValue = relativeType == null ? 999 : Integer.valueOf(relativeType);
                if (!(relativeValue < -3 || relativeValue > 3 || nowUnits.contains(fieldType) && relativeValue == 0)) {
                    int limit = 1;
                    if (fieldType != null && fieldType.startsWith("day")) {
                        limit = 3;
                    }
                    Integer i = -1 * limit;
                    while (i <= limit) {
                        parts.setAttribute("relative", "type", i.toString());
                        set.add(parts.toString());
                        Integer n = i;
                        i = i + 1;
                    }
                }
            }
        }
        ,
        DECIMAL_FORMAT_LENGTH{

            @Override
            void addPaths(Set<String> set, CLDRFile cldrFile, String path, XPathParts parts) {
                String decimalFormatPatternType;
                SupplementalDataInfo.PluralInfo pluralInfo = LogicalGrouping.getPluralInfo(cldrFile);
                Set<SupplementalDataInfo.PluralInfo.Count> pluralTypes = pluralInfo.getCounts();
                String decimalFormatLengthType = parts.size() > 3 ? parts.getAttributeValue(3, "type") : null;
                String string = decimalFormatPatternType = parts.size() > 5 ? parts.getAttributeValue(5, "type") : null;
                if (decimalFormatLengthType != null && decimalFormatPatternType != null && compactDecimalFormatLengths.contains(decimalFormatLengthType)) {
                    int numZeroes = decimalFormatPatternType.length() - 1;
                    int baseZeroes = numZeroes / 3 * 3;
                    for (int i = 0; i < 3; ++i) {
                        String patType = "1" + String.format(String.format("%%0%dd", baseZeroes + i), 0);
                        parts.setAttribute(5, "type", patType);
                        for (SupplementalDataInfo.PluralInfo.Count count : pluralTypes) {
                            parts.setAttribute(5, "count", count.toString());
                            set.add(parts.toString());
                        }
                    }
                }
            }
        }
        ,
        COUNT{

            @Override
            void addPaths(Set<String> set, CLDRFile cldrFile, String path, XPathParts parts) {
                this.addCaseOnly(set, cldrFile, parts);
            }
        }
        ,
        COUNT_CASE{

            @Override
            void addPaths(Set<String> set, CLDRFile cldrFile, String path, XPathParts parts) {
                if (!GrammarInfo.getGrammarLocales().contains(cldrFile.getLocaleID())) {
                    this.addCaseOnly(set, cldrFile, parts);
                    return;
                }
                GrammarInfo grammarInfo = supplementalData.getGrammarInfo(cldrFile.getLocaleID());
                if (grammarInfo == null || parts.getElement(3).equals("unitLength") && GrammarInfo.getUnitsToAddGrammar().contains(parts.getAttributeValue(3, "type"))) {
                    this.addCaseOnly(set, cldrFile, parts);
                    return;
                }
                Set<SupplementalDataInfo.PluralInfo.Count> pluralTypes = LogicalGrouping.getPluralInfo(cldrFile).getCounts();
                Collection<String> rawCases = grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalCase, GrammarInfo.GrammaticalScope.units);
                this.setGrammarAttributes(set, parts, pluralTypes, rawCases, null);
            }
        }
        ,
        COUNT_CASE_GENDER{

            @Override
            void addPaths(Set<String> set, CLDRFile cldrFile, String path, XPathParts parts) {
                if (!GrammarInfo.getGrammarLocales().contains(cldrFile.getLocaleID())) {
                    this.addCaseOnly(set, cldrFile, parts);
                    return;
                }
                GrammarInfo grammarInfo = supplementalData.getGrammarInfo(cldrFile.getLocaleID());
                if (grammarInfo == null) {
                    this.addCaseOnly(set, cldrFile, parts);
                    return;
                }
                Set<SupplementalDataInfo.PluralInfo.Count> pluralTypes = LogicalGrouping.getPluralInfo(cldrFile).getCounts();
                Collection<String> rawCases = grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalCase, GrammarInfo.GrammaticalScope.units);
                Collection<String> rawGenders = grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalGender, GrammarInfo.GrammaticalScope.units);
                this.setGrammarAttributes(set, parts, pluralTypes, rawCases, rawGenders);
            }
        };


        abstract void addPaths(Set<String> var1, CLDRFile var2, String var3, XPathParts var4);

        public void addCaseOnly(Set<String> set, CLDRFile cldrFile, XPathParts parts) {
            Set<SupplementalDataInfo.PluralInfo.Count> pluralTypes = LogicalGrouping.getPluralInfo(cldrFile).getCounts();
            for (SupplementalDataInfo.PluralInfo.Count count : pluralTypes) {
                parts.setAttribute(-1, "count", count.toString());
                set.add(parts.toString());
            }
        }

        public void setGrammarAttributes(Set<String> set, XPathParts parts, Set<SupplementalDataInfo.PluralInfo.Count> pluralTypes, Collection<String> rawCases, Collection<String> rawGenders) {
            String defaultGender = GrammarInfo.GrammaticalFeature.grammaticalGender.getDefault(rawGenders);
            String defaultCase = GrammarInfo.GrammaticalFeature.grammaticalCase.getDefault(rawCases);
            if (rawCases == null || rawCases.isEmpty()) {
                rawCases = Collections.singleton(defaultCase);
            }
            if (rawGenders == null || rawGenders.isEmpty()) {
                rawGenders = Collections.singleton(defaultGender);
            }
            for (String gender : rawGenders) {
                if (gender.equals(defaultGender)) {
                    gender = null;
                }
                for (String case1 : rawCases) {
                    if (case1.equals(defaultCase)) {
                        case1 = null;
                    }
                    for (SupplementalDataInfo.PluralInfo.Count count : pluralTypes) {
                        parts.setAttribute(-1, "gender", gender);
                        parts.setAttribute(-1, "count", count.toString());
                        parts.setAttribute(-1, "case", case1);
                        set.add(parts.toString());
                    }
                }
            }
        }

        private static boolean isLocaleDependent(PathType pathType) {
            return pathType == COUNT || pathType == DAY_PERIODS || pathType.equals((Object)COUNT_CASE) || pathType.equals((Object)COUNT_CASE_GENDER);
        }

        public static PathType getPathTypeFromPath(String path) {
            if (path.indexOf("/metazone") > 0) {
                return METAZONE;
            }
            if (path.indexOf("/days") > 0) {
                return DAYS;
            }
            if (path.indexOf("/dayPeriods") > 0) {
                return DAY_PERIODS;
            }
            if (path.indexOf("/quarters") > 0) {
                return QUARTERS;
            }
            if (path.indexOf("/months") > 0) {
                return MONTHS;
            }
            if (path.indexOf("/relative[") > 0) {
                return RELATIVE;
            }
            if (path.indexOf("/decimalFormatLength") > 0) {
                return DECIMAL_FORMAT_LENGTH;
            }
            if (path.indexOf("/unitLength[@type=\"long\"]") > 0) {
                if (path.indexOf("compoundUnitPattern1") > 0) {
                    return COUNT_CASE_GENDER;
                }
                if (path.indexOf("/unitPattern[") > 0) {
                    return COUNT_CASE;
                }
            }
            if (path.indexOf("[@count=") > 0) {
                return COUNT;
            }
            return SINGLETON;
        }

        @Deprecated
        private static PathType getPathTypeFromParts(XPathParts parts) {
            throw new UnsupportedOperationException("Code not updated. We may want to try using XPathParts in a future optimization, so leaving for now.");
        }
    }
}

