/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.With;

public final class FileUtilities {
    public static final boolean SHOW_FILES;
    public static final PrintWriter CONSOLE;
    private static PrintWriter log;
    public static final Pattern SEMI_SPLIT;
    private static final boolean SHOW_SKIP = false;

    public static BufferedReader openUTF8Reader(String dir, String filename) throws IOException {
        return FileUtilities.openReader(dir, filename, "UTF-8");
    }

    public static BufferedReader openUTF8Reader(File file) throws IOException {
        return FileUtilities.openReader(file, "UTF-8");
    }

    public static BufferedReader openReader(String dir, String filename, String encoding) throws IOException {
        File file = dir.length() == 0 ? new File(filename) : new File(dir, filename);
        return FileUtilities.openReader(file, encoding);
    }

    private static BufferedReader openReader(File file, String encoding) throws UnsupportedEncodingException, FileNotFoundException {
        if (SHOW_FILES && log != null) {
            log.println("Opening File: " + PathUtilities.getNormalizedPathString(file));
        }
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding), 4096);
    }

    public static PrintWriter openUTF8Writer(String dir, String filename) throws IOException {
        return FileUtilities.openWriter(dir, filename, StandardCharsets.UTF_8);
    }

    public static PrintWriter openUTF8Writer(File dir, String filename) throws IOException {
        return FileUtilities.openWriter(dir, filename, StandardCharsets.UTF_8);
    }

    public static PrintWriter openUTF8Writer(File file) throws IOException {
        return FileUtilities.openWriter(file, StandardCharsets.UTF_8);
    }

    public static PrintWriter openWriter(File dir, String filename, Charset encoding) throws IOException {
        File file = dir == null ? new File(filename) : new File(dir, filename);
        return FileUtilities.openWriter(file, encoding);
    }

    private static PrintWriter openWriter(File file, Charset encoding) throws IOException {
        String parentName;
        if (SHOW_FILES && log != null) {
            log.println("Creating File: " + PathUtilities.getNormalizedPathString(file));
        }
        if ((parentName = file.getParent()) != null) {
            File parent = new File(parentName);
            parent.mkdirs();
        }
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding), 4096));
    }

    public static PrintWriter openWriter(String dir, String filename, String encoding) throws IOException {
        return FileUtilities.openWriter(new File(dir), filename, Charset.forName(encoding));
    }

    public static PrintWriter openWriter(String dir, String filename, Charset encoding) throws IOException {
        return FileUtilities.openWriter(new File(dir), filename, encoding);
    }

    public static BufferedReader openFile(Class<?> class1, String file) {
        return FileUtilities.openFile(class1, file, StandardCharsets.UTF_8);
    }

    public static BufferedReader openFile(Class<?> class1, String file, Charset charset) {
        try {
            InputStream resourceAsStream = class1.getResourceAsStream(file);
            if (charset == null) {
                charset = StandardCharsets.UTF_8;
            }
            InputStreamReader reader = new InputStreamReader(resourceAsStream, charset);
            BufferedReader bufferedReader = new BufferedReader(reader, 65536);
            return bufferedReader;
        }
        catch (Exception e) {
            String className = class1 == null ? null : class1.getCanonicalName();
            String normalizedPath = null;
            try {
                String relativeFileName = FileUtilities.getRelativeFileName(class1, "../util/");
                normalizedPath = PathUtilities.getNormalizedPathString(relativeFileName, new String[0]);
            }
            catch (Exception e1) {
                throw new ICUUncheckedIOException("Couldn't open file: " + file + "; relative to class: " + className, e);
            }
            throw new ICUUncheckedIOException("Couldn't open file " + file + "; in path " + normalizedPath + "; relative to class: " + className, e);
        }
    }

    public static BufferedReader openFile(String directory, String file, Charset charset) {
        try {
            if (directory.equals("")) {
                return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(file)), charset));
            }
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(directory, file)), charset));
        }
        catch (FileNotFoundException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    public static BufferedReader openFile(File file, Charset charset) {
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
        }
        catch (FileNotFoundException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    public static BufferedReader openFile(File file) {
        return FileUtilities.openFile(file, StandardCharsets.UTF_8);
    }

    public static BufferedReader openFile(String directory, String file) {
        return FileUtilities.openFile(directory, file, StandardCharsets.UTF_8);
    }

    public static String[] splitCommaSeparated(String line) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder item = new StringBuilder();
        boolean inQuote = false;
        block4: for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            switch (ch) {
                case '\"': {
                    boolean bl = inQuote = !inQuote;
                    if (!inQuote || item.length() == 0) continue block4;
                    item.append('\"');
                    inQuote = true;
                    continue block4;
                }
                case ',': {
                    if (!inQuote) {
                        result.add(item.toString());
                        item.setLength(0);
                        continue block4;
                    }
                    item.append(ch);
                    continue block4;
                }
                default: {
                    item.append(ch);
                }
            }
        }
        result.add(item.toString());
        return result.toArray(new String[result.size()]);
    }

    public static void appendFile(Class<?> class1, String filename, PrintWriter out) {
        FileUtilities.appendFile(class1, filename, StandardCharsets.UTF_8, null, out);
    }

    public static void appendFile(Class<?> class1, String filename, String[] replacementList, PrintWriter out) {
        FileUtilities.appendFile(class1, filename, StandardCharsets.UTF_8, replacementList, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendFile(Class<?> class1, String filename, Charset charset, String[] replacementList, PrintWriter out) {
        BufferedReader br = FileUtilities.openFile(class1, filename, charset);
        try {
            try {
                FileUtilities.appendBufferedReader(br, out, replacementList);
            }
            finally {
                br.close();
            }
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    public static void appendFile(String filename, String encoding, PrintWriter output) throws IOException {
        FileUtilities.appendFile(filename, encoding, output, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendFile(String filename, String encoding, PrintWriter output, String[] replacementList) throws IOException {
        try (BufferedReader br = FileUtilities.openReader("", filename, encoding);){
            FileUtilities.appendBufferedReader(br, output, replacementList);
        }
    }

    public static void appendBufferedReader(BufferedReader br, PrintWriter output, String[] replacementList) throws IOException {
        String line;
        while ((line = br.readLine()) != null) {
            if (replacementList != null) {
                for (int i = 0; i < replacementList.length; i += 2) {
                    line = FileUtilities.replace(line, replacementList[i], replacementList[i + 1]);
                }
            }
            output.println(line);
        }
        br.close();
    }

    public static String replace(String source, String piece, String replacement) {
        if (source == null || source.length() < piece.length()) {
            return source;
        }
        int pos = 0;
        while ((pos = source.indexOf(piece, pos)) >= 0) {
            source = source.substring(0, pos) + replacement + source.substring(pos + piece.length());
            pos += replacement.length();
        }
        return source;
    }

    public static String replace(String source, String[][] replacements) {
        return FileUtilities.replace(source, replacements, replacements.length);
    }

    public static String replace(String source, String[][] replacements, int count) {
        for (int i = 0; i < count; ++i) {
            source = FileUtilities.replace(source, replacements[i][0], replacements[i][1]);
        }
        return source;
    }

    public static String replace(String source, String[][] replacements, boolean reverse) {
        if (!reverse) {
            return FileUtilities.replace(source, replacements);
        }
        for (int i = 0; i < replacements.length; ++i) {
            source = FileUtilities.replace(source, replacements[i][1], replacements[i][0]);
        }
        return source;
    }

    public static String anchorize(String source) {
        String result = source.toLowerCase(Locale.ENGLISH).replaceAll("[^\\p{L}\\p{N}]+", "_");
        if (result.endsWith("_")) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.startsWith("_")) {
            result = result.substring(1);
        }
        return result;
    }

    public static void copyFile(Class<?> class1, String sourceFile, String targetDirectory) {
        FileUtilities.copyFile(class1, sourceFile, targetDirectory, sourceFile, null);
    }

    public static void copyFile(Class<?> class1, String sourceFile, String targetDirectory, String newName) {
        FileUtilities.copyFile(class1, sourceFile, targetDirectory, newName, null);
    }

    public static void copyFile(Class<?> class1, String sourceFile, String targetDirectory, String newName, String[] replacementList) {
        try {
            PrintWriter out = FileUtilities.openUTF8Writer(targetDirectory, newName);
            FileUtilities.appendFile(class1, sourceFile, StandardCharsets.UTF_8, replacementList, out);
            out.close();
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    public static String getRelativeFileName(Class<?> class1, String filename) {
        URL resource = class1.getResource(filename);
        String resourceString = resource.toString();
        if (resourceString.startsWith("file:")) {
            return resourceString.substring(5);
        }
        if (resourceString.startsWith("jar:file:")) {
            return resourceString.substring(9);
        }
        throw new ICUUncheckedIOException("File not found: " + resourceString);
    }

    public static Iterable<String> in(Class<?> class1, String file) {
        return With.in(new With.SimpleIterator[]{new FileLines(FileUtilities.openFile(class1, file, StandardCharsets.UTF_8))});
    }

    public static Iterable<String> in(Class<?> class1, String file, Charset charset) {
        return With.in(new With.SimpleIterator[]{new FileLines(FileUtilities.openFile(class1, file, charset))});
    }

    public static Iterable<String> in(String directory, String file) {
        return With.in(new With.SimpleIterator[]{new FileLines(FileUtilities.openFile(directory, file, StandardCharsets.UTF_8))});
    }

    public static Iterable<String> in(BufferedReader reader) {
        return With.in(new With.SimpleIterator[]{new FileLines(reader)});
    }

    public static Iterable<String> in(String directory, String file, Charset charset) {
        return With.in(new With.SimpleIterator[]{new FileLines(FileUtilities.openFile(directory, file, charset))});
    }

    public static String cleanLine(String line) {
        int comment = line.indexOf("#");
        if (comment >= 0) {
            line = line.substring(0, comment);
        }
        if (line.startsWith("\ufeff")) {
            line = line.substring(1);
        }
        return line.trim();
    }

    public static String[] cleanSemiFields(String line) {
        return (line = FileUtilities.cleanLine(line)).isEmpty() ? null : SEMI_SPLIT.split(line);
    }

    public static void handleFile(String filename, LineHandler handler) throws IOException {
        String line;
        BufferedReader in = CldrUtility.getUTF8Data(filename);
        while ((line = in.readLine()) != null) {
            try {
                if (handler.handle(line)) continue;
            }
            catch (Exception e) {
                throw new ICUUncheckedIOException("Problem with line: " + line, e);
            }
        }
        in.close();
    }

    public static Iterable<String> in(File file) {
        return With.in(new With.SimpleIterator[]{new FileLines(FileUtilities.openFile(file, StandardCharsets.UTF_8))});
    }

    static {
        boolean showFiles = false;
        try {
            showFiles = System.getProperty("SHOW_FILES") != null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        SHOW_FILES = showFiles;
        log = CONSOLE = new PrintWriter(System.out, true);
        SEMI_SPLIT = PatternCache.get("\\s*;\\s*");
    }

    public static interface LineHandler {
        public boolean handle(String var1) throws Exception;
    }

    private static class FileLines
    implements With.SimpleIterator<String> {
        private BufferedReader input;

        public FileLines(BufferedReader input) {
            this.input = input;
        }

        @Override
        public String next() {
            try {
                String result = this.input.readLine();
                if (result == null) {
                    this.input.close();
                }
                return result;
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException(e);
            }
        }
    }

    public static class FileProcessor {
        private int lineCount;

        protected void handleStart() {
        }

        protected boolean handleLine(int lineCount, String line) {
            return true;
        }

        protected void handleEnd() {
        }

        public int getLineCount() {
            return this.lineCount;
        }

        public void handleComment(String line, int commentCharPosition) {
        }

        public FileProcessor process(Class<?> classLocation, String fileName) {
            try {
                BufferedReader in = FileUtilities.openFile(classLocation, fileName);
                return this.process(in, fileName);
            }
            catch (Exception e) {
                throw new ICUUncheckedIOException(this.lineCount + ":\t" + 0, e);
            }
        }

        public FileProcessor process(String fileName) {
            try {
                FileInputStream fileStream = new FileInputStream(fileName);
                InputStreamReader reader = new InputStreamReader((InputStream)fileStream, StandardCharsets.UTF_8);
                BufferedReader bufferedReader = new BufferedReader(reader, 65536);
                return this.process(bufferedReader, fileName);
            }
            catch (Exception e) {
                throw new ICUUncheckedIOException(this.lineCount + ":\t" + 0, e);
            }
        }

        public FileProcessor process(String directory, String fileName) {
            try {
                FileInputStream fileStream = new FileInputStream(directory + File.separator + fileName);
                InputStreamReader reader = new InputStreamReader((InputStream)fileStream, StandardCharsets.UTF_8);
                BufferedReader bufferedReader = new BufferedReader(reader, 65536);
                return this.process(bufferedReader, fileName);
            }
            catch (Exception e) {
                throw new ICUUncheckedIOException(this.lineCount + ":\t" + 0, e);
            }
        }

        public FileProcessor process(BufferedReader in, String fileName) {
            this.handleStart();
            String line = null;
            this.lineCount = 1;
            try {
                while ((line = in.readLine()) != null) {
                    int comment = line.indexOf("#");
                    if (comment >= 0) {
                        this.handleComment(line, comment);
                        line = line.substring(0, comment);
                    }
                    if (line.startsWith("\ufeff")) {
                        line = line.substring(1);
                    }
                    if ((line = line.trim()).length() != 0 && !this.handleLine(this.lineCount, line)) break;
                    ++this.lineCount;
                }
                in.close();
                this.handleEnd();
            }
            catch (Exception e) {
                throw new ICUUncheckedIOException(this.lineCount + ":\t" + line, e);
            }
            return this;
        }
    }

    public static abstract class SemiFileReader
    extends FileProcessor {
        public static final Pattern SPLIT = PatternCache.get("\\s*;\\s*");

        protected abstract boolean handleLine(int var1, int var2, int var3, String[] var4);

        @Override
        protected void handleEnd() {
        }

        protected boolean isCodePoint() {
            return true;
        }

        protected String[] splitLine(String line) {
            return SPLIT.split(line);
        }

        @Override
        protected boolean handleLine(int lineCount, String line) {
            int end;
            int start;
            String[] parts = this.splitLine(line);
            if (this.isCodePoint()) {
                String source = parts[0];
                int range = source.indexOf("..");
                if (range >= 0) {
                    start = Integer.parseInt(source.substring(0, range), 16);
                    end = Integer.parseInt(source.substring(range + 2), 16);
                } else {
                    start = end = Integer.parseInt(source, 16);
                }
            } else {
                end = -1;
                start = -1;
            }
            return this.handleLine(lineCount, start, end, parts);
        }
    }
}

