/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class KeyboardSettings {
    private final FallbackSetting fallbackSetting;
    private final TransformFailureSetting transformFailureSetting;
    private final TransformPartialSetting transformPartialSetting;

    private KeyboardSettings(FallbackSetting fallbackSetting, TransformFailureSetting transformFailureSetting, TransformPartialSetting transformPartialSetting) {
        this.fallbackSetting = Preconditions.checkNotNull(fallbackSetting);
        this.transformFailureSetting = Preconditions.checkNotNull(transformFailureSetting);
        this.transformPartialSetting = Preconditions.checkNotNull(transformPartialSetting);
    }

    public static KeyboardSettings of(FallbackSetting fallbackSetting, TransformFailureSetting transformFailureSetting, TransformPartialSetting transformPartialSetting) {
        return new KeyboardSettings(fallbackSetting, transformFailureSetting, transformPartialSetting);
    }

    public FallbackSetting fallbackSetting() {
        return this.fallbackSetting;
    }

    public TransformFailureSetting transformFailureSetting() {
        return this.transformFailureSetting;
    }

    public TransformPartialSetting transformPartialSetting() {
        return this.transformPartialSetting;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("fallbackSetting", (Object)this.fallbackSetting).add("transformFailureSetting", (Object)this.transformFailureSetting).add("transformPartialSetting", (Object)this.transformPartialSetting).toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KeyboardSettings) {
            KeyboardSettings other = (KeyboardSettings)o;
            return Objects.equal((Object)this.fallbackSetting, (Object)other.fallbackSetting) && Objects.equal((Object)this.transformFailureSetting, (Object)other.transformFailureSetting) && Objects.equal((Object)this.transformPartialSetting, (Object)other.transformPartialSetting);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.fallbackSetting, this.transformFailureSetting, this.transformPartialSetting});
    }

    public static enum TransformPartialSetting {
        HIDE,
        SHOW,
        NONE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum TransformFailureSetting {
        EMIT,
        OMIT,
        NONE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum FallbackSetting {
        BASE,
        OMIT,
        NONE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

