/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.locale.XCldrStub;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.Output;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.unicode.cldr.test.ExampleGenerator;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.UnitConverter;
import org.unicode.cldr.util.UnitPathType;

public class BestMinimalPairSamples {
    public static final String EQUALS_NOMINATIVE = "\uff1dnominative";
    private static final Joiner PLUS_JOINER = Joiner.on("+");
    private static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    private static final SupplementalDataInfo supplementalDataInfo = SupplementalDataInfo.getInstance();
    private final CLDRFile cldrFile;
    private final GrammarInfo grammarInfo;
    private final PluralRules pluralInfo;
    private final PluralRules ordinalInfo;
    private final ICUServiceBuilder icuServiceBuilder;
    private CaseAndGenderSamples caseAndGenderSamples = null;
    private Multimap<String, String> genderToUnits;
    private Multimap<Integer, String> uniqueCaseAndCountToUnits;
    private Multimap<String, String> distinctNominativeCaseToUnit;
    private final boolean gatherStats;
    static final Set<String> SKIP_CASE = ImmutableSet.of("concentr-ofglucose", "concentr-portion", "length-100-kilometer", "pressure-ofhg");
    static final Set<String> WORSE = ImmutableSet.of("length-100-kilometer", "length-mile-scandinavian");

    public BestMinimalPairSamples(CLDRFile cldrFile, ICUServiceBuilder icuServiceBuilder, boolean gatherStats) {
        this.cldrFile = cldrFile;
        this.grammarInfo = supplementalDataInfo.getGrammarInfo(cldrFile.getLocaleID());
        this.pluralInfo = supplementalDataInfo.getPlurals(SupplementalDataInfo.PluralType.cardinal, cldrFile.getLocaleID()).getPluralRules();
        this.ordinalInfo = supplementalDataInfo.getPlurals(SupplementalDataInfo.PluralType.ordinal, cldrFile.getLocaleID()).getPluralRules();
        this.icuServiceBuilder = icuServiceBuilder;
        this.genderToUnits = TreeMultimap.create();
        this.uniqueCaseAndCountToUnits = TreeMultimap.create();
        this.gatherStats = gatherStats;
    }

    public synchronized String getBestUnitWithGender(String gender, Output<String> shortUnitId) {
        if (gender == null || this.grammarInfo == null) {
            return null;
        }
        if (this.caseAndGenderSamples == null) {
            this.caseAndGenderSamples = this.loadCaches();
        }
        return this.caseAndGenderSamples.getGender(gender, shortUnitId);
    }

    public synchronized String getBestUnitWithCase(String unitCase, Output<String> shortUnitId) {
        if (unitCase == null || this.grammarInfo == null) {
            return null;
        }
        if (this.caseAndGenderSamples == null) {
            this.caseAndGenderSamples = this.loadCaches();
        }
        return this.caseAndGenderSamples.getCase(unitCase, shortUnitId);
    }

    /*
     * Could not resolve type clashes
     */
    public CaseAndGenderSamples loadCaches() {
        Collection<String> unitCases = this.grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalCase, GrammarInfo.GrammaticalScope.units);
        HashMap<String, String> genderResults = Maps.newHashMap();
        TreeMultimap unitPatternToCaseAndCounts = TreeMultimap.create();
        this.distinctNominativeCaseToUnit = TreeMultimap.create();
        int bestCaseFormCount = 0;
        String bestCaseUnitId = null;
        TreeMultimap bestUnitPatternToCases = null;
        TreeMultimap<Object, String> unitToDistinctNominativeCase = TreeMultimap.create();
        for (String longUnitId : GrammarInfo.getUnitsToAddGrammar()) {
            int diff;
            Iterator unitCase2;
            String possibleGender = this.cldrFile.getStringValue("//ldml/units/unitLength[@type=\"long\"]/unit[@type=\"" + longUnitId + "\"]/gender");
            String shortUnitId = ExampleGenerator.UNIT_CONVERTER.getShortId(longUnitId);
            if (shortUnitId.equals("hour") && this.cldrFile.getLocaleID().equals("ta")) {
                boolean bl = false;
            }
            if (possibleGender != null) {
                String formerLongUnitId;
                if (this.gatherStats) {
                    this.genderToUnits.put(possibleGender, shortUnitId);
                }
                if ((formerLongUnitId = (String)genderResults.get(possibleGender)) == null || this.isBetterUnit(longUnitId, formerLongUnitId)) {
                    genderResults.put(possibleGender, longUnitId);
                }
            }
            if (unitCases.isEmpty()) continue;
            unitPatternToCaseAndCounts.clear();
            for (String count : this.pluralInfo.getKeywords()) {
                for (Iterator unitCase2 : unitCases) {
                    String grammarAttributes = GrammarInfo.getGrammaticalInfoAttributes(this.grammarInfo, UnitPathType.unit, count, null, (String)((Object)unitCase2));
                    String unitPattern = this.cldrFile.getStringValue("//ldml/units/unitLength[@type=\"long\"]/unit[@type=\"" + longUnitId + "\"]/unitPattern" + grammarAttributes);
                    if (unitPattern == null) continue;
                    unitPattern = unitPattern.replace("\u00a0", "").trim();
                    Pair caseAndCount = Pair.of(unitCase2, count);
                    unitPatternToCaseAndCounts.put(unitPattern, caseAndCount);
                }
            }
            int caseFormCount = unitPatternToCaseAndCounts.keySet().size();
            boolean alwaysSameAsNominative = true;
            TreeMultimap caseAndCountToPattern = Multimaps.invertFrom(unitPatternToCaseAndCounts, TreeMultimap.create());
            for (Map.Entry entry : caseAndCountToPattern.entries()) {
                Pair nomPair;
                SortedSet nomPatterns;
                Pair caseAndCount = (Pair)entry.getKey();
                String pattern = (String)entry.getValue();
                String gCase = (String)caseAndCount.getFirst();
                if (gCase.equals("nominative") || (nomPatterns = caseAndCountToPattern.get(nomPair = Pair.of("nominative", caseAndCount.getSecond()))).contains(pattern)) continue;
                unitToDistinctNominativeCase.put(shortUnitId, gCase);
                alwaysSameAsNominative = false;
            }
            unitCase2 = unitToDistinctNominativeCase.asMap().entrySet().iterator();
            while (unitCase2.hasNext()) {
                Map.Entry entry;
                entry = unitCase2.next();
                this.distinctNominativeCaseToUnit.put(PLUS_JOINER.join(entry.getValue()), (String)entry.getKey());
            }
            if (alwaysSameAsNominative) {
                this.distinctNominativeCaseToUnit.put(EQUALS_NOMINATIVE, shortUnitId);
            }
            if (this.gatherStats && !SKIP_CASE.contains(longUnitId)) {
                this.uniqueCaseAndCountToUnits.put(caseFormCount, shortUnitId);
            }
            if ((diff = caseFormCount - bestCaseFormCount) <= 0 && (diff != 0 || !this.isBetterUnit(longUnitId, bestCaseUnitId))) continue;
            bestCaseFormCount = caseFormCount;
            bestCaseUnitId = longUnitId;
            bestUnitPatternToCases = TreeMultimap.create(unitPatternToCaseAndCounts);
        }
        Map<String, String> caseCache = this.getBestCasePatterns(bestUnitPatternToCases);
        SupplementalDataInfo.PluralInfo.Count count = this.pluralInfo.getKeywords().contains("one") ? SupplementalDataInfo.PluralInfo.Count.one : SupplementalDataInfo.PluralInfo.Count.other;
        HashMap result2 = Maps.newHashMap();
        for (Map.Entry entry : genderResults.entrySet()) {
            String longUnitId = (String)entry.getValue();
            String unitPattern = this.cldrFile.getStringValue("//ldml/units/unitLength[@type=\"long\"]/unit[@type=\"" + longUnitId + "\"]/unitPattern[@count=\"" + (Object)((Object)count) + "\"]");
            unitPattern = unitPattern.replace("{0}", "").replace("\u00a0", "").trim();
            result2.put(entry.getKey(), Pair.of(ExampleGenerator.UNIT_CONVERTER.getShortId(longUnitId), unitPattern));
        }
        Map<String, Pair<String, String>> genderCache = XCldrStub.ImmutableMap.copyOf(result2);
        CaseAndGenderSamples result = new CaseAndGenderSamples(caseCache, ExampleGenerator.UNIT_CONVERTER.getShortId(bestCaseUnitId), genderCache);
        this.genderToUnits = ImmutableMultimap.copyOf(this.genderToUnits);
        this.uniqueCaseAndCountToUnits = ImmutableMultimap.copyOf(this.uniqueCaseAndCountToUnits);
        this.distinctNominativeCaseToUnit = ImmutableMultimap.copyOf(this.distinctNominativeCaseToUnit);
        return result;
    }

    private Map<String, String> getBestCasePatterns(Multimap<String, Pair<String, String>> bestUnitPatternToCases) {
        if (bestUnitPatternToCases == null || bestUnitPatternToCases.isEmpty()) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> result = new TreeMap<String, String>();
        while (true) {
            String bestPattern = this.getBestPattern(bestUnitPatternToCases);
            Pair<String, String> bestCaseCount = bestUnitPatternToCases.get(bestPattern).iterator().next();
            String bestCase = bestCaseCount.getFirst();
            String bestCount = bestCaseCount.getSecond();
            String sample = this.getPluralOrOrdinalSample(SupplementalDataInfo.PluralType.cardinal, bestCount);
            if (sample == null) {
                this.getPluralOrOrdinalSample(SupplementalDataInfo.PluralType.cardinal, bestCount);
            }
            result.put(bestCaseCount.getFirst(), bestPattern.replace("{0}", sample));
            TreeMultimap caseToPatterns = Multimaps.invertFrom(bestUnitPatternToCases, TreeMultimap.create());
            for (String count : this.pluralInfo.getKeywords()) {
                caseToPatterns.removeAll(Pair.of(bestCase, count));
            }
            if (caseToPatterns.keySet().isEmpty()) {
                return result;
            }
            bestUnitPatternToCases = Multimaps.invertFrom(caseToPatterns, TreeMultimap.create());
        }
    }

    private String getBestPattern(Multimap<String, Pair<String, String>> bestUnitPatternToCases) {
        int bestCaseSize = 1000;
        String bestPattern = null;
        Collection<Pair<String, String>> bestCase = null;
        for (Map.Entry<String, Collection<Pair<String, String>>> entry : bestUnitPatternToCases.asMap().entrySet()) {
            Collection<Pair<String, String>> setOfCases = entry.getValue();
            if (setOfCases.size() >= bestCaseSize) continue;
            bestCaseSize = setOfCases.size();
            bestPattern = entry.getKey();
            bestCase = setOfCases;
        }
        return bestPattern;
    }

    public boolean isBetterUnit(String longUnitId, String formerLongUnitId) {
        boolean isBetter = false;
        int diff = this.systemWeight(longUnitId) - this.systemWeight(formerLongUnitId);
        if (diff < 0) {
            isBetter = true;
        } else if (diff == 0) {
            diff = this.categoryWeight(longUnitId) - this.categoryWeight(formerLongUnitId);
            if (diff < 0) {
                isBetter = true;
            } else if (diff == 0 && longUnitId.compareTo(formerLongUnitId) < 0) {
                isBetter = true;
            }
        }
        return isBetter;
    }

    public int systemWeight(String longUnitId) {
        if (WORSE.contains(longUnitId)) {
            return 1;
        }
        Set<UnitConverter.UnitSystem> systems = ExampleGenerator.UNIT_CONVERTER.getSystemsEnum(ExampleGenerator.UNIT_CONVERTER.getShortId(longUnitId));
        if (systems.contains((Object)UnitConverter.UnitSystem.metric)) {
            return 0;
        }
        return 1;
    }

    private int categoryWeight(String longUnitId) {
        if (longUnitId.startsWith("length")) {
            return 0;
        }
        if (longUnitId.startsWith("weight")) {
            return 1;
        }
        if (longUnitId.startsWith("duration")) {
            return 2;
        }
        return 999;
    }

    public String getPluralOrOrdinalSample(SupplementalDataInfo.PluralType pluralType, String code) {
        PluralRules rules = pluralType == SupplementalDataInfo.PluralType.cardinal ? this.pluralInfo : this.ordinalInfo;
        PluralRules.FixedDecimalSamples samples = rules.getDecimalSamples(code, PluralRules.SampleType.INTEGER);
        if (samples == null) {
            samples = rules.getDecimalSamples(code, PluralRules.SampleType.DECIMAL);
        }
        if (samples == null) {
            return null;
        }
        PluralRules.FixedDecimal sample = null;
        for (PluralRules.FixedDecimalRange sampleRange : samples.getSamples()) {
            sample = sampleRange.start;
            if (sample.doubleValue() == 0.0) continue;
            break;
        }
        if (this.icuServiceBuilder != null) {
            DecimalFormat nf;
            int visibleDigits = sample.getVisibleDecimalDigitCount();
            if (visibleDigits == 0) {
                nf = this.icuServiceBuilder.getNumberFormat(0);
            } else {
                nf = this.icuServiceBuilder.getNumberFormat(1);
                int minFracDigits = nf.getMinimumFractionDigits();
                int maxFracDigits = nf.getMaximumFractionDigits();
                if (minFracDigits != visibleDigits || maxFracDigits != visibleDigits) {
                    nf = (DecimalFormat)nf.clone();
                    nf.setMaximumFractionDigits(visibleDigits);
                    nf.setMinimumFractionDigits(visibleDigits);
                }
            }
            return nf.format(sample);
        }
        return sample.toString();
    }

    public String getBestValue(String header, String code, Output<String> shortUnitId) {
        String result = null;
        switch (header) {
            case "Case": {
                result = this.getBestUnitWithCase(code, shortUnitId);
                break;
            }
            case "Gender": {
                result = this.getBestUnitWithGender(code, shortUnitId);
                break;
            }
            case "Ordinal": {
                result = this.getPluralOrOrdinalSample(SupplementalDataInfo.PluralType.ordinal, code);
                shortUnitId.value = "n/a";
                break;
            }
            case "Plural": {
                result = this.getPluralOrOrdinalSample(SupplementalDataInfo.PluralType.cardinal, code);
                shortUnitId.value = "n/a";
            }
        }
        return result == null ? "X" : result;
    }

    public Multimap<String, String> getGenderToUnits() {
        return this.genderToUnits;
    }

    public Multimap<Integer, String> getUniqueCaseAndCountToUnits() {
        return this.uniqueCaseAndCountToUnits;
    }

    public Multimap<String, String> getDistinctNominativeCaseToUnit() {
        return this.distinctNominativeCaseToUnit;
    }

    static final class CaseAndGenderSamples {
        private final Map<String, Pair<String, String>> genderCache;
        private final Map<String, String> caseCache;
        private final String caseUnitId;

        public CaseAndGenderSamples(Map<String, String> caseCache2, String bestCaseUnitId, Map<String, Pair<String, String>> genderCache2) {
            this.genderCache = genderCache2;
            this.caseCache = caseCache2;
            this.caseUnitId = bestCaseUnitId;
        }

        public String getGender(String gender, Output<String> shortUnitId) {
            Pair<String, String> result = this.genderCache.get(gender);
            if (result == null) {
                return null;
            }
            shortUnitId.value = result.getFirst();
            return result.getSecond();
        }

        public String getCase(String unitCase, Output<String> shortUnitId) {
            shortUnitId.value = this.caseUnitId;
            return this.caseCache.get(unitCase);
        }
    }
}

