/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.PatternCache;

public class CheckNames
extends CheckCLDR {
    private static final Pattern YEAR_PATTERN = PatternCache.get("\\d{3,4}");
    private static final Pattern YEARS_NOT_ALLOWED = Pattern.compile("//ldml/localeDisplayNames/(languages|currencies|scripts|territories|measurementSystemNames|transformNames)/.*");

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (value == null) {
            return this;
        }
        if (!YEARS_NOT_ALLOWED.matcher(path).matches() || !this.getCldrFileToCheck().isNotRoot(path)) {
            return this;
        }
        Matcher matcher = YEAR_PATTERN.matcher(value);
        if (matcher.find()) {
            if (path.startsWith("//ldml/localeDisplayNames/territories") && this.getCldrFileToCheck().getBaileyValue(path, null, null).equals(value)) {
                return this;
            }
            if (!path.startsWith("//ldml/localeDisplayNames/currencies") || !this.isEnclosedByBraces(matcher, value, '(', ')') && !this.isEnclosedByBraces(matcher, value, '[', ']')) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.nameContainsYear).setMessage("The name should not contain any years or region codes ({0})", matcher.group()));
            }
        }
        return this;
    }

    private boolean isEnclosedByBraces(Matcher matcher, String value, char startBrace, char endBrace) {
        return value.lastIndexOf(startBrace, matcher.start()) > -1 && value.indexOf(endBrace, matcher.end()) >= -1;
    }
}

