/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.XPathParts;

public class CheckPlaceHolders
extends CheckCLDR {
    private static final Pattern PLACEHOLDER_PATTERN = PatternCache.get("([0-9]|[1-9][0-9]+)");
    private static final Pattern SKIP_PATH_LIST = Pattern.compile("//ldml/characters/(exemplarCharacters|parseLenient).*");

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (SKIP_PATH_LIST.matcher(path).matches()) {
            return this;
        }
        int startPlaceHolder = 0;
        if (value == null) {
            return this;
        }
        while (startPlaceHolder != -1 && startPlaceHolder < value.length()) {
            if ((startPlaceHolder = value.indexOf(123, startPlaceHolder + 1)) == -1) continue;
            int endPlaceHolder = value.indexOf(125, startPlaceHolder + 1);
            if (endPlaceHolder == -1) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Invalid placeholder in value \"" + value + "\""));
                continue;
            }
            String placeHolderString = value.substring(startPlaceHolder + 1, endPlaceHolder);
            Matcher matcher = PLACEHOLDER_PATTERN.matcher(placeHolderString);
            if (!matcher.matches()) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Invalid placeholder in value \"" + value + "\""));
            }
            startPlaceHolder = endPlaceHolder;
        }
        if (path.startsWith("//ldml/listPatterns/listPattern") && !path.endsWith("/alias")) {
            XPathParts parts = XPathParts.getFrozenInstance(path);
            switch (parts.getAttributeValue(-1, "type")) {
                case "start": {
                    this.checkNothingAfter1(value, result);
                    break;
                }
                case "middle": {
                    this.checkNothingBefore0(value, result);
                    this.checkNothingAfter1(value, result);
                    break;
                }
                case "end": {
                    this.checkNothingBefore0(value, result);
                    break;
                }
                case "2": {
                    int pos1 = value.indexOf("{0}");
                    int pos2 = value.indexOf("{1}");
                    if (pos1 <= pos2) break;
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Invalid list pattern \u00ab" + value + "\u00bb: the placeholder {0} must be before {1}."));
                    break;
                }
                case "3": {
                    int pos1 = value.indexOf("{0}");
                    int pos2 = value.indexOf("{1}");
                    int pos3 = value.indexOf("{2}");
                    if (pos1 <= pos2 && pos2 <= pos3) break;
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Invalid list pattern \u00ab" + value + "\u00bb: the placeholders {0}, {1}, {2} must appear in that order."));
                }
            }
        }
        return this;
    }

    private void checkNothingAfter1(String value, List<CheckCLDR.CheckStatus> result) {
        if (!value.endsWith("{1}")) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Invalid list pattern \u00ab" + value + "\u00bb, no text can come after {1}."));
        }
    }

    private void checkNothingBefore0(String value, List<CheckCLDR.CheckStatus> result) {
        if (!value.startsWith("{0}")) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Invalid list pattern \u00ab" + value + "\u00bb, no text can come before {0}."));
        }
    }
}

