/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.SimpleLocaleParser;
import org.unicode.cldr.util.BNF;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Quoter;

class CheckLangTagBNF {
    private static final String LANGUAGE_TAG_TEST_FILE = CldrUtility.getProperty("test");
    private static final String BNF_DEFINITION_FILE = CldrUtility.getProperty("bnf");
    private String rules;
    private String generationRules;
    private Pattern pattern;
    private BNF bnf;
    private static final String[] groupNames = new String[]{"whole", "lang", "script", "region", "variants", "extensions", "privateuse", "legacy", "privateuse", "localeExtensions"};
    private static Random random = new Random(3L);

    CheckLangTagBNF() {
    }

    public CheckLangTagBNF setFromFile(String filename) throws IOException {
        String line;
        BufferedReader in = FileUtilities.openUTF8Reader("", filename);
        CldrUtility.VariableReplacer result = new CldrUtility.VariableReplacer();
        String variable = null;
        StringBuffer definition = new StringBuffer();
        StringBuffer ruleBuffer = new StringBuffer();
        StringBuffer generationRuleBuffer = new StringBuffer();
        int count = 1;
        while ((line = in.readLine()) != null) {
            ruleBuffer.append(line).append("\n");
            if (line.length() != 0) {
                String trimline;
                int hashPos;
                if (line.charAt(0) == '\ufeff') {
                    line = line.substring(1);
                }
                if ((hashPos = line.indexOf(35)) >= 0) {
                    line = line.substring(0, hashPos);
                }
                if ((trimline = line.trim()).length() != 0) {
                    generationRuleBuffer.append(trimline).append("\n");
                    String linePart = line;
                    if (linePart.trim().length() != 0) {
                        int equalsPos;
                        boolean terminated = trimline.endsWith(";");
                        if (terminated) {
                            linePart = linePart.substring(0, linePart.lastIndexOf(59));
                        }
                        if ((equalsPos = linePart.indexOf(61)) >= 0) {
                            if (variable != null) {
                                throw new IllegalArgumentException("Missing ';' before " + count + ") " + line);
                            }
                            variable = linePart.substring(0, equalsPos).trim();
                            definition.append(linePart.substring(equalsPos + 1).trim());
                        } else {
                            if (variable == null) {
                                throw new IllegalArgumentException("Missing '=' at " + count + ") " + line);
                            }
                            definition.append("\n").append(linePart);
                        }
                        if (terminated) {
                            result.add(variable, result.replace(definition.toString()));
                            variable = null;
                            definition.setLength(0);
                        }
                    }
                }
            }
            ++count;
        }
        if (variable != null) {
            throw new IllegalArgumentException("Missing ';' at end");
        }
        String resolved = result.replace("$root").replaceAll("[0-9]+%", "");
        System.out.println("Regex: " + resolved);
        this.rules = ruleBuffer.toString();
        this.generationRules = generationRuleBuffer.toString().replaceAll("\\?:", "").replaceAll("\\(\\?i\\)", "");
        this.pattern = Pattern.compile(resolved, 4);
        return this;
    }

    private static String randomizeAsciiCase(String s2) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if ('A' <= c && c <= 'Z') {
                if (random.nextBoolean()) {
                    c = (char)(c + 32);
                }
            } else if ('a' <= c && c <= 'z' && random.nextBoolean()) {
                c = (char)(c - 32);
            }
            result.append(c);
        }
        return result.toString();
    }

    public BNF getBnf() {
        if (this.bnf != null) {
            return this.bnf;
        }
        this.bnf = new BNF(new Random(2L), new Quoter.RuleQuoter()).setMaxRepeat(5).addRules(this.generationRules).complete();
        return this.bnf;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getRules() {
        return this.rules;
    }

    public String getGenerationRules() {
        return this.generationRules;
    }

    public static void main(String[] args) throws IOException {
        String test;
        CheckLangTagBNF bnfData = new CheckLangTagBNF();
        bnfData.setFromFile(BNF_DEFINITION_FILE);
        String contents = bnfData.getRules();
        Pattern pat = bnfData.getPattern();
        Matcher regexLanguageTag = pat.matcher("");
        Locale loc = new Locale("fOo", "fIi", "bAr");
        System.out.println("locale.getLanguage " + loc.getLanguage());
        System.out.println("locale.getCountry " + loc.getCountry());
        System.out.println("locale.getVariant " + loc.getVariant());
        ULocale loc2 = new ULocale("eS_latN-eS@currencY=EUR;collatioN=traditionaL");
        System.out.println("ulocale.getLanguage " + loc2.getLanguage());
        System.out.println("ulocale.getScript " + loc2.getScript());
        System.out.println("ulocale.getCountry " + loc2.getCountry());
        System.out.println("ulocale.getVariant " + loc2.getVariant());
        Iterator<String> it = loc2.getKeywords();
        while (it.hasNext()) {
            String keyword = it.next();
            System.out.println("\tulocale.getKeywords " + keyword + " = " + loc2.getKeywordValue(keyword));
        }
        BNF bnf = bnfData.getBnf();
        for (int i = 0; i < 100; ++i) {
            String trial = bnf.next();
            trial = CheckLangTagBNF.randomizeAsciiCase(trial);
            System.out.println(trial);
            if (regexLanguageTag.reset(trial).matches()) continue;
            throw new IllegalArgumentException("Regex generation fails with: " + trial);
        }
        System.out.println("*** ILL-FORMED ***");
        BNF invalidBNF = new BNF(new Random(0L), new Quoter.RuleQuoter()).setMaxRepeat(5).addRules("$tag = ([A-Z a-z 0-9]{1,8} 50% 20% 10% 5% 5% 5% 5%);").addRules("$s = [-_] ;").addRules("$root = $tag ($s $tag){0,7} 10% 10% 10% 10% 10% 10% 10% 10% ; ").complete();
        for (int i = 0; i < 100; ++i) {
            String trial = invalidBNF.next();
            if (regexLanguageTag.reset(trial).matches()) continue;
            System.out.println(trial);
        }
        System.out.println(contents);
        LanguageTagParser ltp = new LanguageTagParser();
        SimpleLocaleParser simpleLocaleParser = new SimpleLocaleParser();
        boolean expected = true;
        int errorCount = 0;
        BufferedReader in = FileUtilities.openUTF8Reader("", LANGUAGE_TAG_TEST_FILE);
        while ((test = in.readLine()) != null) {
            int hashPos;
            if (test.length() == 0) continue;
            if (test.charAt(0) == '\ufeff') {
                test = test.substring(1);
            }
            if ((hashPos = test.indexOf(35)) >= 0) {
                test = test.substring(0, hashPos);
            }
            if ((test = test.trim()).length() == 0) continue;
            if (test.equalsIgnoreCase("WELL-FORMED")) {
                expected = true;
                continue;
            }
            if (test.equalsIgnoreCase("ILL-FORMED")) {
                expected = false;
                continue;
            }
            System.out.println("Parsing " + test);
            CheckLangTagBNF.checkParse(ltp, simpleLocaleParser, test);
            boolean matches = regexLanguageTag.reset(test).matches();
            if (matches != expected) {
                System.out.println("*** TEST FAILURE ***");
                ++errorCount;
            }
            System.out.println("\tregex?\t" + matches + (matches == expected ? "" : "\t EXPECTED: " + expected + " for\t" + test));
            if (!matches) continue;
            for (int j = 0; j <= regexLanguageTag.groupCount(); ++j) {
                String g2 = regexLanguageTag.group(j);
                if (g2 == null || g2.length() == 0) continue;
                System.out.println("\t" + j + "\t" + groupNames[j] + ":\t" + g2);
            }
        }
        System.out.println("Error count: " + errorCount);
    }

    private static void checkParse(LanguageTagParser ltp, SimpleLocaleParser slp, String test) {
        try {
            ltp.set(test);
            boolean couldParse = slp.set(test);
            if (!couldParse) {
                System.out.println("###Coundn't parse: test");
            } else {
                System.out.println("Simple Parser: " + slp.toString());
                String lang = ltp.getLanguage();
                if (lang.length() == 0) {
                    lang = "und";
                }
                CheckLangTagBNF.checkStrings("language", lang, slp.getLanguage());
                CheckLangTagBNF.checkStrings("script", ltp.getScript(), slp.getScript());
                CheckLangTagBNF.checkStrings("country", ltp.getRegion(), slp.getCountry());
                CheckLangTagBNF.checkStrings("variants", ltp.getVariants(), slp.getVariants());
                LinkedHashMap<String, String> foo = new LinkedHashMap<String, String>();
                foo.putAll(ltp.getExtensions());
                foo.putAll(ltp.getLocaleExtensions());
                CheckLangTagBNF.checkStrings("variants", foo, slp.getExtensions());
            }
            if (ltp.getLanguage().length() != 0) {
                System.out.println("\tlang:    \t" + ltp.getLanguage() + (ltp.isLegacy() ? " (legacy)" : ""));
            }
            if (ltp.getScript().length() != 0) {
                System.out.println("\tscript:\t" + ltp.getScript());
            }
            if (ltp.getRegion().length() != 0) {
                System.out.println("\tregion:\t" + ltp.getRegion());
            }
            if (ltp.getVariants().size() != 0) {
                System.out.println("\tvariants:\t" + ltp.getVariants());
            }
            if (ltp.getExtensions().size() != 0) {
                System.out.println("\textensions:\t" + ltp.getExtensions());
            }
            if (ltp.getLocaleExtensions().size() != 0) {
                System.out.println("\tlocale extensions:\t" + ltp.getLocaleExtensions());
            }
            System.out.println("\tisValid?\t" + ltp.isValid());
        }
        catch (Exception e) {
            System.out.println("\t" + e.getMessage());
            System.out.println("\tisValid?\tfalse");
        }
    }

    private static <T> void checkStrings(String message, T obj1, T obj2) {
        String object2;
        String object1 = obj1.toString().replace('_', '-');
        if (!object1.equals(object2 = obj2.toString().replace('_', '-'))) {
            if (object1.equalsIgnoreCase(object2)) {
                System.out.println("$$$Case Difference at " + message + "<" + obj1 + "> != <" + obj2 + ">");
            } else {
                System.out.println("###Difference at " + message + "<" + obj1 + "> != <" + obj2 + ">");
            }
        }
    }
}

