/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.XMLFileReader;

class ExtractMessages {
    public static final UnicodeSet LATIN_SCRIPT = new UnicodeSet("[:script=latin:]").freeze();
    private static Matcher fileMatcher;
    public static PrintWriter output;
    public static boolean SKIPEQUALS;
    public static boolean SKIPIFCLDR;
    public static String DIR;
    private static Map<String, Pair<String, DataHandler>> numericId_Id;
    private static Matcher numericIdMatcher;
    private static Factory cldrFactory;
    private static CLDRFile english;
    public static Collator col;
    private static OtherHandler otherHandler;
    static Map<String, String> fixLocaleMap;
    static StandardCodes sc;
    static DateFormatSymbols dfs;
    static DataHandler[] dataHandlers;

    ExtractMessages() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        double startTime = System.currentTimeMillis();
        output = FileUtilities.openUTF8Writer(DIR, "additions.txt");
        int totalCount = 0;
        TreeSet<String> skipped = new TreeSet<String>();
        try {
            String sourceDirectory = ExtractMessages.getProperty("SOURCE", null);
            if (sourceDirectory == null) {
                System.out.println("Need Source Directory! ");
                return;
            }
            fileMatcher = PatternCache.get(ExtractMessages.getProperty("FILE", ".*")).matcher("");
            SKIPIFCLDR = ExtractMessages.getProperty("SKIPIFCLDR", null) != null;
            boolean showMissing = true;
            File src = new File(sourceDirectory);
            XMLFileReader xfr = new XMLFileReader().setHandler(new EnglishHandler());
            xfr.read(src + "/en.xmb", XMLFileReader.CONTENT_HANDLER | XMLFileReader.ERROR_HANDLER, false);
            for (File file : src.listFiles()) {
                String canonicalFile;
                if (file.isDirectory() || file.length() == 0L || !(canonicalFile = PathUtilities.getNormalizedPathString(file)).endsWith(".xtb")) continue;
                String name = file.getName();
                if (!fileMatcher.reset(name = name.substring(0, name.length() - 4)).matches()) continue;
                System.out.println("* " + canonicalFile);
                try {
                    otherHandler.setLocale(name);
                }
                catch (RuntimeException e1) {
                    System.out.println("Skipping, no CLDR locale file: " + name + "\t" + english.getName(name) + "\t" + e1.getClass().getName() + "\t" + e1.getMessage());
                    skipped.add(name);
                    continue;
                }
                xfr = new XMLFileReader().setHandler(otherHandler);
                try {
                    xfr.read(canonicalFile, XMLFileReader.CONTENT_HANDLER | XMLFileReader.ERROR_HANDLER, false);
                }
                catch (RuntimeException e) {
                    System.out.println(e.getMessage());
                    continue;
                }
                CLDRFile newFile = SimpleFactory.makeFile(otherHandler.getLocale());
                int itemCount = 0;
                for (DataHandler dataHandler : dataHandlers) {
                    if (showMissing) {
                        System.out.println("case " + (Object)((Object)dataHandler.type) + ":");
                        for (String value : dataHandler.missing) {
                            System.out.println("addName(\"" + value + "\", \"XXX\", true);");
                        }
                    }
                    for (String id : dataHandler.id_to_value.keySet()) {
                        Set otherValue = dataHandler.id_to_value.getAll(id);
                        if (otherValue == null || otherValue.size() == 0) continue;
                        String cldrValue = (String)dataHandler.id_to_cldrValue.get(id);
                        int count = 0;
                        for (String oValue : otherValue) {
                            ++itemCount;
                            output.println(otherHandler.getLocale() + "\t" + (Object)((Object)dataHandler.type) + "\t" + id + "\t" + oValue + (cldrValue == null ? "" : "\tcldr:\t" + cldrValue) + (count == 0 ? "" : "\talt:\t" + String.valueOf(count)));
                            newFile.add(dataHandler.getPath(id, count), oValue);
                        }
                    }
                }
                PrintWriter cldrOut = FileUtilities.openUTF8Writer(DIR, otherHandler.getLocale() + ".xml");
                newFile.write(cldrOut);
                cldrOut.close();
                output.println();
                showMissing = false;
                output.flush();
                System.out.println("\titems: " + itemCount);
                totalCount += itemCount;
            }
            for (String name : skipped) {
                System.out.println("\tSkipping, no CLDR locale file: " + name + "\t" + english.getName(name));
            }
            double deltaTime = (double)System.currentTimeMillis() - startTime;
            System.out.println("Elapsed: " + deltaTime / 1000.0 + " seconds");
            System.out.println("\ttotal items: " + totalCount);
        }
        finally {
            output.close();
        }
    }

    private static String getProperty(String key, String defaultValue) {
        String fileRegex = System.getProperty(key);
        if (fileRegex == null) {
            fileRegex = defaultValue;
        }
        System.out.println("-D" + key + "=" + fileRegex);
        return fileRegex;
    }

    private static String fixLocale(String locale) {
        String newLocale = fixLocaleMap.get(locale = locale.replace('-', '_'));
        if (newLocale != null) {
            locale = newLocale;
        }
        return locale;
    }

    static {
        SKIPEQUALS = true;
        SKIPIFCLDR = true;
        DIR = CLDRPaths.GEN_DIRECTORY + "/../additions/";
        numericId_Id = new TreeMap<String, Pair<String, DataHandler>>();
        numericIdMatcher = PatternCache.get("\\[@id=\"([^\"]+)\"\\]").matcher("");
        cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        english = cldrFactory.make("en", true);
        col = Collator.getInstance(ULocale.ENGLISH);
        col.setStrength(1);
        otherHandler = new OtherHandler();
        fixLocaleMap = CldrUtility.asMap(new String[][]{{"zh_CN", "zh"}, {"zh_TW", "zh_Hant"}, {"pt_BR", "pt"}, {"in", "id"}, {"iw", "he"}, {"jw", "jv"}, {"ku", "ku_Arab"}});
        sc = StandardCodes.make();
        dfs = new DateFormatSymbols(ULocale.ENGLISH);
        dataHandlers = new DataHandler[]{new DataHandler(Type.LANGUAGE, ".*form of language.*"), new DataHandler(Type.REGION, ".*the country or region.*"), new DataHandler(Type.CURRENCY, ".*currency name.*"), new DataHandler(Type.MONTH, ".*Name of the month of .*"), new DataHandler(Type.MONTHSHORT, ".*3 letter abbreviation for name of Month.*"), new DataHandler(Type.DAY, ".*day in week.*"), new DataHandler(Type.DAYSHORT, ".*Short Version of .*"), new DataHandler(Type.TIMEZONE, ".*is a display name for a timezone.*")};
    }

    static class DataHandler
    implements Comparable<DataHandler> {
        private Matcher matcher;
        private Type type;
        private Map<String, String> name_code = new TreeMap<String, String>();
        private Set<String> missing = new TreeSet<String>();
        private Relation<String, String> id_to_value = Relation.of(new TreeMap(), TreeSet.class);
        private Map<String, String> id_to_cldrValue = new TreeMap<String, String>();
        private CasingAction forceCasing = CasingAction.NONE;

        public void reset(CLDRFile cldrFile) {
            this.id_to_value.clear();
            this.id_to_cldrValue.clear();
            this.forceCasing = CasingAction.NONE;
            String key = null;
            switch (this.type) {
                case LANGUAGE: {
                    key = "en";
                    break;
                }
                case REGION: {
                    key = "FR";
                    break;
                }
                case CURRENCY: {
                    key = "GBP";
                    break;
                }
                case MONTH: 
                case MONTHSHORT: {
                    key = "1";
                    break;
                }
                case DAY: 
                case DAYSHORT: {
                    key = "mon";
                    break;
                }
                case TIMEZONE: {
                    key = "America/New_York";
                }
            }
            String sample = this.getCldrValue(cldrFile, key);
            if (sample != null) {
                if (UCharacter.isLowerCase(sample.charAt(0))) {
                    this.forceCasing = CasingAction.FORCE_LOWER;
                } else if (UCharacter.isUpperCase(sample.charAt(0))) {
                    this.forceCasing = CasingAction.FORCE_TITLE;
                }
            }
        }

        public String fixValue(ULocale uLocale, String value) {
            value = TransliteratorUtilities.fromXML.transliterate(value);
            if (this.forceCasing == CasingAction.FORCE_LOWER) {
                if (!UCharacter.isLowerCase(value.charAt(0))) {
                    value = UCharacter.toLowerCase(value);
                }
            } else if (this.forceCasing == CasingAction.FORCE_TITLE && !UCharacter.isUpperCase(value.charAt(0))) {
                value = UCharacter.toTitleCase(uLocale, value, null);
            }
            return value;
        }

        public void addValues(String id, String value, String cldrValue) {
            this.id_to_value.put(id, value);
            if (cldrValue != null) {
                this.id_to_cldrValue.put(id, cldrValue);
            }
        }

        public void addName(String name, String code, boolean skipMessage) {
            this.name_code.put(name, code);
        }

        DataHandler(Type type, String pattern) {
            this.type = type;
            this.matcher = PatternCache.get(pattern).matcher("");
            switch (type) {
                case LANGUAGE: {
                    for (String code : sc.getAvailableCodes("language")) {
                        String name = english.getName("language", code);
                        if (name == null) continue;
                        this.addName(name, code.replace("-", "_"), false);
                    }
                    this.addName("English (US)", "en_US", true);
                    this.addName("English (UK)", "en_GB", true);
                    this.addName("Chinese (Simplified)", "zh_Hans", true);
                    this.addName("Chinese (Traditional)", "zh_Hant", true);
                    this.addName("Norwegian (Nynorsk)", "nn", true);
                    this.addName("Portuguese (Portugal)", "pt_PT", true);
                    this.addName("Portuguese (Brazil)", "pt_BR", true);
                    this.addName("English (Australia)", "en_AU", true);
                    this.addName("Scots Gaelic", "gd", true);
                    this.addName("Frisian", "fy", true);
                    this.addName("Sesotho", "st", true);
                    this.addName("Kyrgyz", "ky", true);
                    this.addName("Laothian", "lo", true);
                    this.addName("Cambodian", "km", true);
                    this.addName("Greenlandic", "kl", true);
                    this.addName("Inupiak", "ik", true);
                    this.addName("Volapuk", "vo", true);
                    this.addName("Byelorussian", "be", true);
                    this.addName("Faeroese", "fo", true);
                    this.addName("Singhalese", "si", true);
                    this.addName("Gaelic", "ga", true);
                    this.addName("Bhutani", "dz", true);
                    this.addName("Setswana", "tn", true);
                    this.addName("Siswati", "ss", true);
                    this.addName("Sangro", "sg", true);
                    break;
                }
                case REGION: {
                    for (String code : sc.getAvailableCodes("territory")) {
                        String name = english.getName("territory", code);
                        if (name == null) continue;
                        this.addName(name, code, false);
                    }
                    this.addName("Bosnia and Herzegowina", "BA", true);
                    this.addName("Congo", "CG", true);
                    this.addName("Congo, Democratic Republic of the", "CD", true);
                    this.addName("Congo, The Democratic Republic of the", "CD", true);
                    this.addName("Cote D'ivoire", "CI", true);
                    this.addName("C\u00f4te d'Ivoire", "CI", true);
                    this.addName("Equitorial Guinea", "GQ", true);
                    this.addName("French Quiana", "GF", true);
                    this.addName("Heard and Mc Donald Islands", "HM", true);
                    this.addName("Holy See (Vatican City State)", "VA", true);
                    this.addName("Iran (Islamic Republic of)", "IR", true);
                    this.addName("Korea, Democratic People's Republic of", "KP", true);
                    this.addName("Korea, Republic of", "KR", true);
                    this.addName("Libyan Arab Jamahiriya", "LY", true);
                    this.addName("Lichtenstein", "LI", true);
                    this.addName("Macao", "MO", true);
                    this.addName("Micronesia, Federated States of", "FM", true);
                    this.addName("Palestine", "PS", true);
                    this.addName("Serbia and Montenegro", "CS", true);
                    this.addName("Slovakia (Slovak Republic)", "SK", true);
                    this.addName("S\u00e3o Tom\u00e9 and Pr\u00edncipe", "ST", true);
                    this.addName("The Former Yugoslav Republic of Macedonia", "MK", true);
                    this.addName("United States minor outlying islands", "UM", true);
                    this.addName("Vatican City", "VA", true);
                    this.addName("Virgin Islands, British", "VG", true);
                    this.addName("Virgin Islands, U.S.", "VI", true);
                    this.addName("Zaire", "CD", true);
                    this.addName("\u00c5land Islands", "AX", true);
                    break;
                }
                case CURRENCY: {
                    for (String code : sc.getAvailableCodes("currency")) {
                        String name = english.getName("currency", code);
                        if (name == null) continue;
                        this.addName(name, code, false);
                    }
                    this.addName("Australian Dollars", "AUD", true);
                    this.addName("Bolivian Boliviano", "BOB", true);
                    this.addName("British Pounds Sterling", "GBP", true);
                    this.addName("Bulgarian Lev", "BGN", true);
                    this.addName("Canadian Dollars", "CAD", true);
                    this.addName("Czech Koruna", "CZK", true);
                    this.addName("Danish Kroner", "DKK", true);
                    this.addName("Denmark Kroner", "DKK", true);
                    this.addName("Deutsche Marks", "DEM", true);
                    this.addName("Euros", "EUR", true);
                    this.addName("French Franks", "FRF", true);
                    this.addName("Hong Kong Dollars", "HKD", true);
                    this.addName("Israeli Shekel", "ILS", true);
                    this.addName("Lithuanian Litas", "LTL", true);
                    this.addName("Mexico Peso", "MXN", true);
                    this.addName("New Romanian Leu", "RON", true);
                    this.addName("New Taiwan Dollar", "TWD", true);
                    this.addName("New Zealand Dollars", "NZD", true);
                    this.addName("Norway Kroner", "NOK", true);
                    this.addName("Norwegian Kroner", "NOK", true);
                    this.addName("Peruvian Nuevo Sol", "PEN", true);
                    this.addName("Polish New Zloty", "PLN", true);
                    this.addName("Polish NewZloty", "PLN", true);
                    this.addName("Russian Rouble", "RUB", true);
                    this.addName("Singapore Dollars", "SGD", true);
                    this.addName("Slovenian Tolar", "SIT", true);
                    this.addName("Sweden Kronor", "SEK", true);
                    this.addName("Swedish Kronor", "SEK", true);
                    this.addName("Swiss Francs", "CHF", true);
                    this.addName("US Dollars", "USD", true);
                    this.addName("United Arab EmiratesD irham", "AED", true);
                    this.addName("Venezuela Bolivar", "VEB", true);
                    this.addName("Yuan Renminbi", "CNY", true);
                    break;
                }
                case TIMEZONE: {
                    for (String code : sc.getAvailableCodes("tzid")) {
                        String[] parts = code.split("/");
                        this.addName(parts[parts.length - 1].replace("_", " "), code, false);
                    }
                    this.addName("Alaska Time", "America/Anchorage", true);
                    this.addName("Canary Islands", "Atlantic/Canary", true);
                    this.addName("Dumont D'Urville", "Antarctica/DumontDUrville", true);
                    this.addName("Easter Island", "Pacific/Easter", true);
                    this.addName("Salvador", "America/El_Salvador", true);
                    this.addName("St. Kitts", "America/St_Kitts", true);
                    this.addName("St. Lucia", "America/St_Lucia", true);
                    this.addName("St. Thomas", "America/St_Thomas", true);
                    this.addName("St. Vincent", "America/St_Vincent", true);
                    break;
                }
                case MONTH: 
                case MONTHSHORT: {
                    String[] names = type == Type.MONTH ? dfs.getMonths() : dfs.getShortMonths();
                    for (int i = 0; i < names.length; ++i) {
                        this.addName(names[i], String.valueOf(i + 1), true);
                    }
                    break;
                }
                case DAY: 
                case DAYSHORT: {
                    String[] names2 = type == Type.DAY ? dfs.getWeekdays() : dfs.getShortWeekdays();
                    for (int i = 1; i < names2.length; ++i) {
                        this.addName(names2[i], names2[i].substring(0, 3).toLowerCase(Locale.ENGLISH), true);
                    }
                    break;
                }
            }
        }

        public String getCldrValue(CLDRFile cldrFile, String id) {
            String result = cldrFile.getStringValue(this.getPath(id));
            if (result == null && this.type == Type.TIMEZONE) {
                String[] parts = id.split("/");
                result = parts[parts.length - 1].replace("_", " ");
            }
            return result;
        }

        boolean matches(String text) {
            return this.matcher.reset(text).matches();
        }

        String getCode(String value) {
            return this.name_code.get(value);
        }

        @Override
        public int compareTo(DataHandler o) {
            throw new IllegalArgumentException();
        }

        String getPath(String id, int count) {
            String result = this.getPath(id);
            result = result + "[@alt=\"proposed-x" + (count += 650) + "\"]";
            result = result + "[@draft=\"provisional\"]";
            return result;
        }

        String getPath(String id) {
            switch (this.type) {
                case LANGUAGE: {
                    return CLDRFile.getKey(0, id);
                }
                case REGION: {
                    return CLDRFile.getKey(2, id);
                }
                case CURRENCY: {
                    return CLDRFile.getKey(4, id);
                }
                case TIMEZONE: {
                    return "//ldml/dates/timeZoneNames/zone[@type=\"$1\"]/exemplarCity".replace("$1", id);
                }
                case MONTH: {
                    return "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"wide\"]/month[@type=\"$1\"]".replace("$1", id);
                }
                case MONTHSHORT: {
                    return "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"abbreviated\"]/month[@type=\"$1\"]".replace("$1", id);
                }
                case DAY: {
                    return "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"wide\"]/day[@type=\"$1\"]".replace("$1", id);
                }
                case DAYSHORT: {
                    return "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/days/dayContext[@type=\"format\"]/dayWidth[@type=\"abbreviated\"]/day[@type=\"$1\"]".replace("$1", id);
                }
            }
            return null;
        }
    }

    static enum CasingAction {
        NONE,
        FORCE_TITLE,
        FORCE_LOWER;

    }

    static enum Type {
        LANGUAGE,
        REGION,
        CURRENCY,
        MONTH,
        MONTHSHORT,
        DAY,
        DAYSHORT,
        TIMEZONE;

    }

    private static class OtherHandler
    extends XMLFileReader.SimpleHandler {
        private String locale;
        private ULocale uLocale;
        CLDRFile cldrFile;
        boolean usesLatin;

        private OtherHandler() {
        }

        @Override
        public void handlePathValue(String path, String value) {
            if ((value = value.trim()).length() == 0) {
                return;
            }
            numericIdMatcher.reset(path).find();
            String numericId = numericIdMatcher.group(1);
            Pair id_handler = (Pair)numericId_Id.get(numericId);
            if (id_handler == null) {
                return;
            }
            String id = (String)id_handler.getFirst();
            DataHandler dataHandler = (DataHandler)id_handler.getSecond();
            if (!this.usesLatin && LATIN_SCRIPT.containsSome(value)) {
                return;
            }
            value = dataHandler.fixValue(this.uLocale, value);
            String cldrValue = dataHandler.getCldrValue(this.cldrFile, id);
            if (cldrValue != null && (col.compare(cldrValue, value) == 0 ? SKIPEQUALS : SKIPIFCLDR)) {
                return;
            }
            dataHandler.addValues(id, value, cldrValue);
        }

        public void setLocale(String locale) {
            this.locale = locale = ExtractMessages.fixLocale(locale);
            this.uLocale = new ULocale(locale);
            String lang = this.uLocale.getLanguage();
            if (locale.equals("fr_CA") || lang.equals("en")) {
                throw new RuntimeException("Skipping " + locale);
            }
            this.cldrFile = cldrFactory.make(locale, false);
            UnicodeSet exemplars = this.cldrFile.getExemplarSet("", CLDRFile.WinningChoice.WINNING);
            this.usesLatin = exemplars != null && exemplars.containsSome(LATIN_SCRIPT);
            for (DataHandler dataHandler : dataHandlers) {
                dataHandler.reset(this.cldrFile);
            }
        }

        public String getLocale() {
            return this.locale;
        }
    }

    private static class EnglishHandler
    extends XMLFileReader.SimpleHandler {
        private EnglishHandler() {
        }

        @Override
        public void handlePathValue(String path, String value) {
            for (DataHandler handler : dataHandlers) {
                if (!handler.matches(path)) continue;
                numericIdMatcher.reset(path).find();
                String id = numericIdMatcher.group(1);
                value = value.trim();
                if (value.length() == 0) {
                    return;
                }
                String realID = handler.getCode(value = TransliteratorUtilities.fromXML.transliterate(value));
                if (realID == null) {
                    handler.missing.add(value);
                    return;
                }
                numericId_Id.put(id, new Pair<String, DataHandler>(realID, handler));
            }
        }
    }
}

