/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.unicode.cldr.util.SupplementalDataInfo;

public class GenerateBcp47Tests {
    public static void main(String[] args) {
        SupplementalDataInfo info = SupplementalDataInfo.getInstance();
        Map<Row.R2<String, String>, String> deprecatedMap = info.getBcp47Deprecated();
        Map<Row.R2<String, String>, String> descriptionsMap = info.getBcp47Descriptions();
        System.out.println("#Deprecated");
        for (Map.Entry<Row.R2<String, String>, String> entry : deprecatedMap.entrySet()) {
            if (!"true".equals(entry.getValue())) continue;
            Row.R2<String, String> key = entry.getKey();
            System.out.println("{\"" + (String)key.get0() + "\", \"" + (String)key.get1() + "\"},");
        }
        System.out.println("#Tests");
        Relation<String, String> extension2Keys = info.getBcp47Extension2Keys();
        Relation<String, String> keys2subtypes = info.getBcp47Keys();
        LinkedHashSet<String> deprecatedSet = new LinkedHashSet<String>();
        for (Map.Entry<String, Set<String>> extensionKeys : extension2Keys.keyValuesSet()) {
            String extension = extensionKeys.getKey();
            Set<String> keys = extensionKeys.getValue();
            for (String key : keys) {
                Set<String> subtypes = keys2subtypes.get(key);
                Row.R2<String, String> keyBlank = Row.of(key, "");
                boolean deprecatedKey = "true".equals(deprecatedMap.get(keyBlank));
                String keyDescription = descriptionsMap.get(keyBlank);
                String non_deprecated = null;
                String deprecated = null;
                if (subtypes != null) {
                    for (String subtype : subtypes) {
                        Row.R2<String, String> keySubtype = Row.of(key, subtype);
                        boolean deprecatedSubtype = deprecatedKey || "true".equals(deprecatedMap.get(keySubtype));
                        String subtypeDescription = descriptionsMap.get(keySubtype);
                        if (deprecatedSubtype) {
                            if (deprecated != null) continue;
                            deprecatedSet.add("{\"OK\", \"en-" + extension + "-" + key + "-" + subtype + "\"}, // deprecated " + keyDescription + "; " + subtypeDescription);
                            deprecated = subtype;
                            continue;
                        }
                        if (non_deprecated != null) continue;
                        System.out.println("{\"OK\", \"en-" + extension + "-" + key + "-" + subtype + "\"}, // " + keyDescription + "; " + subtypeDescription);
                        non_deprecated = subtype;
                    }
                    continue;
                }
                System.out.println("{\"OK\", \"en-" + extension + "-" + key + "-SPECIAL\"}, // " + keyDescription);
            }
        }
        for (String dep : deprecatedSet) {
            System.out.println(dep);
        }
    }
}

