/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Splitter;
import com.ibm.icu.text.DisplayContext;
import com.ibm.icu.text.LocaleDisplayNames;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import org.unicode.cldr.test.CasingInfo;
import org.unicode.cldr.test.CheckConsistentCasing;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.XPathParts;

public class GenerateCasingChart {
    public static void main(String[] args) {
        GenerateCasingChart.check(ULocale.ENGLISH);
        GenerateCasingChart.check(ULocale.FRENCH);
        GenerateCasingChart.check(new ULocale("ca"));
        CasingInfo casingInfo = new CasingInfo();
        String dir = CLDRPaths.COMMON_DIRECTORY + "/casing";
        Splitter period = Splitter.on(".");
        Factory factory = CLDRConfig.getInstance().getFullCldrFactory();
        System.out.print("Locale\tLevel\tCount\tCLanguage");
        for (ContextTransformUsage x : ContextTransformUsage.values()) {
            System.out.print("\t" + (Object)((Object)x));
        }
        System.out.println();
        boolean showCasing = false;
        UnicodeSet changesUpper = new UnicodeSet("[:CWU:]").freeze();
        for (String localeFile : new File(dir).list()) {
            Map<CheckConsistentCasing.Category, CheckConsistentCasing.CasingTypeAndErrFlag> info;
            String locale = period.split(localeFile).iterator().next();
            try {
                info = casingInfo.getLocaleCasing(locale);
            }
            catch (Exception e) {
                System.out.println(locale + "\t\t\tMalformed, skipping");
                continue;
            }
            CLDRFile cldrFile = factory.make(locale, true);
            UnicodeSet exemplars = cldrFile.getExemplarSet("", CLDRFile.WinningChoice.WINNING);
            ChainedMap.M3 data = ChainedMap.of(new LinkedHashMap(), new LinkedHashMap(), ContextTransformValue.class);
            Level level = StandardCodes.make().getLocaleCoverageLevel("cldr", locale);
            boolean hasCasedLetters = changesUpper.containsSome(exemplars);
            LinkedHashSet items = new LinkedHashSet();
            cldrFile.iterator("//ldml/contextTransforms").forEachRemaining(items::add);
            if (!hasCasedLetters) {
                if (items.size() == 0) continue;
                System.out.println(locale + "Uncased language has context!!!");
                continue;
            }
            System.out.print(locale);
            System.out.print("\t" + (Object)((Object)level));
            System.out.print("\t" + items.size());
            System.out.print("\t" + (Object)((Object)info.get((Object)CheckConsistentCasing.Category.language).type()));
            if (items.size() == 0) {
                System.out.println("\tNo Context Items");
                continue;
            }
            if (showCasing) {
                for (CheckConsistentCasing.Category category : CheckConsistentCasing.Category.values()) {
                    CheckConsistentCasing.CasingType value = info.get((Object)category).type();
                    System.out.print("\t" + (value == null ? "n/a" : Character.valueOf(value.toString().toUpperCase(Locale.ENGLISH).charAt(0))));
                }
                System.out.println();
            }
            for (String path : items) {
                XPathParts parts = XPathParts.getFrozenInstance(path);
                ContextTransformUsage contextTransformUsage = ContextTransformUsage.valueOf(parts.getAttributeValue(-2, "type").replace("-", "_"));
                ContextTransformType contextTransformType = ContextTransformType.valueOf(parts.getAttributeValue(-1, "type").replace("-", "_"));
                String stringValue = cldrFile.getStringValue(path);
                ContextTransformValue contextTransformValue = stringValue.equals("\u2205\u2205\u2205") ? ContextTransformValue.none : ContextTransformValue.valueOf(stringValue.replace("-", "_"));
                data.put(contextTransformUsage, contextTransformType, contextTransformValue);
            }
            for (ContextTransformUsage contextTransformUsage : ContextTransformUsage.values()) {
                Map map = data.get(contextTransformUsage);
                System.out.print("\t" + (map == null ? "n/a" : map.entrySet().toString().replace("=", " = ")));
            }
            System.out.println();
        }
    }

    private static void check(ULocale locale) {
        LocaleDisplayNames localeDisplayNames = LocaleDisplayNames.getInstance(locale, DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU);
        System.out.println(locale.getDisplayName(ULocale.ENGLISH) + "\t" + locale.getDisplayName(locale) + "\t" + localeDisplayNames.localeDisplayName(locale));
    }

    static enum ContextTransformValue {
        titlecase_firstword,
        none;

    }

    static enum ContextTransformType {
        stand_alone,
        uiListOrMenu;

    }

    static enum ContextTransformUsage {
        languages,
        script,
        keyValue,
        calendar_field,
        day_format_except_narrow,
        day_standalone_except_narrow,
        month_format_except_narrow,
        month_standalone_except_narrow,
        era_name,
        era_abbr,
        relative,
        currencyName,
        number_spellout;

    }
}

