/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.PluralRules;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.tool.PluralRulesFactory;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;

public class GeneratePluralConfirmation {
    private static final PluralRules.PluralType ICU_ORDINAL = PluralRules.PluralType.ORDINAL;
    private static final CLDRConfig testInfo = ToolConfig.getToolInstance();
    private static final StandardCodes STANDARD_CODES = StandardCodes.make();
    private static final SupplementalDataInfo SUPPLEMENTAL = testInfo.getSupplementalDataInfo();
    private static final PluralRulesFactory prf = PluralRulesFactory.getInstance(SUPPLEMENTAL);

    public static void main(String[] args) {
        for (String uLocale : new TreeSet<String>(prf.getLocales())) {
            for (PluralRules.PluralType type : PluralRules.PluralType.values()) {
                for (SupplementalDataInfo.PluralInfo.Count count : SupplementalDataInfo.PluralInfo.Count.values()) {
                    String pattern = PluralRulesFactory.getSamplePattern(uLocale, type, count);
                    if (pattern.contains("{no pattern available}")) continue;
                    System.out.println("locale=" + uLocale + "; action=add ; new_path=//ldml/numbers/minimalPairs/" + (type == PluralRules.PluralType.CARDINAL ? "plural" : "ordinal") + "MinimalPairs[@" + (type == PluralRules.PluralType.CARDINAL ? "count" : "ordinal") + "=\"" + count.toString().toLowerCase(Locale.ENGLISH) + "\"]; new_value=" + pattern);
                }
                System.out.println();
            }
        }
    }

    public static void mainOld2(String[] args) {
        Set<String> locales = STANDARD_CODES.getLocaleCoverageLocales(Organization.google);
        LanguageTagParser ltp = new LanguageTagParser();
        block4: for (String loc : locales) {
            String pat;
            ltp.set(loc);
            if (!ltp.getScript().isEmpty() || !ltp.getRegion().isEmpty()) continue;
            EnumSet<SupplementalDataInfo.PluralInfo.Count> counts = EnumSet.noneOf(SupplementalDataInfo.PluralInfo.Count.class);
            for (SupplementalDataInfo.PluralInfo.Count count : SupplementalDataInfo.PluralInfo.Count.VALUES) {
                pat = PluralRulesFactory.getSamplePattern(loc, ICU_ORDINAL, count);
                if (pat == null || pat.contains("{no pattern available}")) continue;
                counts.add(count);
            }
            switch (counts.size()) {
                case 0: {
                    System.out.format("%s\t%s\t%s\t%s\n", loc, "missing", "n/a", "n/a");
                    continue block4;
                }
                case 1: {
                    String pat2 = PluralRulesFactory.getSamplePattern(loc, ICU_ORDINAL, SupplementalDataInfo.PluralInfo.Count.other);
                    System.out.format("%s\t%s\t%s\t%s\n", new Object[]{loc, "constant", SupplementalDataInfo.PluralInfo.Count.other, "n/a"});
                    continue block4;
                }
            }
            for (SupplementalDataInfo.PluralInfo.Count count : counts) {
                pat = PluralRulesFactory.getSamplePattern(loc, ICU_ORDINAL, count);
                System.out.format("%s\t%s\t%s\t%s\n", new Object[]{loc, "multiple", count, pat});
            }
        }
    }

    public static void mainOld(String[] args) {
        TreeSet<String> testLocales = new TreeSet<String>(Arrays.asList("az cy hy ka kk km ky lo mk mn my ne pa si sq uz eu my si sq vi zu".split(" ")));
        System.out.println(testLocales);
        LanguageTagParser ltp = new LanguageTagParser();
        for (String locale : testLocales) {
            if (locale.equals("root") || locale.equals("en_GB") || locale.equals("es_419") || locale.equals("*")) continue;
            for (SupplementalDataInfo.PluralType type : SupplementalDataInfo.PluralType.values()) {
                if (type == SupplementalDataInfo.PluralType.cardinal) continue;
                SupplementalDataInfo.PluralInfo pluralInfo = SUPPLEMENTAL.getPlurals(type, locale, false);
                PluralRules rules = pluralInfo == null ? PluralRules.DEFAULT : pluralInfo.getPluralRules();
                Values values = new Values();
                values.locale = locale;
                values.type = type;
                for (int i = 0; i < 30; ++i) {
                    PluralRules.FixedDecimal fd = new PluralRules.FixedDecimal(i);
                    String keyword = rules.select(fd);
                    values.showValue(keyword, fd);
                }
                for (String keyword : rules.getKeywords()) {
                    PluralRules.FixedDecimalSamples samples = rules.getDecimalSamples(keyword, PluralRules.SampleType.DECIMAL);
                    values.showSamples(keyword, samples);
                    samples = rules.getDecimalSamples(keyword, PluralRules.SampleType.INTEGER);
                    values.showSamples(keyword, samples);
                }
                System.out.println(values);
            }
        }
    }

    static class Values {
        String locale;
        SupplementalDataInfo.PluralType type;
        Relation<SupplementalDataInfo.PluralInfo.Count, PluralRules.FixedDecimal> soFar = Relation.of(new EnumMap(SupplementalDataInfo.PluralInfo.Count.class), TreeSet.class);
        Map<PluralRules.FixedDecimal, String> sorted = new TreeMap<PluralRules.FixedDecimal, String>();

        Values() {
        }

        private void showValue(String keyword, PluralRules.FixedDecimal fd) {
            Set<PluralRules.FixedDecimal> soFarSet = this.soFar.getAll(keyword);
            if (soFarSet != null && soFarSet.contains(fd)) {
                return;
            }
            this.soFar.put(SupplementalDataInfo.PluralInfo.Count.valueOf(keyword), fd);
            this.sorted.put(fd, keyword);
        }

        public void showSamples(String keyword, PluralRules.FixedDecimalSamples samples) {
            if (samples == null) {
                return;
            }
            for (PluralRules.FixedDecimalRange range : samples.getSamples()) {
                Set<PluralRules.FixedDecimal> soFarSet = this.soFar.getAll(keyword);
                if (soFarSet != null && soFarSet.size() > 10) break;
                this.showValue(keyword, range.start);
                if (range.end.equals(range.start)) continue;
                soFarSet = this.soFar.getAll(keyword);
                if (soFarSet != null && soFarSet.size() > 10) break;
                this.showValue(keyword, range.end);
            }
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            for (Map.Entry<SupplementalDataInfo.PluralInfo.Count, Set<PluralRules.FixedDecimal>> entry : this.soFar.keyValuesSet()) {
                SupplementalDataInfo.PluralInfo.Count count = entry.getKey();
                for (PluralRules.FixedDecimal fd : entry.getValue()) {
                    String pattern = PluralRulesFactory.getSamplePattern(this.locale, this.type.standardType, count);
                    buffer.append(this.locale + "\t" + (Object)((Object)this.type) + "\t" + (Object)((Object)count) + "\t" + fd + "\t\u00ab" + pattern.replace("{0}", String.valueOf(fd)) + "\u00bb\n");
                }
                buffer.append("\n");
            }
            return buffer.toString();
        }
    }
}

