/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Output;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class MinimizeRegex {
    private static final Comparator<String> LENGTH_FIRST_COMPARE = Comparator.comparingInt(String::length).reversed().thenComparing(Comparator.naturalOrder());

    public static void main(String[] args) {
        String defaultArg = "zxx|zu|zh|zgh|yue|yo|yi|yav|xog|xh|wo|wae|vun|vo|vi|vai|uz|ur|und|uk|ug|tzm|twq|tt|tr|to|tk|ti|th|tg|teo|te|ta|sw|sv|su|st|sr|sq|so|sn|smn|sm|sl|sk|si|shi|sg|ses|seh|se|sd|sbp|saq|sah|sa|rwk|rw|ru|rof|ro|rn|rm|qu|pt|ps|prg|pl|pa|os|or|om|nyn|ny|nus|no|nnh|nn|nmg|nl|ne|nds|nd|nb|naq|mzn|my|mul|mua|mt|ms|mr|mn|ml|mk|mi|mgo|mgh|mg|mfe|mer|mas|lv|luy|luo|lu|lt|lrc|lo|ln|lkt|lg|lb|lag|la|ky|kw|ku|ksh|ksf|ksb|ks|kok|ko|kn|km|kln|kl|kkj|kk|ki|khq|kea|kde|kam|kab|ka|jv|jmc|jgo|ja|it|is|ii|ig|id|ia|hy|hu|ht|hsb|hr|hmn|hi|he|haw|ha|gv|guz|gu|gsw|gl|gd|ga|fy|fur|fr|fo|fil|fi|ff|fa|ewo|eu|et|es|eo|en|el|ee|ebu|dz|dyo|dua|dsb|dje|de|dav|da|cy|cu|cs|co|ckb|chr|cgg|ceb|ce|ccp|ca|bs|brx|br|bo|bn|bm|bg|bez|bem|be|bas|az|ast|asa|as|ar|am|ak|agq|af";
        String regexString = args.length < 1 ? defaultArg : args[0];
        UnicodeSet set = new UnicodeSet(args.length < 2 ? "[:ascii:]" : args[1]);
        System.out.println(defaultArg + "\n");
        Output<Set<String>> flattenedOut = new Output<Set<String>>();
        String recompressed = MinimizeRegex.compressWith(regexString, set, flattenedOut);
        System.out.println(Joiner.on("|").join((Iterable)flattenedOut.value) + "\n");
        System.out.println(recompressed + "\n");
    }

    public static String compressWith(String regexString, UnicodeSet set) {
        return MinimizeRegex.compressWith(regexString, set, null);
    }

    public static String simplePattern(Collection<String> strings) {
        TreeSet<String> temp = new TreeSet<String>(LENGTH_FIRST_COMPARE);
        temp.addAll(strings);
        return Joiner.on("|").join(temp);
    }

    public static String compressWith(String regexString, UnicodeSet set, Output<Set<String>> flattenedOut) {
        TreeSet<String> flattened = MinimizeRegex.flatten(Pattern.compile(regexString), "", set);
        String regexString2 = Joiner.on("|").join(flattened);
        TreeSet<String> flattened2 = MinimizeRegex.flatten(Pattern.compile(regexString2), "", set);
        if (!flattened2.equals(flattened)) {
            throw new IllegalArgumentException("Failed to compress: " + regexString + " using " + set + ", got " + regexString2);
        }
        if (flattenedOut != null) {
            flattenedOut.value = flattened;
        }
        return MinimizeRegex.compressWith(flattened, set);
    }

    public static String compressWith(Set<String> flattened, UnicodeSet set) {
        TreeSet<String> flattened2;
        String recompressed = MinimizeRegex.compress(flattened, new Output<Boolean>());
        try {
            flattened2 = MinimizeRegex.flatten(Pattern.compile(recompressed), "", set);
        }
        catch (PatternSyntaxException e) {
            int loc = e.getIndex();
            if (loc >= 0) {
                recompressed = recompressed.substring(0, loc) + "$$$$$" + recompressed.substring(loc);
            }
            throw new IllegalArgumentException("Failed to parse: " + recompressed, e);
        }
        if (!flattened2.equals(flattened)) {
            throw new IllegalArgumentException("Failed to compress:\n" + flattened + "\n\u2260 " + flattened2);
        }
        return recompressed;
    }

    private static String compress(Set<String> flattened, Output<Boolean> isSingle) {
        TreeMultimap<Integer, String> firstToRemainder = TreeMultimap.create();
        UnicodeSet results = new UnicodeSet();
        boolean hasEmpty = false;
        for (String string : flattened) {
            if (string.isEmpty()) {
                hasEmpty = true;
                continue;
            }
            int n = string.codePointAt(0);
            firstToRemainder.put(n, string.substring(UCharacter.charCount(n)));
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : firstToRemainder.asMap().entrySet()) {
            Set items = (Set)entry.getValue();
            buf.setLength(0);
            buf.appendCodePoint((Integer)entry.getKey());
            if (items.size() == 1) {
                buf.append((String)items.iterator().next());
            } else {
                String sub = MinimizeRegex.compress(items, isSingle);
                if (((Boolean)isSingle.value).booleanValue()) {
                    buf.append(sub);
                } else {
                    buf.append('(').append(sub).append(')');
                }
            }
            results.add(buf.toString());
        }
        TreeSet<String> treeSet = new TreeSet<String>(results.strings());
        results.removeAll(treeSet);
        switch (results.size()) {
            case 0: {
                break;
            }
            case 1: {
                treeSet.add(results.iterator().next());
                break;
            }
            default: {
                treeSet.add(results.toPattern(false));
            }
        }
        switch (treeSet.size()) {
            case 0: {
                throw new IllegalArgumentException();
            }
            case 1: {
                isSingle.value = true;
                return (String)treeSet.iterator().next() + (hasEmpty ? "?" : "");
            }
        }
        String string = Joiner.on("|").join(treeSet);
        if (hasEmpty) {
            isSingle.value = true;
            return '(' + string + ")?";
        }
        isSingle.value = false;
        return string;
    }

    public static TreeSet<String> flatten(Pattern pattern, String prefix, UnicodeSet set) {
        return MinimizeRegex.flatten(pattern.matcher(""), prefix, set, new TreeSet<String>(LENGTH_FIRST_COMPARE));
    }

    private static TreeSet<String> flatten(Matcher matcher, String prefix, UnicodeSet set, TreeSet<String> results) {
        for (String s2 : set) {
            String trial = prefix + s2;
            matcher.reset(trial);
            boolean matches = matcher.matches();
            if (matches) {
                results.add(trial);
            }
            if (!matcher.hitEnd()) continue;
            MinimizeRegex.flatten(matcher, trial, set, results);
        }
        return results;
    }
}

