/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagCanonicalizer;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.RegexUtilities;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class ShowStarredCoverage {
    static final CLDRConfig config = CLDRConfig.getInstance();
    static final PathStarrer pathStarrer = new PathStarrer().setSubstitutionPattern("*");
    static final PathHeader.Factory phf = PathHeader.getFactory(config.getEnglish());
    static final SupplementalDataInfo sdi = config.getSupplementalDataInfo();
    static final Set<PathHeader.PageId> MainDateTimePages = EnumSet.of(PathHeader.PageId.Fields, PathHeader.PageId.Gregorian, PathHeader.PageId.Generic);
    static final Pattern PARENS = Pattern.compile("\\s*\\(.*\\)");
    private static final boolean SHOW = false;

    public static void main(String[] args) {
        String[] values;
        MyOptions.parse(args, true);
        if (MyOptions.tag.option.doesOccur()) {
            new LanguageTagCollector().getLanguageTags();
            return;
        }
        EnumSet<DtdType> dtdTypes = EnumSet.noneOf(DtdType.class);
        for (String string : values = MyOptions.dtdTypes.option.getValue().split("[, ]+")) {
            dtdTypes.add(DtdType.valueOf(string));
        }
        String fileLocale = MyOptions.language.option.getValue();
        ChainedMap.M3<Level, PathHeader, Boolean> levelToPathHeaders = ChainedMap.of(new TreeMap(), new TreeMap(), Boolean.class);
        for (DtdType dtdType : DtdType.values()) {
            if (dtdTypes != null && !dtdTypes.contains((Object)dtdType)) continue;
            for (String dir : dtdType.directories) {
                if (dtdType == DtdType.ldml) {
                    ShowStarredCoverage.doLdml(dir, fileLocale, levelToPathHeaders);
                    continue;
                }
                ShowStarredCoverage.doNonLdml(dtdType, dir, fileLocale, levelToPathHeaders);
            }
        }
        System.out.println("\u2116\tLevel\tSection|Page\tStarredPath");
        for (Map.Entry entry : levelToPathHeaders) {
            Level level = (Level)((Object)entry.getKey());
            Map pathHeaders2 = (Map)entry.getValue();
            Counter<String> codeCount = new Counter<String>();
            for (PathHeader ph : pathHeaders2.keySet()) {
                codeCount.add(ShowStarredCoverage.condense(ph), 1L);
            }
            ShowStarredCoverage.showResults("code count", level, codeCount);
        }
    }

    private static String condense(PathHeader ph) {
        String starredPath = pathStarrer.set(ph.getOriginalPath()).toString();
        starredPath = starredPath.replace("[@alt=\"*\"]", "");
        PathHeader.SectionId sectionId = ph.getSectionId();
        PathHeader.PageId pageId = ph.getPageId();
        String category = (Object)((Object)sectionId) + "|" + (Object)((Object)pageId);
        switch (sectionId) {
            case Core_Data: {
                category = sectionId.toString();
                break;
            }
            case Currencies: {
                category = (Object)((Object)sectionId) + " \u2014 " + (starredPath.contains("@count") ? "long name" : (starredPath.contains("/symbol") ? "symbol" : "name"));
                break;
            }
            case DateTime: {
                category = (Object)((Object)sectionId) + " \u2014 " + (starredPath.contains("/displayName") ? "field labels" : (starredPath.contains("/interval") ? "intervals" : (pageId == PathHeader.PageId.Fields ? "relative" : "basic")));
                category = category + (MainDateTimePages.contains((Object)pageId) ? "" : " (non-greg)");
                break;
            }
            case Locale_Display_Names: {
                category = "Names \u2014 " + (starredPath.contains("/subdivision") ? "Country subdivisions" : (pageId == PathHeader.PageId.Territories ? "Continents & Sub~" : (pageId.toString().startsWith("Territor") ? "Countries" : pageId.toString())));
                break;
            }
            case Numbers: {
                category = pageId == PathHeader.PageId.Compact_Decimal_Formatting ? (starredPath.contains("currency") ? "Currency" : "Number") + " Formats \u2014 compact" : sectionId.toString();
                break;
            }
            case Misc: {
                category = starredPath.contains("/annotation") ? "Emoji " + (starredPath.contains("@type") ? "names" : "keywords") : (starredPath.contains("/characterLabel") ? "Character Labels" : PathHeader.PageId.LinguisticElements.toString());
                break;
            }
            case Timezones: {
                category = sectionId.toString();
                break;
            }
            case Units: {
                category = sectionId.toString();
            }
        }
        return ShowStarredCoverage.stripParens(category + "\t" + starredPath);
    }

    private static String stripParens(String label) {
        if (label.contains("(")) {
            String newLabel = PARENS.matcher(label).replaceAll("");
            if (label.equals(newLabel)) {
                System.out.println(RegexUtilities.showMismatch(Pattern.compile(".*" + PARENS.toString() + ".*"), (CharSequence)label));
            }
            return newLabel;
        }
        return label;
    }

    private static void showResults(String title, Level level, Counter<String> counts) {
        for (String key : counts.keySet()) {
            long results = counts.get(key);
            System.out.println(results + "\t" + (Object)((Object)level) + "\t" + key);
        }
    }

    private static void doNonLdml(DtdType dtdType, String dir, String fileLocale, ChainedMap.M3<Level, PathHeader, Boolean> levelToPathHeaders) {
        Matcher localeMatch = Pattern.compile("\\b" + fileLocale + "\\b").matcher("");
        for (String file : new File(CLDRPaths.COMMON_DIRECTORY + dir).list()) {
            List<Pair<String, String>> contents1;
            if (!file.endsWith(".xml")) continue;
            if (file.startsWith("plural")) {
                boolean bl = false;
            }
            try {
                contents1 = XMLFileReader.loadPathValues(CLDRPaths.COMMON_DIRECTORY + dir + "/" + file, new ArrayList<Pair<String, String>>(), true);
            }
            catch (Exception e) {
                return;
            }
            DtdData dtdData = DtdData.getInstance(dtdType);
            TreeMultimap<String, String> extras = TreeMultimap.create();
            for (Pair<String, String> s2 : contents1) {
                String path = s2.getFirst();
                if (path.contains("it")) {
                    boolean bl = false;
                }
                String value = s2.getSecond();
                XPathParts pathPlain = XPathParts.getFrozenInstance(path);
                if (dtdData.isMetadata(pathPlain)) continue;
                Set<String> pathForValues = dtdData.getRegularizedPaths(pathPlain, extras);
                if (pathForValues != null) {
                    for (String string : pathForValues) {
                        if (!localeMatch.reset(string).find() && !localeMatch.reset(value).find()) continue;
                        PathHeader pathHeader = phf.fromPath(string);
                        levelToPathHeaders.put(Level.UNDETERMINED, pathHeader, true);
                        Splitter splitter = DtdData.getValueSplitter(pathPlain);
                        for (String line : splitter.split(value)) {
                            if (!ShowStarredCoverage.isComment(pathPlain, line)) continue;
                        }
                    }
                }
                for (Map.Entry entry : extras.asMap().entrySet()) {
                    String extraPath = (String)entry.getKey();
                    for (String value2 : (Collection)entry.getValue()) {
                        if (!localeMatch.reset(extraPath).find() && !localeMatch.reset(value2).find()) continue;
                        PathHeader pathHeaderExtra = phf.fromPath(extraPath);
                        levelToPathHeaders.put(Level.UNDETERMINED, pathHeaderExtra, true);
                    }
                }
            }
        }
    }

    static boolean isExtraSplit(String extraPath) {
        return extraPath.endsWith("/_type") && extraPath.startsWith("//supplementalData/metaZones/mapTimezones");
    }

    public static boolean isComment(XPathParts pathPlain, String line) {
        return pathPlain.contains("transform") && line.startsWith("#");
    }

    private static void doLdml(String dir, String fileLocale, ChainedMap.M3<Level, PathHeader, Boolean> levelToPathHeaders) {
        CLDRFile file;
        CLDRFile.Status status = new CLDRFile.Status();
        boolean isMain = "main".equals(dir);
        System.out.println("directory:\t" + dir);
        Factory cldrFactory = Factory.make(CLDRPaths.COMMON_DIRECTORY + dir, fileLocale, CLDRFile.DraftStatus.unconfirmed);
        try {
            file = cldrFactory.make(fileLocale, isMain);
        }
        catch (Exception e) {
            System.out.println((Object)((Object)Level.UNDETERMINED) + "\tNo file " + dir + "/" + fileLocale + ".xml");
            return;
        }
        ChainedMap.M4 levelToData = ChainedMap.of(new TreeMap(), new TreeMap(), new TreeMap(), Boolean.class);
        Counter<Level> counter = new Counter<Level>();
        TreeSet<PathHeader> pathHeaders = new TreeSet<PathHeader>();
        for (String path : file) {
            if (path.endsWith("/alias") || path.startsWith("//ldml/identity")) continue;
            String locale = file.getSourceLocaleID(path, status);
            if (!path.equals(status.pathWhereFound) || config.getSupplementalDataInfo().isDeprecated(DtdType.ldml, path)) continue;
            PathHeader ph = phf.fromPath(path);
            CLDRLocale loc = CLDRLocale.getInstance(fileLocale);
            int requiredVotes = sdi.getRequiredVotes(loc, ph);
            Level level = config.getSupplementalDataInfo().getCoverageLevel(path, fileLocale);
            if (level.compareTo(Level.MODERN) > 0) continue;
            levelToPathHeaders.put(level, ph, true);
            pathHeaders.add(ph);
            PathHeader.SurveyToolStatus stStatus = ph.getSurveyToolStatus();
            String starred = pathStarrer.set(path);
            String attributes = Joiner.on("|").join(pathStarrer.getAttributes());
            levelToData.put(level, starred + "|" + (Object)((Object)stStatus) + "|" + requiredVotes, attributes, Boolean.TRUE);
            counter.add(level, 1L);
        }
    }

    static class LanguageTagCollector {
        private static final CLDRConfig CldrConfig = CLDRConfig.getInstance();
        LanguageTagParser ltp = new LanguageTagParser();
        LanguageTagCanonicalizer ltc = new LanguageTagCanonicalizer();
        Relation<String, Source> languageTags = Relation.of(new TreeMap(new SupplementalDataInfo.LengthFirstComparator()), TreeSet.class);
        final SupplementalDataInfo supp = CldrConfig.getSupplementalDataInfo();
        final Map<String, Row.R2<List<String>, String>> languageFix = this.supp.getLocaleAliasInfo().get("language");

        LanguageTagCollector() {
        }

        private void getLanguageTags() {
            Map<String, String> likely = this.supp.getLikelySubtags();
            for (Map.Entry<String, String> entry : likely.entrySet()) {
                this.addLanguage(entry.getKey(), Source.canon);
            }
            for (String string : this.supp.getLanguagesForTerritoriesPopulationData()) {
                this.addLanguage(string, Source.supp);
            }
            for (String string : this.supp.getLanguages()) {
                this.addLanguage(string, Source.supp);
            }
            for (String string : this.supp.getBasicLanguageDataLanguages()) {
                this.addLanguage(string, Source.supp);
            }
            for (Map.Entry entry : this.languageFix.entrySet()) {
                String lang = (String)entry.getKey();
                if (lang.contains("_")) continue;
                this.addLanguage(lang, Source.alias);
            }
            File base = CldrConfig.getCldrBaseDirectory();
            this.addFiles(base, "common/main", Source.main);
            this.addFiles(base, "exemplars/main", Source.exemplars);
            this.addFiles(base, "seed/main", Source.seed);
            this.addFiles(base, "keyboards", Source.keyboards);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (Map.Entry<String, Set<Source>> entry : this.languageTags.keyValuesSet()) {
                String written = entry.getKey();
                String name = this.getName(written);
                Set<Source> source = entry.getValue();
                if (source.contains((Object)Source.alias) && source.size() > 1) {
                    linkedHashSet.add(written + "\t" + name + "\t" + this.languageFix.get(written).get0() + "\t" + Joiner.on(" ").join(source));
                    source = Collections.singleton(Source.alias);
                }
                System.out.println(written + "\t" + name + "\t" + Joiner.on(" ").join(source));
            }
            for (String s2 : linkedHashSet) {
                System.out.println("BAD:\t" + s2);
            }
        }

        public String getName(String written) {
            Row.R2<List<String>, String> alias;
            String result = CldrConfig.getEnglish().getName(written);
            if (result.equals(written) && (alias = this.languageFix.get(written)) != null) {
                result = CldrConfig.getEnglish().getName((String)((List)alias.get0()).get(0));
            }
            return result;
        }

        private void addFiles(File base, String name, Source source) {
            this.addFiles(new File(base, name), source);
        }

        private void addFiles(File base, Source source) {
            if (!base.isDirectory()) {
                return;
            }
            for (File file : base.listFiles()) {
                if (file.isDirectory()) {
                    this.addFiles(file, source);
                    continue;
                }
                String fileName = file.getName();
                if (!fileName.endsWith(".xml") || fileName.startsWith("_")) continue;
                this.addLanguage(fileName.substring(0, fileName.length() - 4), source);
            }
        }

        private void addLanguage(String key, Source source) {
            if (key.startsWith("und") || key.startsWith("root")) {
                this.languageTags.put("und", source);
                return;
            }
            this.ltp.set(key);
            this.languageTags.put(this.ltp.getLanguage(), source);
        }

        static enum Source {
            main,
            canon,
            supp,
            seed,
            exemplars,
            keyboards,
            alias;

        }
    }

    static enum MyOptions {
        language(".*", "it", "language to gather coverage data for"),
        tag(".*", null, "gather data on language tags"),
        dtdTypes(".*", "ldml", "dtdTypes, comma separated.");

        final Option option;
        static Option.Options myOptions;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = new Option(this, argumentPattern, defaultArgument, helpText);
        }

        private static Set<String> parse(String[] args, boolean showArguments) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }
}

