/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.dev.util.UnicodeMap;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.CharSequences;
import com.ibm.icu.text.SimpleFormatter;
import com.ibm.icu.text.Transform;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetSpanner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.ChartAnnotations;
import org.unicode.cldr.tool.SubdivisionNames;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.EmojiConstants;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.XListFormatter;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class Annotations {
    private static final boolean DEBUG = false;
    public static final String BAD_MARKER = "\u2297";
    public static final String MISSING_MARKER = "\u2296";
    public static final String ENGLISH_MARKER = "\u2295";
    public static final String EQUIVALENT = "\u2263";
    public static final String NEUTRAL_HOLDING = "\ud83e\uddd1\u200d\ud83e\udd1d\u200d\ud83e\uddd1";
    public static final Splitter splitter = Splitter.on(Pattern.compile("[|;]")).trimResults().omitEmptyStrings();
    static final Splitter dotSplitter = Splitter.on(".").trimResults();
    static final Map<String, Map<String, AnnotationSet>> cache = new ConcurrentHashMap<String, Map<String, AnnotationSet>>();
    static final Set<String> LOCALES;
    static final String DIR;
    private static final AnnotationSet ENGLISH_DATA;
    private final Set<String> annotations;
    private final String tts;

    public Annotations(Set<String> attributes, String tts2) {
        this.annotations = attributes == null ? Collections.emptySet() : ImmutableSet.copyOf(attributes);
        for (String attr : this.annotations) {
            if (!attr.contains(CldrUtility.INHERITANCE_MARKER)) continue;
            throw new IllegalArgumentException(CldrUtility.INHERITANCE_MARKER);
        }
        this.tts = tts2;
        if (this.tts != null && this.tts.contains(CldrUtility.INHERITANCE_MARKER)) {
            throw new IllegalArgumentException(CldrUtility.INHERITANCE_MARKER);
        }
    }

    public Annotations add(Set<String> attributes, String tts2) {
        return new Annotations(this.getKeywords() == null ? attributes : (attributes == null ? this.getKeywords() : this.union(attributes, this.getKeywords())), this.getShortName() == null ? tts2 : (tts2 == null ? this.getShortName() : this.throwDup()));
    }

    private String throwDup() {
        throw new IllegalArgumentException("Duplicate tts");
    }

    private Set<String> union(Set<String> a, Set<String> b) {
        TreeSet<String> result = new TreeSet<String>(a);
        result.addAll(b);
        return result;
    }

    public static Set<String> getAvailable() {
        return LOCALES;
    }

    public static Set<String> getAvailableLocales() {
        return LOCALES;
    }

    public static AnnotationSet getDataSet(String locale) {
        return Annotations.getDataSet(DIR, locale);
    }

    public static AnnotationSet getDataSet(String dir, String locale) {
        AnnotationSet result;
        Map<String, AnnotationSet> dirCache;
        if (dir == null) {
            dir = DIR;
        }
        if ((dirCache = cache.get(dir)) == null) {
            dirCache = new ConcurrentHashMap<String, AnnotationSet>();
            cache.put(dir, dirCache);
        }
        if ((result = dirCache.get(locale)) != null) {
            return result;
        }
        if (!LOCALES.contains(locale)) {
            return null;
        }
        String parentString = LocaleIDParser.getParent(locale);
        AnnotationSet parentData = null;
        if (parentString != null && !parentString.equals("root")) {
            parentData = Annotations.getDataSet(dir, parentString);
        }
        MyHandler myHandler = new MyHandler(dirCache, locale, parentData);
        XMLFileReader xfr = new XMLFileReader().setHandler(myHandler);
        xfr.read(dir + "/" + locale + ".xml", -1, true);
        return myHandler.cleanup();
    }

    public static UnicodeMap<Annotations> getData(String locale) {
        return Annotations.getData(DIR, locale);
    }

    public static UnicodeMap<Annotations> getData(String dir, String locale) {
        AnnotationSet result = Annotations.getDataSet(dir, locale);
        return result == null ? null : result.baseData;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean html) {
        Set<String> annotations2 = this.getKeywords();
        if (this.getShortName() != null && annotations2.contains(this.getShortName())) {
            annotations2 = new LinkedHashSet<String>(this.getKeywords());
            annotations2.remove(this.getShortName());
        }
        String result = Joiner.on(" |\u00a0").join(annotations2);
        if (this.getShortName() != null) {
            String ttsString = (html ? "*<b>" : "*") + this.getShortName() + (html ? "</b>" : "*");
            result = result.isEmpty() ? ttsString : ttsString + (html ? "<br>|\u00a0" : " |\u00a0") + result;
        }
        return result;
    }

    public Set<String> getKeywords() {
        return this.annotations;
    }

    public String getShortName() {
        return this.tts;
    }

    public static void main(String[] args) {
        Annotations.writeList();
    }

    private static void writeList() {
        AnnotationSet eng = Annotations.getDataSet("en");
        Annotations an = (Annotations)eng.baseData.get("\u2764");
        UnicodeMap<Annotations> map = eng.getUnresolvedExplicitValues();
        TreeSet<Object> keys = new TreeSet<Object>(ChartAnnotations.RBC);
        map.keySet().addAllTo(keys);
        for (String string : keys) {
            System.out.println(Utility.hex(string, 4, "_").toLowerCase(Locale.ROOT) + "\t" + string + "\t" + map.get(string).getShortName() + "\t" + Joiner.on(" | ").join(map.get(string).getKeywords()));
        }
        for (String string : Arrays.asList("\ud83d\udc8f", "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69", "\ud83d\udc91", "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc69", "\ud83d\udc6a", "\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d\udc67", "\ud83d\udc66\ud83c\udffb", "\ud83d\udc69\ud83c\udfff", "\ud83d\udc68\u200d\u2696", "\ud83d\udc68\ud83c\udfff\u200d\u2696", "\ud83d\udc69\u200d\u2696", "\ud83d\udc69\ud83c\udffc\u200d\u2696", "\ud83d\udc6e", "\ud83d\udc6e\u200d\u2642\ufe0f", "\ud83d\udc6e\ud83c\udffc\u200d\u2642\ufe0f", "\ud83d\udc6e\u200d\u2640\ufe0f", "\ud83d\udc6e\ud83c\udfff\u200d\u2640\ufe0f", "\ud83d\udeb4", "\ud83d\udeb4\ud83c\udfff", "\ud83d\udeb4\u200d\u2642\ufe0f", "\ud83d\udeb4\ud83c\udfff\u200d\u2642\ufe0f", "\ud83d\udeb4\u200d\u2640\ufe0f", "\ud83d\udeb4\ud83c\udfff\u200d\u2640\ufe0f")) {
            String shortName = eng.getShortName(string);
            Set<String> keywords = eng.getKeywords(string);
            System.out.println("{\"" + string + "\",\"" + shortName + "\",\"" + Joiner.on("|").join(keywords) + "\"},");
        }
    }

    private static void writeEnglish() {
        AnnotationSet eng = Annotations.getDataSet("en");
        System.out.println(Annotations.getAvailable());
        AnnotationSet eng100 = Annotations.getDataSet("en_001");
        UnicodeMap<Annotations> map100 = eng100.getUnresolvedExplicitValues();
        UnicodeMap<Annotations> map = eng.getUnresolvedExplicitValues();
        TreeSet<Object> keys = new TreeSet<Object>(ChartAnnotations.RBC);
        map.keySet().addAllTo(keys);
        for (String string : keys) {
            Annotations value = map.get(string);
            Annotations value100 = map100.get(string);
            Set<String> keywords100 = value100 == null ? null : value100.getKeywords();
            System.out.println(string + "\tname\t\t" + value.getShortName() + "\t" + (value100 == null ? "" : value100.getShortName()) + "\t" + Joiner.on(" | ").join(value.getKeywords()) + "\t" + (keywords100 == null ? "" : Joiner.on(" | ").join(keywords100)));
        }
    }

    static {
        File directory = new File(CLDRPaths.COMMON_DIRECTORY, "annotations");
        DIR = PathUtilities.getNormalizedPathString(directory);
        ImmutableSet.Builder temp = ImmutableSet.builder();
        for (File file : directory.listFiles()) {
            String name = file.toString();
            String shortName = file.getName();
            if (!shortName.endsWith(".xml") || shortName.startsWith("#") || shortName.startsWith(".")) continue;
            temp.add(dotSplitter.split(shortName).iterator().next());
        }
        LOCALES = temp.build();
        ENGLISH_DATA = Annotations.getDataSet("en");
    }

    public static final class AnnotationSet {
        private static final CLDRConfig CONFIG = CLDRConfig.getInstance();
        static final Factory factory = CONFIG.getCldrFactory();
        static final CLDRFile ENGLISH = CONFIG.getEnglish();
        static final CLDRFile ENGLISH_ANNOTATIONS = null;
        static final SubdivisionNames englishSubdivisionIdToName = new SubdivisionNames("en", "main");
        private final String locale;
        private final UnicodeMap<Annotations> baseData;
        private final UnicodeMap<Annotations> unresolvedData;
        private final CLDRFile cldrFile;
        private final SubdivisionNames subdivisionIdToName;
        private final SimpleFormatter initialPattern;
        private final Pattern initialRegexPattern;
        private final XListFormatter listPattern;
        private final Set<String> flagLabelSet;
        private final Set<String> keycapLabelSet;
        private final String keycapLabel;
        private final String flagLabel;
        private final Map<String, Annotations> localeCache = new ConcurrentHashMap<String, Annotations>();
        static UnicodeSetSpanner uss = new UnicodeSetSpanner(EmojiConstants.COMPONENTS);

        private AnnotationSet(String locale, UnicodeMap<Annotations> source, UnicodeMap<Annotations> resolvedSource) {
            this.locale = locale;
            this.unresolvedData = source.freeze();
            this.baseData = resolvedSource == null ? this.unresolvedData : resolvedSource.freeze();
            this.cldrFile = factory.make(locale, true);
            this.subdivisionIdToName = new SubdivisionNames(locale, "main", "subdivisions");
            this.listPattern = new XListFormatter(this.cldrFile, EmojiConstants.COMPOSED_NAME_LIST);
            String initialPatternString = this.getStringValue("//ldml/characterLabels/characterLabelPattern[@type=\"category-list\"]");
            this.initialPattern = SimpleFormatter.compile(initialPatternString);
            String regexPattern = ("\\Q" + initialPatternString.replace("{0}", "\\E.*\\Q").replace("{1}", "\\E.*\\Q") + "\\E").replace("\\Q\\E", "");
            this.initialRegexPattern = Pattern.compile(regexPattern);
            this.flagLabelSet = this.getLabelSet("flag");
            this.flagLabel = this.flagLabelSet.isEmpty() ? null : this.flagLabelSet.iterator().next();
            this.keycapLabelSet = this.getLabelSet("keycap");
            this.keycapLabel = this.keycapLabelSet.isEmpty() ? null : this.keycapLabelSet.iterator().next();
        }

        @Deprecated
        private Set<String> getLabelSet() {
            return this.getLabelSet("flag");
        }

        private Set<String> getLabelSet(String typeAttributeValue) {
            String label = this.getStringValue("//ldml/characterLabels/characterLabel[@type=\"" + typeAttributeValue + "\"]");
            return label == null ? Collections.emptySet() : Collections.singleton(label);
        }

        private String getStringValue(String xpath) {
            return this.getStringValue(xpath, this.cldrFile, ENGLISH);
        }

        private String getStringValue(String xpath, CLDRFile cldrFile2, CLDRFile english) {
            String result = cldrFile2.getStringValueWithBailey(xpath);
            if (result == null) {
                return Annotations.ENGLISH_MARKER + english.getStringValueWithBailey(xpath);
            }
            String sourceLocale = cldrFile2.getSourceLocaleID(xpath, null);
            if ((sourceLocale.equals("code-fallback") || sourceLocale.equals("root")) && !xpath.equals("//ldml/characterLabels/characterLabelPattern[@type=\"category-list\"]")) {
                return Annotations.MISSING_MARKER + result;
            }
            return result;
        }

        public String getShortName(String code) {
            return this.getShortName(code, null);
        }

        public String getShortName(String code, Transform<String, String> otherSource) {
            Annotations stock;
            if (code.equals("\ud83e\uddd9\u200d\u2640\ufe0f")) {
                boolean bl = false;
            }
            if ((stock = this.baseData.get(code = code.replace("\ufe0f", ""))) != null && stock.tts != null) {
                return stock.tts;
            }
            stock = this.localeCache.get(code);
            if (stock != null) {
                return stock.tts;
            }
            stock = this.synthesize(code, otherSource);
            if (stock != null) {
                this.localeCache.put(code, stock);
                return stock.tts;
            }
            return null;
        }

        public Set<String> getKeywords(String code) {
            Annotations stock = this.baseData.get(code = code.replace("\ufe0f", ""));
            if (stock != null && stock.annotations != null) {
                return stock.annotations;
            }
            stock = this.localeCache.get(code);
            if (stock != null) {
                return stock.annotations;
            }
            stock = this.synthesize(code, null);
            if (stock != null) {
                this.localeCache.put(code, stock);
                return stock.annotations;
            }
            return Collections.emptySet();
        }

        public UnicodeSet keySet() {
            return this.baseData.keySet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Annotations synthesize(String code, Transform<String, String> otherSource) {
            if (code.equals("\ud83d\udc71\ud83c\udffb\u200d\u2642")) {
                boolean bl = false;
            }
            String shortName = null;
            int len = code.codePointCount(0, code.length());
            boolean isKeycap10 = code.equals("\ud83d\udd1f");
            if (len == 1 && !isKeycap10) {
                String tempName = null;
                if (this.locale.equals("en")) {
                    if (otherSource != null) {
                        tempName = otherSource.transform(code);
                    }
                    if (tempName == null) {
                        return null;
                    }
                    return new Annotations(Collections.emptySet(), tempName);
                }
                tempName = Annotations.getDataSet("en").getShortName(code);
                if (tempName == null) {
                    return null;
                }
                return new Annotations(Collections.emptySet(), Annotations.ENGLISH_MARKER + tempName);
            }
            if (EmojiConstants.REGIONAL_INDICATORS.containsAll(code)) {
                String countryCode = EmojiConstants.getFlagCode(code);
                String path = CLDRFile.getKey(2, countryCode);
                String regionName = this.getStringValue(path);
                if (regionName == null) {
                    regionName = Annotations.ENGLISH_MARKER + ENGLISH.getStringValueWithBailey(path);
                }
                String flagName = this.flagLabel == null ? regionName : this.initialPattern.format(this.flagLabel, regionName);
                return new Annotations(this.flagLabelSet, flagName);
            }
            if (code.startsWith(EmojiConstants.BLACK_FLAG) && code.endsWith(EmojiConstants.TAG_TERM)) {
                String subdivisionCode = EmojiConstants.getTagSpec(code);
                String subdivisionName = this.subdivisionIdToName.get(subdivisionCode);
                if (subdivisionName == null) {
                    subdivisionName = Annotations.MISSING_MARKER + subdivisionCode;
                }
                String flagName = this.flagLabel == null ? subdivisionName : this.initialPattern.format(this.flagLabel, subdivisionName);
                return new Annotations(this.flagLabelSet, flagName);
            }
            if (isKeycap10 || code.contains("\u20e3")) {
                String rem = code.equals("\ud83d\udd1f") ? "10" : UTF16.valueOf(code.charAt(0));
                shortName = this.initialPattern.format(this.keycapLabel, rem);
                return new Annotations(this.keycapLabelSet, shortName);
            }
            UnicodeSet skipSet = EmojiConstants.REM_SKIP_SET;
            String rem = "";
            SimpleFormatter startPattern = this.initialPattern;
            if (EmojiConstants.COMPONENTS.containsSome(code)) {
                UnicodeSetSpanner unicodeSetSpanner = uss;
                synchronized (unicodeSetSpanner) {
                    rem = uss.deleteFrom(code, UnicodeSet.SpanCondition.NOT_CONTAINED);
                    code = uss.deleteFrom(code, UnicodeSet.SpanCondition.CONTAINED);
                }
            }
            if (code.contains(EmojiConstants.JOINER_STRING)) {
                if (code.contains("\ud83d\udc8b")) {
                    rem = code + rem;
                    code = "\ud83d\udc8f";
                    skipSet = EmojiConstants.REM_GROUP_SKIP_SET;
                } else if (code.contains("\u2764") && !code.startsWith("\u2764")) {
                    rem = code + rem;
                    code = "\ud83d\udc91";
                    skipSet = EmojiConstants.REM_GROUP_SKIP_SET;
                } else if (code.equals(EmojiConstants.COMPOSED_HANDSHAKE)) {
                    code = EmojiConstants.HANDSHAKE;
                } else if (code.contains(EmojiConstants.HANDSHAKE)) {
                    code = code.startsWith("\ud83d\udc68") ? "\ud83d\udc6c" : (code.endsWith("\ud83d\udc68") ? "\ud83d\udc6b" : (code.startsWith("\ud83d\udc69") ? "\ud83d\udc6d" : Annotations.NEUTRAL_HOLDING));
                    skipSet = EmojiConstants.REM_GROUP_SKIP_SET;
                } else if (EmojiConstants.FAMILY_MARKERS.containsAll(code)) {
                    rem = code + rem;
                    code = "\ud83d\udc6a";
                    skipSet = EmojiConstants.REM_GROUP_SKIP_SET;
                }
            }
            return this.getBasePlusRemainder(this.cldrFile, code, rem, skipSet, startPattern, otherSource);
        }

        private boolean matchesInitialPattern(String code) {
            Annotations baseAnnotation = this.baseData.get(code);
            String baseName = baseAnnotation == null ? null : baseAnnotation.getShortName();
            return baseName != null && this.initialRegexPattern.matcher(baseName).matches();
        }

        private Annotations getBasePlusRemainder(CLDRFile cldrFile, String base, String rem, UnicodeSet ignore, SimpleFormatter pattern, Transform<String, String> otherSource) {
            String shortName = null;
            LinkedHashSet<String> annotations = new LinkedHashSet<String>();
            boolean needMarker = true;
            if (base != null) {
                needMarker = false;
                Annotations stock = this.baseData.get(base);
                if (stock != null) {
                    shortName = stock.getShortName();
                    annotations.addAll(stock.getKeywords());
                } else if (otherSource != null) {
                    shortName = otherSource.transform(base);
                } else {
                    return null;
                }
                if (shortName == null) {
                    return null;
                }
            }
            boolean hackBlond = EmojiConstants.HAIR_EXPLICIT.contains(base.codePointAt(0));
            ArrayList<String> arguments = new ArrayList<String>();
            int lastSkin = -1;
            for (int mod : CharSequences.codePoints(rem)) {
                if (ignore.contains(mod)) continue;
                if (EmojiConstants.MODIFIERS.contains(mod)) {
                    if (lastSkin == mod) continue;
                    lastSkin = mod;
                }
                Annotations stock = this.baseData.get(mod);
                String modName = null;
                if (stock != null) {
                    modName = stock.getShortName();
                } else if (otherSource != null) {
                    modName = otherSource.transform(base);
                }
                if (modName == null) {
                    Annotations engName;
                    needMarker = true;
                    if (ENGLISH_DATA != null && (engName = ENGLISH_DATA.baseData.get(mod)) != null) {
                        modName = engName.getShortName();
                    }
                    if (modName == null) {
                        modName = Utility.hex(mod);
                    }
                }
                if (hackBlond && shortName != null) {
                    String sep = this.initialPattern.format("", "");
                    int splitPoint = shortName.indexOf(sep);
                    if (splitPoint >= 0) {
                        String modName0 = shortName.substring(splitPoint + sep.length());
                        shortName = shortName.substring(0, splitPoint);
                        if (modName != null) {
                            arguments.add(modName);
                            annotations.add(modName);
                        }
                        modName = modName0;
                    }
                    hackBlond = false;
                }
                if (modName == null) continue;
                arguments.add(modName);
                annotations.add(modName);
            }
            if (!arguments.isEmpty()) {
                shortName = pattern.format(shortName, this.listPattern.format(arguments));
            }
            Annotations result = new Annotations(annotations, (needMarker ? Annotations.ENGLISH_MARKER : "") + shortName);
            return result;
        }

        @Deprecated
        public String toString(String code, boolean html) {
            return this.toString(code, html, null);
        }

        public String toString(String code, boolean html, AnnotationSet parentAnnotations) {
            Set<String> parentKeywords;
            String parentShortName;
            String shortName;
            if (this.locale.equals("be") && code.equals("\ud83e\udd17")) {
                boolean bl = false;
            }
            if ((shortName = this.getShortName(code)) == null || shortName.startsWith(Annotations.BAD_MARKER) || shortName.startsWith(Annotations.ENGLISH_MARKER)) {
                return Annotations.MISSING_MARKER;
            }
            String string = parentShortName = parentAnnotations == null ? null : parentAnnotations.getShortName(code);
            if (shortName != null && Objects.equal(shortName, parentShortName)) {
                shortName = Annotations.EQUIVALENT;
            }
            Set<String> keywords = this.getKeywordsMinus(code);
            Set<String> set = parentKeywords = parentAnnotations == null ? null : parentAnnotations.getKeywordsMinus(code);
            if (keywords != null && !keywords.isEmpty() && Objects.equal(keywords, parentKeywords)) {
                keywords = Collections.singleton(Annotations.EQUIVALENT);
            }
            String result = Joiner.on(" |\u00a0").join(keywords);
            if (shortName != null) {
                String ttsString = (html ? "*<b>" : "*") + shortName + (html ? "</b>" : "*");
                result = result.isEmpty() ? ttsString : ttsString + (html ? "<br>|\u00a0" : " |\u00a0") + result;
            }
            return result;
        }

        public UnicodeMap<Annotations> getExplicitValues() {
            return this.baseData;
        }

        public UnicodeMap<Annotations> getUnresolvedExplicitValues() {
            return this.unresolvedData;
        }

        public Set<String> getKeywordsMinus(String code) {
            String shortName = this.getShortName(code);
            Set<String> keywords = this.getKeywords(code);
            if (shortName != null && keywords.contains(shortName)) {
                keywords = new LinkedHashSet<String>(keywords);
                keywords.remove(shortName);
            }
            return keywords;
        }
    }

    static class MyHandler
    extends XMLFileReader.SimpleHandler {
        private final String locale;
        private final UnicodeMap<Annotations> localeData = new UnicodeMap();
        private final AnnotationSet parentData;
        private final Map<String, AnnotationSet> dirCache;
        static final Pattern SPACES = Pattern.compile("\\s+");

        public MyHandler(Map<String, AnnotationSet> dirCache, String locale, AnnotationSet parentData) {
            this.locale = locale;
            this.parentData = parentData;
            this.dirCache = dirCache;
        }

        public AnnotationSet cleanup() {
            UnicodeMap<Annotations> templocaleData = null;
            if (this.parentData != null) {
                templocaleData = new UnicodeMap<Annotations>();
                UnicodeSet keys = new UnicodeSet(this.parentData.baseData.keySet()).addAll(this.localeData.keySet());
                for (String key : keys) {
                    Annotations parentValue = (Annotations)this.parentData.baseData.get(key);
                    Annotations myValue = this.localeData.get(key);
                    if (parentValue == null) {
                        templocaleData.put(key, myValue);
                        continue;
                    }
                    if (myValue == null) {
                        templocaleData.put(key, parentValue);
                        continue;
                    }
                    String tts = myValue.tts == null ? parentValue.tts : myValue.tts;
                    Set annotations = myValue.annotations == null || myValue.annotations.isEmpty() ? parentValue.annotations : myValue.annotations;
                    templocaleData.put(key, new Annotations(annotations, tts));
                }
            }
            AnnotationSet result = new AnnotationSet(this.locale, this.localeData, templocaleData);
            this.dirCache.put(this.locale, result);
            return result;
        }

        @Override
        public void handlePathValue(String path, String value) {
            if (value.contains(CldrUtility.INHERITANCE_MARKER)) {
                return;
            }
            XPathParts parts = XPathParts.getFrozenInstance(path);
            String lastElement = parts.getElement(-1);
            if (!lastElement.equals("annotation")) {
                if (!"identity".equals(parts.getElement(1))) {
                    throw new IllegalArgumentException("Unexpected path");
                }
                return;
            }
            String usString = parts.getAttributeValue(-1, "cp");
            UnicodeSet us1 = usString.startsWith("[") && usString.endsWith("]") ? new UnicodeSet(usString) : new UnicodeSet().add(usString);
            UnicodeSet us = new UnicodeSet();
            for (String s2 : us1) {
                us.add(s2.replace("\ufe0f", ""));
            }
            String tts = parts.getAttributeValue(-1, "tts");
            String type = parts.getAttributeValue(-1, "type");
            String alt = parts.getAttributeValue(-1, "alt");
            String value2 = SPACES.matcher(value).replaceAll(" ").trim();
            if (!value2.equals(value)) {
                value = value2;
            }
            if (alt == null) {
                if ("tts".equals(type)) {
                    this.addItems(this.localeData, us, Collections.emptySet(), value);
                } else {
                    TreeSet<String> attributes = new TreeSet<String>(splitter.splitToList(value));
                    this.addItems(this.localeData, us, attributes, tts);
                }
            }
        }

        private void addItems(UnicodeMap<Annotations> unicodeMap, UnicodeSet us, Set<String> attributes, String tts) {
            for (String entry : us) {
                this.addItems(unicodeMap, entry, attributes, tts);
            }
        }

        private void addItems(UnicodeMap<Annotations> unicodeMap, String entry, Set<String> attributes, String tts) {
            Annotations annotations = unicodeMap.get(entry);
            if (annotations == null) {
                unicodeMap.put(entry, new Annotations(attributes, tts));
            } else {
                unicodeMap.put(entry, annotations.add(attributes, tts));
            }
        }
    }
}

