/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUException;
import com.ibm.icu.util.Output;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.LanguageInfo;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.RegexUtilities;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Validity;

public class AttributeValueValidity {
    static final Splitter BAR = Splitter.on('|').trimResults().omitEmptyStrings();
    static final Splitter SPACE = Splitter.on(PatternCache.get("\\s+")).trimResults().omitEmptyStrings();
    private static final Set<DtdType> ALL_DTDs = Collections.unmodifiableSet(EnumSet.allOf(DtdType.class));
    private static final SupplementalDataInfo supplementalData = CLDRConfig.getInstance().getSupplementalDataInfo();
    private static Map<DtdType, Map<String, Map<String, MatcherPattern>>> dtd_element_attribute_validity = new EnumMap<DtdType, Map<String, Map<String, MatcherPattern>>>(DtdType.class);
    private static Map<String, MatcherPattern> common_attribute_validity = new LinkedHashMap<String, MatcherPattern>();
    private static Map<String, MatcherPattern> variables = new LinkedHashMap<String, MatcherPattern>();
    private static final RegexMatcher NOT_DONE_YET = new RegexMatcher(".*", 4);
    private static final Map<SupplementalDataInfo.AttributeValidityInfo, String> failures = new LinkedHashMap<SupplementalDataInfo.AttributeValidityInfo, String>();
    private static final boolean DEBUG = false;
    private static EnumMap<LocaleSpecific, Set<String>> LOCALE_SPECIFIC;
    static final int MAX_STRING = 64;

    private static void addCollectionVariable(String name, Set<String> validItems) {
        variables.put(name, new CollectionMatcher(validItems));
    }

    public static Relation<String, String> getAllPossibleMissing(DtdType dtdType) {
        Relation<String, String> missing = Relation.of(new TreeMap(), LinkedHashSet.class);
        if (dtdType == DtdType.ldmlICU) {
            return missing;
        }
        DtdData dtdData2 = DtdData.getInstance(dtdType);
        Map element_attribute_validity = CldrUtility.ifNull(dtd_element_attribute_validity.get((Object)dtdType), Collections.emptyMap());
        for (DtdData.Element element : dtdData2.getElements()) {
            if (element.isDeprecated()) continue;
            Map attribute_validity = CldrUtility.ifNull(element_attribute_validity.get(element.name), Collections.emptyMap());
            for (DtdData.Attribute attribute : element.getAttributes().keySet()) {
                MatcherPattern validity;
                if (attribute.isDeprecated() || !attribute.values.isEmpty() || (validity = (MatcherPattern)attribute_validity.get(attribute.name)) != null) continue;
                missing.put(attribute.name, new AttributeValueSpec(dtdType, element.name, attribute.name, "$xxx").toString());
            }
        }
        return missing;
    }

    private static MatcherPattern getMatcherPattern2(String type, String value) {
        MatcherPattern result;
        MatcherTypes matcherType;
        MatcherTypes matcherTypes = matcherType = type == null ? MatcherTypes.single : MatcherTypes.valueOf(type);
        if (matcherType != MatcherTypes.TODO && value.startsWith("$")) {
            MatcherPattern result2 = AttributeValueValidity.getVariable(matcherType, value);
            if (result2 != null) {
                return result2;
            }
            throw new IllegalArgumentException("Unknown variable: " + value);
        }
        switch (matcherType) {
            case single: {
                result = new CollectionMatcher(Collections.singleton(value.trim()));
                break;
            }
            case choice: {
                result = new CollectionMatcher(SPACE.splitToList(value));
                break;
            }
            case unicodeSet: {
                result = new UnicodeSetMatcher(new UnicodeSet(value));
                break;
            }
            case unicodeSetOrString: {
                result = new UnicodeSetOrStringMatcher(new UnicodeSet(value));
                break;
            }
            case regex: {
                result = new RegexMatcher(value, 4);
                break;
            }
            case locale: {
                result = value.equals("all") ? LocaleMatcher.ALL_LANGUAGES : LocaleMatcher.REGULAR;
                break;
            }
            case localeSpecific: {
                result = LocaleSpecificMatcher.getInstance(value);
                break;
            }
            case TODO: {
                result = NOT_DONE_YET;
                break;
            }
            case list: {
                result = new ListMatcher(new CollectionMatcher(SPACE.splitToList(value)));
                break;
            }
            default: {
                return null;
            }
        }
        return result;
    }

    private static MatcherPattern getVariable(MatcherTypes matcherType, String value) {
        List<String> values = BAR.splitToList(value);
        MatcherPattern[] reasons = new MatcherPattern[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            reasons[i] = AttributeValueValidity.getNonNullVariable(values.get(i));
        }
        MatcherPattern result = reasons.length == 1 ? reasons[0] : new OrMatcher(reasons);
        if (matcherType == MatcherTypes.list) {
            result = new ListMatcher(result);
        }
        return result;
    }

    private static void addAttributes(Set<String> attributes, Map<String, MatcherPattern> attribute_validity, MatcherPattern mp) {
        for (String attribute : attributes) {
            MatcherPattern old = attribute_validity.get(attribute);
            if (old != null) {
                mp = new OrMatcher(old, mp);
            }
            attribute_validity.put(attribute, mp);
        }
    }

    public static void setLocaleSpecifics(EnumMap<LocaleSpecific, Set<String>> newValues) {
        LOCALE_SPECIFIC = newValues;
    }

    private static Status check(Map<String, MatcherPattern> attribute_validity, String element, String attribute, String attributeValue, Output<String> reason) {
        if (attribute_validity == null) {
            return Status.noTest;
        }
        MatcherPattern matcherPattern = attribute_validity.get(attribute);
        if (matcherPattern == null) {
            return Status.noTest;
        }
        if (matcherPattern.matches(attributeValue, reason)) {
            return Status.ok;
        }
        return Status.illegal;
    }

    public static Status check(DtdData dtdData, String element, String attribute, String attributeValue, Output<String> reason) {
        if (dtdData.isDeprecated(element, attribute, attributeValue)) {
            return Status.deprecated;
        }
        Status haveTest = AttributeValueValidity.check(common_attribute_validity, element, attribute, attributeValue, reason);
        if (haveTest == Status.noTest) {
            Map<String, Map<String, MatcherPattern>> element_attribute_validity = dtd_element_attribute_validity.get((Object)dtdData.dtdType);
            if (element_attribute_validity == null) {
                return Status.noTest;
            }
            Map<String, MatcherPattern> attribute_validity = element_attribute_validity.get(element);
            if (attribute_validity == null) {
                return Status.noTest;
            }
            haveTest = AttributeValueValidity.check(attribute_validity, element, attribute, attributeValue, reason);
        }
        return haveTest;
    }

    public static Set<Row.R3<DtdType, String, String>> getTodoTests() {
        LinkedHashSet<Row.R3<DtdType, String, String>> result = new LinkedHashSet<Row.R3<DtdType, String, String>>();
        for (Map.Entry<DtdType, Map<String, Map<String, MatcherPattern>>> entry1 : dtd_element_attribute_validity.entrySet()) {
            for (Map.Entry<String, Map<String, MatcherPattern>> entry2 : entry1.getValue().entrySet()) {
                for (Map.Entry<String, MatcherPattern> entry3 : entry2.getValue().entrySet()) {
                    if (entry3.getValue() != NOT_DONE_YET) continue;
                    result.add(Row.of(entry1.getKey(), entry2.getKey(), entry3.getKey()));
                }
            }
        }
        return result;
    }

    public static Map<SupplementalDataInfo.AttributeValidityInfo, String> getReadFailures() {
        return Collections.unmodifiableMap(failures);
    }

    public static MatcherPattern getMatcherPattern(String variable) {
        return variables.get(variable);
    }

    private static MatcherPattern getNonNullVariable(String variable) {
        MatcherPattern result = variables.get(variable);
        if (result == null) {
            throw new NullPointerException();
        }
        return result;
    }

    public static Set<String> getMatcherPatternIds() {
        return Collections.unmodifiableSet(variables.keySet());
    }

    public static void main(String[] args) {
        for (DtdType type : DtdType.values()) {
            Relation<String, String> missing = AttributeValueValidity.getAllPossibleMissing(type);
            for (Map.Entry<String, String> x : missing.keyValueSet()) {
                System.out.println((Object)((Object)type) + "\t" + CldrUtility.toString(x));
            }
        }
    }

    static {
        Relation<Row.R2<String, String>, String> bcp47Aliases = supplementalData.getBcp47Aliases();
        LinkedHashSet<String> bcp47Keys = new LinkedHashSet<String>();
        LinkedHashSet<String> bcp47Values = new LinkedHashSet<String>();
        for (Map.Entry<String, Set<String>> entry : supplementalData.getBcp47Keys().keyValuesSet()) {
            Set<String> fullValues = new TreeSet<String>();
            String key = entry.getKey();
            bcp47Keys.add(key);
            Set<String> rawValues = entry.getValue();
            for (String string : rawValues) {
                Row.R2<String, String> keyValue;
                Set<String> set;
                if (key.equals("cu")) {
                    fullValues.add(string.toUpperCase());
                } else {
                    fullValues.add(string);
                }
                if ((set = bcp47Aliases.getAll(keyValue = Row.R2.of(key, string))) == null) continue;
                fullValues.addAll(set);
            }
            if (key.equals("ca")) {
                fullValues.add("generic");
            }
            fullValues = Collections.unmodifiableSet(fullValues);
            AttributeValueValidity.addCollectionVariable("$_bcp47_" + key, fullValues);
            Set<String> aliases = supplementalData.getBcp47Aliases().getAll(Row.of(key, ""));
            if (aliases != null) {
                for (String aliasKey : aliases) {
                    bcp47Keys.add(aliasKey);
                    AttributeValueValidity.addCollectionVariable("$_bcp47_" + aliasKey, fullValues);
                }
            }
            bcp47Values.addAll(fullValues);
        }
        bcp47Keys.add("x");
        bcp47Keys.add("x0");
        AttributeValueValidity.addCollectionVariable("$_bcp47_keys", bcp47Keys);
        AttributeValueValidity.addCollectionVariable("$_bcp47_value", bcp47Values);
        Validity validity = Validity.getInstance();
        for (StandardCodes.LstrType key : StandardCodes.LstrType.values()) {
            Map<Validity.Status, Set<String>> statusToCodes = validity.getStatusToCodes(key);
            if (statusToCodes == null) continue;
            String string = "$_" + (Object)((Object)key);
            LinkedHashSet<String> all = new LinkedHashSet<String>();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            LinkedHashSet<String> suffix = new LinkedHashSet<String>();
            LinkedHashSet<String> regularAndUnknown = new LinkedHashSet<String>();
            for (Map.Entry item2 : statusToCodes.entrySet()) {
                Validity.Status status = (Validity.Status)((Object)item2.getKey());
                LinkedHashSet<String> validItems = (LinkedHashSet<String>)item2.getValue();
                if (key == StandardCodes.LstrType.variant) {
                    LinkedHashSet<String> temp2 = new LinkedHashSet<String>(validItems);
                    for (String item : validItems) {
                        temp2.add(item.toUpperCase(Locale.ROOT));
                    }
                    validItems = temp2;
                } else if (key == StandardCodes.LstrType.subdivision) {
                    for (String item : validItems) {
                        if (item.contains("-")) {
                            List<String> parts = Splitter.on('-').splitToList(item);
                            linkedHashSet.add(parts.get(0));
                            suffix.add(parts.get(1));
                            continue;
                        }
                        int prefixWidth = item.charAt(0) < 'A' ? 3 : 2;
                        linkedHashSet.add(item.substring(0, prefixWidth));
                        suffix.add(item.substring(prefixWidth));
                    }
                }
                all.addAll((Collection<String>)validItems);
                if (status == Validity.Status.regular || status == Validity.Status.special || status == Validity.Status.unknown) {
                    regularAndUnknown.addAll(validItems);
                }
                AttributeValueValidity.addCollectionVariable(string + "_" + (Object)((Object)status), validItems);
            }
            if (key == StandardCodes.LstrType.subdivision) {
                AttributeValueValidity.addCollectionVariable(string + "_prefix", linkedHashSet);
                AttributeValueValidity.addCollectionVariable(string + "_suffix", suffix);
            }
            AttributeValueValidity.addCollectionVariable(string, all);
            AttributeValueValidity.addCollectionVariable(string + "_plus", regularAndUnknown);
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(StandardCodes.LstrType.language.specials);
        LinkedHashSet<String> coverage = new LinkedHashSet<String>();
        LinkedHashSet<String> large_official = new LinkedHashSet<String>();
        LocaleIDParser lip = new LocaleIDParser();
        for (String string : LanguageInfo.getAvailable()) {
            LanguageInfo info = LanguageInfo.get(string);
            LanguageInfo.CldrDir cldrDir = info.getCldrDir();
            String base = lip.set(string).getLanguage();
            if (cldrDir == LanguageInfo.CldrDir.main || cldrDir == LanguageInfo.CldrDir.base) {
                linkedHashSet.add(base);
            }
            if (info.getCldrLevel() == Level.MODERN) {
                coverage.add(base);
            }
            if (info.getLiteratePopulation() <= 1000000 || info.getStatusToRegions().isEmpty()) continue;
            large_official.add(base);
        }
        AttributeValueValidity.addCollectionVariable("$_language_main", linkedHashSet);
        AttributeValueValidity.addCollectionVariable("$_language_coverage", coverage);
        AttributeValueValidity.addCollectionVariable("$_language_large_official", large_official);
        TreeSet<String> cldrLang = new TreeSet<String>(linkedHashSet);
        cldrLang.addAll(coverage);
        cldrLang.addAll(large_official);
        AttributeValueValidity.addCollectionVariable("$_language_cldr", large_official);
        Map<String, Row.R2<String, String>> map = supplementalData.getValidityInfo();
        for (Map.Entry entry : map.entrySet()) {
            String value;
            String id = (String)entry.getKey();
            String type = (String)((Row.R2)entry.getValue()).get0();
            MatcherPattern mp = AttributeValueValidity.getMatcherPattern2(type, value = (String)((Row.R2)entry.getValue()).get1());
            if (mp != null) {
                variables.put(id, mp);
                continue;
            }
            throw new IllegalArgumentException("Duplicate element " + mp);
        }
        Map<SupplementalDataInfo.AttributeValidityInfo, String> rawAttributeValueInfo = supplementalData.getAttributeValidity();
        boolean bl = false;
        for (Map.Entry<SupplementalDataInfo.AttributeValidityInfo, String> entry : rawAttributeValueInfo.entrySet()) {
            SupplementalDataInfo.AttributeValidityInfo item = entry.getKey();
            String value = entry.getValue();
            MatcherPattern mp = AttributeValueValidity.getMatcherPattern2(item.getType(), value);
            if (mp == null) {
                AttributeValueValidity.getMatcherPattern2(item.getType(), value);
                failures.put(item, value);
                continue;
            }
            Set<DtdType> dtds = item.getDtds();
            if (dtds == null) {
                dtds = ALL_DTDs;
            }
            for (DtdType dtdType : dtds) {
                DtdData data = DtdData.getInstance(dtdType);
                Map<String, Map<String, MatcherPattern>> element_attribute_validity = dtd_element_attribute_validity.get((Object)dtdType);
                if (element_attribute_validity == null) {
                    element_attribute_validity = new TreeMap<String, Map<String, MatcherPattern>>();
                    dtd_element_attribute_validity.put(dtdType, element_attribute_validity);
                }
                Set<String> attributeList = item.getAttributes();
                Set<String> elementList = item.getElements();
                if (elementList.size() == 0) {
                    AttributeValueValidity.addAttributes(attributeList, common_attribute_validity, mp);
                    continue;
                }
                for (String element : elementList) {
                    DtdData.Element elementInfo = data.getElementFromName().get(element);
                    if (elementInfo == null) {
                        throw new ICUException("Illegal <attributeValues>, element not valid: " + (Object)((Object)dtdType) + ", element: " + element);
                    }
                    for (String attribute : attributeList) {
                        DtdData.Attribute attributeInfo = elementInfo.getAttributeNamed(attribute);
                        if (attributeInfo == null) {
                            throw new ICUException("Illegal <attributeValues>, attribute not valid: " + (Object)((Object)dtdType) + ", element: " + element + ", attribute: " + attribute);
                        }
                        if (attributeInfo.values.isEmpty()) continue;
                    }
                    Map<String, MatcherPattern> attribute_validity = element_attribute_validity.get(element);
                    if (attribute_validity == null) {
                        attribute_validity = new TreeMap<String, MatcherPattern>();
                        element_attribute_validity.put(element, attribute_validity);
                    }
                    AttributeValueValidity.addAttributes(attributeList, attribute_validity, mp);
                }
            }
        }
        LOCALE_SPECIFIC = null;
    }

    public static final class AttributeValueSpec
    implements Comparable<AttributeValueSpec> {
        public final DtdType type;
        public final String element;
        public final String attribute;
        public final String attributeValue;

        public AttributeValueSpec(DtdType type, String element, String attribute, String attributeValue) {
            this.type = type;
            this.element = element;
            this.attribute = attribute;
            this.attributeValue = attributeValue;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.element, this.attribute, this.attributeValue});
        }

        public boolean equals(Object obj) {
            AttributeValueSpec other = (AttributeValueSpec)obj;
            return CldrUtility.deepEquals(new Object[]{this.type, other.type, this.element, other.element, this.attribute, other.attribute, this.attributeValue, other.attributeValue});
        }

        @Override
        public int compareTo(AttributeValueSpec other) {
            return ComparisonChain.start().compare((Comparable<?>)((Object)this.type), (Comparable<?>)((Object)other.type)).compare((Comparable<?>)((Object)this.element), (Comparable<?>)((Object)other.element)).compare((Comparable<?>)((Object)this.attribute), (Comparable<?>)((Object)other.attribute)).compare((Comparable<?>)((Object)this.attributeValue), (Comparable<?>)((Object)other.attributeValue)).result();
        }

        public String toString() {
            return "<attributeValues dtds='" + (Object)((Object)this.type) + "' elements='" + this.element + "' attributes='" + this.attribute + "' type='TODO'>" + this.attributeValue + "</attributeValues>";
        }
    }

    public static class LocaleMatcher
    extends MatcherPattern {
        final MatcherPattern language;
        final MatcherPattern script = AttributeValueValidity.access$100("$_script");
        final MatcherPattern territory = AttributeValueValidity.access$100("$_region");
        final MatcherPattern variant = AttributeValueValidity.access$100("$_variant");
        final LocaleIDParser lip = new LocaleIDParser();
        public static LocaleMatcher REGULAR = new LocaleMatcher("$_language_plus");
        public static LocaleMatcher ALL_LANGUAGES = new LocaleMatcher("$_language");

        private LocaleMatcher(String variable) {
            this.language = AttributeValueValidity.getNonNullVariable(variable);
        }

        @Override
        public boolean matches(String value, Output<String> reason) {
            this.lip.set(value);
            String field = this.lip.getLanguage();
            if (!this.language.matches(field, reason)) {
                if (reason != null) {
                    reason.value = "invalid base language";
                }
                return false;
            }
            field = this.lip.getScript();
            if (field.length() != 0 && !this.script.matches(field, reason)) {
                if (reason != null) {
                    reason.value = "invalid script";
                }
                return false;
            }
            field = this.lip.getRegion();
            if (field.length() != 0 && !this.territory.matches(field, reason)) {
                if (reason != null) {
                    reason.value = "invalid region";
                }
                return false;
            }
            String[] fields = this.lip.getVariants();
            for (int i = 0; i < fields.length; ++i) {
                if (this.variant.matches(fields[i], reason)) continue;
                if (reason != null) {
                    reason.value = "invalid variant";
                }
                return false;
            }
            return true;
        }

        @Override
        public String _getPattern() {
            return "Unicode_Language_Subtag";
        }
    }

    public static class ListMatcher
    extends MatcherPattern {
        private MatcherPattern other;

        public ListMatcher(MatcherPattern other) {
            this.other = other;
        }

        @Override
        public boolean matches(String value, Output<String> reason) {
            List<String> values = SPACE.splitToList(value);
            if (values.isEmpty()) {
                return true;
            }
            for (String valueItem : values) {
                if (this.other.matches(valueItem, reason)) continue;
                if (reason != null) {
                    reason.value = "\u00ab" + valueItem + "\u00bb \u2209 " + this.other.getPattern();
                }
                return false;
            }
            return true;
        }

        @Override
        public String _getPattern() {
            return "List of " + this.other._getPattern();
        }
    }

    public static class OrMatcher
    extends MatcherPattern {
        private final MatcherPattern[] operands;

        public OrMatcher(MatcherPattern ... operands) {
            for (MatcherPattern operand : operands) {
                if (operand != null) continue;
                throw new NullPointerException();
            }
            this.operands = operands;
        }

        @Override
        public boolean matches(String value, Output<String> reason) {
            StringBuilder fullReason = reason == null ? null : new StringBuilder();
            for (MatcherPattern operand : this.operands) {
                if (operand.matches(value, reason)) {
                    return true;
                }
                if (fullReason == null) continue;
                if (fullReason.length() != 0) {
                    fullReason.append("&");
                }
                fullReason.append((String)reason.value);
            }
            if (fullReason != null) {
                reason.value = fullReason.toString();
            }
            return false;
        }

        @Override
        public String _getPattern() {
            StringBuffer result = new StringBuffer();
            for (MatcherPattern operand : this.operands) {
                if (result.length() != 0) {
                    result.append('|');
                }
                result.append(operand._getPattern());
            }
            return result.toString();
        }
    }

    public static class UnicodeSetOrStringMatcher
    extends MatcherPattern {
        private final UnicodeSet collection;

        public UnicodeSetOrStringMatcher(UnicodeSet collection) {
            this.collection = collection.freeze();
        }

        @Override
        public boolean matches(String value, Output<String> reason) {
            boolean result = false;
            if (UnicodeSet.resemblesPattern(value, 0)) {
                try {
                    UnicodeSet valueSet = new UnicodeSet(value);
                    result = this.collection.containsAll(valueSet);
                    if (!result && reason != null) {
                        reason.value = "\u2209 " + this.getPattern();
                    }
                }
                catch (Exception e) {
                    reason.value = " illegal pattern " + this.getPattern() + ": " + value;
                }
            } else {
                result = this.collection.contains(value);
                if (!result && reason != null) {
                    reason.value = "\u2209 " + this.getPattern();
                }
            }
            return result;
        }

        @Override
        public String _getPattern() {
            return this.collection.toPattern(false);
        }
    }

    public static class UnicodeSetMatcher
    extends MatcherPattern {
        private final UnicodeSet collection;

        public UnicodeSetMatcher(UnicodeSet collection) {
            this.collection = collection.freeze();
        }

        @Override
        public boolean matches(String value, Output<String> reason) {
            boolean result = false;
            try {
                UnicodeSet valueSet = new UnicodeSet(value);
                result = this.collection.containsAll(valueSet);
                if (!result && reason != null) {
                    reason.value = "\u2209 " + this.getPattern();
                }
            }
            catch (Exception e) {
                reason.value = " illegal pattern " + this.getPattern() + ": " + value;
            }
            return result;
        }

        @Override
        public String _getPattern() {
            return this.collection.toPattern(false);
        }
    }

    public static class CollectionMatcher
    extends MatcherPattern {
        private final Collection<String> collection;

        public CollectionMatcher(Collection<String> collection) {
            this.collection = Collections.unmodifiableCollection(new LinkedHashSet<String>(collection));
        }

        @Override
        public boolean matches(String value, Output<String> reason) {
            boolean result = this.collection.contains(value);
            if (!result && reason != null) {
                reason.value = "\u2209 " + this.getPattern();
            }
            return result;
        }

        @Override
        public String _getPattern() {
            return this.collection.toString();
        }
    }

    public static class LocaleSpecificMatcher
    extends MatcherPattern {
        final LocaleSpecific ls;
        static final int MAX_STRING = 64;

        public LocaleSpecificMatcher(LocaleSpecific ls) {
            this.ls = ls;
        }

        public static LocaleSpecificMatcher getInstance(String value) {
            return new LocaleSpecificMatcher(LocaleSpecific.valueOf(value));
        }

        public boolean matches(String value) {
            return ((Set)LOCALE_SPECIFIC.get((Object)this.ls)).contains(value);
        }

        @Override
        public boolean matches(String value, Output<String> reason) {
            boolean result = ((Set)LOCALE_SPECIFIC.get((Object)this.ls)).contains(value);
            if (!result && reason != null) {
                reason.value = "\u2209 " + this.getPattern();
            }
            return result;
        }

        @Override
        public String _getPattern() {
            return ((Set)LOCALE_SPECIFIC.get((Object)this.ls)).toString();
        }
    }

    public static class RegexMatcher
    extends MatcherPattern {
        private Matcher matcher;

        public RegexMatcher(String pattern, int flags) {
            this.matcher = Pattern.compile(pattern, flags).matcher("");
        }

        @Override
        public boolean matches(String value, Output<String> reason) {
            this.matcher.reset(value.toString());
            boolean result = this.matcher.matches();
            if (!result && reason != null) {
                reason.value = RegexUtilities.showMismatch(this.matcher, (CharSequence)value.toString());
            }
            return result;
        }

        @Override
        public String _getPattern() {
            return this.matcher.toString();
        }
    }

    static enum MatcherTypes {
        single,
        choice,
        list,
        unicodeSet,
        unicodeSetOrString,
        regex,
        locale,
        bcp47,
        subdivision,
        localeSpecific,
        TODO;

    }

    public static abstract class MatcherPattern {
        public abstract boolean matches(String var1, Output<String> var2);

        public String getPattern() {
            String temp = this._getPattern();
            return temp.length() <= 64 ? temp : temp.substring(0, 64) + "\u2026";
        }

        public abstract String _getPattern();

        public String toString() {
            return this.getClass().getName() + "\t" + this.getPattern();
        }
    }

    public static enum LocaleSpecific {
        pluralCardinal,
        pluralOrdinal,
        dayPeriodFormat,
        dayPeriodSelection;

    }

    public static enum Status {
        ok,
        deprecated,
        illegal,
        noTest;

    }
}

