/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Row;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ChainedMap {
    private final Map<Object, Object> mapBase;
    private final Constructor<Map<Object, Object>>[] mapConstructors;
    private final int indexStart;

    private ChainedMap(Map<? extends Object, ? extends Object> ... maps) {
        this(maps[0], ChainedMap.constructorList(maps), 0);
    }

    private ChainedMap(Map<?, ?> mapBase, Constructor<Map<Object, Object>>[] mapConstructors, int indexStart) {
        this.mapBase = mapBase;
        this.mapConstructors = mapConstructors;
        this.indexStart = indexStart;
    }

    private static Constructor<Map<Object, Object>>[] constructorList(Map<? extends Object, ? extends Object> ... maps) {
        Constructor[] tempMapConstructors = new Constructor[maps.length - 1];
        for (int i = 0; i < maps.length - 1; ++i) {
            Constructor<?> constructor2;
            block3: {
                for (Constructor<?> constructor2 : maps[i + 1].getClass().getConstructors()) {
                    if (constructor2.getParameterTypes().length != 0) {
                        continue;
                    }
                    break block3;
                }
                throw new IllegalArgumentException("Couldn't create empty constructor for " + maps[i]);
            }
            tempMapConstructors[i] = constructor2;
        }
        return tempMapConstructors;
    }

    public static <T> Constructor<T> getEmptyConstructor(Class<T> c) {
        for (Constructor<?> constructor : c.getConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }

    public static <K2, K1, V> M3<K2, K1, V> of(Map<K2, Object> map2, Map<K1, Object> map1, Class<V> valueClass) {
        return new M3(map2, map1, valueClass);
    }

    public static <K3, K2, K1, V> M4<K3, K2, K1, V> of(Map<K3, Object> map3, Map<K2, Object> map2, Map<K1, Object> map1, Class<V> valueClass) {
        return new M4(map3, map2, map1, valueClass);
    }

    public static <K4, K3, K2, K1, V> M5<K4, K3, K2, K1, V> of(Map<K4, Object> map4, Map<K3, Object> map3, Map<K2, Object> map2, Map<K1, Object> map1, Class<V> valueClass) {
        return new M5(map4, map3, map2, map1, valueClass);
    }

    private Object iterator() {
        return this.mapBase.entrySet().iterator();
    }

    public void clear() {
        this.mapBase.clear();
    }

    private Object handleGet(Object ... keys) {
        Map map = this.mapBase;
        int last = keys.length - 1;
        for (int i = 0; i < last; ++i) {
            Object key = keys[i];
            if ((map = (Map)map.get(key)) != null) continue;
            return null;
        }
        return map.get(keys[last]);
    }

    private Object handlePut(Object value, Object ... keys) {
        Map<Object, Object> map = this.mapBase;
        int last = keys.length - 1;
        for (int i = this.indexStart; i < last; ++i) {
            Object key = keys[i];
            Map<Object, Object> map2 = (Map<Object, Object>)map.get(key);
            if (map2 == null) {
                try {
                    map2 = this.mapConstructors[i].newInstance(new Object[0]);
                    map.put(key, map2);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot create map with " + this.mapConstructors[i], e);
                }
            }
            map = map2;
        }
        return value == null ? map.remove(keys[last]) : map.put(keys[last], value);
    }

    public String toString() {
        return this.mapBase.toString();
    }

    public static void main(String[] args) {
        M5 foo = ChainedMap.of(new TreeMap(), new HashMap(), new TreeMap(), new TreeMap(), Double.class);
        System.out.println(foo.put(true, (byte)0, "abc", 3, 1.5));
        System.out.println(foo.get(true, (byte)0, "abc", 3));
        System.out.println(foo.put(false, (byte)0, "Def", 3, 1.5));
        System.out.println(foo.put(true, (byte)-1, "ghi", 3, 2.0));
        System.out.println(foo.put(true, (byte)0, "ghi", 3, 3.0));
        System.out.println(foo.put(true, (byte)0, "abc", 4, 1.5));
        for (Map.Entry entry : foo) {
            System.out.println("entries: " + entry);
        }
        for (Row.R5 r5 : foo.rows()) {
            System.out.println("rows: " + r5);
        }
    }

    public static class M5<K4, K3, K2, K1, V>
    extends ChainedMap
    implements Iterable<Map.Entry<K4, Map<K3, Map<K2, Map<K1, V>>>>> {
        private M5(Map<K4, Object> map4, Map<K3, Object> map3, Map<K2, Object> map2, Map<K1, Object> map1, Class<V> valueClass) {
            super(new Map[]{map4, map3, map2, map1});
        }

        public V get(K4 key4, K3 key3, K2 key2, K1 key1) {
            return (V)((ChainedMap)this).handleGet(new Object[]{key4, key3, key2, key1});
        }

        public M4<K3, K2, K1, V> get(K4 key4) {
            Map submap = (Map)((ChainedMap)this).handleGet(new Object[]{key4});
            return submap == null ? null : new M4(submap, ((ChainedMap)this).mapConstructors, ((ChainedMap)this).indexStart + 2);
        }

        public V put(K4 key4, K3 key3, K2 key2, K1 key1, V value) {
            return (V)((ChainedMap)this).handlePut(value, new Object[]{key4, key3, key2, key1});
        }

        @Override
        public Iterator<Map.Entry<K4, Map<K3, Map<K2, Map<K1, V>>>>> iterator() {
            return (Iterator)((ChainedMap)this).iterator();
        }

        public Iterable<Row.R5<K4, K3, K2, K1, V>> rows() {
            ArrayList<Row.R5<K4, K3, K2, K1, V>> result = new ArrayList<Row.R5<K4, K3, K2, K1, V>>();
            for (Map.Entry entry0 : ((ChainedMap)this).mapBase.entrySet()) {
                for (Map.Entry entry1 : ((Map)entry0.getValue()).entrySet()) {
                    for (Map.Entry entry2 : ((Map)entry1.getValue()).entrySet()) {
                        for (Map.Entry entry3 : ((Map)entry2.getValue()).entrySet()) {
                            Row.R5 item = Row.of(entry0.getKey(), entry1.getKey(), entry2.getKey(), entry3.getKey(), entry3.getValue());
                            result.add(item);
                        }
                    }
                }
            }
            return result;
        }

        public Set<K4> keySet() {
            return ((ChainedMap)this).mapBase.keySet();
        }
    }

    public static class M4<K3, K2, K1, V>
    extends ChainedMap
    implements Iterable<Map.Entry<K3, Map<K2, Map<K1, V>>>> {
        private M4(Map<K3, Object> map3, Map<K2, Object> map2, Map<K1, Object> map1, Class<V> valueClass) {
            super(new Map[]{map3, map2, map1});
        }

        private M4(Map<?, ?> map2, Constructor<Map<Object, Object>>[] constructors, int indexStart) {
            super(map2, constructors, indexStart);
        }

        public V get(K3 key3, K2 key2, K1 key1) {
            return (V)((ChainedMap)this).handleGet(new Object[]{key3, key2, key1});
        }

        public M3<K2, K1, V> get(K3 key3) {
            Map submap = (Map)((ChainedMap)this).handleGet(new Object[]{key3});
            return submap == null ? null : new M3(submap, ((ChainedMap)this).mapConstructors, ((ChainedMap)this).indexStart + 1);
        }

        public V put(K3 key3, K2 key2, K1 key1, V value) {
            return (V)((ChainedMap)this).handlePut(value, new Object[]{key3, key2, key1});
        }

        @Override
        public Iterator<Map.Entry<K3, Map<K2, Map<K1, V>>>> iterator() {
            return (Iterator)((ChainedMap)this).iterator();
        }

        public Iterable<Row.R4<K3, K2, K1, V>> rows() {
            ArrayList<Row.R4<K3, K2, K1, V>> result = new ArrayList<Row.R4<K3, K2, K1, V>>();
            for (Map.Entry entry0 : ((ChainedMap)this).mapBase.entrySet()) {
                for (Map.Entry entry1 : ((Map)entry0.getValue()).entrySet()) {
                    for (Map.Entry entry2 : ((Map)entry1.getValue()).entrySet()) {
                        Row.R4 item = Row.of(entry0.getKey(), entry1.getKey(), entry2.getKey(), entry2.getValue());
                        result.add(item);
                    }
                }
            }
            return result;
        }

        public Set<K3> keySet() {
            return ((ChainedMap)this).mapBase.keySet();
        }
    }

    public static class M3<K2, K1, V>
    extends ChainedMap
    implements Iterable<Map.Entry<K2, Map<K1, V>>> {
        private M3(Map<K2, Object> map2, Map<K1, Object> map1, Class<V> valueClass) {
            super(new Map[]{map2, map1});
        }

        private M3(Map<?, ?> map2, Constructor<Map<Object, Object>>[] constructors, int indexStart) {
            super(map2, constructors, indexStart);
        }

        public V get(K2 key2, K1 key1) {
            return (V)((ChainedMap)this).handleGet(new Object[]{key2, key1});
        }

        public Map<K1, V> get(K2 key2) {
            Map map = (Map)((ChainedMap)this).mapBase.get(key2);
            return map == null ? null : Collections.unmodifiableMap(map);
        }

        public V put(K2 key2, K1 key1, V value) {
            return (V)((ChainedMap)this).handlePut(value, new Object[]{key2, key1});
        }

        @Override
        public Iterator<Map.Entry<K2, Map<K1, V>>> iterator() {
            return (Iterator)((ChainedMap)this).iterator();
        }

        public Iterable<Row.R3<K2, K1, V>> rows() {
            ArrayList<Row.R3<K2, K1, V>> result = new ArrayList<Row.R3<K2, K1, V>>();
            for (Map.Entry entry0 : ((ChainedMap)this).mapBase.entrySet()) {
                for (Map.Entry entry1 : ((Map)entry0.getValue()).entrySet()) {
                    Row.R3 item = Row.of(entry0.getKey(), entry1.getKey(), entry1.getValue());
                    result.add(item);
                }
            }
            return result;
        }

        public Set<K2> keySet() {
            return ((ChainedMap)this).mapBase.keySet();
        }
    }
}

