/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.Transform;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.MapComparator;
import org.unicode.cldr.util.MatchValue;
import org.unicode.cldr.util.MergeLists;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class DtdData
extends XMLFileReader.SimpleHandler {
    private static final String COMMENT_PREFIX = System.lineSeparator() + "    ";
    private static final boolean SHOW_ALL = CldrUtility.getProperty("show_all", false);
    private static final boolean USE_SYNTHESIZED = false;
    private static final boolean DEBUG = false;
    private static final Pattern FILLER = PatternCache.get("[^-a-zA-Z0-9#_:]");
    private final Relation<String, Attribute> nameToAttributes = Relation.of(new TreeMap(), LinkedHashSet.class);
    private Map<String, Element> nameToElement = new HashMap<String, Element>();
    private MapComparator<String> elementComparator;
    private MapComparator<String> attributeComparator;
    public final Element ROOT;
    public final Element PCDATA = this.elementFrom("#PCDATA");
    public final Element ANY = this.elementFrom("ANY");
    public final DtdType dtdType;
    public final String version;
    private Element lastElement;
    private Attribute lastAttribute;
    private Set<String> preCommentCache;
    private DtdComparator dtdComparator;
    static final Set<String> DRAFT_ON_NON_LEAF_ALLOWED = ImmutableSet.of("collation", "transform", "unitPreferenceData", "rulesetGrouping");
    private static final ConcurrentMap<Pair<DtdType, File>, DtdData> CACHE = new ConcurrentHashMap<Pair<DtdType, File>, DtdData>();
    static final Set<String> METADATA = new HashSet<String>(Arrays.asList("references", "standard", "draft"));
    private static MapComparator<String> valueOrdering = new MapComparator().setErrorOnMissing(false).freeze();
    static MapComparator<String> dayValueOrder = new MapComparator<String>().add("sun", "mon", "tue", "wed", "thu", "fri", "sat").freeze();
    static MapComparator<String> dayPeriodOrder = new MapComparator<String>().add("midnight", "am", "noon", "pm", "morning1", "morning2", "afternoon1", "afternoon2", "evening1", "evening2", "night1", "night2", "earlyMorning", "morning", "midDay", "afternoon", "evening", "night", "weeHours").freeze();
    static MapComparator<String> listPatternOrder = new MapComparator<String>().add("start", "middle", "end", "2", "3").freeze();
    static MapComparator<String> widthOrder = new MapComparator<String>().add("abbreviated", "narrow", "short", "wide", "all").freeze();
    static MapComparator<String> lengthOrder = new MapComparator<String>().add("full", "long", "medium", "short").freeze();
    static MapComparator<String> dateFieldOrder = new MapComparator<String>().add("era", "era-short", "era-narrow", "year", "year-short", "year-narrow", "quarter", "quarter-short", "quarter-narrow", "month", "month-short", "month-narrow", "week", "week-short", "week-narrow", "weekOfMonth", "weekOfMonth-short", "weekOfMonth-narrow", "day", "day-short", "day-narrow", "dayOfYear", "dayOfYear-short", "dayOfYear-narrow", "weekday", "weekday-short", "weekday-narrow", "weekdayOfMonth", "weekdayOfMonth-short", "weekdayOfMonth-narrow", "sun", "sun-short", "sun-narrow", "mon", "mon-short", "mon-narrow", "tue", "tue-short", "tue-narrow", "wed", "wed-short", "wed-narrow", "thu", "thu-short", "thu-narrow", "fri", "fri-short", "fri-narrow", "sat", "sat-short", "sat-narrow", "dayperiod-short", "dayperiod", "dayperiod-narrow", "hour", "hour-short", "hour-narrow", "minute", "minute-short", "minute-narrow", "second", "second-short", "second-narrow", "zone", "zone-short", "zone-narrow").freeze();
    public static final MapComparator<String> unitOrder = new MapComparator<String>().add("acceleration-g-force", "acceleration-meter-per-square-second", "acceleration-meter-per-second-squared", "angle-revolution", "angle-radian", "angle-degree", "angle-arc-minute", "angle-arc-second", "area-square-kilometer", "area-hectare", "area-square-meter", "area-square-centimeter", "area-square-mile", "area-acre", "area-square-yard", "area-square-foot", "area-square-inch", "area-dunam", "concentr-karat", "proportion-karat", "concentr-milligram-ofglucose-per-deciliter", "concentr-milligram-per-deciliter", "concentr-millimole-per-liter", "concentr-item", "concentr-portion", "concentr-permillion", "concentr-part-per-million", "concentr-percent", "concentr-permille", "concentr-permyriad", "concentr-mole", "concentr-ofglucose", "consumption-liter-per-kilometer", "consumption-liter-per-100-kilometer", "consumption-liter-per-100kilometers", "consumption-mile-per-gallon", "consumption-mile-per-gallon-imperial", "digital-petabyte", "digital-terabyte", "digital-terabit", "digital-gigabyte", "digital-gigabit", "digital-megabyte", "digital-megabit", "digital-kilobyte", "digital-kilobit", "digital-byte", "digital-bit", "duration-century", "duration-decade", "duration-year", "duration-year-person", "duration-month", "duration-month-person", "duration-week", "duration-week-person", "duration-day", "duration-day-person", "duration-hour", "duration-minute", "duration-second", "duration-millisecond", "duration-microsecond", "duration-nanosecond", "electric-ampere", "electric-milliampere", "electric-ohm", "electric-volt", "energy-kilocalorie", "energy-calorie", "energy-foodcalorie", "energy-kilojoule", "energy-joule", "energy-kilowatt-hour", "energy-electronvolt", "energy-british-thermal-unit", "energy-therm-us", "force-pound-force", "force-newton", "force-kilowatt-hour-per-100-kilometer", "frequency-gigahertz", "frequency-megahertz", "frequency-kilohertz", "frequency-hertz", "graphics-em", "graphics-pixel", "graphics-megapixel", "graphics-pixel-per-centimeter", "graphics-pixel-per-inch", "graphics-dot-per-centimeter", "graphics-dot-per-inch", "graphics-dot", "length-earth-radius", "length-100-kilometer", "length-kilometer", "length-meter", "length-decimeter", "length-centimeter", "length-millimeter", "length-micrometer", "length-nanometer", "length-picometer", "length-mile", "length-yard", "length-foot", "length-inch", "length-parsec", "length-light-year", "length-astronomical-unit", "length-furlong", "length-fathom", "length-nautical-mile", "length-mile-scandinavian", "length-point", "length-solar-radius", "light-lux", "light-candela", "light-lumen", "light-solar-luminosity", "mass-metric-ton", "mass-kilogram", "mass-gram", "mass-milligram", "mass-microgram", "mass-ton", "mass-stone", "mass-pound", "mass-ounce", "mass-ounce-troy", "mass-carat", "mass-dalton", "mass-earth-mass", "mass-solar-mass", "mass-grain", "power-gigawatt", "power-megawatt", "power-kilowatt", "power-watt", "power-milliwatt", "power-horsepower", "pressure-millimeter-ofhg", "pressure-millimeter-of-mercury", "pressure-ofhg", "pressure-pound-force-per-square-inch", "pressure-pound-per-square-inch", "pressure-inch-ofhg", "pressure-inch-hg", "pressure-bar", "pressure-millibar", "pressure-atmosphere", "pressure-pascal", "pressure-hectopascal", "pressure-kilopascal", "pressure-megapascal", "speed-kilometer-per-hour", "speed-meter-per-second", "speed-mile-per-hour", "speed-knot", "temperature-generic", "temperature-celsius", "temperature-fahrenheit", "temperature-kelvin", "torque-pound-force-foot", "torque-pound-foot", "torque-newton-meter", "volume-cubic-kilometer", "volume-cubic-meter", "volume-cubic-centimeter", "volume-cubic-mile", "volume-cubic-yard", "volume-cubic-foot", "volume-cubic-inch", "volume-megaliter", "volume-hectoliter", "volume-liter", "volume-deciliter", "volume-centiliter", "volume-milliliter", "volume-pint-metric", "volume-cup-metric", "volume-acre-foot", "volume-bushel", "volume-gallon", "volume-gallon-imperial", "volume-quart", "volume-pint", "volume-cup", "volume-fluid-ounce", "volume-fluid-ounce-imperial", "volume-tablespoon", "volume-teaspoon", "volume-barrel", "volume-dessert-spoon", "volume-dessert-spoon-imperial", "volume-drop", "volume-dram", "volume-jigger", "volume-pinch", "volume-quart-imperial").freeze();
    static MapComparator<String> countValueOrder = new MapComparator<String>().add("0", "1", "zero", "one", "two", "few", "many", "other").freeze();
    static MapComparator<String> unitLengthOrder = new MapComparator<String>().add("long", "short", "narrow").freeze();
    static MapComparator<String> currencyFormatOrder = new MapComparator<String>().add("standard", "accounting").freeze();
    static Comparator<String> zoneOrder = StandardCodes.make().getTZIDComparator();
    static final Comparator<String> COMP = CLDRConfig.getInstance().getCollator();
    static final Comparator<String> UNICODE_SET_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1.contains("{")) {
                o1 = o1.replace("{", "");
            }
            if (o2.contains("{")) {
                o2 = o2.replace("{", "");
            }
            return COMP.compare(o1, o2);
        }
    };
    private static AttributeValueComparator ldmlAvc = new AttributeValueComparator(){

        @Override
        public int compare(String element, String attribute, String value1, String value2) {
            Comparator<String> comp = DtdData.getAttributeValueComparator(element, attribute);
            return comp.compare(value1, value2);
        }
    };
    public static final Splitter SPACE_SPLITTER = Splitter.on(CharMatcher.whitespace()).trimResults().omitEmptyStrings();
    public static final Splitter BAR_SPLITTER = Splitter.on('|').trimResults().omitEmptyStrings();
    public static final Splitter CR_SPLITTER = Splitter.on(CharMatcher.anyOf("\n\r")).trimResults().omitEmptyStrings();
    static final Set<String> SPACED_VALUES = ImmutableSet.of("idValidity", "languageGroup");

    private DtdData(DtdType type, String version) {
        this.dtdType = type;
        this.ROOT = this.elementFrom(type.rootType.toString());
        this.version = version;
    }

    private void addAttribute(String eName, String aName, String type, String mode, String value) {
        Attribute a = new Attribute(this.dtdType, this.nameToElement.get(eName), aName, Mode.forString(mode), FILLER.split(type), value, this.preCommentCache);
        this.preCommentCache = null;
        this.getAttributesFromName().put(aName, a);
        CldrUtility.putNew(a.element.attributes, a, a.element.attributes.size());
        this.lastElement = null;
        this.lastAttribute = a;
    }

    private Element elementFrom(String name) {
        Element result = this.nameToElement.get(name);
        if (result == null) {
            result = new Element(name);
            this.nameToElement.put(name, result);
        }
        return result;
    }

    private void addElement(String name2, String model) {
        Element element = this.elementFrom(name2);
        element.setChildren(this, model, this.preCommentCache);
        this.preCommentCache = null;
        this.lastElement = element;
        this.lastAttribute = null;
    }

    private void addComment(String comment) {
        comment = comment.trim();
        if (this.preCommentCache != null || comment.startsWith("#")) {
            if (comment.startsWith("@")) {
                throw new IllegalArgumentException("@ annotation comment must follow element or attribute, without intervening # comment");
            }
            this.preCommentCache = DtdData.addUnmodifiable(this.preCommentCache, comment);
        } else if (this.lastElement != null) {
            this.lastElement.addComment(comment);
        } else if (this.lastAttribute != null) {
            this.lastAttribute.addComment(comment);
        } else {
            if (comment.startsWith("@")) {
                throw new IllegalArgumentException("@ annotation comment must follow element or attribute, without intervening # comment");
            }
            this.preCommentCache = DtdData.addUnmodifiable(this.preCommentCache, comment);
        }
    }

    @Override
    @Deprecated
    public void handleElementDecl(String name, String model) {
        if (SHOW_ALL) {
            System.out.println(System.lineSeparator() + "<!ELEMENT " + name + " " + model + " >");
        }
        this.addElement(name, model);
    }

    @Override
    @Deprecated
    public void handleStartDtd(String name, String publicId, String systemId) {
        DtdType explicitDtdType = DtdType.valueOf(name);
        if (explicitDtdType != this.dtdType && explicitDtdType != this.dtdType.rootType) {
            throw new IllegalArgumentException("Mismatch in dtdTypes");
        }
    }

    @Override
    @Deprecated
    public void handleAttributeDecl(String eName, String aName, String type, String mode, String value) {
        if (SHOW_ALL) {
            System.out.println("<!ATTLIST " + eName + " " + aName + " " + type + " " + mode + (value == null ? "" : " \"" + value + "\"") + " >");
        }
        if (eName.equals("draft")) {
            eName = "week";
        }
        this.addAttribute(eName, aName, type, mode, value);
    }

    @Override
    @Deprecated
    public void handleComment(String path, String comment) {
        if (comment.contains("Copyright")) {
            comment = CldrUtility.getCopyrightString();
        }
        if (SHOW_ALL) {
            System.out.println("<!-- " + comment.trim() + " -->");
        }
        this.addComment(comment);
    }

    @Override
    @Deprecated
    public void handleEndDtd() {
        throw new XMLFileReader.AbortException();
    }

    @Deprecated
    public static DtdData getInstance(DtdType type) {
        return DtdData.getInstance(type, CLDRConfig.getInstance().getCldrBaseDirectory());
    }

    public static DtdData getInstance(DtdType type, String version) {
        File directory = version == null ? CLDRConfig.getInstance().getCldrBaseDirectory() : new File(CLDRPaths.ARCHIVE_DIRECTORY + "/cldr-" + version);
        return DtdData.getInstance(type, version, directory);
    }

    public static DtdData getInstance(DtdType type, File directory) {
        Pair<DtdType, File> key = new Pair<DtdType, File>(type, directory);
        DtdData data = CACHE.computeIfAbsent(key, k -> DtdData.getInstance(type, null, directory));
        return data;
    }

    private static DtdData getInstance(DtdType type, String version, File directory) {
        DtdData simpleHandler = new DtdData(type, version);
        XMLFileReader xfr = new XMLFileReader().setHandler(simpleHandler);
        if (type != type.rootType) {
            DtdData.readFile(type.rootType, xfr, directory);
        }
        DtdData.readFile(type, xfr, directory);
        if (type == DtdType.ldmlICU) {
            Element special = simpleHandler.nameToElement.get("special");
            for (String extraElementName : Arrays.asList("icu:breakIteratorData", "icu:UCARules", "icu:scripts", "icu:transforms", "icu:ruleBasedNumberFormats", "icu:isLeapMonth", "icu:version", "icu:breakDictionaryData", "icu:depends")) {
                Element extraElement = simpleHandler.nameToElement.get(extraElementName);
                special.children.put(extraElement, special.children.size());
            }
        }
        if (simpleHandler.ROOT.children.size() == 0) {
            throw new IllegalArgumentException();
        }
        simpleHandler.finish();
        simpleHandler.freeze();
        return simpleHandler;
    }

    private void finish() {
        this.dtdComparator = new DtdComparator();
    }

    public static void readFile(DtdType type, XMLFileReader xfr, File directory) {
        File file = new File(directory, type.dtdPath);
        StringReader s2 = new StringReader("<?xml version='1.0' encoding='UTF-8' ?><!DOCTYPE " + (Object)((Object)type) + " SYSTEM '" + file.getAbsolutePath() + "'>");
        xfr.read(type.toString(), s2, -1, true);
    }

    private void freeze() {
        if (this.version == null) {
            MergeLists<String> elementMergeList = new MergeLists<String>();
            elementMergeList.add(this.dtdType.toString());
            MergeLists<String> attributeMergeList = new MergeLists<String>();
            attributeMergeList.add("_q");
            for (Element element : this.nameToElement.values()) {
                Collection<String> names;
                if (element.children.size() > 0) {
                    names = this.getNames(element.children.keySet());
                    elementMergeList.add(names);
                }
                if (element.attributes.size() <= 0) continue;
                names = this.getNames(element.attributes.keySet());
                attributeMergeList.add(names);
            }
            List elementList = elementMergeList.merge();
            List attributeList = attributeMergeList.merge();
            this.elementComparator = new MapComparator(elementList).setErrorOnMissing(true).freeze();
            this.attributeComparator = new MapComparator(attributeList).setErrorOnMissing(true).freeze();
        }
        this.nameToAttributes.freeze();
        this.nameToElement = Collections.unmodifiableMap(this.nameToElement);
    }

    private Collection<String> getNames(Collection<? extends Named> keySet) {
        ArrayList<String> result = new ArrayList<String>();
        for (Named named : keySet) {
            result.add(named.getName());
        }
        return result;
    }

    public Comparator<String> getDtdComparator(AttributeValueComparator avc) {
        return this.dtdComparator;
    }

    public DtdComparator getDtdComparator() {
        return this.dtdComparator;
    }

    public MapComparator<String> getAttributeComparator() {
        return this.attributeComparator;
    }

    public MapComparator<String> getElementComparator() {
        return this.elementComparator;
    }

    public Relation<String, Attribute> getAttributesFromName() {
        return this.nameToAttributes;
    }

    public Map<String, Element> getElementFromName() {
        return this.nameToElement;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        Seen seen = new Seen(this.dtdType);
        seen.seenElements.add(this.ANY);
        seen.seenElements.add(this.PCDATA);
        this.toString(this.ROOT, b, seen);
        int currentEnd = b.length();
        for (Element e : this.nameToElement.values()) {
            this.toString(e, b, seen);
        }
        if (currentEnd != b.length()) {
            b.insert(currentEnd, System.lineSeparator() + System.lineSeparator() + "<!-- Elements not reachable from root! -->" + System.lineSeparator());
        }
        return b.toString();
    }

    public Set<Element> getDescendents(Element start, Set<Element> toAddTo) {
        if (!toAddTo.contains(start)) {
            toAddTo.add(start);
            for (Element e : start.children.keySet()) {
                this.getDescendents(e, toAddTo);
            }
        }
        return toAddTo;
    }

    private void toString(Element current, StringBuilder b, Seen seen) {
        boolean first = true;
        if (seen.seenElements.contains(current)) {
            return;
        }
        seen.seenElements.add(current);
        boolean elementDeprecated = this.isDeprecated(current.name, "*", "*");
        this.showComments(b, current.commentsPre, true);
        b.append("\n\n<!ELEMENT " + current.name + " " + current.model + " >");
        this.showComments(b, current.commentsPost, false);
        if (this.isOrdered(current.name)) {
            b.append(COMMENT_PREFIX + "<!--@ORDERED-->");
        }
        if (current.getElementStatus() != ElementStatus.regular) {
            b.append(COMMENT_PREFIX + "<!--@" + current.getElementStatus().toString().toUpperCase(Locale.ROOT) + "-->");
        }
        if (elementDeprecated) {
            b.append(COMMENT_PREFIX + "<!--@DEPRECATED-->");
        }
        LinkedHashSet<String> deprecatedValues = new LinkedHashSet<String>();
        for (Attribute a : current.attributes.keySet()) {
            if (seen.seenAttributes.contains(a)) continue;
            seen.seenAttributes.add(a);
            boolean attributeDeprecated = elementDeprecated || this.isDeprecated(current.name, a.name, "*");
            deprecatedValues.clear();
            this.showComments(b, a.commentsPre, true);
            b.append("\n<!ATTLIST " + current.name + " " + a.name);
            if (a.type == AttributeType.ENUMERATED_TYPE) {
                b.append(" (");
                first = true;
                for (String s2 : a.values.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(" | ");
                    }
                    b.append(s2);
                    if (attributeDeprecated || !this.isDeprecated(current.name, a.name, s2)) continue;
                    deprecatedValues.add(s2);
                }
                b.append(")");
            } else {
                b.append(' ').append((Object)a.type);
            }
            if (a.mode != Mode.NULL) {
                b.append(" ").append(a.mode.source);
            }
            if (a.defaultValue != null) {
                b.append(" \"").append(a.defaultValue).append('\"');
            }
            b.append(" >");
            this.showComments(b, a.commentsPost, false);
            if (a.matchValue != null) {
                b.append(COMMENT_PREFIX + "<!--@MATCH:" + a.matchValue.getName() + "-->");
            }
            if (METADATA.contains(a.name) || a.attributeStatus == AttributeStatus.metadata) {
                b.append(COMMENT_PREFIX + "<!--@METADATA-->");
            } else if (!this.isDistinguishing(current.name, a.name)) {
                b.append(COMMENT_PREFIX + "<!--@VALUE-->");
            }
            if (attributeDeprecated) {
                b.append(COMMENT_PREFIX + "<!--@DEPRECATED-->");
                continue;
            }
            if (deprecatedValues.isEmpty()) continue;
            b.append(COMMENT_PREFIX + "<!--@DEPRECATED:" + Joiner.on(", ").join(deprecatedValues) + "-->");
        }
        if (current.children.size() > 0) {
            for (Element e : current.children.keySet()) {
                this.toString(e, b, seen);
            }
        }
    }

    private void showComments(StringBuilder b, Set<String> comments, boolean separate) {
        if (comments == null) {
            return;
        }
        if (separate && b.length() != 0) {
            b.append(System.lineSeparator());
        }
        for (String c : comments) {
            boolean deprecatedComment = false;
            if (deprecatedComment) continue;
            if (separate) {
                if (b.length() == 0) {
                    b.append("<!--").append(System.lineSeparator()).append(c).append(System.lineSeparator()).append("-->");
                    continue;
                }
                b.append(System.lineSeparator());
            } else {
                b.append(COMMENT_PREFIX);
            }
            b.append("<!-- ").append(c).append(" -->");
        }
    }

    public static <T> T removeFirst(Collection<T> elements, Transform<T, Boolean> matcher) {
        Iterator<T> it = elements.iterator();
        while (it.hasNext()) {
            T item = it.next();
            if (matcher.transform(item) != Boolean.TRUE) continue;
            it.remove();
            return item;
        }
        return null;
    }

    public Set<Element> getElements() {
        return new LinkedHashSet<Element>(this.nameToElement.values());
    }

    public Set<Attribute> getAttributes() {
        return new LinkedHashSet<Attribute>(this.nameToAttributes.values());
    }

    public boolean isDistinguishing(String elementName, String attribute) {
        return this.getAttributeStatus(elementName, attribute) == AttributeStatus.distinguished;
    }

    static final Set<String> addUnmodifiable(Set<String> comment, String addition) {
        if (comment == null) {
            return Collections.singleton(addition);
        }
        comment = new LinkedHashSet<String>(comment);
        comment.add(addition);
        return Collections.unmodifiableSet(comment);
    }

    public boolean isDeprecated(String elementName, String attributeName, String attributeValue) {
        Element element = this.nameToElement.get(elementName);
        if (element == null) {
            throw new IllegalByDtdException(elementName, attributeName, attributeValue);
        }
        if (element.isDeprecatedElement) {
            return true;
        }
        if ("*".equals(attributeName) || "_q".equals(attributeName)) {
            return false;
        }
        Attribute attribute = element.getAttributeNamed(attributeName);
        if (attribute == null) {
            throw new IllegalByDtdException(elementName, attributeName, attributeValue);
        }
        if (attribute.isDeprecatedAttribute) {
            return true;
        }
        return attribute.deprecatedValues.contains(attributeValue);
    }

    public boolean isOrdered(String elementName) {
        Element element = this.nameToElement.get(elementName);
        if (element == null) {
            throw new IllegalByDtdException(elementName, null, null);
        }
        return element.isOrderedElement;
    }

    public AttributeStatus getAttributeStatus(String elementName, String attributeName) {
        if ("_q".equals(attributeName)) {
            return AttributeStatus.distinguished;
        }
        Element element = this.nameToElement.get(elementName);
        if (element == null) {
            if (elementName.startsWith("icu:")) {
                return AttributeStatus.distinguished;
            }
            throw new IllegalByDtdException(elementName, attributeName, null);
        }
        Attribute attribute = element.getAttributeNamed(attributeName);
        if (attribute == null) {
            if (elementName.startsWith("icu:")) {
                return AttributeStatus.distinguished;
            }
            throw new IllegalByDtdException(elementName, attributeName, null);
        }
        return attribute.attributeStatus;
    }

    public static Comparator<String> getAttributeValueComparator(String element, String attribute) {
        return DtdData.getAttributeValueComparator(DtdType.ldml, element, attribute);
    }

    static Comparator<String> getAttributeValueComparator(DtdType type, String element, String attribute) {
        Comparator<String> comp = valueOrdering;
        if (type != DtdType.ldml && type != DtdType.ldmlICU) {
            return comp;
        }
        if (attribute.equals("day")) {
            comp = dayValueOrder;
        } else if (attribute.equals("type")) {
            if (element.endsWith("FormatLength")) {
                comp = lengthOrder;
            } else if (element.endsWith("Width")) {
                comp = widthOrder;
            } else if (element.equals("day")) {
                comp = dayValueOrder;
            } else if (element.equals("field")) {
                comp = dateFieldOrder;
            } else if (element.equals("zone")) {
                comp = zoneOrder;
            } else if (element.equals("listPatternPart")) {
                comp = listPatternOrder;
            } else if (element.equals("currencyFormat")) {
                comp = currencyFormatOrder;
            } else if (element.equals("unitLength")) {
                comp = unitLengthOrder;
            } else if (element.equals("unit")) {
                comp = unitOrder;
            } else if (element.equals("dayPeriod")) {
                comp = dayPeriodOrder;
            }
        } else if (attribute.equals("count") && !element.equals("minDays")) {
            comp = countValueOrder;
        } else if (attribute.equals("cp") && element.equals("annotation")) {
            comp = UNICODE_SET_COMPARATOR;
        }
        return comp;
    }

    public boolean hasValue(String elementName) {
        return this.nameToElement.get(elementName).type == ElementType.PCDATA;
    }

    public boolean isMetadata(XPathParts pathPlain) {
        for (String s2 : pathPlain.getElements()) {
            Element e = this.getElementFromName().get(s2);
            if (e.elementStatus != ElementStatus.metadata) continue;
            return true;
        }
        return false;
    }

    public static boolean isMetadataOld(DtdType dtdType2, XPathParts pathPlain) {
        String element1 = pathPlain.getElement(1);
        String element2 = pathPlain.getElement(2);
        String elementN = pathPlain.getElement(-1);
        switch (dtdType2) {
            case ldml: {
                switch (element1) {
                    case "generation": 
                    case "metadata": {
                        return true;
                    }
                }
                break;
            }
            case ldmlBCP47: {
                switch (element1) {
                    case "generation": 
                    case "version": {
                        return true;
                    }
                }
                break;
            }
            case supplementalData: {
                switch (element1) {
                    case "generation": 
                    case "version": 
                    case "validity": 
                    case "references": 
                    case "coverageLevels": {
                        return true;
                    }
                    case "transforms": {
                        return elementN.equals("comment");
                    }
                    case "metadata": {
                        switch (element2) {
                            case "validity": 
                            case "serialElements": 
                            case "suppress": 
                            case "distinguishing": 
                            case "blocking": 
                            case "casingData": {
                                return true;
                            }
                        }
                    }
                }
                break;
            }
        }
        return false;
    }

    public boolean isDeprecated(XPathParts pathPlain) {
        for (int i = 0; i < pathPlain.size(); ++i) {
            String elementName = pathPlain.getElement(i);
            if (this.isDeprecated(elementName, "*", null)) {
                return true;
            }
            for (String attribute : pathPlain.getAttributeKeys(i)) {
                String attributeValue;
                if (!this.isDeprecated(elementName, attribute, attributeValue = pathPlain.getAttributeValue(i, attribute))) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getRegularizedPaths(XPathParts pathPlain, Multimap<String, String> extras) {
        extras.clear();
        HashMap<String, String> valueAttributes = new HashMap<String, String>();
        XPathPartsSet pathResult = new XPathPartsSet();
        String element = null;
        for (int i = 0; i < pathPlain.size(); ++i) {
            element = pathPlain.getElement(i);
            pathResult.addElement(element);
            valueAttributes.clear();
            for (String attribute : pathPlain.getAttributeKeys(i)) {
                AttributeStatus status = this.getAttributeStatus(element, attribute);
                String attributeValue = pathPlain.getAttributeValue(i, attribute);
                switch (status) {
                    case distinguished: {
                        AttributeType attrType = this.getAttributeType(element, attribute);
                        if (attrType == AttributeType.NMTOKENS) {
                            pathResult.addAttributes(attribute, DtdData.SPACE_SPLITTER.splitToList(attributeValue));
                            break;
                        }
                        pathResult.addAttribute(attribute, attributeValue);
                        break;
                    }
                    case value: {
                        valueAttributes.put(attribute, attributeValue);
                        break;
                    }
                }
            }
            if (valueAttributes.isEmpty()) continue;
            boolean hasValue = this.hasValue(element);
            if (hasValue) {
                pathResult.setElement(i, element + "_");
            } else {
                boolean bl = false;
            }
            for (Map.Entry attributeAndValue : valueAttributes.entrySet()) {
                String attribute = (String)attributeAndValue.getKey();
                String attributeValue = (String)attributeAndValue.getValue();
                ImmutableSet pathsShort = pathResult.toStrings();
                AttributeType attrType = this.getAttributeType(element, attribute);
                for (String pathShort : pathsShort) {
                    pathShort = pathShort + "/_" + attribute;
                    if (attrType == AttributeType.NMTOKENS) {
                        for (String valuePart : SPACE_SPLITTER.split(attributeValue)) {
                            extras.put(pathShort, valuePart);
                        }
                        continue;
                    }
                    extras.put(pathShort, attributeValue);
                }
            }
            if (!hasValue) continue;
            pathResult.setElement(i, element);
        }
        if (!this.hasValue(element)) {
            return null;
        }
        return pathResult.toStrings();
    }

    public AttributeType getAttributeType(String elementName, String attributeName) {
        Attribute attr = this.getAttribute(elementName, attributeName);
        return attr != null ? attr.type : null;
    }

    public Attribute getAttribute(String elementName, String attributeName) {
        Element element = this.nameToElement.get(elementName);
        return element != null ? element.getAttributeNamed(attributeName) : null;
    }

    public static Splitter getValueSplitter(XPathParts pathPlain) {
        if (!Collections.disjoint(pathPlain.getElements(), SPACED_VALUES)) {
            return SPACE_SPLITTER;
        }
        if (pathPlain.getElement(-1).equals("annotation") && !pathPlain.getAttributeKeys(-1).contains("tts")) {
            return BAR_SPLITTER;
        }
        return CR_SPLITTER;
    }

    public static boolean isComment(XPathParts pathPlain, String line) {
        return pathPlain.contains("transform") && line.startsWith("#");
    }

    public static boolean isExtraSplit(String extraPath) {
        return extraPath.endsWith("/_type") && extraPath.startsWith("//supplementalData/metaZones/mapTimezones");
    }

    public ValueStatus getValueStatus(String elementName, String attributeName, String value) {
        Element element = this.nameToElement.get(elementName);
        if (element == null) {
            return ValueStatus.invalid;
        }
        Attribute attr = element.getAttributeNamed(attributeName);
        if (attr == null) {
            return ValueStatus.invalid;
        }
        return attr.getValueStatus(value);
    }

    public Multimap<String, String> getNonEnumerated(Map<String, String> matchValues) {
        TreeMultimap<String, String> nonEnumeratedElementToAttribute = TreeMultimap.create();
        for (Map.Entry<String, Element> entry : this.nameToElement.entrySet()) {
            Element element = entry.getValue();
            for (Attribute attribute : element.attributes.keySet()) {
                if (attribute.type == AttributeType.ENUMERATED_TYPE) continue;
                String elementName = element.getName();
                String attrName = attribute.getName();
                nonEnumeratedElementToAttribute.put(elementName, attrName);
                if (attribute.matchValue == null) continue;
                matchValues.put(elementName + "\t" + attrName, attribute.matchValue.getName());
            }
        }
        return ImmutableSetMultimap.copyOf(nonEnumeratedElementToAttribute);
    }

    private static class XPathPartsSet {
        private final Set<XPathParts> list = new LinkedHashSet<XPathParts>();

        private XPathPartsSet() {
        }

        private void addElement(String element) {
            if (this.list.isEmpty()) {
                this.list.add(new XPathParts().addElement(element));
            } else {
                for (XPathParts item : this.list) {
                    item.addElement(element);
                }
            }
        }

        private void addAttribute(String attribute, String attributeValue) {
            for (XPathParts item : this.list) {
                item.addAttribute(attribute, attributeValue);
            }
        }

        private void setElement(int i, String string) {
            for (XPathParts item : this.list) {
                item.setElement(i, string);
            }
        }

        private void addAttributes(String attribute, List<String> attributeValues) {
            if (attributeValues.size() == 1) {
                this.addAttribute(attribute, attributeValues.iterator().next());
            } else {
                LinkedHashSet<XPathParts> newList = new LinkedHashSet<XPathParts>();
                for (XPathParts item : this.list) {
                    for (String attributeValue : attributeValues) {
                        XPathParts newItem = item.cloneAsThawed();
                        newItem.addAttribute(attribute, attributeValue);
                        newList.add(newItem);
                    }
                }
                this.list.clear();
                this.list.addAll(newList);
            }
        }

        private ImmutableSet<String> toStrings() {
            ImmutableSet.Builder result = new ImmutableSet.Builder();
            for (XPathParts item : this.list) {
                result.add(item.toString());
            }
            return result.build();
        }

        public String toString() {
            return this.list.toString();
        }
    }

    public class IllegalByDtdException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public final String elementName;
        public final String attributeName;
        public final String attributeValue;

        public IllegalByDtdException(String elementName, String attributeName, String attributeValue) {
            this.elementName = elementName;
            this.attributeName = attributeName;
            this.attributeValue = attributeValue;
        }

        @Override
        public String getMessage() {
            return "Dtd " + (Object)((Object)DtdData.this.dtdType) + " doesn\u2019t allow element=" + this.elementName + (this.attributeName == null ? "" : ", attribute: " + this.attributeName) + (this.attributeValue == null ? "" : ", attributeValue: " + this.attributeValue);
        }
    }

    static final class Seen {
        Set<Element> seenElements = new HashSet<Element>();
        Set<Attribute> seenAttributes = new HashSet<Attribute>();

        public Seen(DtdType dtdType) {
            if (dtdType.rootType == dtdType) {
                return;
            }
            DtdData otherData = DtdData.getInstance(dtdType.rootType);
            this.walk(otherData, otherData.ROOT);
            this.seenElements.remove(otherData.nameToElement.get("special"));
        }

        private void walk(DtdData otherData, Element current) {
            this.seenElements.add(current);
            this.seenAttributes.addAll(current.attributes.keySet());
            for (Element e : current.children.keySet()) {
                this.walk(otherData, e);
            }
        }
    }

    public class DtdComparator
    implements Comparator<String> {
        @Override
        public int compare(String path1, String path2) {
            XPathParts a = XPathParts.getFrozenInstance(path1);
            XPathParts b = XPathParts.getFrozenInstance(path2);
            return this.xpathComparator(a, b);
        }

        public int xpathComparator(XPathParts a, XPathParts b) {
            String baseA = a.getElement(0);
            String baseB = b.getElement(0);
            if (!DtdData.this.ROOT.name.equals(baseA) || !DtdData.this.ROOT.name.equals(baseB)) {
                throw new IllegalArgumentException("Comparing different DTDs: " + DtdData.this.ROOT.name + ", " + baseA + ", " + baseB);
            }
            int min2 = Math.min(a.size(), b.size());
            Element parent = DtdData.this.ROOT;
            for (int i = 1; i < min2; ++i) {
                Element elementB;
                String elementRawA = a.getElement(i);
                String elementRawB = b.getElement(i);
                if (elementRawA.startsWith("_")) {
                    return elementRawB.startsWith("_") ? elementRawA.compareTo(elementRawB) : -1;
                }
                if (elementRawB.startsWith("_")) {
                    return 1;
                }
                Element elementA = (Element)DtdData.this.nameToElement.get(elementRawA);
                if (elementA != (elementB = (Element)DtdData.this.nameToElement.get(elementRawB))) {
                    int aa = (Integer)parent.children.get(elementA);
                    int bb = (Integer)parent.children.get(elementB);
                    return aa - bb;
                }
                int countA = a.getAttributeCount(i);
                int countB = b.getAttributeCount(i);
                if (countA != 0 || countB != 0) {
                    String aqValue = a.getAttributeValue(i, "_q");
                    if (aqValue != null) {
                        String bqValue = b.getAttributeValue(i, "_q");
                        if (!aqValue.equals(bqValue)) {
                            int aValue = Integer.parseInt(aqValue);
                            int bValue = Integer.parseInt(bqValue);
                            return aValue - bValue;
                        }
                        --countA;
                        --countB;
                    }
                    for (Map.Entry attr : elementA.attributes.entrySet()) {
                        Attribute main = (Attribute)attr.getKey();
                        String valueA = a.getAttributeValue(i, main.name);
                        String valueB = b.getAttributeValue(i, main.name);
                        if (valueA == null) {
                            if (valueB == null) continue;
                            return -1;
                        }
                        if (valueB == null) {
                            return 1;
                        }
                        if (valueA.equals(valueB)) {
                            if (--countA != 0 || --countB != 0) continue;
                            break;
                        }
                        if (main.attributeValueComparator != null) {
                            return main.attributeValueComparator.compare(valueA, valueB);
                        }
                        if (main.values.size() != 0) {
                            int aa = main.values.get(valueA);
                            int bb = main.values.get(valueB);
                            return aa - bb;
                        }
                        return valueA.compareTo(valueB);
                    }
                    if (countA != 0 || countB != 0) {
                        throw new IllegalArgumentException();
                    }
                }
                parent = elementA;
            }
            return a.size() - b.size();
        }
    }

    public static interface AttributeValueComparator {
        public int compare(String var1, String var2, String var3, String var4);
    }

    public static enum DtdItem {
        ELEMENT,
        ATTRIBUTE,
        ATTRIBUTE_VALUE;

    }

    public static class Element
    implements Named {
        public final String name;
        private String rawModel;
        private ElementType type;
        private final Map<Element, Integer> children = new LinkedHashMap<Element, Integer>();
        private final Map<Attribute, Integer> attributes = new LinkedHashMap<Attribute, Integer>();
        private Set<String> commentsPre;
        private Set<String> commentsPost;
        private String model;
        private boolean isOrderedElement;
        private boolean isDeprecatedElement;
        private ElementStatus elementStatus = ElementStatus.regular;
        static final Pattern CLEANER1 = PatternCache.get("([,|(])(?=\\S)");
        static final Pattern CLEANER2 = PatternCache.get("(?=\\S)([|)])");

        private Element(String name2) {
            this.name = name2.intern();
        }

        private void setChildren(DtdData dtdData, String model, Set<String> precomments) {
            this.commentsPre = precomments;
            this.rawModel = model;
            this.model = this.clean(model);
            if (model.equals("EMPTY")) {
                this.type = ElementType.EMPTY;
                return;
            }
            this.type = ElementType.CHILDREN;
            for (String part : FILLER.split(model)) {
                if (part.length() == 0) continue;
                if (part.equals("#PCDATA")) {
                    this.type = ElementType.PCDATA;
                    continue;
                }
                if (part.equals("ANY")) {
                    this.type = ElementType.ANY;
                    continue;
                }
                CldrUtility.putNew(this.children, dtdData.elementFrom(part), this.children.size());
            }
            if (this.type == ElementType.CHILDREN == (this.children.size() == 0) && !model.startsWith("(#PCDATA|cp")) {
                throw new IllegalArgumentException("CLDR does not permit Mixed content. " + this.name + ":" + model);
            }
        }

        private String clean(String model2) {
            String result = CLEANER1.matcher(model2).replaceAll("$1 ");
            return (result = CLEANER2.matcher(result).replaceAll(" $1")).equals(model2) ? model2 : result;
        }

        public boolean containsAttribute(String string) {
            for (Attribute a : this.attributes.keySet()) {
                if (!a.name.equals(string)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.name;
        }

        public String toDtdString() {
            return "<!ELEMENT " + this.name + " " + this.getRawModel() + " >";
        }

        public ElementType getType() {
            return this.type;
        }

        public Map<Element, Integer> getChildren() {
            return Collections.unmodifiableMap(this.children);
        }

        public Map<Attribute, Integer> getAttributes() {
            return Collections.unmodifiableMap(this.attributes);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Element getChildNamed(String string) {
            for (Element e : this.children.keySet()) {
                if (!e.name.equals(string)) continue;
                return e;
            }
            return null;
        }

        public Attribute getAttributeNamed(String string) {
            for (Attribute a : this.attributes.keySet()) {
                if (!a.name.equals(string)) continue;
                return a;
            }
            return null;
        }

        public void addComment(String addition) {
            if (addition.startsWith("@")) {
                switch (addition) {
                    case "@ORDERED": {
                        this.isOrderedElement = true;
                        break;
                    }
                    case "@DEPRECATED": {
                        this.isDeprecatedElement = true;
                        break;
                    }
                    case "@METADATA": {
                        this.elementStatus = ElementStatus.metadata;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized annotation: " + addition);
                    }
                }
                return;
            }
            this.commentsPost = DtdData.addUnmodifiable(this.commentsPost, addition.trim());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Element)) {
                return false;
            }
            Element that = (Element)obj;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean isDeprecated() {
            return this.isDeprecatedElement;
        }

        public boolean isOrdered() {
            return this.isOrderedElement;
        }

        public ElementStatus getElementStatus() {
            return this.elementStatus;
        }

        public String getRawModel() {
            return this.rawModel;
        }
    }

    public static enum ElementStatus {
        regular,
        metadata;

    }

    static interface Named {
        public String getName();
    }

    public static enum ElementType {
        EMPTY,
        ANY,
        PCDATA("(#PCDATA)"),
        CHILDREN;

        public final String source;

        private ElementType(String s2) {
            this.source = s2;
        }

        private ElementType() {
            this.source = this.name();
        }
    }

    public static enum ValueStatus {
        invalid,
        unknown,
        valid;

    }

    public static class Attribute
    implements Named {
        private static final Joiner JOINER_COMMA_SPACE = Joiner.on(", ");
        public static final String AUG_TRAIL = "\u27eb";
        public static final String AUG_LEAD = "\u27ea";
        public static final String ENUM_TRAIL = "\u27e9";
        public static final String ENUM_LEAD = "\u27e8";
        public static final Pattern LEAD_TRAIL = Pattern.compile("(.*[\u27ea\u27e8])(.*)([\u27eb\u27e9].*)");
        public final String name;
        public final Element element;
        public final Mode mode;
        public final String defaultValue;
        public final AttributeType type;
        public final Map<String, Integer> values;
        private final Set<String> commentsPre;
        private Set<String> commentsPost;
        private boolean isDeprecatedAttribute;
        public AttributeStatus attributeStatus = AttributeStatus.distinguished;
        private Set<String> deprecatedValues = Collections.emptySet();
        public MatchValue matchValue;
        private final Comparator<String> attributeValueComparator;
        private static Splitter COMMA = Splitter.on(',').trimResults();

        private Attribute(DtdType dtdType, Element element2, String aName, Mode mode2, String[] split, String value2, Set<String> firstComment) {
            int elementChildrenCount;
            this.commentsPre = firstComment;
            this.element = element2;
            this.name = aName.intern();
            if (this.name.equals("draft") && !DRAFT_ON_NON_LEAF_ALLOWED.contains(this.element.getName()) && ((elementChildrenCount = this.element.getChildren().size()) > 1 || elementChildrenCount == 1 && !this.element.getChildren().keySet().iterator().next().getName().equals("cp"))) {
                this.isDeprecatedAttribute = true;
            }
            this.mode = mode2;
            this.defaultValue = value2 == null ? null : value2.intern();
            AttributeType _type = AttributeType.ENUMERATED_TYPE;
            Map _values = Collections.emptyMap();
            if (split.length == 1) {
                try {
                    _type = AttributeType.valueOf(split[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.type = _type;
            if (_type == AttributeType.ENUMERATED_TYPE) {
                LinkedHashMap<String, Integer> temp = new LinkedHashMap<String, Integer>();
                for (String part : split) {
                    if (part.length() == 0) continue;
                    temp.put(part.intern(), temp.size());
                }
                _values = Collections.unmodifiableMap(temp);
            }
            this.values = _values;
            this.attributeValueComparator = DtdData.getAttributeValueComparator(dtdType, this.element.name, this.name);
        }

        public String toString() {
            return this.element.name + ":" + this.name;
        }

        public String getSampleValue() {
            return this.type == AttributeType.ENUMERATED_TYPE ? (this.values.containsKey("year") ? "year" : this.values.keySet().iterator().next()) : (this.matchValue != null ? this.matchValue.getSample() : "\u2753");
        }

        public StringBuilder appendDtdString(StringBuilder b) {
            Attribute a = this;
            b.append("<!ATTLIST " + this.element.name + " " + a.name);
            if (a.type == AttributeType.ENUMERATED_TYPE) {
                b.append(" (");
                boolean first = true;
                for (String s2 : a.values.keySet()) {
                    if (this.deprecatedValues.contains(s2)) continue;
                    if (first) {
                        first = false;
                    } else {
                        b.append(" | ");
                    }
                    b.append(s2);
                }
                b.append(")");
            } else {
                b.append(' ').append((Object)a.type);
            }
            if (a.mode != Mode.NULL) {
                b.append(" ").append(a.mode.source);
            }
            if (a.defaultValue != null) {
                b.append(" \"").append(a.defaultValue).append('\"');
            }
            b.append(" >");
            return b;
        }

        public String features() {
            return (this.type == AttributeType.ENUMERATED_TYPE ? this.values.keySet().toString() : this.type.toString()) + (this.mode == Mode.NULL ? "" : ", mode=" + (Object)((Object)this.mode)) + (this.defaultValue == null ? "" : ", default=" + this.defaultValue);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void addComment(String commentIn) {
            if (commentIn.startsWith("@")) {
                block5 : switch (commentIn) {
                    case "@METADATA": {
                        this.attributeStatus = AttributeStatus.metadata;
                        break;
                    }
                    case "@VALUE": {
                        this.attributeStatus = AttributeStatus.value;
                        break;
                    }
                    case "@DEPRECATED": {
                        this.isDeprecatedAttribute = true;
                        break;
                    }
                    default: {
                        int colonPos = commentIn.indexOf(58);
                        if (colonPos < 0) {
                            throw new IllegalArgumentException("Unrecognized annotation: " + commentIn);
                        }
                        String command = commentIn.substring(0, colonPos);
                        String argument = commentIn.substring(colonPos + 1);
                        switch (command) {
                            case "@DEPRECATED": {
                                this.deprecatedValues = Collections.unmodifiableSet(new HashSet<String>(COMMA.splitToList(argument)));
                                break block5;
                            }
                            case "@MATCH": {
                                if (this.matchValue != null) {
                                    throw new IllegalArgumentException("Conflicting @MATCH: " + this.matchValue.getName() + " & " + argument);
                                }
                                this.matchValue = MatchValue.of(argument);
                                break block5;
                            }
                        }
                        throw new IllegalArgumentException("Unrecognized annotation: " + commentIn);
                    }
                }
                return;
            }
            this.commentsPost = DtdData.addUnmodifiable(this.commentsPost, commentIn.trim());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Attribute)) {
                return false;
            }
            Attribute that = (Attribute)obj;
            return this.name.equals(that.name) && this.element.name.equals(that.element.name);
        }

        public int hashCode() {
            return this.name.hashCode() * 37 + this.element.name.hashCode();
        }

        public boolean isDeprecated() {
            return this.isDeprecatedAttribute;
        }

        public boolean isDeprecatedValue(String value) {
            return this.deprecatedValues.contains(value);
        }

        public AttributeStatus getStatus() {
            return this.attributeStatus;
        }

        public ValueStatus getValueStatus(String value) {
            return this.deprecatedValues.contains(value) ? ValueStatus.invalid : (this.type == AttributeType.ENUMERATED_TYPE ? (this.values.containsKey(value) ? ValueStatus.valid : ValueStatus.invalid) : (this.matchValue == null ? ValueStatus.unknown : (this.matchValue.is(value) ? ValueStatus.valid : ValueStatus.invalid)));
        }

        public String getMatchString() {
            return this.type == AttributeType.ENUMERATED_TYPE ? ENUM_LEAD + JOINER_COMMA_SPACE.join(this.values.keySet()) + ENUM_TRAIL : (this.matchValue != null ? AUG_LEAD + this.matchValue.toString() + AUG_TRAIL : "");
        }

        public Attribute getMatchingName(Map<Attribute, Integer> attributes) {
            for (Attribute attribute : attributes.keySet()) {
                if (!this.name.equals(attribute.getName())) continue;
                return attribute;
            }
            return null;
        }
    }

    public static enum AttributeType {
        CDATA,
        ID,
        IDREF,
        IDREFS,
        ENTITY,
        ENTITIES,
        NMTOKEN,
        NMTOKENS,
        ENUMERATED_TYPE;

    }

    public static enum Mode {
        REQUIRED("#REQUIRED"),
        OPTIONAL("#IMPLIED"),
        FIXED("#FIXED"),
        NULL("null");

        public final String source;

        private Mode(String s2) {
            this.source = s2;
        }

        public static Mode forString(String mode) {
            for (Mode value : Mode.values()) {
                if (!value.source.equals(mode)) continue;
                return value;
            }
            if (mode == null) {
                return NULL;
            }
            throw new IllegalArgumentException(mode);
        }
    }

    public static enum AttributeStatus {
        distinguished("\u00a7d"),
        value("\u00a7v"),
        metadata("\u00a7m\ufe0e");

        public final String shortName;

        private AttributeStatus(String shortName) {
            this.shortName = shortName;
        }

        public static String getShortName(AttributeStatus status) {
            return status == null ? "" : status.shortName;
        }
    }
}

