/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.ibm.icu.util.ULocale;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.LanguageTagParser;

public enum LanguageGroup {
    root("und"),
    germanic("gem"),
    celtic("cel"),
    romance("roa"),
    slavic("sla"),
    baltic("bat"),
    indic("inc"),
    iranian("ira"),
    other_indo("ine_001"),
    caucasian("cau"),
    dravidian("dra"),
    uralic("urj"),
    cjk("und_Hani"),
    sino_tibetan("sit"),
    tai("tai"),
    austronesian("map"),
    turkic("trk"),
    afroasiatic("afa"),
    austroasiatic("aav"),
    niger_congo("nic"),
    east_sudanic("sdv"),
    songhay("son"),
    american("und_019"),
    art("art"),
    other("und_001");

    public final String iso;
    static final Map<ULocale, LanguageGroup> LANGUAGE_GROUP;
    static final ChainedMap.M3<LanguageGroup, ULocale, Integer> GROUP_LANGUAGE;
    public static Comparator<ULocale> COMPARATOR;

    private LanguageGroup(String iso) {
        this.iso = iso;
    }

    private static void add(Map<ULocale, LanguageGroup> map, LanguageGroup group, String ... baseLanguages) {
        Map<ULocale, Integer> soFar = GROUP_LANGUAGE.get(group);
        int count = soFar == null ? 0 : soFar.size();
        for (String s2 : baseLanguages) {
            ULocale loc = new ULocale(s2);
            if (map.put(loc, group) != null) {
                throw new IllegalArgumentException("duplicate: " + s2 + ", " + (Object)((Object)group));
            }
            GROUP_LANGUAGE.put(group, loc, count);
            ++count;
        }
    }

    public static LanguageGroup get(ULocale locale) {
        return CldrUtility.ifNull(LANGUAGE_GROUP.get(new ULocale(locale.getLanguage())), other);
    }

    public static Set<ULocale> getExplicit() {
        return Collections.unmodifiableSet(LANGUAGE_GROUP.keySet());
    }

    public static Set<ULocale> getLocales(LanguageGroup group) {
        return Collections.unmodifiableSet(GROUP_LANGUAGE.get(group).keySet());
    }

    public static int rankInGroup(ULocale locale) {
        LanguageGroup group = LANGUAGE_GROUP.get(locale = new ULocale(locale.getLanguage()));
        if (group == null) {
            return Integer.MAX_VALUE;
        }
        return GROUP_LANGUAGE.get(group).get(locale);
    }

    public static void main(String[] args) {
        CLDRFile english = CLDRConfig.getInstance().getEnglish();
        System.out.print("<supplementalData>\n\t<version number=\"$Revision:$\"/>\n\t<languageGroups>\n");
        for (LanguageGroup languageGroup : LanguageGroup.values()) {
            Set<ULocale> locales = LanguageGroup.getLocales(languageGroup);
            String englishName = languageGroup.getName(english);
            System.out.print("\t\t<languageGroup id=\"" + languageGroup.iso + "\" code=\"" + Joiner.on(", ").join(locales) + "\"/>\t<!-- " + englishName + " -->\n");
        }
        System.out.print("\t</languageGroups>\n<supplementalData>\n");
    }

    public String getName(CLDRFile cldrFile) {
        String prefix = "";
        LanguageTagParser ltp = new LanguageTagParser().set(this.iso);
        switch (ltp.getRegion()) {
            case "001": {
                if (ltp.getLanguage().equals("und")) {
                    return "Other";
                }
                prefix = "Other ";
                break;
            }
            case "": {
                break;
            }
            default: {
                return cldrFile.getName(2, ltp.getRegion());
            }
        }
        switch (ltp.getScript()) {
            case "Hani": {
                return "CJK";
            }
            case "": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Need to fix code: " + ltp.getScript());
            }
        }
        return prefix + cldrFile.getName(ltp.getLanguage()).replace(" [Other]", "").replace(" languages", "");
    }

    public String toString() {
        return this.getName(CLDRConfig.getInstance().getEnglish());
    }

    static {
        GROUP_LANGUAGE = ChainedMap.of(new TreeMap(), new LinkedHashMap(), Integer.class);
        LinkedHashMap<ULocale, LanguageGroup> temp = new LinkedHashMap<ULocale, LanguageGroup>();
        LANGUAGE_GROUP = Collections.unmodifiableMap(temp);
        LanguageGroup.add(temp, root, "root");
        LanguageGroup.add(temp, germanic, "en", "fy", "nl", "af", "de", "gsw", "wae", "ksh", "lb", "sv", "da", "no", "nb", "nn", "fo", "is", "yi", "nds");
        LanguageGroup.add(temp, celtic, "ga", "gd", "cy", "gv", "kw", "br");
        LanguageGroup.add(temp, romance, "fr", "pt", "gl", "es", "ca", "ast", "it", "rm", "ro", "fur", "an", "co", "oc", "sc", "scn", "wa");
        LanguageGroup.add(temp, slavic, "pl", "cs", "sk", "sl", "hr", "bs", "mk", "sr", "bg", "ru", "be", "uk", "dsb", "hsb", "cu", "szl");
        LanguageGroup.add(temp, baltic, "lt", "lv", "prg");
        LanguageGroup.add(temp, indic, "ur", "hi", "gu", "sd", "bn", "as", "ccp", "or", "mr", "ne", "pa", "si", "kok", "ks", "mai", "doi", "dv", "sa", "trw");
        LanguageGroup.add(temp, iranian, "fa", "ps", "ku", "os", "ckb", "lrc", "mzn", "tg", "bgn", "sdh");
        LanguageGroup.add(temp, other_indo, "el", "hy", "sq");
        LanguageGroup.add(temp, dravidian, "ta", "te", "ml", "kn");
        LanguageGroup.add(temp, cjk, "zh", "yue", "ja", "ko");
        LanguageGroup.add(temp, turkic, "tr", "az", "tk", "kk", "ky", "uz", "ug", "sah", "tt", "ba", "cv");
        LanguageGroup.add(temp, uralic, "hu", "fi", "et", "se", "smn", "myv", "sma", "smj", "sms");
        LanguageGroup.add(temp, afroasiatic, "ar", "mt", "he", "om", "so", "ha", "am", "tzm", "zgh", "aa", "kab", "shi", "ssy", "ti", "byn", "gez", "sid", "syr", "tig", "wal");
        LanguageGroup.add(temp, tai, "th", "lo", "blt");
        LanguageGroup.add(temp, austronesian, "id", "ms", "jv", "fil", "haw", "mg", "to", "ceb", "mi", "su", "trv");
        LanguageGroup.add(temp, austroasiatic, "vi", "km", "sat");
        LanguageGroup.add(temp, niger_congo, "sw", "swc", "yo", "ig", "ff", "sn", "zu", "wo", "xh", "agq", "ak", "asa", "bas", "bem", "bez", "bm", "cgg", "dua", "dyo", "ebu", "ee", "ewo", "guz", "jgo", "kam", "ki", "kkj", "ksb", "ksf", "lag", "lg", "ln", "lu", "luy", "mua", "nd", "nnh", "nr", "nyn", "rn", "rof", "rw", "sbp", "sg", "ss", "tn", "ts", "vai", "ve", "dav", "jmc", "kde", "mer", "mgh", "mgo", "nmg", "nso", "rwk", "seh", "vun", "xog", "yav", "bss", "cch", "gaa", "kaj", "kcg", "ken", "kpe", "nqo", "ny", "st");
        LanguageGroup.add(temp, american, "chr", "kl", "lkt", "qu", "arn", "cad", "cic", "gn", "iu", "moh", "mus", "nv", "osa", "quc", "nci");
        LanguageGroup.add(temp, east_sudanic, "luo", "mas", "nus", "saq", "teo", "kln");
        LanguageGroup.add(temp, sino_tibetan, "my", "bo", "brx", "dz", "ii", "mni");
        LanguageGroup.add(temp, songhay, "dje", "khq", "ses", "twq");
        LanguageGroup.add(temp, caucasian, "ka", "ce");
        LanguageGroup.add(temp, other, "eu", "mn", "naq", "pcm", "kea", "mfe", "wbp");
        LanguageGroup.add(temp, art, "eo", "vo", "ia", "io", "jbo");
        COMPARATOR = new Comparator<ULocale>(){

            @Override
            public int compare(ULocale o1, ULocale o2) {
                int r2;
                LanguageGroup group1 = LanguageGroup.get(o1);
                LanguageGroup group2 = LanguageGroup.get(o2);
                int diff = group1.ordinal() - group2.ordinal();
                if (diff != 0) {
                    return diff;
                }
                int r1 = LanguageGroup.rankInGroup(o1);
                diff = r1 - (r2 = LanguageGroup.rankInGroup(o2));
                return diff != 0 ? diff : o1.compareTo(o2);
            }
        };
    }
}

