/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.tool.CLDRFileTransformer;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CldrUtility;

public class SpecialLocales {
    private static final String INCLUDE_SUBLOCALES = "*";
    private Map<CLDRLocale, Type> specials = new HashMap<CLDRLocale, Type>();
    private Map<Type, Set<CLDRLocale>> types = new HashMap<Type, Set<CLDRLocale>>();
    private Map<CLDRLocale, String> comments = new HashMap<CLDRLocale, String>();
    private Set<CLDRLocale> specialsWildcards = new HashSet<CLDRLocale>();
    private static boolean DEBUG = false;

    public static Type getType(CLDRLocale l) {
        return SpecialLocales.getInstance().getTypeInternal(l);
    }

    public static Set<CLDRLocale> getByType(Type t) {
        return SpecialLocales.getInstance().getByTypeInternal(t);
    }

    public static String getComment(CLDRLocale l) {
        return SpecialLocales.getCommentRaw(l).replaceAll("@", "");
    }

    public static String getCommentRaw(CLDRLocale l) {
        return SpecialLocales.getInstance().getCommentInternal(l).replaceAll("@@", "@" + l.getBaseName());
    }

    private static synchronized SpecialLocales getInstance() {
        return SpecialLocalesHelper.SINGLETON;
    }

    public Set<CLDRLocale> getByTypeInternal(Type t) {
        return this.types.get((Object)t);
    }

    public Type getTypeInternal(CLDRLocale l) {
        l = this.findLocale(l, l);
        return this.specials.get(l);
    }

    public String getCommentInternal(CLDRLocale l) {
        l = this.findLocale(l, l);
        return this.comments.get(l);
    }

    public CLDRLocale findLocale(CLDRLocale fromLocale, CLDRLocale origLocale) {
        if (origLocale == fromLocale && this.specials.containsKey(origLocale)) {
            return origLocale;
        }
        if (fromLocale == null) {
            return origLocale;
        }
        if (this.specialsWildcards.contains(fromLocale)) {
            return fromLocale;
        }
        return this.findLocale(fromLocale.getParent(), origLocale);
    }

    private SpecialLocales() {
        for (CLDRFileTransformer.LocaleTransform lt : CLDRFileTransformer.LocaleTransform.values()) {
            if (lt.getPolicyIfExisting() != CLDRFileTransformer.PolicyIfExisting.DISCARD) continue;
            CLDRLocale inputLocale = CLDRLocale.getInstance(lt.getInputLocale());
            CLDRLocale outputLocale = CLDRLocale.getInstance(lt.getOutputLocale());
            this.addToType(Type.readonly, outputLocale);
            this.comments.put(outputLocale, "@" + outputLocale.getBaseName() + " is generated from @" + inputLocale.getBaseName() + " via transliteration, and so @@ may not be edited directly. Edit @" + inputLocale.getBaseName() + " to make changes.");
        }
        for (DataFileRow r : DataFileRow.ROWS) {
            CLDRLocale l = null;
            try {
                l = CLDRLocale.getInstance(r.id);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid CLDRLocale in SpecialLocales.txt:" + r.id);
            }
            this.addToType(r.type, l);
            if (r.includeSubLocs) {
                if (r.type == Type.scratch) {
                    throw new IllegalArgumentException("Scratch locales cannot include sublocales: " + l);
                }
                this.specialsWildcards.add(l);
            }
            if (!r.comment.isEmpty()) {
                this.comments.put(l, r.comment);
            }
            if (!DEBUG) continue;
            System.out.println(SpecialLocales.class.getSimpleName() + ": locale " + l + ", includejSublocs=" + r.includeSubLocs + ", type=" + (Object)((Object)r.type) + ", comment: " + r.comment);
        }
        this.specials = Collections.unmodifiableMap(this.specials);
        this.specialsWildcards = Collections.unmodifiableSet(this.specialsWildcards);
        this.comments = Collections.unmodifiableMap(this.comments);
        this.types = Collections.unmodifiableMap(this.types);
    }

    private Set<CLDRLocale> addToType(Type t, CLDRLocale l) {
        Set<CLDRLocale> s2 = this.types.get((Object)t);
        if (s2 == null) {
            s2 = new TreeSet<CLDRLocale>();
            this.types.put(t, s2);
        }
        s2.add(l);
        this.specials.put(l, t);
        return s2;
    }

    @Deprecated
    public static boolean isScratchLocale(String locale) {
        return SpecialLocales.isScratchLocale(CLDRLocale.getInstance(locale));
    }

    public static boolean isScratchLocale(CLDRLocale loc) {
        return SpecialLocales.getType(loc) == Type.scratch;
    }

    public static List<String> getScratchLocaleIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (DataFileRow r : DataFileRow.ROWS) {
            if (r.type != Type.scratch) continue;
            ids.add(r.id);
        }
        return ids;
    }

    private static class DataFileRow {
        public boolean includeSubLocs;
        public String id;
        public Type type;
        public String comment;
        public static List<DataFileRow> ROWS = DataFileRow.readDataFile();

        public DataFileRow(String id, Type type, String comment, boolean includeSubLocs) {
            this.id = id;
            this.type = type;
            this.comment = comment;
            this.includeSubLocs = includeSubLocs;
        }

        private static List<DataFileRow> readDataFile() {
            ArrayList<DataFileRow> rows = new ArrayList<DataFileRow>();
            int ln = 0;
            try {
                BufferedReader lstreg = CldrUtility.getUTF8Data("SpecialLocales.txt");
                while (true) {
                    String line = lstreg.readLine();
                    ++ln;
                    if (line == null) break;
                    int commentPos = line.indexOf(35);
                    if (commentPos >= 0) {
                        line = line.substring(0, commentPos);
                    }
                    if ((line = line.trim()).length() == 0) continue;
                    List<String> stuff = CldrUtility.splitList(line, ';', true);
                    String id = stuff.get(0);
                    boolean includeSublocs = id.endsWith(SpecialLocales.INCLUDE_SUBLOCALES);
                    if (includeSublocs) {
                        id = id.substring(0, id.length() - SpecialLocales.INCLUDE_SUBLOCALES.length());
                    }
                    String type = stuff.get(1);
                    String comment = stuff.get(2);
                    Type t = null;
                    try {
                        t = Type.valueOf(type.toLowerCase(Locale.ENGLISH));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Invalid SpecialLocales.Type in SpecialLocales.txt:" + ln + ": " + line);
                    }
                    rows.add(new DataFileRow(id, t, comment, includeSublocs));
                }
            }
            catch (IOException e) {
                throw new ICUUncheckedIOException("Internal Error", e);
            }
            return rows;
        }
    }

    private static final class SpecialLocalesHelper {
        static final SpecialLocales SINGLETON = new SpecialLocales();

        private SpecialLocalesHelper() {
        }
    }

    public static enum Type {
        readonly,
        scratch;

    }
}

