/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.unicode.cldr.util.CharSource;
import org.unicode.cldr.util.CharUtilities;
import org.unicode.cldr.util.CompactStringByteConverter;
import org.unicode.cldr.util.Dictionary;
import org.unicode.cldr.util.SimpleDictionary;
import org.unicode.cldr.util.StateDictionary;
import org.unicode.cldr.util.StateDictionaryBuilder;
import org.unicode.cldr.util.Utf8StringByteConverter;

public class TestStateDictionaryBuilder<T> {
    private static final boolean SHORT_TEST = true;
    private static final boolean SHOW_CONTENTS = true;
    private static final boolean CHECK_BOOLEAN = false;
    private final boolean SHOW_STATES = true;
    boolean SIMPLE_ONLY = false;
    boolean TEST_AGAINST_SIMPLE = true;
    Dictionary<T> stateDictionary;
    Dictionary.Matcher<T> stateMatcher;
    Dictionary<T> simpleDictionary;
    Dictionary.Matcher<T> simpleMatcher;
    Map<CharSequence, T> baseMapping = new TreeMap<CharSequence, T>();
    final StateDictionaryBuilder<T> stateDictionaryBuilder = new StateDictionaryBuilder();
    final SimpleDictionary.SimpleDictionaryBuilder<T> simpleDictionaryBuilder = new SimpleDictionary.SimpleDictionaryBuilder();

    public static void main(String[] args) {
        try {
            new TestStateDictionaryBuilder().test(args);
        }
        finally {
            System.out.println("DONE");
        }
    }

    public void test(String[] args) {
        for (String string : args) {
            if (string.equalsIgnoreCase("utf8")) {
                this.stateDictionaryBuilder.setByteConverter(new Utf8StringByteConverter());
                continue;
            }
            if (string.equalsIgnoreCase("normal")) {
                this.stateDictionaryBuilder.setByteConverter(new CompactStringByteConverter(false));
                continue;
            }
            if (!string.equalsIgnoreCase("compact")) continue;
            this.stateDictionaryBuilder.setByteConverter(new CompactStringByteConverter(true));
        }
        this.baseMapping.put("GMT+0000", "t");
        this.baseMapping.put("GMT+0100", "t");
        this.baseMapping.put("GMT+0200", "t");
        this.baseMapping.put("GMT+0300", "t");
        this.baseMapping.put("GMT+0307", "t");
        this.showDictionaryContents();
        this.addToBoth((CharSequence)"man", 1);
        this.addToBoth((CharSequence)"manner", 100);
        this.addToBoth((CharSequence)"many", 10);
        this.addToBoth((CharSequence)"any", 83);
        this.showDictionaryContents();
        this.baseMapping.put("man", "Woman");
        this.baseMapping.put("many", "Few");
        this.baseMapping.put("any", "All");
        this.showDictionaryContents();
        for (Dictionary.Matcher.Filter filter : Dictionary.Matcher.Filter.values()) {
            String string = "many manners ma";
            TestStateDictionaryBuilder.tryFind("many manners ma", new CharUtilities.CharSourceWrapper<String>("many manners ma"), this.stateDictionary, filter);
        }
        this.showWords("ma");
        this.showWords("ma!");
        this.showWords("!ma");
        this.showWords("man");
        this.showWords("man!");
        this.showWords("mann");
        this.showWords("mann!");
        this.showWords("many");
        this.showWords("many!");
        this.compare();
        this.addToBoth((CharSequence)"m\u03b1nner", 1000);
        this.showDictionaryContents();
        this.showWords("m\u03b1");
        this.compare();
        this.addToBoth((CharSequence)"fish", 10);
        this.showDictionaryContents();
        this.showWords("a fisherman");
        this.compare();
        this.addToBoth((CharSequence)"fisher", 13);
        this.showDictionaryContents();
        this.showWords("a fisherman");
        this.compare();
        this.addToBoth((CharSequence)"her", 55);
        this.showDictionaryContents();
        this.showWords("a fisherman");
        this.compare();
        String[] stringArray = TimeZone.getAvailableIDs();
        SimpleDateFormat dt = (SimpleDateFormat)DateFormat.getDateInstance(1, new ULocale("hi"));
        dt.applyPattern("vvvv");
        for (String zoneID : stringArray) {
            TimeZone zone = TimeZone.getTimeZone(zoneID);
            dt.setTimeZone(zone);
            String zoneName = dt.format(0);
            this.addToBoth((CharSequence)zoneName, zoneID);
        }
        this.compare();
        this.showDictionaryContents();
        ((StateDictionary)this.stateDictionary).flatten();
        if (this.SIMPLE_ONLY) {
            this.testWithUnicodeNames();
            ((StateDictionary)this.stateDictionary).flatten();
            this.compare();
            System.out.println();
            this.showDictionaryContents();
        }
    }

    public static <U> void tryFind(CharSequence originalText, CharSource charListText, Dictionary<U> dictionary, Dictionary.Matcher.Filter filter) {
        System.out.println("Using dictionary: " + Dictionary.load(dictionary.getMapping(), new TreeMap()));
        System.out.println("Searching in: {" + originalText + "} with filter=" + (Object)((Object)filter));
        Dictionary.Matcher<U> matcher = dictionary.getMatcher();
        matcher.setText(charListText);
        while (true) {
            Dictionary.Matcher.Status status = matcher.find(filter);
            String unique = "";
            if (status == Dictionary.Matcher.Status.NONE) break;
            if (status == Dictionary.Matcher.Status.PARTIAL) {
                unique = matcher.nextUniquePartial() ? "\tUnique" : "\tNot Unique";
            }
            System.out.println("{" + TestStateDictionaryBuilder.showBoth(charListText, 0, matcher.getOffset()) + "[[" + TestStateDictionaryBuilder.showBoth(charListText, matcher.getOffset(), matcher.getMatchEnd()) + "]]" + TestStateDictionaryBuilder.showBoth(charListText, matcher.getMatchEnd(), charListText.getKnownLength()) + "}\t" + (Object)((Object)status) + "  \t{" + matcher.getMatchValue() + "}\t" + unique);
        }
        System.out.println();
    }

    public static CharSequence showBoth(CharSource source, int start, int end) {
        if (source instanceof CharUtilities.CharSourceWrapper) {
            CharUtilities.CharSourceWrapper new_name = (CharUtilities.CharSourceWrapper)source;
            return new_name.sourceSubSequence(start, end);
        }
        return source.subSequence(start, end);
    }

    private void showDictionaryContents() {
        this.simpleDictionary = this.simpleDictionaryBuilder.make((Map)this.baseMapping);
        this.simpleMatcher = this.simpleDictionary.getMatcher();
        this.stateDictionary = this.stateDictionaryBuilder.make((Map)this.baseMapping);
        this.stateMatcher = this.stateDictionary.getMatcher();
        this.baseMapping.clear();
        System.out.println("Dictionary: " + Dictionary.load(this.stateDictionary.getMapping(), new TreeMap()));
        System.out.println();
        System.out.println("States:\n" + this.stateDictionary);
        System.out.println();
        System.out.println("Structure:\n" + this.stateDictionary.debugShow());
        System.out.println();
    }

    private void testWithUnicodeNames() {
        UnicodeSet testSet = new UnicodeSet("[[:assigned:] - [:ideographic:] - [:Co:] - [:Cs:]]");
        int count = 0;
        TreeMap<String, String> data = new TreeMap<String, String>();
        UnicodeSetIterator it = new UnicodeSetIterator(testSet);
        while (it.next()) {
            String name = UCharacter.getExtendedName(it.codepoint);
            if (name == null) continue;
            if ((++count & 0xFF) == 0) {
                System.out.println(count + ":\t" + Utility.hex(it.codepoint) + "\t" + name);
            }
            data.put(name, Utility.hex(it.codepoint, 4));
        }
        count = 0;
        for (String item : data.keySet()) {
            if (count++ > 500) continue;
            this.addToBoth((CharSequence)item, data.get(item));
        }
        this.simpleDictionary = this.simpleDictionaryBuilder.make((Map)this.baseMapping);
        this.stateDictionary = this.stateDictionaryBuilder.make((Map)this.baseMapping);
        this.baseMapping.clear();
        this.compare();
    }

    private void compare() {
        System.out.println("Comparing results: ");
        Map dictionaryData = Dictionary.load(this.stateDictionary.getMapping(), new HashMap());
        Map simpleDictionaryData = Dictionary.load(this.simpleDictionary.getMapping(), new HashMap());
        assert (dictionaryData.equals(simpleDictionaryData)) : this.showDifference(dictionaryData, simpleDictionaryData);
        System.out.println("Size: " + dictionaryData.size());
        System.out.println("Rows: " + ((StateDictionary)this.stateDictionary).getRowCount());
        System.out.println("Checking values: state dictionary");
        this.checkSimpleMatches(this.stateMatcher, dictionaryData);
        System.out.println("Checking values: simple dictionary");
        this.checkSimpleMatches(this.simpleMatcher, simpleDictionaryData);
        int count = 0;
        System.out.println("Cross-checking all values");
        for (CharSequence myText : simpleDictionaryData.keySet()) {
            if ((++count & 0xFF) == 255) {
                System.out.println(count + ":\t" + myText);
            }
            this.crossCheck(new CharUtilities.CharSourceWrapper<CharSequence>(myText));
            this.crossCheck("!" + myText);
            this.crossCheck(myText + "!");
        }
    }

    private String showDifference(Map<CharSequence, T> dictionaryData, Map<CharSequence, T> simpleDictionaryData) {
        System.out.println(dictionaryData.size() + ", " + simpleDictionaryData.size());
        Iterator<Map.Entry<CharSequence, T>> it1 = dictionaryData.entrySet().iterator();
        Iterator<Map.Entry<CharSequence, T>> it2 = simpleDictionaryData.entrySet().iterator();
        while (it1.hasNext() || it2.hasNext()) {
            Map.Entry<CharSequence, T> item1 = it1.hasNext() ? it1.next() : null;
            Map.Entry<CharSequence, T> item2 = it2.hasNext() ? it2.next() : null;
            System.out.println(item1 + ", " + item2);
            if (item1 != null && item2 != null && item1.equals(item2)) continue;
            return item1 + "!=" + item2;
        }
        return "no difference";
    }

    private void crossCheck(CharSequence myText) {
        this.crossCheck(new CharUtilities.CharSourceWrapper<CharSequence>(myText));
    }

    private void crossCheck(CharSource myText) {
        this.stateMatcher.setText(myText);
        this.simpleMatcher.setText(myText);
        int i = 0;
        while (this.stateMatcher.getText().hasCharAt(i)) {
            Dictionary.Matcher.Status stateStatus;
            this.stateMatcher.setOffset(i);
            this.simpleMatcher.setOffset(i);
            do {
                stateStatus = this.stateMatcher.next();
                Dictionary.Matcher.Status simpleStatus = this.simpleMatcher.next();
                assert (stateStatus == simpleStatus) : this.showValues(stateStatus, simpleStatus);
                int stateEnd = this.stateMatcher.getMatchEnd();
                int simpleEnd = this.simpleMatcher.getMatchEnd();
                assert (stateEnd == simpleEnd) : this.showValues(stateStatus, simpleStatus);
                if (stateStatus == Dictionary.Matcher.Status.PARTIAL) {
                    boolean stateUnique = this.stateMatcher.nextUniquePartial();
                    boolean simpleUnique = this.simpleMatcher.nextUniquePartial();
                    assert (stateUnique == simpleUnique) : this.showValues(stateStatus, simpleStatus);
                }
                assert (this.stateMatcher.getMatchValue() == this.simpleMatcher.getMatchValue()) : this.showValues(stateStatus, simpleStatus);
            } while (stateStatus == Dictionary.Matcher.Status.MATCH);
            ++i;
        }
    }

    private String showValues(Dictionary.Matcher.Status stateStatus, Dictionary.Matcher.Status simpleStatus) {
        return "\nTEXT:\t" + this.stateMatcher.text + "\n" + "STATE:\t" + this.showValues(stateStatus, this.stateMatcher) + "\n" + "SIMPLE:\t" + this.showValues(simpleStatus, this.simpleMatcher);
    }

    private String showValues(Dictionary.Matcher.Status status, Dictionary.Matcher<T> matcher) {
        boolean uniquePartial = status == Dictionary.Matcher.Status.PARTIAL && matcher.nextUniquePartial();
        return String.format("\tOffsets: %s,%s\tStatus: %s\tString: \"%s\"\tValue: %s %s", new Object[]{matcher.getOffset(), matcher.getMatchEnd(), status, matcher.getMatchText(), matcher.getMatchValue(), status == Dictionary.Matcher.Status.PARTIAL && uniquePartial ? "\tUNIQUE" : ""});
    }

    private void checkSimpleMatches(Dictionary.Matcher<T> matcher, Map<CharSequence, T> data) {
        int count = 0;
        for (CharSequence myText : data.keySet()) {
            Dictionary.Matcher.Status next1;
            if ((count++ & 0xFF) == 255) {
                System.out.println(count + ":\t" + myText);
            }
            matcher.setText(myText);
            matcher.setOffset(0);
            int matchEnd = -1;
            Object matchValue = null;
            while ((next1 = matcher.next()) == Dictionary.Matcher.Status.MATCH) {
                matchEnd = matcher.getMatchEnd();
                matchValue = matcher.getMatchValue();
            }
            assert (matchEnd == myText.length()) : "failed to find end of <" + myText + "> got instead " + matchEnd;
            assert (matchValue == data.get(myText));
        }
    }

    private void addToBoth(CharSequence string, int i) {
        this.baseMapping.put(string, i + "/" + string);
    }

    private void addToBoth(CharSequence string, T i) {
        this.baseMapping.put(string, i);
    }

    private void showWords(String myText) {
        System.out.format("Finding words in: \"%s\"\n", myText);
        if (this.SIMPLE_ONLY) {
            this.showWords("", this.simpleMatcher, myText);
        } else {
            Set<String> stateResult;
            Set<String> simpleResult = this.showWords("Simple", this.simpleMatcher, myText);
            if (!simpleResult.equals(stateResult = this.showWords("STATE", this.stateMatcher, myText))) {
                System.out.println("  DIFFERENCE");
                this.showWords("Simple", this.simpleMatcher, myText);
                this.showWords("STATE", this.stateMatcher, myText);
                LinkedHashSet<String> simpleMinusState = new LinkedHashSet<String>(simpleResult);
                simpleMinusState.removeAll(stateResult);
                System.out.println("Simple-State" + simpleMinusState);
                LinkedHashSet<String> stateMinusSimple = new LinkedHashSet<String>(stateResult);
                stateMinusSimple.removeAll(simpleResult);
                System.out.println("State-Simple" + stateMinusSimple);
            }
        }
    }

    private Set<String> showWords(String title, Dictionary.Matcher<T> matcher, String myText) {
        title = title.equals("") ? "" : "\tType: " + title;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        matcher.setText(myText);
        boolean uniquePartial = false;
        int i = 0;
        while (matcher.hasCharAt(i)) {
            Dictionary.Matcher.Status status;
            matcher.setOffset(i);
            do {
                if ((status = matcher.next()) == Dictionary.Matcher.Status.PARTIAL) {
                    uniquePartial = matcher.nextUniquePartial();
                }
                String info = String.format("\tOffsets: %s,%s\tStatus: %s\tString: \"%s\"\tValue: %s%s", new Object[]{matcher.getOffset(), matcher.getMatchEnd(), status, matcher.getMatchText(), matcher.getMatchValue(), status == Dictionary.Matcher.Status.PARTIAL && uniquePartial ? "\tUNIQUE" : ""});
                result.add(info);
                if (status == Dictionary.Matcher.Status.NONE) continue;
                System.out.println(title + info);
            } while (status == Dictionary.Matcher.Status.MATCH);
            ++i;
        }
        return result;
    }
}

