/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.RecursiveAction;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CheckCoverage;
import org.unicode.cldr.test.CheckNew;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.test.OutdatedPaths;
import org.unicode.cldr.test.SubmissionLocales;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.Predicate;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.ValuePathStatus;
import org.unicode.cldr.util.VoteResolver;
import org.unicode.cldr.util.VoterProgress;

public class VettingViewer<T> {
    private static final boolean DEBUG = false;
    private static final boolean SHOW_SUBTYPES = true;
    private static final String CONNECT_PREFIX = "\u208d_";
    private static final String CONNECT_SUFFIX = "\u208e";
    private static final String TH_AND_STYLES = "<th class='tv-th' style='text-align:left'>";
    private static final String SPLIT_CHAR = "\ufffe";
    private static final boolean DEBUG_THREADS = false;
    private static final Set<CheckCLDR.CheckStatus.Subtype> OK_IF_VOTED = EnumSet.of(CheckCLDR.CheckStatus.Subtype.sameAsEnglish);
    private static PathHeader.Factory pathTransform;
    private static final OutdatedPaths outdatedPaths;
    private final Factory cldrFactory;
    private final CLDRFile englishFile;
    private final UsersChoice<T> userVoteStatus;
    private final SupplementalDataInfo supplementalDataInfo;
    private final Set<String> defaultContentLocales;
    private final boolean USE_FORKJOIN = false;
    public static final UnicodeSet LATIN;
    static final NumberFormat nf;
    private final Relation<String, String> reasonsToPaths;
    private ProgressCallback progressCallback = new ProgressCallback();

    public static boolean orgIsNeutralForSummary(Organization org) {
        return org.equals((Object)Organization.surveytool);
    }

    public static OutdatedPaths getOutdatedPaths() {
        return outdatedPaths;
    }

    public VettingViewer(SupplementalDataInfo supplementalDataInfo, Factory cldrFactory, UsersChoice<T> userVoteStatus) {
        this.cldrFactory = cldrFactory;
        this.englishFile = cldrFactory.make("en", true);
        if (pathTransform == null) {
            pathTransform = PathHeader.getFactory(this.englishFile);
        }
        this.userVoteStatus = userVoteStatus;
        this.supplementalDataInfo = supplementalDataInfo;
        this.defaultContentLocales = supplementalDataInfo.getDefaultContentLocales();
        this.reasonsToPaths = Relation.of(new HashMap(), HashSet.class);
    }

    public DashboardData generateDashboard(EnumSet<Choice> choices, String localeID, int userId, T organization, Level usersLevel, CLDRFile sourceFile, CLDRFile baselineFile) {
        DashboardData dd = new DashboardData();
        FileInfo fileInfo = new FileInfo(localeID, usersLevel, choices, organization);
        fileInfo.setFiles(sourceFile, baselineFile);
        fileInfo.setSorted(dd.sorted);
        fileInfo.setVoterProgressAndId(dd.voterProgress, userId);
        fileInfo.getFileInfo();
        return dd;
    }

    public void generatePriorityItemsSummary(Appendable output, EnumSet<Choice> choices, T organization) {
        try {
            output.append("<p>The following summarizes the Priority Items across locales, using the default coverage levels for your organization for each locale. Before using, please read the instructions at <a target='CLDR_ST_DOCS' href='https://cldr.unicode.org/translation/getting-started/vetting-view#TOC-Priority-Items'>Priority Items Summary</a>.</p>\n");
            StringBuilder headerRow = new StringBuilder();
            headerRow.append("<tr class='tvs-tr'>").append(TH_AND_STYLES).append("Locale</th>").append(TH_AND_STYLES).append("Codes</th>");
            for (Choice choice : choices) {
                headerRow.append("<th class='tv-th'>");
                choice.appendDisplay(headerRow);
                headerRow.append("</th>");
            }
            headerRow.append("</tr>\n");
            String header = headerRow.toString();
            if (VettingViewer.orgIsNeutralForSummary((Organization)((Object)organization))) {
                this.writeSummaryTable(output, header, Level.COMPREHENSIVE, choices, organization);
            } else {
                for (Level level : Level.values()) {
                    this.writeSummaryTable(output, header, level, choices, organization);
                }
            }
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private void writeSummaryTable(Appendable output, String header, Level desiredLevel, EnumSet<Choice> choices, T organization) throws IOException {
        TreeMap<Object, String> sortedNames = new TreeMap<Object, String>(CLDRConfig.getInstance().getCollator());
        LocalesWithExplicitLevel includeLocale = new LocalesWithExplicitLevel((Organization)((Object)organization), desiredLevel);
        for (String localeID : this.cldrFactory.getAvailable()) {
            if (this.defaultContentLocales.contains(localeID) || localeID.equals("en") || !includeLocale.is(localeID)) continue;
            sortedNames.put(this.getName(localeID), localeID);
        }
        if (sortedNames.isEmpty()) {
            return;
        }
        output.append("<h2>Level: ").append(desiredLevel.toString()).append("</h2>");
        output.append("<table class='tvs-table'>\n");
        TreeMap<String, FileInfo> localeNameToFileInfo = new TreeMap<String, FileInfo>();
        VettingCounters totals = new VettingCounters();
        Set entrySet = sortedNames.entrySet();
        WriteContext context = new WriteContext(entrySet, choices, organization, totals, localeNameToFileInfo, header);
        WriteAction writeAction = new WriteAction(context);
        writeAction.computeAll();
        context.appendTo(output);
        output.append(header);
        this.writeSummaryRow(output, choices, totals.problemCounter, "Total", null);
        output.append("</table>");
        this.showSubtypes(output, sortedNames, localeNameToFileInfo, totals, true);
        this.showSubtypes(output, sortedNames, localeNameToFileInfo, totals, false);
    }

    private void showSubtypes(Appendable output, Map<String, String> sortedNames, Map<String, FileInfo> localeNameToFileInfo, VettingCounters totals, boolean errors) throws IOException {
        output.append("<h3>Details: ").append(errors ? "Error Types" : "Warning Types").append("</h3>");
        output.append("<table class='tvs-table'>");
        Counter subtypeCounterTotals = errors ? totals.errorSubtypeCounter : totals.warningSubtypeCounter;
        Set<CheckCLDR.CheckStatus.Subtype> sortedBySize = subtypeCounterTotals.getKeysetSortedByCount(false);
        this.writeDetailHeader(sortedBySize, output);
        for (Map.Entry<String, FileInfo> entry : localeNameToFileInfo.entrySet()) {
            Counter counter;
            Counter counter2 = counter = errors ? entry.getValue().vc.errorSubtypeCounter : entry.getValue().vc.warningSubtypeCounter;
            if (counter.getTotal() == 0L) continue;
            String name = entry.getKey();
            String localeID = sortedNames.get(name);
            output.append("<tr>").append(TH_AND_STYLES);
            this.appendNameAndCode(name, localeID, output);
            output.append("</th>");
            for (CheckCLDR.CheckStatus.Subtype subtype : sortedBySize) {
                long count = counter.get(subtype);
                output.append("<td class='tvs-count'>");
                if (count != 0L) {
                    output.append(nf.format(count));
                }
                output.append("</td>");
            }
        }
        this.writeDetailHeader(sortedBySize, output);
        output.append("<tr>").append(TH_AND_STYLES).append("<i>Total</i>").append("</th>").append(TH_AND_STYLES).append("</th>");
        for (CheckCLDR.CheckStatus.Subtype subtype : sortedBySize) {
            long count = subtypeCounterTotals.get(subtype);
            output.append("<td class='tvs-count'>");
            if (count != 0L) {
                output.append("<b>").append(nf.format(count)).append("</b>");
            }
            output.append("</td>");
        }
        output.append("</table>");
    }

    private void writeDetailHeader(Set<CheckCLDR.CheckStatus.Subtype> sortedBySize, Appendable output) throws IOException {
        output.append("<tr>").append(TH_AND_STYLES).append("Name").append("</th>").append(TH_AND_STYLES).append("ID").append("</th>");
        for (CheckCLDR.CheckStatus.Subtype subtype : sortedBySize) {
            output.append(TH_AND_STYLES).append(subtype.toString()).append("</th>");
        }
    }

    private void writeSummaryRow(Appendable output, EnumSet<Choice> choices, Counter<Choice> problemCounter, String name, String localeID) throws IOException {
        output.append("<tr>").append(TH_AND_STYLES);
        if (localeID == null) {
            output.append("<i>").append(name).append("</i>").append("</th>").append(TH_AND_STYLES);
        } else {
            this.appendNameAndCode(name, localeID, output);
        }
        output.append("</th>\n");
        for (Choice choice : choices) {
            long count = problemCounter.get(choice);
            output.append("<td class='tvs-count'>");
            if (localeID == null) {
                output.append("<b>");
            }
            output.append(nf.format(count));
            if (localeID == null) {
                output.append("</b>");
            }
            output.append("</td>\n");
        }
        output.append("</tr>\n");
    }

    private void appendNameAndCode(String name, String localeID, Appendable output) throws IOException {
        String url = "v#/" + localeID + "//";
        String[] names = name.split(SPLIT_CHAR);
        output.append("<a href='" + url).append("'>").append(TransliteratorUtilities.toHTML.transform(names[0])).append("</a>").append("</th>").append(TH_AND_STYLES).append("<code>").append(names[1]).append("</code>");
    }

    private String getName(String localeID) {
        Set<String> contents = this.supplementalDataInfo.getEquivalentsForLocale(localeID);
        return this.englishFile.getName(localeID, true, CLDRFile.SHORT_ALTS) + SPLIT_CHAR + VettingViewer.gatherCodes(contents);
    }

    private static String gatherCodes(Set<String> contents) {
        LinkedHashSet<Set<String>> source = new LinkedHashSet<Set<String>>();
        for (String s2 : contents) {
            source.add(new LinkedHashSet<String>(Arrays.asList(s2.split("_"))));
        }
        LinkedHashSet<Set<String>> oldSource = new LinkedHashSet<Set<String>>();
        do {
            oldSource.clear();
            oldSource.addAll(source);
            source.clear();
            Set<String> last = null;
            for (Set<String> set : oldSource) {
                if (last == null) {
                    last = set;
                    continue;
                }
                if (set.containsAll(last)) {
                    last = VettingViewer.combine(last, set);
                    continue;
                }
                source.add(last);
                last = set;
            }
            source.add(last);
        } while (oldSource.size() != source.size());
        StringBuilder b = new StringBuilder();
        for (Set set : source) {
            if (b.length() != 0) {
                b.append(", ");
            }
            String sep = "";
            for (String string : set) {
                if (string.startsWith(CONNECT_PREFIX)) {
                    b.append(string + CONNECT_SUFFIX);
                } else {
                    b.append(sep + string);
                }
                sep = "_";
            }
        }
        return b.toString();
    }

    private static Set<String> combine(Set<String> last, Set<String> ss) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String s2 : ss) {
            if (last.contains(s2)) {
                result.add(s2);
                continue;
            }
            result.add(CONNECT_PREFIX + s2);
        }
        return result;
    }

    public static MissingStatus getMissingStatus(CLDRFile sourceFile, String path, boolean latin) {
        MissingStatus result;
        boolean isAliased;
        if (sourceFile == null) {
            return MissingStatus.ABSENT;
        }
        String sourceLocaleID = sourceFile.getLocaleID();
        if ("root".equals(sourceLocaleID)) {
            return MissingStatus.MISSING_OK;
        }
        String value = sourceFile.getStringValue(path);
        CLDRFile.Status status = new CLDRFile.Status();
        String sourceLocale = sourceFile.getSourceLocaleIdExtended(path, status, false);
        boolean bl = isAliased = !path.equals(status.pathWhereFound);
        if (value == null) {
            result = ValuePathStatus.isMissingOk(sourceFile, path, latin, isAliased) ? MissingStatus.MISSING_OK : MissingStatus.ABSENT;
        } else {
            String localeFound = sourceFile.getSourceLocaleIdExtended(path, status, false);
            boolean localeFoundIsRootOrCodeFallback = localeFound.equals("root") || localeFound.equals("code-fallback");
            boolean isParentRoot = CLDRLocale.getInstance(sourceFile.getLocaleID()).isParentRoot();
            result = localeFoundIsRootOrCodeFallback ? (ValuePathStatus.isMissingOk(sourceFile, path, latin, isAliased) ? MissingStatus.ROOT_OK : (isParentRoot ? MissingStatus.ABSENT : MissingStatus.ALIASED)) : (!isAliased ? MissingStatus.PRESENT : (isParentRoot ? (ValuePathStatus.isMissingOk(sourceFile, path, latin, isAliased) ? MissingStatus.MISSING_OK : MissingStatus.ABSENT) : MissingStatus.ALIASED));
        }
        return result;
    }

    public static boolean isLatinScriptLocale(CLDRFile sourceFile) {
        return ValuePathStatus.isLatinScriptLocale(sourceFile);
    }

    private static void appendToMessage(CharSequence usersValue, CheckCLDR.CheckStatus.Subtype subtype, StringBuilder testMessage) {
        if (subtype != null) {
            usersValue = "&lt;" + (Object)((Object)subtype) + "&gt; " + usersValue;
        }
        VettingViewer.appendToMessage(usersValue, testMessage);
    }

    private static void appendToMessage(CharSequence usersValue, StringBuilder testMessage) {
        if (usersValue.length() == 0) {
            return;
        }
        if (testMessage.length() != 0) {
            testMessage.append("<br>");
        }
        testMessage.append(usersValue);
    }

    public VettingViewer<T> setProgressCallback(ProgressCallback newCallback) {
        this.progressCallback = newCallback;
        return this;
    }

    public static String getHeaderStyles() {
        return "<style>\n.hide {display:none}\n.vve {}\n.vvn {}\n.vvp {}\n.vvl {}\n.vvm {}\n.vvu {}\n.vvw {}\n.vvd {}\n.vvo {}\n</style>";
    }

    public ArrayList<String> getErrorOnPath(EnumSet<Choice> choices, String localeID, T organization, Level usersLevel, String path) {
        Relation sorted = Relation.of(new TreeMap(), TreeSet.class);
        CLDRFile sourceFile = this.cldrFactory.make(localeID, true);
        CLDRFile baselineFile = null;
        try {
            Factory baselineFactory = CLDRConfig.getInstance().getCommonAndSeedAndMainAndAnnotationsFactory();
            baselineFile = baselineFactory.make(localeID, true);
        }
        catch (Exception baselineFactory) {
            // empty catch block
        }
        FileInfo fileInfo = new FileInfo(localeID, usersLevel, choices, organization);
        fileInfo.setFiles(sourceFile, baselineFile);
        fileInfo.setSorted(sorted);
        fileInfo.setSinglePath(path);
        fileInfo.getFileInfo();
        EnumSet errors = fileInfo.problems;
        ArrayList<String> out = new ArrayList<String>();
        for (Object error : errors.toArray()) {
            out.add(((Choice)((Object)error)).jsonLabel);
        }
        return out;
    }

    public static void getStatus(CLDRFile file, PathHeader.Factory pathHeaderFactory, Counter<Level> foundCounter, Counter<Level> unconfirmedCounter, Counter<Level> missingCounter, Relation<MissingStatus, String> missingPaths, Set<String> unconfirmedPaths) {
        VettingViewer.getStatus(file.fullIterable(), file, pathHeaderFactory, foundCounter, unconfirmedCounter, missingCounter, missingPaths, unconfirmedPaths);
    }

    public static void getStatus(Iterable<String> allPaths, CLDRFile file, PathHeader.Factory pathHeaderFactory, Counter<Level> foundCounter, Counter<Level> unconfirmedCounter, Counter<Level> missingCounter, Relation<MissingStatus, String> missingPaths, Set<String> unconfirmedPaths) {
        if (!file.isResolved()) {
            throw new IllegalArgumentException("File must be resolved, no minimal draft status");
        }
        foundCounter.clear();
        unconfirmedCounter.clear();
        missingCounter.clear();
        boolean latin = VettingViewer.isLatinScriptLocale(file);
        CoverageLevel2 coverageLevel2 = CoverageLevel2.getInstance(SupplementalDataInfo.getInstance(), file.getLocaleID());
        block5: for (String path : allPaths) {
            PathHeader ph = pathHeaderFactory.fromPath(path);
            if (ph.getSectionId() == PathHeader.SectionId.Special) continue;
            Level level = coverageLevel2.getLevel(path);
            MissingStatus missingStatus = VettingViewer.getMissingStatus(file, path, latin);
            switch (missingStatus) {
                case ABSENT: {
                    missingCounter.add(level, 1L);
                    if (missingPaths == null || level.compareTo(Level.MODERN) > 0) continue block5;
                    missingPaths.put(missingStatus, path);
                    continue block5;
                }
                case ALIASED: 
                case PRESENT: {
                    String fullPath = file.getFullXPath(path);
                    if (fullPath.contains("unconfirmed") || fullPath.contains("provisional")) {
                        unconfirmedCounter.add(level, 1L);
                        if (unconfirmedPaths == null || level.compareTo(Level.MODERN) > 0) continue block5;
                        unconfirmedPaths.add(path);
                        continue block5;
                    }
                    foundCounter.add(level, 1L);
                    continue block5;
                }
                case MISSING_OK: 
                case ROOT_OK: {
                    continue block5;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static EnumSet<Choice> getChoiceSetForOrg(Organization usersOrg) {
        EnumSet<Choice> choiceSet = EnumSet.allOf(Choice.class);
        if (VettingViewer.orgIsNeutralForSummary(usersOrg)) {
            choiceSet = EnumSet.of(Choice.error, Choice.warning, Choice.hasDispute, Choice.notApproved);
        }
        return choiceSet;
    }

    static {
        outdatedPaths = new OutdatedPaths();
        LATIN = ValuePathStatus.LATIN;
        nf = NumberFormat.getIntegerInstance(ULocale.ENGLISH);
        nf.setGroupingUsed(true);
    }

    public static class ProgressCallback {
        public void nudge() {
        }

        public void done() {
        }

        public boolean isStopped() {
            return false;
        }
    }

    public static enum MissingStatus {
        PRESENT,
        ALIASED,
        MISSING_OK,
        ROOT_OK,
        ABSENT;

    }

    private class WriteAction
    extends RecursiveAction {
        private final int length;
        private final int start;
        private final WriteContext context;
        private static final long serialVersionUID = 1L;

        public WriteAction(WriteContext context) {
            this(context, 0, context.size());
        }

        public WriteAction(WriteContext context, int start, int length) {
            this.context = context;
            this.start = start;
            this.length = length;
        }

        @Override
        protected void compute() {
            if (this.length == 0) {
                return;
            }
            if (this.length <= this.context.configChunkSize) {
                this.computeAll();
            } else {
                int split = this.length / 2;
                WriteAction.invokeAll(new WriteAction(this.context, this.start, split), new WriteAction(this.context, this.start + split, this.length - split));
            }
        }

        private void computeAll() {
            for (int n = this.start; n < this.start + this.length; ++n) {
                this.computeOne(n);
            }
        }

        private void computeOne(int n) {
            if (VettingViewer.this.progressCallback.isStopped()) {
                throw new RuntimeException("Requested to stop");
            }
            String name = (String)this.context.localeNames.get(n);
            String localeID = (String)this.context.localeIds.get(n);
            EnumSet choices = this.context.choices;
            StringBuffer output = this.context.outputs[n];
            if (output == null) {
                throw new NullPointerException("output " + n + " null");
            }
            CLDRFile sourceFile = VettingViewer.this.cldrFactory.make(localeID, true);
            CLDRFile baselineFile = null;
            if (!this.context.ourChoicesThatRequireOldFile.isEmpty()) {
                try {
                    Factory baselineFactory = CLDRConfig.getInstance().getCommonAndSeedAndMainAndAnnotationsFactory();
                    baselineFile = baselineFactory.make(localeID, true);
                }
                catch (Exception baselineFactory) {
                    // empty catch block
                }
            }
            Level level = Level.MODERN;
            if (this.context.organization != null) {
                level = StandardCodes.make().getLocaleCoverageLevel(this.context.organization.toString(), localeID);
            }
            FileInfo fileInfo = new FileInfo(localeID, level, choices, this.context.organization);
            fileInfo.setFiles(sourceFile, baselineFile);
            fileInfo.getFileInfo();
            this.context.localeNameToFileInfo.put(name, fileInfo);
            this.context.totals.addAll(fileInfo.vc);
            try {
                VettingViewer.this.writeSummaryRow(output, choices, fileInfo.vc.problemCounter, name, localeID);
            }
            catch (IOException e) {
                System.err.println("writeAction.compute(" + n + ") - writeexc " + name + ": " + localeID);
                this.completeExceptionally(new RuntimeException("While writing " + localeID, e));
            }
        }
    }

    private class WriteContext {
        private final List<String> localeNames = new ArrayList<String>();
        private final List<String> localeIds = new ArrayList<String>();
        private final StringBuffer[] outputs;
        private final EnumSet<Choice> choices;
        private final EnumSet<Choice> ourChoicesThatRequireOldFile;
        private final T organization;
        private final VettingCounters totals;
        private final Map<String, FileInfo> localeNameToFileInfo;
        private final String header;
        private final int configChunkSize;

        private WriteContext(Set<Map.Entry<String, String>> entrySet, EnumSet<Choice> choices, T organization, VettingCounters totals, Map<String, FileInfo> localeNameToFileInfo, String header) {
            for (Map.Entry<String, String> e : entrySet) {
                this.localeNames.add(e.getKey());
                this.localeIds.add(e.getValue());
            }
            int count = this.localeNames.size();
            this.outputs = new StringBuffer[count];
            for (int i = 0; i < count; ++i) {
                this.outputs[i] = new StringBuffer();
            }
            this.choices = choices;
            EnumSet<Choice> thingsThatRequireOldFile = EnumSet.of(Choice.englishChanged, Choice.missingCoverage, Choice.changedOldValue);
            this.ourChoicesThatRequireOldFile = choices.clone();
            this.ourChoicesThatRequireOldFile.retainAll(thingsThatRequireOldFile);
            this.organization = organization;
            this.totals = totals;
            this.localeNameToFileInfo = localeNameToFileInfo;
            this.header = header;
            CLDRConfig config = CLDRConfig.getInstance();
            int configParallel = Math.max(config.getProperty("CLDR_VETTINGVIEWER_PARALLEL", 0), 0);
            if (configParallel < 1) {
                configParallel = Runtime.getRuntime().availableProcessors();
            }
            this.configChunkSize = Math.max(config.getProperty("CLDR_VETTINGVIEWER_CHUNKSIZE", 1), 1);
        }

        private void appendTo(Appendable output) throws IOException {
            char lastChar = ' ';
            for (int n = 0; n < this.outputs.length; ++n) {
                String name = this.localeNames.get(n);
                output.append(this.outputs[n]);
                char nextChar = name.charAt(0);
                if (lastChar == nextChar) continue;
                output.append(this.header);
                lastChar = nextChar;
            }
        }

        private int size() {
            return this.localeNames.size();
        }
    }

    public static final class LocalesWithExplicitLevel
    implements Predicate<String> {
        private final Organization org;
        private final Level desiredLevel;

        public LocalesWithExplicitLevel(Organization org, Level level) {
            this.org = org;
            this.desiredLevel = level;
        }

        @Override
        public boolean is(String localeId) {
            Output<StandardCodes.LocaleCoverageType> output = new Output<StandardCodes.LocaleCoverageType>();
            if (VettingViewer.orgIsNeutralForSummary(this.org)) {
                for (Organization checkorg : Organization.values()) {
                    StandardCodes.make().getLocaleCoverageLevel(checkorg, localeId, output);
                    if (output.value != StandardCodes.LocaleCoverageType.explicit) continue;
                    return true;
                }
                return false;
            }
            Level level = StandardCodes.make().getLocaleCoverageLevel(this.org, localeId, output);
            return this.desiredLevel == level && output.value == StandardCodes.LocaleCoverageType.explicit;
        }
    }

    private class FileInfo {
        private final String localeId;
        private final CLDRLocale cldrLocale;
        private final Level usersLevel;
        private final EnumSet<Choice> choices;
        private final T organization;
        private CLDRFile sourceFile = null;
        private CLDRFile baselineFileUnresolved = null;
        private boolean latin = false;
        private Relation<Row.R2<PathHeader.SectionId, PathHeader.PageId>, WritingInfo> sorted = null;
        private int voterId = 0;
        private VoterProgress voterProgress = null;
        private final VettingCounters vc = new VettingCounters();
        private final EnumSet<Choice> problems = EnumSet.noneOf(Choice.class);
        private final StringBuilder htmlMessage = new StringBuilder();
        private final StringBuilder statusMessage = new StringBuilder();
        private final EnumSet<CheckCLDR.CheckStatus.Subtype> subtypes = EnumSet.noneOf(CheckCLDR.CheckStatus.Subtype.class);
        private final DefaultErrorStatus errorChecker = new DefaultErrorStatus(VettingViewer.access$800(VettingViewer.this));
        private String specificSinglePath = null;

        private FileInfo(String localeId, Level level, EnumSet<Choice> choices, T organization) {
            this.localeId = localeId;
            this.cldrLocale = CLDRLocale.getInstance(localeId);
            this.usersLevel = level;
            this.choices = choices;
            this.organization = organization;
        }

        private void setFiles(CLDRFile sourceFile, CLDRFile baselineFile) {
            this.sourceFile = sourceFile;
            this.baselineFileUnresolved = baselineFile == null ? null : baselineFile.getUnresolved();
            this.latin = VettingViewer.isLatinScriptLocale(sourceFile);
        }

        private void setSorted(Relation<Row.R2<PathHeader.SectionId, PathHeader.PageId>, WritingInfo> sorted) {
            this.sorted = sorted;
        }

        private void setVoterProgressAndId(VoterProgress voterProgress, int userId) {
            this.voterProgress = voterProgress;
            this.voterId = userId;
        }

        private void setSinglePath(String path) {
            this.specificSinglePath = path;
        }

        private void getFileInfo() {
            if (VettingViewer.this.progressCallback.isStopped()) {
                throw new RuntimeException("Requested to stop");
            }
            this.errorChecker.initErrorStatus(this.sourceFile);
            if (this.specificSinglePath != null) {
                this.handleOnePath(this.specificSinglePath);
                return;
            }
            HashSet<String> seenSoFar = new HashSet<String>();
            for (String path : this.sourceFile.fullIterable()) {
                if (seenSoFar.contains(path)) continue;
                seenSoFar.add(path);
                VettingViewer.this.progressCallback.nudge();
                this.handleOnePath(path);
            }
        }

        private void handleOnePath(String path) {
            VoteStatus voteStatus;
            String oldValue;
            boolean pathLevelIsTooHigh;
            PathHeader ph = pathTransform.fromPath(path);
            if (ph == null || ph.shouldHide()) {
                return;
            }
            String value = this.sourceFile.getWinningValueForVettingViewer(path);
            this.statusMessage.setLength(0);
            this.subtypes.clear();
            ErrorChecker.Status errorStatus = this.errorChecker.getErrorStatus(path, value, this.statusMessage, this.subtypes);
            Level pathLevel = VettingViewer.this.supplementalDataInfo.getCoverageLevel(path, this.localeId);
            boolean onlyRecordErrors = pathLevelIsTooHigh = pathLevel.compareTo(this.usersLevel) > 0;
            this.problems.clear();
            this.htmlMessage.setLength(0);
            String string = oldValue = this.baselineFileUnresolved == null ? null : this.baselineFileUnresolved.getWinningValue(path);
            if (this.skipForLimitedSubmission(path, errorStatus, oldValue)) {
                return;
            }
            if (!onlyRecordErrors && this.choices.contains((Object)Choice.changedOldValue) && oldValue != null && !oldValue.equals(value)) {
                this.problems.add(Choice.changedOldValue);
                this.vc.problemCounter.increment(Choice.changedOldValue);
            }
            boolean itemsOkIfVoted = (voteStatus = VettingViewer.this.userVoteStatus.getStatusForUsersOrganization(this.sourceFile, path, this.organization)) == VoteStatus.ok;
            MissingStatus missingStatus = onlyRecordErrors ? null : this.recordMissingChangedEtc(path, itemsOkIfVoted, value, oldValue);
            this.recordChoice(errorStatus, itemsOkIfVoted, onlyRecordErrors);
            if (!onlyRecordErrors) {
                this.recordLosingDisputedEtc(path, voteStatus, missingStatus);
            }
            this.updateVotedOrAbstained(path, pathLevelIsTooHigh);
            if (this.specificSinglePath == null && !this.problems.isEmpty() && this.sorted != null) {
                VettingViewer.this.reasonsToPaths.clear();
                Row.R2<PathHeader.SectionId, PathHeader.PageId> group = Row.of(ph.getSectionId(), ph.getPageId());
                this.sorted.put(group, new WritingInfo(ph, this.problems, this.htmlMessage));
            }
        }

        private void updateVotedOrAbstained(String path, boolean pathLevelIsTooHigh) {
            if (this.voterProgress == null || this.voterId == 0) {
                return;
            }
            if (pathLevelIsTooHigh && this.problems.isEmpty()) {
                return;
            }
            this.voterProgress.incrementVotablePathCount();
            if (VettingViewer.this.userVoteStatus.userDidVote(this.voterId, this.cldrLocale, path)) {
                this.voterProgress.incrementVotedPathCount();
            } else if (this.choices.contains((Object)Choice.abstained)) {
                this.problems.add(Choice.abstained);
                this.vc.problemCounter.increment(Choice.abstained);
            }
        }

        private boolean skipForLimitedSubmission(String path, ErrorChecker.Status errorStatus, String oldValue) {
            boolean isMissing;
            boolean isError = errorStatus == ErrorChecker.Status.error;
            boolean bl = isMissing = oldValue == null;
            return !SubmissionLocales.allowEvenIfLimited(this.localeId, path, isError, isMissing);
        }

        private MissingStatus recordMissingChangedEtc(String path, boolean itemsOkIfVoted, String value, String oldValue) {
            VoteResolver<String> resolver = VettingViewer.this.userVoteStatus.getVoteResolver(this.cldrLocale, path);
            MissingStatus missingStatus = resolver.getWinningStatus() == VoteResolver.Status.missing ? VettingViewer.getMissingStatus(this.sourceFile, path, this.latin) : MissingStatus.PRESENT;
            if (this.choices.contains((Object)Choice.missingCoverage) && missingStatus == MissingStatus.ABSENT) {
                this.problems.add(Choice.missingCoverage);
                this.vc.problemCounter.increment(Choice.missingCoverage);
            }
            if (SubmissionLocales.pathAllowedInLimitedSubmission(path)) {
                this.problems.add(Choice.englishChanged);
                this.vc.problemCounter.increment(Choice.englishChanged);
            }
            return missingStatus;
        }

        private void recordEnglishChanged(String path, String value, String oldValue) {
            String oldEnglishValue;
            if (Objects.equals(value, oldValue) && this.choices.contains((Object)Choice.englishChanged) && !"\ufffd".equals(oldEnglishValue = outdatedPaths.getPreviousEnglish(path))) {
                this.problems.add(Choice.englishChanged);
                this.vc.problemCounter.increment(Choice.englishChanged);
            }
        }

        private void recordChoice(ErrorChecker.Status errorStatus, boolean itemsOkIfVoted, boolean onlyRecordErrors) {
            block3: {
                Choice choice;
                block2: {
                    Choice choice2 = errorStatus == ErrorChecker.Status.error ? Choice.error : (choice = errorStatus == ErrorChecker.Status.warning ? Choice.warning : null);
                    if (choice != Choice.error || !this.choices.contains((Object)Choice.error) || itemsOkIfVoted && OK_IF_VOTED.containsAll(this.subtypes)) break block2;
                    this.problems.add(choice);
                    VettingViewer.appendToMessage(this.statusMessage, this.htmlMessage);
                    this.vc.problemCounter.increment(choice);
                    for (CheckCLDR.CheckStatus.Subtype subtype : this.subtypes) {
                        this.vc.errorSubtypeCounter.increment(subtype);
                    }
                    break block3;
                }
                if (onlyRecordErrors || choice != Choice.warning || !this.choices.contains((Object)Choice.warning) || itemsOkIfVoted && OK_IF_VOTED.containsAll(this.subtypes)) break block3;
                this.problems.add(choice);
                VettingViewer.appendToMessage(this.statusMessage, this.htmlMessage);
                this.vc.problemCounter.increment(choice);
                for (CheckCLDR.CheckStatus.Subtype subtype : this.subtypes) {
                    this.vc.warningSubtypeCounter.increment(subtype);
                }
            }
        }

        private void recordLosingDisputedEtc(String path, VoteStatus voteStatus, MissingStatus missingStatus) {
            switch (voteStatus) {
                case losing: {
                    String usersValue;
                    if (this.choices.contains((Object)Choice.weLost)) {
                        this.problems.add(Choice.weLost);
                        this.vc.problemCounter.increment(Choice.weLost);
                    }
                    if ((usersValue = VettingViewer.this.userVoteStatus.getWinningValueForUsersOrganization(this.sourceFile, path, this.organization)) == null) break;
                    usersValue = "Losing value: <" + TransliteratorUtilities.toHTML.transform(usersValue) + ">";
                    VettingViewer.appendToMessage(usersValue, this.htmlMessage);
                    break;
                }
                case disputed: {
                    if (!this.choices.contains((Object)Choice.hasDispute)) break;
                    this.problems.add(Choice.hasDispute);
                    this.vc.problemCounter.increment(Choice.hasDispute);
                    break;
                }
                case provisionalOrWorse: {
                    if (missingStatus != MissingStatus.PRESENT || !this.choices.contains((Object)Choice.notApproved)) break;
                    this.problems.add(Choice.notApproved);
                    this.vc.problemCounter.increment(Choice.notApproved);
                    break;
                }
            }
        }
    }

    private class VettingCounters {
        private final Counter<Choice> problemCounter = new Counter();
        private final Counter<CheckCLDR.CheckStatus.Subtype> errorSubtypeCounter = new Counter();
        private final Counter<CheckCLDR.CheckStatus.Subtype> warningSubtypeCounter = new Counter();

        private VettingCounters() {
        }

        private void addAll(VettingCounters other) {
            this.problemCounter.addAll(other.problemCounter);
            this.errorSubtypeCounter.addAll(other.errorSubtypeCounter);
            this.warningSubtypeCounter.addAll(other.warningSubtypeCounter);
        }
    }

    public class DashboardData {
        public Relation<Row.R2<PathHeader.SectionId, PathHeader.PageId>, WritingInfo> sorted = Relation.of(new TreeMap(), TreeSet.class);
        public VoterProgress voterProgress = new VoterProgress();
    }

    public class WritingInfo
    implements Comparable<WritingInfo> {
        public final PathHeader codeOutput;
        public final Set<Choice> problems;
        public final String htmlMessage;

        public WritingInfo(PathHeader ph, EnumSet<Choice> problems, CharSequence htmlMessage) {
            this.codeOutput = ph;
            this.problems = Collections.unmodifiableSet(problems.clone());
            this.htmlMessage = htmlMessage.toString();
        }

        @Override
        public int compareTo(WritingInfo other) {
            return this.codeOutput.compareTo(other.codeOutput);
        }
    }

    private static class DefaultErrorStatus
    implements ErrorChecker {
        private CheckCLDR checkCldr;
        private HashMap<String, String> options = new HashMap();
        private ArrayList<CheckCLDR.CheckStatus> result = new ArrayList();
        private CLDRFile cldrFile;
        private final Factory factory;

        private DefaultErrorStatus(Factory cldrFactory) {
            this.factory = cldrFactory;
        }

        @Override
        public ErrorChecker.Status initErrorStatus(CLDRFile cldrFile) {
            this.cldrFile = cldrFile;
            this.options = new HashMap();
            this.result = new ArrayList();
            this.checkCldr = CheckCLDR.getCheckAll(this.factory, ".*");
            this.checkCldr.setCldrFileToCheck(cldrFile, new CheckCLDR.Options(this.options), this.result);
            return ErrorChecker.Status.ok;
        }

        @Override
        public List<CheckCLDR.CheckStatus> getErrorCheckStatus(String path, String value) {
            String fullPath = this.cldrFile.getFullXPath(path);
            ArrayList<CheckCLDR.CheckStatus> result2 = new ArrayList<CheckCLDR.CheckStatus>();
            this.checkCldr.check(path, fullPath, value, new CheckCLDR.Options(this.options), result2);
            return result2;
        }

        @Override
        public ErrorChecker.Status getErrorStatus(String path, String value, StringBuilder statusMessage) {
            return this.getErrorStatus(path, value, statusMessage, null);
        }

        @Override
        public ErrorChecker.Status getErrorStatus(String path, String value, StringBuilder statusMessage, EnumSet<CheckCLDR.CheckStatus.Subtype> outputSubtypes) {
            ErrorChecker.Status result0 = ErrorChecker.Status.ok;
            StringBuilder errorMessage = new StringBuilder();
            String fullPath = this.cldrFile.getFullXPath(path);
            this.checkCldr.check(path, fullPath, value, new CheckCLDR.Options(this.options), this.result);
            for (CheckCLDR.CheckStatus checkStatus : this.result) {
                CheckCLDR cause = checkStatus.getCause();
                if (cause instanceof CheckCoverage || cause instanceof CheckNew) continue;
                CheckCLDR.CheckStatus.Type statusType = checkStatus.getType();
                if (statusType.equals((Object)CheckCLDR.CheckStatus.errorType)) {
                    if (result0 == ErrorChecker.Status.warning) {
                        errorMessage.setLength(0);
                        if (outputSubtypes != null) {
                            outputSubtypes.clear();
                        }
                    }
                    result0 = ErrorChecker.Status.error;
                    if (outputSubtypes != null) {
                        outputSubtypes.add(checkStatus.getSubtype());
                    }
                    VettingViewer.appendToMessage(checkStatus.getMessage(), checkStatus.getSubtype(), errorMessage);
                    continue;
                }
                if (result0 == ErrorChecker.Status.error || !statusType.equals((Object)CheckCLDR.CheckStatus.warningType)) continue;
                result0 = ErrorChecker.Status.warning;
                if (outputSubtypes != null) {
                    outputSubtypes.add(checkStatus.getSubtype());
                }
                VettingViewer.appendToMessage(checkStatus.getMessage(), checkStatus.getSubtype(), errorMessage);
            }
            if (result0 != ErrorChecker.Status.ok) {
                VettingViewer.appendToMessage(errorMessage, statusMessage);
            }
            return result0;
        }
    }

    public static interface ErrorChecker {
        public Status initErrorStatus(CLDRFile var1);

        public List<CheckCLDR.CheckStatus> getErrorCheckStatus(String var1, String var2);

        public Status getErrorStatus(String var1, String var2, StringBuilder var3);

        public Status getErrorStatus(String var1, String var2, StringBuilder var3, EnumSet<CheckCLDR.CheckStatus.Subtype> var4);

        public static enum Status {
            ok,
            error,
            warning;

        }
    }

    public static interface UsersChoice<T> {
        public String getWinningValueForUsersOrganization(CLDRFile var1, String var2, T var3);

        public VoteStatus getStatusForUsersOrganization(CLDRFile var1, String var2, T var3);

        public boolean userDidVote(int var1, CLDRLocale var2, String var3);

        public VoteResolver<String> getVoteResolver(CLDRLocale var1, String var2);
    }

    public static enum VoteStatus {
        ok_novotes,
        ok,
        provisionalOrWorse,
        losing,
        disputed;

    }

    public static enum Choice {
        error('E', "Error", "The Survey Tool detected an error in the winning value."),
        missingCoverage('M', "Missing", "Your current coverage level requires the item to be present. (During the vetting phase, this is informational: you can\u2019t add new values.)"),
        notApproved('P', "Provisional", "There are not enough votes for this item to be approved (and used)."),
        hasDispute('D', "Disputed", "Different organizations are choosing different values. Please review to approve or reach consensus."),
        weLost('L', "Losing", "The value that your organization chose (overall) is either not the winning value, or doesn\u2019t have enough votes to be approved. This might be due to a dispute between members of your organization."),
        warning('W', "Warning", "The Survey Tool detected a warning about the winning value."),
        englishChanged('U', "English Changed", "The English value has changed in CLDR, but the corresponding value for your language has not. Check if any changes are needed in your language."),
        changedOldValue('C', "Changed", "The winning value was altered from the baseline value. (Informational)"),
        abstained('A', "Abstained", "You have abstained, or not yet voted for any value.");

        public final char abbreviation;
        public final String buttonLabel;
        public final String jsonLabel;
        public final String description;

        private Choice(char abbreviation, String label, String description) {
            this.abbreviation = abbreviation;
            this.jsonLabel = label.replace(' ', '_');
            this.buttonLabel = TransliteratorUtilities.toHTML.transform(label);
            this.description = TransliteratorUtilities.toHTML.transform(description);
        }

        private <T extends Appendable> void appendDisplay(T target) throws IOException {
            target.append("<span title='").append(this.description);
            target.append("'>").append(this.buttonLabel).append("*</span>");
        }
    }
}

