/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.Transform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XEquivalenceClass<T, R>
implements Iterable<T> {
    private static final String ARROW = "\u2192";
    private Map<T, Set<T>> toPartitionSet = new HashMap<T, Set<T>>();
    private Map<T, Map<T, Set<R>>> obj_obj_reasons = new HashMap<T, Map<T, Set<R>>>();
    private R defaultReason;
    private SetMaker setMaker;

    public SetMaker<T> getSetMaker() {
        return this.setMaker;
    }

    public static void main(String[] args) {
        XEquivalenceClass<String, Integer> foo1 = new XEquivalenceClass<String, Integer>(1);
        String[][] tests = new String[][]{{"b", "a1"}, {"b", "c"}, {"a1", "c"}, {"d", "e"}, {"e", "f"}, {"c", "d"}};
        for (int i = 0; i < tests.length; ++i) {
            System.out.println("Adding: " + tests[i][0] + ", " + tests[i][1]);
            foo1.add(tests[i][0], tests[i][1], new Integer(i));
            for (String item : foo1.getExplicitItems()) {
                System.out.println("\t" + item + ";\t" + foo1.getSample(item) + ";\t" + foo1.getEquivalences(item));
                List reasons = foo1.getReasons(item, foo1.getSample(item));
                if (reasons == null) continue;
                System.out.println("\t\t" + XEquivalenceClass.toString(reasons, null));
            }
        }
    }

    public XEquivalenceClass clear(R defaultReasonArg) {
        this.toPartitionSet.clear();
        this.obj_obj_reasons.clear();
        this.defaultReason = defaultReasonArg;
        return this;
    }

    public XEquivalenceClass() {
    }

    public XEquivalenceClass(R defaultReason) {
        this.defaultReason = defaultReason;
    }

    public XEquivalenceClass(R defaultReason, SetMaker<T> setMaker) {
        this.defaultReason = defaultReason;
        this.setMaker = setMaker;
    }

    public XEquivalenceClass add(T a, T b) {
        return this.add(a, b, null);
    }

    public XEquivalenceClass add(T a, T b, R reason) {
        return this.add(a, b, reason, reason);
    }

    public XEquivalenceClass add(T a, T b, R reasonAB, R reasonBA) {
        if (a.equals(b)) {
            return this;
        }
        if (reasonAB == null) {
            reasonAB = this.defaultReason;
        }
        if (reasonBA == null) {
            reasonBA = this.defaultReason;
        }
        this.addReason(a, b, reasonAB);
        this.addReason(b, a, reasonBA);
        Set<T> aPartitionSet = this.toPartitionSet.get(a);
        Set<T> bPartitionSet = this.toPartitionSet.get(b);
        if (aPartitionSet == null) {
            if (bPartitionSet == null) {
                bPartitionSet = this.setMaker != null ? this.setMaker.make() : new HashSet();
                bPartitionSet.add(b);
                this.toPartitionSet.put(b, bPartitionSet);
            }
            bPartitionSet.add(a);
            this.toPartitionSet.put(a, bPartitionSet);
        } else if (bPartitionSet == null) {
            aPartitionSet.add(b);
            this.toPartitionSet.put(b, aPartitionSet);
        } else if (aPartitionSet != bPartitionSet) {
            aPartitionSet.addAll(bPartitionSet);
            for (T item : bPartitionSet) {
                this.toPartitionSet.put(item, aPartitionSet);
            }
        }
        return this;
    }

    public XEquivalenceClass<T, R> addAll(XEquivalenceClass<T, R> other) {
        for (T a : other.obj_obj_reasons.keySet()) {
            Map<T, Set<R>> obj_reasons = other.obj_obj_reasons.get(a);
            for (T b : obj_reasons.keySet()) {
                Set<R> reasons = obj_reasons.get(b);
                for (R reason : reasons) {
                    this.add(a, b, reason);
                }
            }
        }
        return this;
    }

    private void addReason(T a, T b, R reason) {
        Set<R> reasons;
        Map<T, Set<R>> obj_reasons = this.obj_obj_reasons.get(a);
        if (obj_reasons == null) {
            obj_reasons = new HashMap<T, Set<R>>();
            this.obj_obj_reasons.put(a, obj_reasons);
        }
        if ((reasons = obj_reasons.get(b)) == null) {
            reasons = new HashSet<R>();
            obj_reasons.put(b, reasons);
        }
        reasons.add(reason);
    }

    public Set<T> getExplicitItems() {
        return Collections.unmodifiableSet(this.toPartitionSet.keySet());
    }

    public Set<T> getEquivalences(T a) {
        Set<T> aPartitionSet = this.toPartitionSet.get(a);
        if (aPartitionSet == null) {
            aPartitionSet = new HashSet<T>();
            aPartitionSet.add(a);
        }
        return Collections.unmodifiableSet(aPartitionSet);
    }

    public boolean hasEquivalences(T a) {
        return this.toPartitionSet.get(a) != null;
    }

    public Set<Set<T>> getEquivalenceSets() {
        HashSet<Set<T>> result = new HashSet<Set<T>>();
        for (T item : this.toPartitionSet.keySet()) {
            Set<T> partition = this.toPartitionSet.get(item);
            result.add(Collections.unmodifiableSet(partition));
        }
        return result;
    }

    public boolean isEquivalent(T a, T b) {
        if (a.equals(b)) {
            return true;
        }
        Set<T> aPartitionSet = this.toPartitionSet.get(a);
        if (aPartitionSet == null) {
            return false;
        }
        return aPartitionSet.contains(b);
    }

    public T getSample(T a) {
        Set<T> aPartitionSet = this.toPartitionSet.get(a);
        if (aPartitionSet == null) {
            return a;
        }
        return aPartitionSet.iterator().next();
    }

    public T getSample(T a, Filter<T> f) {
        Set<T> aPartitionSet = this.toPartitionSet.get(a);
        if (aPartitionSet == null) {
            return a;
        }
        for (T obj : aPartitionSet) {
            if (!f.matches(obj)) continue;
            return obj;
        }
        return a;
    }

    public Set<T> getSamples() {
        HashSet<T> seenAlready = new HashSet<T>();
        HashSet<T> result = new HashSet<T>();
        for (T item : this.toPartitionSet.keySet()) {
            if (seenAlready.contains(item)) continue;
            Set<T> partition = this.toPartitionSet.get(item);
            result.add(partition.iterator().next());
            seenAlready.addAll(partition);
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return this.getSamples().iterator();
    }

    public static <T, R> String toString(List<Linkage<T, R>> others, Transform<Linkage<T, R>, String> itemTransform) {
        StringBuffer result = new StringBuffer();
        for (Linkage<T, R> item : others) {
            result.append(itemTransform == null ? item.toString() : itemTransform.transform(item));
        }
        return result.toString();
    }

    public List<Linkage<T, R>> getReasons(T a, T b) {
        Set<T> aPartitionSet = this.toPartitionSet.get(a);
        Set<T> bPartitionSet = this.toPartitionSet.get(b);
        if (aPartitionSet == null || bPartitionSet == null || aPartitionSet != bPartitionSet || a.equals(b)) {
            return null;
        }
        ArrayList list = new ArrayList();
        list.add(new Linkage(null, a));
        ArrayList lists = new ArrayList();
        lists.add(list);
        HashSet<Object> sawLastTime = new HashSet<Object>();
        sawLastTime.add(a);
        while (true) {
            ArrayList<ArrayList> extendedList = new ArrayList<ArrayList>();
            HashSet<T> sawThisTime = new HashSet<T>();
            for (ArrayList arrayList : lists) {
                Linkage last = (Linkage)arrayList.get(arrayList.size() - 1);
                Map<T, Set<R>> obj_reasons = this.obj_obj_reasons.get(last.result);
                for (T result : obj_reasons.keySet()) {
                    if (sawLastTime.contains(result)) continue;
                    sawThisTime.add(result);
                    Set<R> reasons = obj_reasons.get(result);
                    ArrayList lista2 = (ArrayList)arrayList.clone();
                    lista2.add(new Linkage<T, R>(reasons, result));
                    extendedList.add(lista2);
                    if (!result.equals(b)) continue;
                    ArrayList found = (ArrayList)lista2.clone();
                    found.remove(0);
                    ((Linkage)found.get((int)(found.size() - 1))).result = null;
                    return found;
                }
            }
            lists = extendedList;
            sawLastTime.addAll(sawThisTime);
        }
    }

    public String toString() {
        return this.getEquivalenceSets().toString();
    }

    public static class Linkage<T, R> {
        public Set<R> reasons;
        public T result;

        public Linkage(Set<R> reasons, T result) {
            this.reasons = reasons;
            this.result = result;
        }

        public String toString() {
            return this.reasons + (this.result == null ? "" : XEquivalenceClass.ARROW + this.result);
        }
    }

    public static interface Filter<T> {
        public boolean matches(T var1);
    }

    public static interface SetMaker<T> {
        public Set<T> make();
    }
}

