/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Function;
import com.ibm.icu.util.ICUException;
import com.ibm.icu.util.ICUUncheckedIOException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Pair;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLFileReader {
    static final boolean SHOW_ALL = false;
    public static int CONTENT_HANDLER = 1;
    public static int ERROR_HANDLER = 2;
    public static int LEXICAL_HANDLER = 4;
    public static int DECLARATION_HANDLER = 8;
    private MyContentHandler DEFAULT_DECLHANDLER = new MyContentHandler();
    private SimpleHandler simpleHandler;

    public XMLFileReader setHandler(SimpleHandler simpleHandler) {
        this.simpleHandler = simpleHandler;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMLFileReader read(String fileName, int handlers, boolean validating) {
        try (FileInputStream fis = new FileInputStream(fileName);){
            XMLFileReader xMLFileReader = this.read(fileName, new InputSource(fis), handlers, validating);
            return xMLFileReader;
        }
        catch (IOException e) {
            File full = new File(fileName);
            String fullName = fileName;
            try {
                fullName = full.getCanonicalPath();
                throw (IllegalArgumentException)new IllegalArgumentException("Can't read " + fullName).initCause(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw (IllegalArgumentException)new IllegalArgumentException("Can't read " + fullName).initCause(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMLFileReader readCLDRResource(String resName, int handlers, boolean validating) {
        try (InputStream inputStream = CldrUtility.getInputStream(resName);){
            XMLFileReader xMLFileReader = this.read(resName, new InputSource(inputStream), handlers, validating);
            return xMLFileReader;
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMLFileReader read(String resName, Class<?> callingClass, int handlers, boolean validating) {
        try (InputStream inputStream = CldrUtility.getInputStream(callingClass, resName);){
            XMLFileReader xMLFileReader = this.read(resName, new InputSource(inputStream), handlers, validating);
            return xMLFileReader;
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    public XMLFileReader read(String systemID, Reader reader, int handlers, boolean validating) {
        XMLFileReader.read(systemID, reader, handlers, validating, (AllHandler)this.DEFAULT_DECLHANDLER.reset());
        return this;
    }

    public XMLFileReader read(String systemID, InputSource insrc, int handlers, boolean validating) {
        XMLFileReader.read(systemID, insrc, handlers, validating, (AllHandler)this.DEFAULT_DECLHANDLER.reset());
        return this;
    }

    public static void read(String systemID, InputStream instr, int handlers, boolean validating, AllHandler allHandler) {
        InputSource is = new InputSource(instr);
        XMLFileReader.read(systemID, is, handlers, validating, allHandler);
    }

    public static void read(String systemID, Reader reader, int handlers, boolean validating, AllHandler allHandler) {
        InputSource is = new InputSource(reader);
        XMLFileReader.read(systemID, is, handlers, validating, allHandler);
    }

    public static void read(String systemID, InputSource is, int handlers, boolean validating, AllHandler allHandler) {
        try {
            XMLReader xmlReader = XMLFileReader.createXMLReader(handlers, validating, allHandler);
            is.setSystemId(systemID);
            try {
                xmlReader.parse(is);
            }
            catch (AbortException abortException) {}
        }
        catch (SAXParseException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Can't read " + systemID + "\tline:\t" + e.getLineNumber()).initCause(e);
        }
        catch (IOException | SAXException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Can't read " + systemID).initCause(e);
        }
    }

    private static final XMLReader createXMLReader(int handlers, boolean validating, AllHandler allHandler) throws SAXNotRecognizedException, SAXNotSupportedException {
        XMLReader xmlReader = XMLFileReader.createXMLReader(validating);
        if ((handlers & CONTENT_HANDLER) != 0) {
            xmlReader.setContentHandler(allHandler);
        }
        if ((handlers & ERROR_HANDLER) != 0) {
            xmlReader.setErrorHandler(allHandler);
        }
        if ((handlers & LEXICAL_HANDLER) != 0) {
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", allHandler);
        }
        if ((handlers & DECLARATION_HANDLER) != 0) {
            xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", allHandler);
        }
        return xmlReader;
    }

    public static String showSAX(SAXParseException exception) {
        return exception.getMessage() + ";\t SystemID: " + exception.getSystemId() + ";\t PublicID: " + exception.getPublicId() + ";\t LineNumber: " + exception.getLineNumber() + ";\t ColumnNumber: " + exception.getColumnNumber();
    }

    public static XMLReader createXMLReader(boolean validating) {
        String[] testList = new String[]{System.getProperty("CLDR_DEFAULT_SAX_PARSER", ""), "org.apache.xerces.parsers.SAXParser", "gnu.xml.aelfred2.XmlReader", "com.bluecast.xml.Piccolo", "oracle.xml.parser.v2.SAXParser"};
        XMLReader result = null;
        for (int i = 0; i < testList.length; ++i) {
            try {
                result = testList[i].length() != 0 ? XMLReaderFactory.createXMLReader(testList[i]) : XMLReaderFactory.createXMLReader();
                result.setFeature("http://xml.org/sax/features/validation", validating);
                break;
            }
            catch (SAXException sAXException) {
                continue;
            }
        }
        if (result == null) {
            throw new NoClassDefFoundError("No SAX parser is available, or unable to set validation correctly");
        }
        return result;
    }

    public static List<Pair<String, String>> loadPathValues(String filename, List<Pair<String, String>> data, boolean validating) {
        return XMLFileReader.loadPathValues(filename, data, validating, false);
    }

    public static List<Pair<String, String>> loadPathValues(String filename, List<Pair<String, String>> data, boolean validating, boolean full) {
        return XMLFileReader.loadPathValues(filename, data, validating, full, null);
    }

    public static List<Pair<String, String>> loadPathValues(String filename, List<Pair<String, String>> data, boolean validating, boolean full, Function<String, String> valueFilter) {
        try {
            new XMLFileReader().setHandler(new PathValueListHandler(data, full, valueFilter)).read(filename, -1, validating);
            return data;
        }
        catch (Exception e) {
            throw new ICUException(filename, e);
        }
    }

    public static void processPathValues(String filename, boolean validating, SimpleHandler simpleHandler) {
        try {
            new XMLFileReader().setHandler(simpleHandler).read(filename, -1, validating);
        }
        catch (Exception e) {
            throw new ICUException(filename, e);
        }
    }

    static final class PathValueListHandler
    extends SimpleHandler {
        List<Pair<String, String>> data;
        boolean full;
        private Function<String, String> valueFilter;

        public PathValueListHandler(List<Pair<String, String>> data, boolean full, Function<String, String> valueFilter) {
            this.data = data != null ? data : new ArrayList();
            this.full = full;
            this.valueFilter = valueFilter;
        }

        @Override
        public void handlePathValue(String path, String value) {
            if (this.valueFilter == null) {
                this.data.add(Pair.of(path, value));
            } else {
                String filteredValue = this.valueFilter.apply(value);
                if (filteredValue != null) {
                    this.data.add(Pair.of(path, filteredValue));
                }
            }
        }

        @Override
        public void handleComment(String path, String comment) {
            if (!this.full || path.equals("/")) {
                return;
            }
            this.data.add(Pair.of("!", comment));
        }
    }

    static final class DebuggingInputStream
    extends InputStream {
        InputStream contents;

        @Override
        public void close() throws IOException {
            this.contents.close();
        }

        public DebuggingInputStream(InputStream fis) {
            this.contents = fis;
        }

        @Override
        public int read() throws IOException {
            int x = this.contents.read();
            System.out.println(Integer.toHexString(x) + ",");
            return x;
        }
    }

    static final class AbortException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        AbortException() {
        }
    }

    public class MyContentHandler
    extends LoggingHandler {
        StringBuffer chars = new StringBuffer();
        StringBuffer commentChars = new StringBuffer();
        Stack<String> startElements = new Stack();
        StringBuffer tempPath = new StringBuffer();
        boolean lastIsStart = false;

        public MyContentHandler reset() {
            this.chars.setLength(0);
            this.tempPath = new StringBuffer("/");
            this.startElements.clear();
            this.startElements.push("/");
            return this;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.lastIsStart) {
                this.chars.append(ch, start, length);
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.tempPath.setLength(0);
            this.tempPath.append(this.startElements.peek()).append('/').append(qName);
            for (int i = 0; i < atts.getLength(); ++i) {
                this.tempPath.append("[@").append(atts.getQName(i)).append("=\"").append(atts.getValue(i).replace('\"', '\'')).append("\"]");
            }
            this.startElements.push(this.tempPath.toString());
            this.chars.setLength(0);
            this.lastIsStart = true;
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            String startElement = this.startElements.pop();
            if (this.lastIsStart) {
                XMLFileReader.this.simpleHandler.handlePathValue(startElement, this.chars.toString());
            }
            this.chars.setLength(0);
            this.lastIsStart = false;
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            XMLFileReader.this.simpleHandler.handleStartDtd(name, publicId, systemId);
        }

        @Override
        public void endDTD() throws SAXException {
            XMLFileReader.this.simpleHandler.handleEndDtd();
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            this.commentChars.append(ch, start, length);
            XMLFileReader.this.simpleHandler.handleComment(this.startElements.peek(), this.commentChars.toString());
            this.commentChars.setLength(0);
        }

        @Override
        public void elementDecl(String name, String model) throws SAXException {
            XMLFileReader.this.simpleHandler.handleElementDecl(name, model);
        }

        @Override
        public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
            XMLFileReader.this.simpleHandler.handleAttributeDecl(eName, aName, type, mode, value);
        }
    }

    public static class LoggingHandler
    implements AllHandler {
        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void elementDecl(String name, String model) throws SAXException {
        }

        @Override
        public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void internalEntityDecl(String name, String value) throws SAXException {
        }

        @Override
        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        }

        public void notationDecl(String name, String publicId, String systemId) {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    public static interface AllHandler
    extends ContentHandler,
    LexicalHandler,
    DeclHandler,
    ErrorHandler {
    }

    public static class SimpleHandler {
        public void handlePathValue(String path, String value) {
        }

        public void handleComment(String path, String comment) {
        }

        public void handleElementDecl(String name, String model) {
        }

        public void handleAttributeDecl(String eName, String aName, String type, String mode, String value) {
        }

        public void handleEndDtd() {
        }

        public void handleStartDtd(String name, String publicId, String systemId) {
        }
    }
}

