/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UnicodeSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class IdentifierInfo {
    private static final UnicodeSet ASCII = new UnicodeSet(0, 127).freeze();
    private String identifier;
    private final BitSet requiredScripts = new BitSet();
    private final Set<BitSet> scriptSetSet = new HashSet<BitSet>();
    private final BitSet commonAmongAlternates = new BitSet();
    private final UnicodeSet numerics = new UnicodeSet();
    private final UnicodeSet identifierProfile = new UnicodeSet(0, 0x10FFFF);
    static final BitSet COMMON_AND_INHERITED = IdentifierInfo.set(new BitSet(), 0, 1);
    private static final BitSet JAPANESE = IdentifierInfo.set(new BitSet(), 25, 17, 20, 22);
    private static final BitSet CHINESE = IdentifierInfo.set(new BitSet(), 25, 17, 5);
    private static final BitSet KOREAN = IdentifierInfo.set(new BitSet(), 25, 17, 18);
    private static final BitSet CONFUSABLE_WITH_LATIN = IdentifierInfo.set(new BitSet(), 8, 14, 6);

    private IdentifierInfo clear() {
        this.requiredScripts.clear();
        this.scriptSetSet.clear();
        this.numerics.clear();
        this.commonAmongAlternates.clear();
        return this;
    }

    public IdentifierInfo setIdentifierProfile(UnicodeSet identifierProfile) {
        this.numerics.set(this.numerics);
        return this;
    }

    public UnicodeSet getIdentifierProfile() {
        return new UnicodeSet(this.identifierProfile);
    }

    public IdentifierInfo setIdentifier(String identifier) {
        this.identifier = identifier;
        this.clear();
        BitSet temp = new BitSet();
        for (int i = 0; i < identifier.length(); i += Character.charCount(i)) {
            int cp = Character.codePointAt(identifier, i);
            if (UCharacter.getType(cp) == 9) {
                this.numerics.add(cp - UCharacter.getNumericValue(cp));
            }
            UScript.getScriptExtensions(cp, temp);
            temp.clear(0);
            temp.clear(1);
            if (temp.cardinality() == 0) {
                this.requiredScripts.set(UScript.getScript(cp));
                continue;
            }
            if (temp.cardinality() == 1) {
                this.requiredScripts.or(temp);
                continue;
            }
            if (this.requiredScripts.intersects(temp) || !this.scriptSetSet.add(temp)) continue;
            temp = new BitSet();
        }
        if (this.scriptSetSet.size() == 0) {
            this.commonAmongAlternates.clear();
        } else {
            this.commonAmongAlternates.set(0, 200);
            Iterator<BitSet> it = this.scriptSetSet.iterator();
            while (it.hasNext()) {
                BitSet next = it.next();
                if (this.requiredScripts.intersects(next)) {
                    it.remove();
                } else {
                    for (BitSet other : this.scriptSetSet) {
                        if (next == other || !IdentifierInfo.contains(next, other)) continue;
                        it.remove();
                        break;
                    }
                }
                this.commonAmongAlternates.and(next);
            }
            if (this.commonAmongAlternates.size() == 0) {
                this.commonAmongAlternates.clear();
            }
        }
        return this;
    }

    public static boolean isMultiScript(String identifier) {
        HashSet<BitSet> setOfScriptSets = new HashSet<BitSet>();
        BitSet temp = new BitSet();
        for (int i = 0; i < identifier.length(); i += Character.charCount(i)) {
            int cp = Character.codePointAt(identifier, i);
            UScript.getScriptExtensions(cp, temp);
            if (temp.cardinality() == 0) {
                int script = UScript.getScript(cp);
                temp.set(script);
            }
            temp.andNot(COMMON_AND_INHERITED);
            if (temp.cardinality() == 0 || !setOfScriptSets.add(temp)) continue;
            temp = new BitSet();
        }
        if (setOfScriptSets.size() == 0) {
            return true;
        }
        temp.clear();
        boolean first = true;
        for (BitSet other : setOfScriptSets) {
            if (first) {
                temp.or(other);
                first = false;
                continue;
            }
            temp.and(other);
        }
        return temp.cardinality() != 0;
    }

    public boolean hasMixedNumberSystems(String identifier) {
        UnicodeSet numerics = new UnicodeSet();
        block4: for (int i = 0; i < identifier.length(); i += Character.charCount(i)) {
            int cp = Character.codePointAt(identifier, i);
            switch (UCharacter.getType(cp)) {
                case 9: {
                    numerics.add(cp - UCharacter.getNumericValue(cp));
                    continue block4;
                }
                case 10: 
                case 11: {
                    throw new IllegalArgumentException("Should not be in identifiers.");
                }
            }
        }
        return numerics.size() > 1;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public BitSet getScripts() {
        return (BitSet)this.requiredScripts.clone();
    }

    public Set<BitSet> getAlternates() {
        HashSet<BitSet> result = new HashSet<BitSet>();
        for (BitSet item : this.scriptSetSet) {
            result.add((BitSet)item.clone());
        }
        return result;
    }

    public UnicodeSet getNumerics() {
        return new UnicodeSet(this.numerics);
    }

    public BitSet getCommonAmongAlternates() {
        return (BitSet)this.commonAmongAlternates.clone();
    }

    public IdentifierStatus getRestrictionLevel() {
        if (!this.identifierProfile.containsAll(this.identifier) || this.getNumerics().size() > 1) {
            return IdentifierStatus.UNRESTRICTIVE;
        }
        if (ASCII.containsAll(this.identifier)) {
            return IdentifierStatus.ASCII;
        }
        BitSet temp = new BitSet();
        temp.or(this.requiredScripts);
        temp.clear(0);
        temp.clear(1);
        int cardinalityPlus = temp.cardinality() + (this.commonAmongAlternates.isEmpty() ? this.scriptSetSet.size() : 1);
        if (cardinalityPlus < 2) {
            return IdentifierStatus.HIGHLY_RESTRICTIVE;
        }
        if (this.containsWithAlternates(JAPANESE, temp) || this.containsWithAlternates(CHINESE, temp) || this.containsWithAlternates(KOREAN, temp)) {
            return IdentifierStatus.HIGHLY_RESTRICTIVE;
        }
        if (cardinalityPlus == 2 && temp.get(25) && !temp.intersects(CONFUSABLE_WITH_LATIN)) {
            return IdentifierStatus.MODERATELY_RESTRICTIVE;
        }
        return IdentifierStatus.MINIMALLY_RESTRICTIVE;
    }

    public String toString() {
        return this.identifier + ", " + this.identifierProfile.toPattern(false) + ", " + this.getRestrictionLevel() + ", " + IdentifierInfo.displayScripts(this.requiredScripts) + ", " + IdentifierInfo.displayAlternates(this.scriptSetSet) + ", " + this.numerics.toPattern(false);
    }

    private boolean containsWithAlternates(BitSet container, BitSet containee) {
        if (!IdentifierInfo.contains(container, containee)) {
            return false;
        }
        for (BitSet alternatives : this.scriptSetSet) {
            if (container.intersects(alternatives)) continue;
            return false;
        }
        return true;
    }

    public static String displayAlternates(Collection<BitSet> alternates) {
        StringBuilder result = new StringBuilder();
        for (BitSet item : alternates) {
            if (result.length() != 0) {
                result.append("; ");
            }
            result.append(IdentifierInfo.displayScripts(item));
        }
        return result.toString();
    }

    public static String displayScripts(BitSet scripts) {
        StringBuilder result = new StringBuilder("[");
        int i = scripts.nextSetBit(0);
        while (i >= 0) {
            if (result.length() != 1) {
                result.append(' ');
            }
            result.append(UScript.getShortName(i));
            i = scripts.nextSetBit(i + 1);
        }
        return result.append("]").toString();
    }

    public static BitSet parseScripts(String scriptsString) {
        BitSet result = new BitSet();
        for (String item : scriptsString.trim().split(",?\\s+")) {
            if (item.isEmpty()) continue;
            result.set(UScript.getCodeFromName(item));
        }
        return result;
    }

    public static Set<BitSet> parseAlternates(String scriptsSetString) {
        HashSet<BitSet> result = new HashSet<BitSet>();
        for (String item : scriptsSetString.trim().split("\\s*;\\s*")) {
            if (item.isEmpty()) continue;
            result.add(IdentifierInfo.parseScripts(item));
        }
        return result;
    }

    public static final boolean contains(BitSet container, BitSet containee) {
        int i = containee.nextSetBit(0);
        while (i >= 0) {
            if (!container.get(i)) {
                return false;
            }
            i = containee.nextSetBit(i + 1);
        }
        return true;
    }

    public static final BitSet set(BitSet bitset, int ... values) {
        for (int value : values) {
            bitset.set(value);
        }
        return bitset;
    }

    public static enum IdentifierStatus {
        ASCII,
        HIGHLY_RESTRICTIVE,
        MODERATELY_RESTRICTIVE,
        MINIMALLY_RESTRICTIVE,
        UNRESTRICTIVE;

    }
}

