/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.StringTransform;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.CompoundTransform;
import org.unicode.cldr.draft.PatternFixer;
import org.unicode.cldr.draft.RegexTransform;
import org.unicode.cldr.draft.Rule;
import org.unicode.cldr.draft.UnicodeSetFilteredTransform;

public class RegexTransformBuilder {
    static final boolean DEBUG = false;
    private static final boolean SKIP_BAD = true;
    private static final PatternFixer PATTERN_FIXER = new PatternFixer(PatternFixer.Target.JAVA);
    static Pattern RULE_PATTERN = Pattern.compile("(?:([^{}>]*) \\{)?([^}<>]*)(?:\\} ([^<>]*))?<?> (.*)", 4);
    static Pattern VARIABLE = Pattern.compile("\\$[0-9]", 4);

    public static StringTransform createFromRules(String string) {
        StringTransform result;
        ArrayList<StringTransform> compound = new ArrayList<StringTransform>();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        String[] ruleSet = string.split(";");
        Matcher m3 = RULE_PATTERN.matcher("");
        ArrayList<String> results = new ArrayList<String>();
        Matcher variable = VARIABLE.matcher("");
        UnicodeSet filter = null;
        for (String ruleString : ruleSet) {
            if ((ruleString = ruleString.trim()).startsWith("::")) {
                String body;
                if (rules.size() != 0) {
                    compound.add(new RegexTransform(rules));
                    rules.clear();
                }
                if ((body = ruleString.substring(2).trim()).equalsIgnoreCase("NULL")) continue;
                if (UnicodeSet.resemblesPattern(body, 0)) {
                    filter = new UnicodeSet(body);
                    continue;
                }
                Transliterator translit = Transliterator.getInstance(body.trim());
                compound.add(translit);
                continue;
            }
            if (!m3.reset(ruleString).matches()) {
                System.out.println("BAD RULE");
                continue;
            }
            String pre = m3.group(1);
            pre = pre == null ? "" : RegexTransformBuilder.fix(pre);
            Object main = RegexTransformBuilder.fix(m3.group(2));
            if (m3.group(3) != null) {
                main = (String)main + "(?=" + RegexTransformBuilder.fix(m3.group(3)) + ")";
            }
            results.clear();
            String result2 = m3.group(4).trim();
            variable.reset(result2);
            int last = 0;
            while (true) {
                if (!variable.find()) break;
                results.add(result2.substring(last, variable.start()));
                results.add(variable.group());
                last = variable.end();
            }
            results.add(result2.substring(last));
            try {
                Rule rule = new Rule(pre, (String)main, results);
                rules.add(rule);
            }
            catch (Exception e) {
                System.out.println("BAD:\t" + e.getMessage());
            }
        }
        if (rules.size() != 0) {
            compound.add(new RegexTransform(rules));
            rules.clear();
        }
        StringTransform stringTransform = result = compound.size() == 1 ? (StringTransform)compound.get(0) : new CompoundTransform(compound);
        if (filter != null) {
            return new UnicodeSetFilteredTransform(filter, result);
        }
        return result;
    }

    private static String fix(String pattern) {
        pattern = pattern.trim();
        PATTERN_FIXER.fix(pattern);
        pattern = Normalizer.decompose(pattern, false);
        return pattern;
    }
}

