/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Transform;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.ICUException;
import com.ibm.icu.util.VersionInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.draft.EnumLookup;
import org.unicode.cldr.tool.CountryCodeConverter;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Containment;
import org.unicode.cldr.util.SemiFileReader;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.With;

public class ScriptMetadata {
    private static final int MAX_RANK = 33;
    private static final String DATA_FILE = "/org/unicode/cldr/util/data/Script_Metadata.csv";
    private static final VersionInfo UNICODE_VERSION = VersionInfo.getInstance(CldrUtility.getProperty("SCRIPT_UNICODE_VERSION", "15"));
    static StandardCodes SC = StandardCodes.make();
    static EnumLookup<Shaping> shapingLookup = EnumLookup.of(Shaping.class, null, "n/a", Shaping.UNKNOWN, new Object[0]);
    static EnumLookup<Trinary> trinaryLookup = EnumLookup.of(Trinary.class, null, "n/a", Trinary.UNKNOWN, new Object[0]);
    static EnumLookup<IdUsage> idUsageLookup = EnumLookup.of(IdUsage.class, null, "n/a", IdUsage.UNKNOWN, new Object[0]);
    public static Set<String> errors = new LinkedHashSet<String>();
    static HashMap<String, Integer> titleToColumn = new HashMap();
    static Relation<String, String> EXTRAS = Relation.of(new HashMap(), HashSet.class);
    static final Map<String, Info> data;
    public static Transform<String, String> TO_SHORT_SCRIPT;
    public static Transform<String, String> TO_LONG_SCRIPT;

    public static void addNameToCode(String type, Map<String, String> hashMap) {
        for (String language : SC.getAvailableCodes(type)) {
            Map<String, String> fullData = StandardCodes.getLStreg().get(type).get(language);
            String name = fullData.get("Description");
            hashMap.put(name.toUpperCase(Locale.ENGLISH), language);
        }
    }

    public static void addSynonym(Map<String, String> map, String newTerm, String oldTerm) {
        String code = map.get(oldTerm.toUpperCase(Locale.ENGLISH));
        map.put(newTerm.toUpperCase(Locale.ENGLISH), code);
    }

    public static Info getInfo(String s2) {
        Info result = data.get(s2);
        if (result == null) {
            try {
                String name2 = UScript.getShortName(UScript.getCodeFromName(s2));
                result = data.get(name2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static Set<String> getScripts() {
        return data.keySet();
    }

    public static Info getInfo(int i) {
        return data.get(UScript.getShortName(i));
    }

    public static Set<Map.Entry<String, Info>> iterable() {
        return data.entrySet();
    }

    public static Set<String> getExtras() {
        return EXTRAS.values();
    }

    static {
        EXTRAS.put("Hani", "Hans");
        EXTRAS.put("Hani", "Hant");
        EXTRAS.put("Hani", "Hanb");
        EXTRAS.put("Hang", "Kore");
        EXTRAS.put("Hang", "Jamo");
        EXTRAS.put("Hira", "Jpan");
        EXTRAS.freeze();
        data = ((MyFileReader)new MyFileReader().process((Class)ScriptMetadata.class, DATA_FILE)).getData();
        TO_SHORT_SCRIPT = new Transform<String, String>(){

            @Override
            public String transform(String source) {
                return UScript.getShortName(UScript.getCodeFromName(source));
            }
        };
        TO_LONG_SCRIPT = new Transform<String, String>(){

            @Override
            public String transform(String source) {
                return UScript.getName(UScript.getCodeFromName(source));
            }
        };
    }

    static class RegionFilter
    implements Transform<String, String> {
        final String[] containingRegion;

        RegionFilter(String ... containingRegion) {
            this.containingRegion = containingRegion;
        }

        @Override
        public String transform(String script) {
            String currentRegion = ScriptMetadata.getInfo((String)script).originCountry;
            while (true) {
                for (String s2 : this.containingRegion) {
                    if (!s2.equals(currentRegion)) continue;
                    return script;
                }
                if (currentRegion.equals("001") || currentRegion.equals("ZZ")) {
                    return null;
                }
                currentRegion = Containment.getContainer(currentRegion);
            }
        }
    }

    public static enum Groupings {
        EUROPEAN("150"),
        MIDDLE_EASTERN("145"),
        CENTRAL_ASIAN("143"),
        SOUTH_ASIAN("034"),
        SOUTHEAST_ASIAN("035"),
        EAST_ASIAN("030"),
        AFRICAN("002"),
        AMERICAN("019");

        public final Set<String> scripts;

        private Groupings(String ... regions) {
            this.scripts = With.in(new Iterable[]{ScriptMetadata.getScripts()}).toUnmodifiableCollection(new RegionFilter(regions), new TreeSet());
        }
    }

    private static class MyFileReader
    extends SemiFileReader {
        private Map<String, Info> data = new HashMap<String, Info>();

        private MyFileReader() {
        }

        @Override
        protected boolean isCodePoint() {
            return false;
        }

        @Override
        protected String[] splitLine(String line) {
            return CldrUtility.splitCommaSeparated(line);
        }

        @Override
        protected boolean handleLine(int lineCount, int start, int end, String[] items) {
            Info info;
            if (items[0].startsWith("For help") || items[0].isEmpty()) {
                return true;
            }
            if (items[0].equals("WR")) {
                Column.setColumns(items);
                return true;
            }
            try {
                info = new Info(items);
            }
            catch (SkipNewUnicodeException e) {
                return true;
            }
            catch (Exception e) {
                errors.add(e.getClass().getName() + "\t" + e.getMessage() + "\t" + Arrays.asList(items));
                return true;
            }
            String script = items[2];
            this.data.put(script, info);
            Set<String> extras = EXTRAS.get(script);
            if (extras != null) {
                for (String script2 : extras) {
                    Info info2 = info;
                    if (script2.equals("Jpan")) {
                        info2 = new Info(info, "IME:YES", null);
                    } else if (script2.equals("Jamo")) {
                        info2 = new Info(info, null, "\u1112");
                    }
                    this.data.put(script2, info2);
                }
            }
            return true;
        }

        @Override
        public MyFileReader process(Class<?> classLocation, String fileName) {
            super.process(classLocation, fileName);
            return this;
        }

        private Map<String, Info> getData() {
            if (!errors.isEmpty()) {
                throw new RuntimeException(Joiner.on("\n\t").join(errors));
            }
            return Collections.unmodifiableMap(this.data);
        }
    }

    public static class Info
    implements Comparable<Info> {
        public final int rank;
        public final VersionInfo age;
        public final String sampleChar;
        public final IdUsage idUsage;
        public final Trinary rtl;
        public final Trinary lbLetters;
        public final Trinary hasCase;
        public final Shaping shapingReq;
        public final Trinary ime;
        public final int density;
        public final String originCountry;
        public final String likelyLanguage;

        private Info(String[] items) {
            this.rank = Math.min(Column.WR.getInt(items, 999), 33);
            this.age = VersionInfo.getInstance(Column.AGE.getItem(items));
            if (this.age.compareTo(UNICODE_VERSION) > 0) {
                throw new SkipNewUnicodeException();
            }
            int sampleCode = Integer.parseInt(Column.SAMPLE_CODE.getItem(items), 16);
            this.sampleChar = UTF16.valueOf(sampleCode);
            this.idUsage = idUsageLookup.forString(Column.ID_USAGE.getItem(items));
            this.rtl = trinaryLookup.forString(Column.RTL.getItem(items));
            this.lbLetters = trinaryLookup.forString(Column.LB_LETTERS.getItem(items));
            this.shapingReq = shapingLookup.forString(Column.SHAPING_REQ.getItem(items));
            this.ime = trinaryLookup.forString(Column.IME.getItem(items));
            this.hasCase = trinaryLookup.forString(Column.HAS_CASE.getItem(items));
            this.density = Column.DENSITY.getInt(items, -1);
            String countryRaw = Column.ORIGIN_COUNTRY.getItem(items);
            String country = CountryCodeConverter.getCodeFromName(countryRaw, false);
            if (country == null) {
                errors.add("Can't map " + countryRaw + " to country/region");
            }
            this.originCountry = country == null ? "ZZ" : country;
            String langCode = Column.LANG_CODE.getItem(items);
            if (langCode.equals("n/a")) {
                langCode = null;
            }
            this.likelyLanguage = langCode == null ? "und" : langCode;
        }

        public Info(Info other, String string, String sampleCharacter) {
            this.rank = other.rank;
            this.age = other.age;
            this.sampleChar = sampleCharacter == null ? other.sampleChar : sampleCharacter;
            this.idUsage = other.idUsage;
            this.rtl = other.rtl;
            this.lbLetters = other.lbLetters;
            this.hasCase = other.hasCase;
            this.shapingReq = other.shapingReq;
            this.ime = "IME:YES".equals(string) ? Trinary.YES : other.ime;
            this.density = other.density;
            this.originCountry = other.originCountry;
            this.likelyLanguage = other.likelyLanguage;
        }

        String fix(String in) {
            return in.toUpperCase(Locale.ENGLISH).replace("N/A", "UNKNOWN").replace("?", "UNKNOWN").replace("RTL", "YES");
        }

        public String toString() {
            return this.rank + "\tSample: " + this.sampleChar + "\tCountry: " + this.getName("territory", this.originCountry) + " (" + this.originCountry + ")\tLanguage: " + this.getName("language", this.likelyLanguage) + " (" + this.likelyLanguage + ")\tId: " + this.idUsage + "\tRtl: " + this.rtl + "\tLb: " + this.lbLetters + "\tShape: " + this.shapingReq + "\tIme: " + this.ime + "\tCase: " + this.hasCase + "\tDensity: " + this.density;
        }

        public Object getName(String type, String code) {
            List<String> fullData = SC.getFullData(type, code);
            if (fullData == null) {
                return "unavailable";
            }
            return fullData.get(0);
        }

        @Override
        public int compareTo(Info o) {
            return this.toString().compareTo(o.toString());
        }
    }

    public static final class SkipNewUnicodeException
    extends ICUException {
    }

    public static enum Shaping {
        UNKNOWN,
        NO,
        MIN,
        YES;

    }

    public static enum Trinary {
        UNKNOWN,
        NO,
        YES;

    }

    public static enum IdUsage {
        UNKNOWN("Other"),
        EXCLUSION("Historic"),
        LIMITED_USE("Limited Use"),
        ASPIRATIONAL("Aspirational"),
        RECOMMENDED("Major Use");

        public final String name;

        private IdUsage(String name) {
            this.name = name;
        }
    }

    private static enum Column {
        WR(new String[0]),
        AGE(new String[0]),
        SAMPLE_CODE(new String[0]),
        ID_USAGE("ID Usage (UAX31)"),
        RTL("RTL?"),
        LB_LETTERS("LB letters?"),
        SHAPING_REQ("Shaping Req?"),
        IME("IME?"),
        ORIGIN_COUNTRY("Origin Country"),
        DENSITY("~Density"),
        LANG_CODE(new String[0]),
        HAS_CASE("Has Case?");

        int columnNumber = -1;
        final Set<String> names = new HashSet<String>();

        private Column(String ... alternateNames) {
            this.names.add(this.name());
            for (String name : alternateNames) {
                this.names.add(name.toUpperCase(Locale.ENGLISH));
            }
        }

        static void setColumns(String[] headers) {
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i].toUpperCase(Locale.ENGLISH);
                for (Column v : Column.values()) {
                    if (!v.names.contains(header)) continue;
                    v.columnNumber = i;
                }
            }
            for (Column v : Column.values()) {
                if (v.columnNumber != -1) continue;
                throw new IllegalArgumentException("Missing field for " + v + ", may need to add additional column alias");
            }
        }

        String getItem(String[] items) {
            return items[this.columnNumber];
        }

        int getInt(String[] items, int defaultValue) {
            String item = this.getItem(items);
            return item.isEmpty() || item.equalsIgnoreCase("n/a") ? defaultValue : Integer.parseInt(item);
        }
    }
}

