/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.unicode.cldr.draft.keyboard.IsoLayoutPosition;

public final class CharacterMap
implements Comparable<CharacterMap> {
    private final IsoLayoutPosition position;
    private final String output;
    private final ImmutableList<String> longPressKeys;
    private final boolean transformNo;

    private CharacterMap(IsoLayoutPosition position, String output, ImmutableList<String> longPressKeys, boolean transformNo) {
        this.position = Preconditions.checkNotNull(position);
        this.output = Preconditions.checkNotNull(output);
        this.longPressKeys = Preconditions.checkNotNull(longPressKeys);
        this.transformNo = transformNo;
    }

    public static CharacterMap of(IsoLayoutPosition position, String output) {
        return new CharacterMap(position, output, ImmutableList.of(), false);
    }

    public static CharacterMap of(IsoLayoutPosition position, String output, ImmutableList<String> longPressKeys) {
        return new CharacterMap(position, output, longPressKeys, false);
    }

    public IsoLayoutPosition position() {
        return this.position;
    }

    public String output() {
        return this.output;
    }

    public ImmutableList<String> longPressKeys() {
        return this.longPressKeys;
    }

    public CharacterMap markAsTransformNo() {
        return new CharacterMap(this.position, this.output, this.longPressKeys, true);
    }

    public boolean isTransformNo() {
        return this.transformNo;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("position", (Object)this.position).add("output", this.output).add("longPressKeys", this.longPressKeys).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CharacterMap) {
            CharacterMap other = (CharacterMap)o;
            return this.position.equals((Object)other.position) && this.output.equals(other.output) && this.longPressKeys.equals(other.longPressKeys);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.position, this.output, this.longPressKeys});
    }

    @Override
    public int compareTo(CharacterMap o) {
        return this.position.compareTo(o.position);
    }

    static Function<CharacterMap, IsoLayoutPosition> isoLayoutPositionFunction() {
        return CharacterMapToIsoLayoutFunction.INSTANCE;
    }

    private static enum CharacterMapToIsoLayoutFunction implements Function<CharacterMap, IsoLayoutPosition>
    {
        INSTANCE;


        @Override
        public IsoLayoutPosition apply(CharacterMap character) {
            return character.position;
        }
    }
}

