/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import org.unicode.cldr.draft.keyboard.KeyMap;
import org.unicode.cldr.draft.keyboard.KeyboardId;
import org.unicode.cldr.draft.keyboard.Transform;

public final class Keyboard {
    private final KeyboardId keyboardId;
    private final ImmutableList<String> names;
    private final ImmutableSortedSet<KeyMap> keyMaps;
    private final ImmutableSortedSet<Transform> transforms;
    private volatile KeyMap baseMap;

    private Keyboard(KeyboardId keyboardId, ImmutableList<String> names, ImmutableSortedSet<KeyMap> keyMaps, ImmutableSortedSet<Transform> transforms) {
        this.keyboardId = Preconditions.checkNotNull(keyboardId);
        this.names = Preconditions.checkNotNull(names);
        this.keyMaps = Preconditions.checkNotNull(keyMaps);
        this.transforms = Preconditions.checkNotNull(transforms);
    }

    public static Keyboard of(KeyboardId keyboardId, ImmutableList<String> names, ImmutableSortedSet<KeyMap> keyMaps, ImmutableSortedSet<Transform> transforms) {
        return new Keyboard(keyboardId, names, keyMaps, transforms);
    }

    public KeyboardId keyboardId() {
        return this.keyboardId;
    }

    public ImmutableList<String> names() {
        return this.names;
    }

    public ImmutableSet<KeyMap> keyMaps() {
        return this.keyMaps;
    }

    public KeyMap baseMap() {
        return this.baseMap == null ? (this.baseMap = this.getBaseMap()) : this.baseMap;
    }

    private KeyMap getBaseMap() {
        for (KeyMap keyMap : this.keyMaps) {
            if (!keyMap.modifierKeyCombinationSet().isBase()) continue;
            return keyMap;
        }
        throw new IllegalStateException("Missing base map for " + this.keyboardId);
    }

    public ImmutableSet<Transform> transforms() {
        return this.transforms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Keyboard) {
            Keyboard other = (Keyboard)o;
            return this.keyboardId.equals(other.keyboardId) && this.names.equals(other.names) && this.keyMaps.equals(other.keyMaps) && this.transforms.equals(other.transforms);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.keyboardId, this.names, this.keyMaps, this.transforms);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("keyboardIds", this.keyboardId).add("names", this.names).add("keyMaps", this.keyMaps).add("transforms", this.transforms).toString();
    }
}

