/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft.keyboard;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import java.io.IOException;
import java.util.List;
import org.unicode.cldr.draft.keyboard.IsoLayoutPosition;

public final class KeycodeMap {
    private final ImmutableSortedMap<Integer, IsoLayoutPosition> keycodeToIsoLayout;
    private static final Splitter LINE_SPLITTER = Splitter.on("\n").omitEmptyStrings();
    private static final Splitter COMMA_SPLITTER = Splitter.on(",");

    private KeycodeMap(ImmutableSortedMap<Integer, IsoLayoutPosition> keycodeToIsoLayout) {
        this.keycodeToIsoLayout = Preconditions.checkNotNull(keycodeToIsoLayout);
    }

    public static KeycodeMap fromCsv(String csv) {
        Preconditions.checkArgument(!csv.isEmpty());
        List<String> lines = LINE_SPLITTER.splitToList(csv);
        Preconditions.checkArgument(lines.get(0).equals("keycode,iso"), "Missing csv headers");
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (String line : Iterables.skip(lines, 1)) {
            List<String> components = COMMA_SPLITTER.splitToList(line);
            builder.put(Integer.valueOf(components.get(0)), (Object)IsoLayoutPosition.valueOf(components.get(1)));
        }
        return new KeycodeMap((ImmutableSortedMap<Integer, IsoLayoutPosition>)builder.build());
    }

    public static KeycodeMap fromResource(Class<?> clazz, String fileName) {
        try {
            String csv = Resources.toString(Resources.getResource(clazz, fileName), Charsets.UTF_8);
            return KeycodeMap.fromCsv(csv);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean hasIsoLayoutPosition(Integer keycode) {
        return this.keycodeToIsoLayout.containsKey(keycode);
    }

    public IsoLayoutPosition getIsoLayoutPosition(Integer keycode) {
        return Preconditions.checkNotNull(this.keycodeToIsoLayout.get(keycode), "No keycode for %s [%s]", (Object)keycode, this.keycodeToIsoLayout);
    }

    public ImmutableSortedMap<Integer, IsoLayoutPosition> keycodeToIsoLayout() {
        return this.keycodeToIsoLayout;
    }
}

