/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.List;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.test.FactoryCheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.InternalCldrException;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.SpecialLocales;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.ValuePathStatus;

public class CheckCoverage
extends FactoryCheckCLDR {
    static final boolean DEBUG = false;
    static final boolean DEBUG_SET = false;
    private static CoverageLevel2 coverageLevel;
    private Level requiredLevel;
    SupplementalDataInfo supplementalData;
    private boolean latin;

    public CheckCoverage(Factory factory) {
        super(factory);
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        Level level;
        if (this.isSkipTest()) {
            return this;
        }
        CLDRFile resolvedCldrFileToCheck = this.getResolvedCldrFileToCheck();
        if (!resolvedCldrFileToCheck.isWinningPath(path)) {
            return this;
        }
        CLDRFile.Status status = new CLDRFile.Status();
        String source = resolvedCldrFileToCheck.getSourceLocaleIdExtended(path, status, false);
        if (!source.equals("code-fallback") && !source.equals("root") && (path.indexOf("metazone") < 0 || value != null && value.length() > 0)) {
            return this;
        }
        if (path == null) {
            throw new InternalCldrException("Empty path!");
        }
        if (this.getCldrFileToCheck() == null) {
            throw new InternalCldrException("No file to check!");
        }
        boolean isAliased = path.equals(status.pathWhereFound);
        if (ValuePathStatus.isMissingOk(resolvedCldrFileToCheck, path, this.latin, isAliased)) {
            return this;
        }
        Level level2 = level = coverageLevel != null ? coverageLevel.getLevel(path) : Level.UNDETERMINED;
        if (level == Level.UNDETERMINED) {
            return this;
        }
        if (this.requiredLevel.compareTo(level) >= 0) {
            CheckCLDR.CheckStatus.Type coverageErrorType = CheckCLDR.CheckStatus.warningType;
            if (this.getPhase().equals((Object)CheckCLDR.Phase.VETTING)) {
                coverageErrorType = CheckCLDR.CheckStatus.errorType;
            }
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(coverageErrorType).setSubtype(CheckCLDR.CheckStatus.Subtype.coverageLevel).setCheckOnSubmit(false).setMessage("Needed to meet {0} coverage level.", new Object[]{level}));
        }
        return this;
    }

    @Override
    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        this.setSkipTest(true);
        String localeID = cldrFileToCheck.getLocaleID();
        if (localeID.equals(new LanguageTagParser().set(localeID).getLanguageScript())) {
            this.supplementalData = SupplementalDataInfo.getInstance(cldrFileToCheck.getSupplementalDirectory());
            coverageLevel = CoverageLevel2.getInstance(this.supplementalData, localeID);
            SupplementalDataInfo.PluralInfo pluralInfo = this.supplementalData.getPlurals(SupplementalDataInfo.PluralType.cardinal, localeID);
            if (pluralInfo == this.supplementalData.getPlurals(SupplementalDataInfo.PluralType.cardinal, "root") && !SpecialLocales.isScratchLocale(localeID)) {
                possibleErrors.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.missingPluralInfo).setMessage("Missing Plural Information - see supplemental plural charts to file bug.", new Object[0]));
            }
        }
        if (options != null && options.get(CheckCLDR.Options.Option.CheckCoverage_skip) != null) {
            return this;
        }
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        if (localeID.equals("root")) {
            return this;
        }
        this.requiredLevel = options.getRequiredLevel(localeID);
        this.setSkipTest(false);
        this.latin = ValuePathStatus.isLatinScriptLocale(cldrFileToCheck);
        return this;
    }

    public void setRequiredLevel(Level level) {
        this.requiredLevel = level;
    }

    public Level getRequiredLevel() {
        return this.requiredLevel;
    }
}

