/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import com.ibm.icu.util.Output;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CheckLogicalGroupings;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LogicalGrouping;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class LogicalGroupChecker {
    private static final int LIMIT_DISTANCE = 5;
    private final CheckLogicalGroupings checkLogicalGroupings;
    private final String path;
    private final String value;
    private final Output<LogicalGrouping.PathType> pathType;
    private final CLDRFile cldrFile;
    private final List<CheckCLDR.CheckStatus> result;
    private final Set<String> paths;
    private final boolean phaseCausesError;
    private final CoverageLevel2 coverageLevel;
    private boolean havePath = false;
    private String firstPath = null;
    private Set<String> missingPaths = null;
    private CLDRFile.DraftStatus myStatus;

    public LogicalGroupChecker(CheckLogicalGroupings checkLogicalGroupings, String path, String value, List<CheckCLDR.CheckStatus> result) {
        this.checkLogicalGroupings = checkLogicalGroupings;
        this.path = path;
        this.value = value;
        this.result = result;
        this.pathType = new Output();
        this.cldrFile = checkLogicalGroupings.getCldrFileToCheck();
        this.paths = LogicalGrouping.getPaths(this.cldrFile, path, this.pathType);
        this.coverageLevel = CoverageLevel2.getInstance(SupplementalDataInfo.getInstance(), this.cldrFile.getLocaleID());
        this.phaseCausesError = CheckLogicalGroupings.PHASES_CAUSE_ERROR.contains((Object)checkLogicalGroupings.getPhase());
    }

    public void run() {
        if (this.isTrivial()) {
            return;
        }
        this.checkEditDistances();
        this.removeOptionalPaths();
        if (this.isTrivial()) {
            return;
        }
        if (this.findMissingPaths()) {
            return;
        }
        if (this.avoidWork()) {
            return;
        }
        this.loop();
    }

    private boolean isTrivial() {
        return this.paths == null || this.paths.size() < 2;
    }

    private void checkEditDistances() {
        switch ((LogicalGrouping.PathType)((Object)this.pathType.value)) {
            case COUNT_CASE: 
            case COUNT: 
            case COUNT_CASE_GENDER: {
                TreeSet<String> sorted = new TreeSet<String>(this.paths);
                if (!this.path.equals(sorted.iterator().next())) break;
                this.reallyCheckEditDistances(sorted);
                break;
            }
        }
    }

    private void reallyCheckEditDistances(TreeSet<String> sorted) {
        TreeMultiset<String> values = TreeMultiset.create();
        int maxDistance = this.getMaxDistance(sorted, values);
        if (maxDistance >= 5) {
            maxDistance = this.getMaxDistance(this.paths, values);
            this.result.add(new CheckCLDR.CheckStatus().setCause(this.checkLogicalGroupings).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.largerDifferences).setMessage("{0} different characters within {1}; {2}", maxDistance, CheckLogicalGroupings.showInvisibles(values), this.value));
        }
    }

    private int getMaxDistance(Set<String> paths, Multiset<String> values) {
        values.clear();
        HashSet<CheckLogicalGroupings.Fingerprint> fingerprints = new HashSet<CheckLogicalGroupings.Fingerprint>();
        for (String path1 : paths) {
            String pathValue = CheckLogicalGroupings.cleanSpaces(this.path.contentEquals(path1) ? this.value : this.cldrFile.getWinningValue(path1));
            values.add(pathValue);
            fingerprints.add(CheckLogicalGroupings.Fingerprint.make(pathValue));
        }
        return CheckLogicalGroupings.Fingerprint.maxDistanceBetween(fingerprints);
    }

    private void removeOptionalPaths() {
        LogicalGrouping.removeOptionalPaths(this.paths, this.cldrFile);
    }

    private boolean findMissingPaths() {
        this.missingPaths = this.getMissingPaths();
        if (this.havePath && !this.missingPaths.isEmpty() && this.path.equals(this.firstPath)) {
            this.handleMissingPaths();
            return true;
        }
        return false;
    }

    private void handleMissingPaths() {
        Set missingCodes = this.missingPaths.stream().map(x -> this.checkLogicalGroupings.getPathReferenceForMessage((String)x, true)).collect(Collectors.toSet());
        Level cLevel = this.coverageLevel.getLevel(this.path);
        CheckCLDR.CheckStatus.Type showError = this.phaseCausesError ? CheckCLDR.CheckStatus.errorType : CheckCLDR.CheckStatus.warningType;
        this.result.add(new CheckCLDR.CheckStatus().setCause(this.checkLogicalGroupings).setMainType(showError).setSubtype(CheckCLDR.CheckStatus.Subtype.incompleteLogicalGroup).setMessage("Incomplete logical group - missing values for: {0}; level={1}", new Object[]{missingCodes.toString(), cLevel}));
    }

    private Set<String> getMissingPaths() {
        HashSet<String> missingPaths = new HashSet<String>();
        for (String apath : this.paths) {
            if (this.isHereOrNonRoot(apath)) {
                this.havePath = true;
                continue;
            }
            if (missingPaths.isEmpty()) {
                this.firstPath = apath;
            }
            missingPaths.add(apath);
        }
        return missingPaths;
    }

    private boolean isHereOrNonRoot(String path) {
        if (this.cldrFile.isHere(path)) {
            return true;
        }
        if (!this.cldrFile.getLocaleID().contains("_")) {
            return false;
        }
        CLDRFile resolvedCldrFile = this.checkLogicalGroupings.getResolvedCldrFileToCheck();
        if (resolvedCldrFile.getStringValue(path) == null) {
            return false;
        }
        String source = resolvedCldrFile.getSourceLocaleID(path, null);
        return !source.equals("root") && !source.equals("code-fallback");
    }

    private boolean avoidWork() {
        String fPath = this.cldrFile.getFullXPath(this.path);
        XPathParts parts = XPathParts.getFrozenInstance(fPath);
        this.myStatus = CLDRFile.DraftStatus.forString(parts.findFirstAttributeValue("draft"));
        return this.myStatus.compareTo(CheckLogicalGroupings.MIMIMUM_DRAFT_STATUS) >= 0;
    }

    private void loop() {
        for (String apath : this.paths) {
            XPathParts parts;
            CLDRFile.DraftStatus draftStatus;
            String fPath;
            if (apath.equals(this.path) || this.missingPaths.contains(apath) || (fPath = this.cldrFile.getFullXPath(apath)) == null || (draftStatus = CLDRFile.DraftStatus.forString((parts = XPathParts.getFrozenInstance(fPath)).findFirstAttributeValue("draft"))).compareTo(this.myStatus) <= 0) continue;
            this.addOneHigherStatus(apath, this.myStatus, draftStatus);
            break;
        }
    }

    private void addOneHigherStatus(String apath, CLDRFile.DraftStatus myStatus, CLDRFile.DraftStatus draftStatus) {
        CheckCLDR.CheckStatus.Type showError = this.phaseCausesError ? CheckCLDR.CheckStatus.errorType : CheckCLDR.CheckStatus.warningType;
        this.result.add(new CheckCLDR.CheckStatus().setCause(this.checkLogicalGroupings).setMainType(showError).setSubtype(CheckCLDR.CheckStatus.Subtype.inconsistentDraftStatus).setMessage("This item has draft status={0}, which is lower than the status={1} (for {2}).", myStatus.name(), draftStatus.name(), this.checkLogicalGroupings.getPathReferenceForMessage(apath, true)));
    }
}

