/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.ListFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.CountryCodeConverter;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter2;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.StandardCodes;

public class AddPopulationData {
    static boolean ADD_POP = CldrUtility.getProperty("ADD_POP", false);
    static boolean SHOW_ALTERNATE_NAMES = CldrUtility.getProperty("SHOW_ALTERNATE_NAMES", false);
    private static final String GCP = "NY.GNP.MKTP.PP.CD";
    private static final String POP = "SP.POP.TOTL";
    private static final String EMPTY = "..";
    private static Counter2<String> worldbank_gdp = new Counter2();
    private static Counter2<String> worldbank_population = new Counter2();
    private static Counter2<String> un_literacy = new Counter2();
    private static Counter2<String> factbook_gdp = new Counter2();
    private static Counter2<String> factbook_population = new Counter2();
    private static Counter2<String> factbook_literacy = new Counter2();
    private static CountryData other = new CountryData();
    static final Set<String> missing = new TreeSet<String>();
    static final NumberFormat dollars = NumberFormat.getCurrencyInstance(ULocale.US);
    static final NumberFormat number = NumberFormat.getNumberInstance(ULocale.US);
    static final NumberFormat percent = NumberFormat.getPercentInstance(ULocale.US);
    static final UnicodeSet DIGITS = new UnicodeSet("[:Nd:]").freeze();

    public static void main(String[] args) throws IOException {
        System.out.println("Code\tName\tPop\tGDP-PPP\tUN Literacy");
        for (String country : StandardCodes.make().getGoodCountries()) {
            AddPopulationData.showCountryData(country);
        }
        TreeSet<String> outliers = new TreeSet<String>();
        outliers.addAll(factbook_population.keySet());
        outliers.addAll(worldbank_population.keySet());
        outliers.addAll(factbook_gdp.keySet());
        outliers.addAll(worldbank_gdp.keySet());
        outliers.addAll(un_literacy.keySet());
        Iterator it = outliers.iterator();
        while (it.hasNext()) {
            if (!StandardCodes.isCountry((String)it.next())) continue;
            it.remove();
        }
        if (outliers.size() != 0) {
            System.out.println("Mistakes: data for non-UN codes");
            for (String country : outliers) {
                AddPopulationData.showCountryData(country);
            }
            throw new IllegalArgumentException("Mistakes: data for non-country codes");
        }
        TreeSet<CallSite> altNames = new TreeSet<CallSite>();
        String oldCode = "";
        for (String string : CountryCodeConverter.names()) {
            String code;
            String icu;
            if (string.equalsIgnoreCase(icu = ULocale.getDisplayCountry("und-" + (code = CountryCodeConverter.getCodeFromName(string, true, missing)), "en"))) continue;
            altNames.add((CallSite)((Object)(code + "\t" + string + "\t" + icu)));
        }
        oldCode = "";
        if (SHOW_ALTERNATE_NAMES) {
            for (String string : altNames) {
                String[] pieces = string.split("\t");
                String code = pieces[0];
                if (code.equals("ZZ")) continue;
                if (!code.equals(oldCode)) {
                    oldCode = code;
                    System.out.println();
                }
                System.out.println(code + "; " + pieces[2] + "; " + pieces[1]);
            }
        }
        if (!missing.isEmpty()) {
            throw new RuntimeException("Could not load codes for: " + ListFormat.getInstance(Locale.getDefault()).format(new Object[]{missing}));
        }
    }

    private static void showCountryData(String country) {
        number.setMaximumFractionDigits(0);
        System.out.println(country + "\t" + ULocale.getDisplayCountry("und-" + country, "en") + "\t" + number.format(AddPopulationData.getPopulation(country)) + "\t" + number.format(AddPopulationData.getGdp(country)) + "\t" + percent.format(AddPopulationData.getLiteracy(country) / 100.0));
    }

    public static Double getLiteracy(String country) {
        return AddPopulationData.firstNonZero(factbook_literacy.getCount(country), un_literacy.getCount(country), CountryData.literacy.getCount(country));
    }

    public static Double getGdp(String country) {
        return AddPopulationData.firstNonZero(factbook_gdp.getCount(country), worldbank_gdp.getCount(country), CountryData.gdp.getCount(country));
    }

    public static Double getPopulation(String country) {
        return AddPopulationData.firstNonZero(factbook_population.getCount(country), worldbank_population.getCount(country), CountryData.population.getCount(country));
    }

    private static Double firstNonZero(Double ... items) {
        for (Double item : items) {
            if (item == 0.0) continue;
            return item;
        }
        return 0.0;
    }

    static String[] splitCommaSeparated(String line) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder item = new StringBuilder();
        boolean inQuote = false;
        block4: for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            switch (ch) {
                case '\"': {
                    boolean bl = inQuote = !inQuote;
                    if (!inQuote || item.length() == 0) continue block4;
                    item.append('\"');
                    inQuote = true;
                    continue block4;
                }
                case ',': {
                    if (!inQuote) {
                        result.add(item.toString());
                        item.setLength(0);
                        continue block4;
                    }
                    item.append(ch);
                    continue block4;
                }
                default: {
                    item.append(ch);
                }
            }
        }
        result.add(item.toString());
        return result.toArray(new String[result.size()]);
    }

    private static void loadFactbookInfo(String filename, final Counter2<String> factbookGdp) throws IOException {
        CldrUtility.handleFile(filename, new CldrUtility.LineHandler(){

            @Override
            public boolean handle(String line) {
                if (line.length() == 0 || line.startsWith("This tab") || line.startsWith("Rank") || line.startsWith(" This file")) {
                    return false;
                }
                String[] pieces = line.split("\\s{2,}");
                String code = CountryCodeConverter.getCodeFromName(FBLine.Country.get(pieces), true, missing);
                if (code == null) {
                    return false;
                }
                if (!StandardCodes.isCountry(code)) {
                    if (ADD_POP) {
                        System.out.println("Skipping factbook info for: " + code);
                    }
                    return false;
                }
                code = code.toUpperCase(Locale.ENGLISH);
                String valueString = FBLine.Value.get(pieces).trim();
                if (valueString.startsWith("$")) {
                    valueString = valueString.substring(1);
                }
                valueString = valueString.replace(",", "");
                double value = Double.parseDouble(valueString.trim());
                factbookGdp.add(code, value);
                if (ADD_POP) {
                    System.out.println("Factbook gdp:\t" + code + "\t" + value);
                }
                return true;
            }
        });
    }

    private static void loadFactbookLiteracy() throws IOException {
        String filename = "external/factbook_literacy.txt";
        CldrUtility.handleFile("external/factbook_literacy.txt", new CldrUtility.LineHandler(){

            @Override
            public boolean handle(String line) {
                String[] pieces = line.split("\\t");
                String code = CountryCodeConverter.getCodeFromName(FBLiteracy.Country.get(pieces), true, missing);
                if (code == null) {
                    return false;
                }
                if (!StandardCodes.isCountry(code)) {
                    if (ADD_POP) {
                        System.out.println("Skipping factbook literacy for: " + code);
                    }
                    return false;
                }
                code = code.toUpperCase(Locale.ENGLISH);
                String valueString = FBLiteracy.Percent.get(pieces).trim();
                double percent = Double.parseDouble(valueString);
                factbook_literacy.put(code, percent);
                if (ADD_POP) {
                    System.out.println("Factbook literacy:\t" + code + "\t" + percent);
                }
                code = null;
                return true;
            }
        });
    }

    private static void loadWorldBankInfo() throws IOException {
        String filename = "external/world_bank_data.csv";
        CldrUtility.handleFile("external/world_bank_data.csv", new CldrUtility.LineHandler(){
            ArrayList<Pair<WBLine, Integer>> columnToTypeAndValue = null;

            @Override
            public boolean handle(String line) {
                double value;
                String[] pieces = AddPopulationData.splitCommaSeparated(line);
                if (this.columnToTypeAndValue == null) {
                    this.columnToTypeAndValue = WBLine.parseHeader(pieces);
                    return false;
                }
                HashMap<Pair<WBLine, Integer>, String> lineAsHash = new HashMap<Pair<WBLine, Integer>, String>();
                for (int i = 0; i < pieces.length; ++i) {
                    lineAsHash.put(this.columnToTypeAndValue.get(i), pieces[i]);
                }
                String seriesCode = (String)lineAsHash.get(Pair.of(WBLine.Series_Code, 0));
                String last = null;
                for (int n = 0; n < this.columnToTypeAndValue.size(); ++n) {
                    String current;
                    Pair<WBLine, Integer> i = this.columnToTypeAndValue.get(n);
                    if (i.getFirst() != WBLine.Year || (current = pieces[n]).length() == 0 || current.equals(AddPopulationData.EMPTY)) continue;
                    last = current;
                }
                if (last == null) {
                    return false;
                }
                String countryName = (String)lineAsHash.get(Pair.of(WBLine.Country_Name, 0));
                String country = CountryCodeConverter.getCodeFromName(countryName, true, missing);
                if (country == null) {
                    return false;
                }
                if (!StandardCodes.isCountry(country)) {
                    if (ADD_POP) {
                        System.out.println("Skipping worldbank info for: " + country);
                    }
                    return false;
                }
                try {
                    value = Double.parseDouble(last);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("File changed format: need to modify code");
                }
                if (seriesCode.equals(AddPopulationData.GCP)) {
                    worldbank_gdp.add(country, value);
                } else if (seriesCode.equals(AddPopulationData.POP)) {
                    worldbank_population.add(country, value);
                } else {
                    throw new IllegalArgumentException();
                }
                return true;
            }
        });
    }

    private static void loadUnLiteracy() throws IOException {
        CldrUtility.handleFile("external/un_literacy.csv", new CldrUtility.LineHandler(){

            @Override
            public boolean handle(String line) {
                String[] pieces = AddPopulationData.splitCommaSeparated(line);
                if (pieces.length != 14 || pieces[1].length() == 0 || !DIGITS.containsAll(pieces[1])) {
                    return false;
                }
                String code = CountryCodeConverter.getCodeFromName(pieces[0], true, missing);
                if (code == null) {
                    return false;
                }
                if (!StandardCodes.isCountry(code)) {
                    if (ADD_POP) {
                        System.out.println("Skipping UN info for: " + code);
                    }
                    return false;
                }
                String totalLiteracy = pieces[3];
                if (totalLiteracy.equals("\ufffd") || totalLiteracy.equals("\u2026") || totalLiteracy.isEmpty()) {
                    return true;
                }
                double percent = Double.parseDouble(totalLiteracy);
                un_literacy.add(code, percent);
                return true;
            }
        });
    }

    static {
        try {
            AddPopulationData.loadFactbookLiteracy();
            AddPopulationData.loadUnLiteracy();
            AddPopulationData.loadFactbookInfo("external/factbook_gdp_ppp.txt", factbook_gdp);
            AddPopulationData.loadFactbookInfo("external/factbook_population.txt", factbook_population);
            CldrUtility.handleFile("external/other_country_data.txt", new MyLineHandler(other));
            AddPopulationData.loadWorldBankInfo();
            StandardCodes sc = StandardCodes.make();
            StringBuilder myErrors = new StringBuilder();
            for (String territory : sc.getGoodAvailableCodes("territory")) {
                if (!StandardCodes.isCountry(territory)) continue;
                double gdp = AddPopulationData.getGdp(territory);
                double literacy = AddPopulationData.getLiteracy(territory);
                double population = AddPopulationData.getPopulation(territory);
                if (gdp == 0.0) {
                    myErrors.append("\n" + territory + ";" + sc.getData("territory", territory) + ";gdp-ppp;0;reason");
                }
                if (literacy == 0.0) {
                    myErrors.append("\n" + territory + ";" + sc.getData("territory", territory) + ";literacy;0;reason");
                }
                if (population != 0.0) continue;
                myErrors.append("\n" + territory + ";" + sc.getData("territory", territory) + ";population;0;reason");
            }
            if (myErrors.length() != 0) {
                throw new IllegalArgumentException("Missing Country values, the following and add to external/other_country_data to fix, chaning the 0 to the real value:" + myErrors);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class MyLineHandler
    implements CldrUtility.LineHandler {
        CountryData countryData;

        public MyLineHandler(CountryData countryData) {
            this.countryData = countryData;
        }

        @Override
        public boolean handle(String line) throws ParseException {
            if (line.startsWith("#")) {
                return true;
            }
            if (line.length() == 0) {
                return true;
            }
            String[] pieces = line.split(";");
            String code = pieces[0].trim();
            if (code.equals("Code")) {
                return false;
            }
            String typeString = pieces[2].trim();
            String data = pieces[3].trim();
            if (typeString.equals("gdp-ppp")) {
                if (StandardCodes.isCountry(data)) {
                    Double otherPop = AddPopulationData.getPopulation(data);
                    Double otherGdp = AddPopulationData.getGdp(data);
                    Double myPop = AddPopulationData.getPopulation(code);
                    if (myPop == 0.0 || otherPop == 0.0 || otherGdp == 0.0) {
                        otherPop = AddPopulationData.getPopulation(data);
                        otherGdp = AddPopulationData.getPopulation(data);
                        myPop = AddPopulationData.getPopulation(code);
                        throw new IllegalArgumentException("Zero population");
                    }
                    CountryData.gdp.add(code, otherGdp * myPop / otherPop);
                } else {
                    CountryData.gdp.add(code, dollars.parse(data).doubleValue());
                }
            } else if (typeString.equals("population")) {
                if (StandardCodes.isCountry(data)) {
                    throw new IllegalArgumentException("Population can't use other country's");
                }
                CountryData.population.add(code, number.parse(data).doubleValue());
            } else if (typeString.equals("literacy")) {
                if (StandardCodes.isCountry(data)) {
                    Double otherPop = AddPopulationData.getLiteracy(data);
                    CountryData.literacy.add(code, otherPop);
                } else {
                    CountryData.literacy.add(code, number.parse(data).doubleValue());
                }
            } else {
                throw new IllegalArgumentException("Illegal type");
            }
            return true;
        }
    }

    static class CountryData {
        private static Counter2<String> population = new Counter2();
        private static Counter2<String> gdp = new Counter2();
        private static Counter2<String> literacy = new Counter2();

        CountryData() {
        }
    }

    static enum FBLiteracy {
        Rank,
        Country,
        Percent;


        String get(String[] pieces) {
            return pieces[this.ordinal()];
        }
    }

    static enum FBLine {
        Rank,
        Country,
        Value,
        Year;


        String get(String[] pieces) {
            return pieces[this.ordinal()];
        }
    }

    static enum WBLine {
        Country_Name,
        Country_Code,
        Series_Name,
        Series_Code,
        Year("(\\d+)\\s*\\[YR(\\d+)\\]");

        final Pattern pattern;

        private WBLine() {
            this.pattern = Pattern.compile(this.name().replaceAll("_", " "));
        }

        private WBLine(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        Matcher match(String str) {
            if (str.startsWith("\ufeff")) {
                str = str.substring("\ufeff".length());
            }
            return this.pattern.matcher(str);
        }

        static Pair<WBLine, Integer> find(String str) {
            for (WBLine i : WBLine.values()) {
                Matcher m3 = i.match(str);
                if (!m3.matches()) continue;
                Integer val = 0;
                if (m3.groupCount() > 0) {
                    val = Integer.parseInt(m3.group(1));
                }
                return Pair.of(i, val);
            }
            return null;
        }

        static ArrayList<Pair<WBLine, Integer>> parseHeader(String[] pieces) {
            ArrayList<Pair<WBLine, Integer>> columnToTypeAndValue = null;
            columnToTypeAndValue = new ArrayList<Pair<WBLine, Integer>>();
            for (int i = 0; i < pieces.length; ++i) {
                columnToTypeAndValue.add(i, WBLine.find(pieces[i]));
            }
            return columnToTypeAndValue;
        }
    }
}

