/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.DisplayAndInputProcessor;
import org.unicode.cldr.tool.IdToPath;
import org.unicode.cldr.tool.LanguageCodeConverter;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.InputStreamFactory;
import org.unicode.cldr.util.PathDescription;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.PatternPlaceholders;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XMLFileReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ConvertXTB {
    private static final Pattern ID_PATTERN = PatternCache.get("\\[@id=\"(\\d++)\"]");
    private static final Pattern PLURAL_MESSAGE_FORMAT = PatternCache.get("\\{[A-Z_]++,plural, (.*)}");
    private static PatternPlaceholders patternPlaceholders;
    private static Map<String, Map<String, String>> loadedReverseTagMaps;
    private static PathDescription pathDescription;
    private Factory factory;
    private File xtbDir;
    private File inputDir;
    private String outputDir;
    private CheckCLDR checkCldr;
    private CLDRFile englishFile;
    private PrintStream out;
    private static final Option.Options options;

    private ConvertXTB(String inputDir, String outputDir, String checkFilter) {
        this.xtbDir = new File(inputDir, "xtb");
        this.inputDir = new File(inputDir);
        this.outputDir = outputDir;
        this.factory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        this.englishFile = this.factory.make("en", true);
        this.checkCldr = CheckCLDR.getCheckAll(this.factory, checkFilter);
        CheckCLDR.setDisplayInformation(this.englishFile);
        this.out = System.out;
    }

    private void setErrorOutput(PrintStream out) {
        this.out = out;
    }

    private String getPlaceholderForName(String xpath, String name) {
        Map<String, String> map;
        if (loadedReverseTagMaps == null) {
            loadedReverseTagMaps = new HashMap<String, Map<String, String>>();
        }
        if ((map = loadedReverseTagMaps.get(xpath)) == null) {
            map = new HashMap<String, String>();
            loadedReverseTagMaps.put(xpath, map);
            Map<String, PatternPlaceholders.PlaceholderInfo> tagMap = this.getTagMap(xpath);
            for (Map.Entry<String, PatternPlaceholders.PlaceholderInfo> entry : tagMap.entrySet()) {
                map.put(entry.getValue().name, entry.getKey());
            }
        }
        return map.get(name);
    }

    private Map<String, PatternPlaceholders.PlaceholderInfo> getTagMap(String xpath) {
        if (patternPlaceholders == null) {
            patternPlaceholders = PatternPlaceholders.getInstance();
        }
        return patternPlaceholders.get(xpath);
    }

    private XtbInfo load(String locale) {
        Set<String> oldMessages = null;
        try {
            oldMessages = this.loadOldMessages(locale);
        }
        catch (IllegalArgumentException e) {
            System.err.println("No wsb found for " + locale + ", skipping");
            return null;
        }
        XtbInfo info = new XtbInfo(LanguageCodeConverter.fromGoogleLocaleId(locale));
        XtbHandler handler = new XtbHandler(oldMessages, info);
        XMLReader xmlReader = XMLFileReader.createXMLReader(false);
        xmlReader.setContentHandler(handler);
        File inputFile = new File(this.xtbDir, locale + ".xtb");
        try (InputStream fis = InputStreamFactory.createInputStream(inputFile);){
            InputSource is = new InputSource(fis);
            xmlReader.parse(is);
        }
        catch (IOException | SAXException e) {
            System.err.println("Error loading " + inputFile.getAbsolutePath());
            e.printStackTrace();
        }
        return info;
    }

    private Set<String> loadOldMessages(String locale) throws IllegalArgumentException {
        locale = LanguageCodeConverter.toGoogleLocaleId(locale);
        WsbHandler handler = new WsbHandler();
        XMLFileReader xfr = new XMLFileReader().setHandler(handler);
        File wsbFile = new File(this.inputDir, locale + "/" + locale + ".wsb");
        xfr.read(wsbFile.getAbsolutePath(), -1, true);
        return handler.getOldMessages();
    }

    private void processAll(String regexFilter) {
        this.out.println("Locale\tMessage ID\tDescription\tEnglish Value\tTranslated Value\tType\tError Message");
        for (String filename : this.xtbDir.list()) {
            String locale;
            XtbInfo xtbInfo;
            if (!filename.matches(regexFilter + "\\.xtb") || (xtbInfo = this.load(locale = filename.substring(0, filename.length() - 4))) == null) continue;
            this.check(xtbInfo);
            this.writeXml(xtbInfo);
        }
    }

    private void check(XtbInfo xtbInfo) {
        String locale = xtbInfo.locale;
        CLDRFile cldrFile = this.factory.make(locale, false).cloneAsThawed();
        for (XtbEntry info : xtbInfo) {
            cldrFile.add(info.xpath, info.value);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        ArrayList<CheckCLDR.CheckStatus> possibleErrors = new ArrayList<CheckCLDR.CheckStatus>();
        this.checkCldr.setCldrFileToCheck(cldrFile, options, possibleErrors);
        for (CheckCLDR.CheckStatus status : possibleErrors) {
            System.out.println(locale + "\tLOCALE ERROR\t" + status.getMessage());
        }
        int numErrors = 0;
        for (XtbEntry info : xtbInfo) {
            String xpath = CLDRFile.getDistinguishingXPath(info.xpath, null);
            String fullPath = cldrFile.getFullXPath(xpath);
            String value = info.value;
            this.checkCldr.check(xpath, fullPath, value, options, possibleErrors);
            numErrors += this.displayErrors(locale, info.messageId, xpath, value, possibleErrors);
        }
        if (numErrors == 0) {
            System.out.println("No errors found for " + locale);
        }
        this.out.flush();
    }

    private int displayErrors(String locale, String id, String xpath, String value, List<CheckCLDR.CheckStatus> possibleErrors) {
        String description = this.getDescription(xpath, value);
        if (id.equals("8190100716823312848") || id.equals("8190100716823312848")) {
            return 0;
        }
        int numErrors = 0;
        for (CheckCLDR.CheckStatus status : possibleErrors) {
            this.out.println(locale + "\t" + id + "\t" + description + "\t" + this.englishFile.getStringValue(xpath) + "\t" + value + "\t" + status.getType() + "\t" + status.getMessage().replace('\t', ' '));
            if (!status.getType().equals("Error")) continue;
            ++numErrors;
        }
        return numErrors;
    }

    private void writeXml(XtbInfo xtbInfo) {
        String locale = xtbInfo.locale;
        File xmlFile = new File(this.outputDir, locale + ".xml");
        SimpleXMLSource altSource = new SimpleXMLSource(locale);
        for (XtbEntry info : xtbInfo) {
            altSource.putValueAtPath(info.xpath, info.value);
        }
        try {
            PrintWriter out = new PrintWriter(xmlFile);
            new CLDRFile(altSource).write(out);
            out.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't write " + xmlFile.getAbsolutePath() + " to disk.");
        }
    }

    private String getDescription(String path, String value) {
        if (pathDescription == null) {
            SupplementalDataInfo supplementalDataInfo = SupplementalDataInfo.getInstance();
            pathDescription = new PathDescription(supplementalDataInfo, this.englishFile, null, null, PathDescription.ErrorHandling.CONTINUE);
        }
        String description = pathDescription.getDescription(path, value, null, null);
        return description;
    }

    public static void main(String[] args) throws IOException {
        options.parse(args, true);
        String inputDir = null;
        Option option = options.get("source_dir");
        if (!option.doesOccur()) {
            throw new RuntimeException("Input dir must be specified");
        }
        inputDir = option.getValue();
        String outputDir = null;
        option = options.get("destination_dir");
        if (!option.doesOccur()) {
            throw new RuntimeException("Output dir must be specified");
        }
        outputDir = option.getValue();
        String localeFilter = options.get("locale_filter").getValue();
        String testFilter = options.get("test_filter").getValue();
        String errorFile = options.get("error_file").getValue();
        ConvertXTB converter = new ConvertXTB(inputDir, outputDir, testFilter);
        PrintStream out = new PrintStream(new File(errorFile));
        converter.setErrorOutput(out);
        converter.processAll(localeFilter);
        out.close();
    }

    static {
        options = new Option.Options().add("source_dir", ".*", "The source directory containing the xtb and wsb files to be read").add("destination_dir", ".*", "The destination directory to write the XML files to").add("locale_filter", (Object)".*", ".*", "A regex filter for (Google) locales to be processed").add("test_filter", (Object)".*", ".*", "A regex filter for CheckCLDR tests").add("error_file", (Object)".*", "./errors.tsv", "The file that checking results should be written to");
    }

    private class WsbHandler
    extends XMLFileReader.SimpleHandler {
        private Set<String> messageIds = new HashSet<String>();

        @Override
        public void handlePathValue(String path, String value) {
            Matcher matcher = ID_PATTERN.matcher(path);
            if (matcher.find()) {
                this.messageIds.add(matcher.group(1));
            }
        }

        public Set<String> getOldMessages() {
            return this.messageIds;
        }
    }

    private class XtbHandler
    implements ContentHandler {
        private DisplayAndInputProcessor daip;
        private StringBuffer currentText;
        private String lastId;
        private String lastXpath;
        private Set<String> orphanedMessages;
        private Set<String> oldMessages;
        private XtbInfo output;

        public XtbHandler(Set<String> oldMessages, XtbInfo output) {
            this.daip = new DisplayAndInputProcessor(CLDRLocale.getInstance(output.locale));
            this.currentText = new StringBuffer();
            this.orphanedMessages = new HashSet<String>();
            this.oldMessages = oldMessages;
            this.output = output;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.currentText.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
            if (qName.equals("translation")) {
                this.lastId = attr.getValue("id");
                this.lastXpath = IdToPath.getPath(this.lastId);
                this.currentText.setLength(0);
            } else if (qName.equals("ph")) {
                String name = attr.getValue("name");
                String placeholder = ConvertXTB.this.getPlaceholderForName(this.lastXpath, name);
                this.currentText.append(placeholder);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("translation")) {
                if (this.lastXpath == null) {
                    this.orphanedMessages.add(this.lastId);
                } else if (!this.oldMessages.contains(this.lastId)) {
                    this.addValue(this.lastXpath, this.currentText.toString());
                }
                this.currentText.setLength(0);
            }
        }

        private void addValue(String xpath, String value) {
            Matcher matcher = PLURAL_MESSAGE_FORMAT.matcher(value);
            if (matcher.matches()) {
                this.addPluralValue(xpath, matcher.group(1));
            } else {
                this.addValueToOutput(xpath, value);
            }
        }

        private void addPluralValue(String xpath, String value) {
            int numOpen = 0;
            StringBuffer buffer = new StringBuffer();
            String countType = null;
            int nameStart = -1;
            block5: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '{': {
                        if (numOpen == 0) {
                            int startIndex = buffer.charAt(0) == '=' ? 1 : 0;
                            countType = buffer.substring(startIndex);
                            buffer.setLength(0);
                        } else {
                            nameStart = i + 1;
                        }
                        ++numOpen;
                        continue block5;
                    }
                    case '}': {
                        if (--numOpen == 0) {
                            if (this.lastXpath.contains("decimalFormatLength")) {
                                if (countType.length() == 1) {
                                    countType = countType.charAt(0) == '1' ? "one" : "zero";
                                } else if (countType.equals("one")) {
                                    buffer.setLength(0);
                                    countType = null;
                                    continue block5;
                                }
                            }
                            String pluralXPath = xpath + "[@count=\"" + countType + "\"]";
                            String pluralValue = buffer.toString();
                            if (pluralValue.contains("{1}") && !pluralValue.contains("{0}")) {
                                pluralValue = countType.matches("[01]") ? pluralValue.replaceAll(countType + "(?!})", "{0}") : pluralValue.replace("{1}", "{0}");
                            }
                            this.addValueToOutput(pluralXPath, pluralValue);
                            buffer.setLength(0);
                            countType = null;
                            continue block5;
                        }
                        String name = value.substring(nameStart, i);
                        buffer.append(ConvertXTB.this.getPlaceholderForName(xpath, name));
                        continue block5;
                    }
                    case '#': {
                        buffer.append(this.lastXpath.contains("decimalFormatLength") ? Character.valueOf('#') : "{0}");
                        continue block5;
                    }
                    default: {
                        if (numOpen >= 2) continue block5;
                        buffer.append(c);
                    }
                }
            }
        }

        private void addValueToOutput(String xpath, String value) {
            value = this.daip.processInput(xpath, value, null);
            this.output.add(new XtbEntry(this.lastId, xpath, value));
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.orphanedMessages.size() > 0) {
                System.err.println(this.orphanedMessages.size() + " message IDs with no matching xpaths: ");
                for (String messageID : this.orphanedMessages) {
                    System.err.println(messageID);
                }
            }
        }

        @Override
        public void setDocumentLocator(Locator arg0) {
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
        }
    }

    private class XtbEntry {
        public String messageId;
        public String xpath;
        public String value;

        public XtbEntry(String messageId, String xpath, String value) {
            this.messageId = messageId;
            this.xpath = xpath;
            this.value = value;
        }
    }

    private class XtbInfo
    implements Iterable<XtbEntry> {
        public String locale;
        public List<XtbEntry> entries;

        public XtbInfo(String locale) {
            this.locale = locale;
            this.entries = new ArrayList<XtbEntry>();
        }

        @Override
        public Iterator<XtbEntry> iterator() {
            return this.entries.iterator();
        }

        public void add(XtbEntry entry) {
            this.entries.add(entry);
        }
    }
}

