/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;

public class GenerateAttributeList {
    Map<String, Map<String, Set<String>[]>> element_attribute_valueSet = new TreeMap<String, Map<String, Set<String>[]>>();
    Set<String> allElements = new TreeSet<String>();
    Map<String, String> defaults = new HashMap<String, String>();

    public GenerateAttributeList(Factory cldrFactory) throws IOException {
        this.addFromStandardCodes();
        this.addFromDTD(CLDRPaths.COMMON_DIRECTORY + "main/en.xml");
        this.addFromDTD(CLDRPaths.COMMON_DIRECTORY + "supplemental/characters.xml");
        this.addFromDirectory(CLDRPaths.COMMON_DIRECTORY + "collation/");
        this.addFromDirectory(CLDRPaths.COMMON_DIRECTORY + "main/");
        this.addFromDirectory(CLDRPaths.COMMON_DIRECTORY + "rbnf/");
        this.addFromDirectory(CLDRPaths.COMMON_DIRECTORY + "segments/");
        this.addFromDirectory(CLDRPaths.COMMON_DIRECTORY + "supplemental/");
        this.addFromDirectory(CLDRPaths.COMMON_DIRECTORY + "transforms/");
    }

    private void addFromStandardCodes() {
        StandardCodes sc = StandardCodes.make();
        this.addFromStandardCodes(sc, "language");
        this.addFromStandardCodes(sc, "territory");
        this.addFromStandardCodes(sc, "script");
        this.addFromStandardCodes(sc, "variant");
        this.addFromStandardCodes(sc, "currency");
        this.addFromStandardCodes(sc, "tzid");
    }

    private void addFromStandardCodes(StandardCodes sc, String cat) {
        Set<String> c = sc.getGoodAvailableCodes(cat);
        String target = cat.equals("tzid") ? "zone" : cat;
        for (String item : c) {
            this.add(target, "type", item, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFromDTD(String filename) throws IOException {
        try (FileInputStream fis = new FileInputStream(filename);){
            XMLReader xmlReader = CLDRFile.createXMLReader(true);
            MyDeclHandler me = new MyDeclHandler();
            xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", me);
            InputSource is = new InputSource(fis);
            is.setSystemId(filename);
            xmlReader.parse(is);
        }
    }

    private void addFromDirectory(String directory) throws IOException {
        File dir = new File(directory);
        directory = PathUtilities.getNormalizedPathString(dir);
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            String file;
            if (files[i].startsWith(".#") || !files[i].endsWith(".xml") || new File(file = directory + File.separatorChar + files[i]).isDirectory()) continue;
            this.addFromFiles(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFromFiles(String file) throws IOException {
        System.out.println(file);
        try (FileInputStream fis = new FileInputStream(file);){
            XMLReader xmlReader = CLDRFile.createXMLReader(true);
            xmlReader.setContentHandler(new MyContentHandler());
            InputSource is = new InputSource(fis);
            is.setSystemId(file);
            xmlReader.parse(is);
        }
    }

    void add(String element, String attribute, String attributeValue, boolean dtd) {
        Set<String>[] valueSets;
        if (element.equals("generation") && attribute.equals("date")) {
            attributeValue = "[date]";
        } else if (element.equals("version") && attribute.equals("number")) {
            attributeValue = "[revision]";
        } else if (attribute.equals("draft") || attribute.equals("validSubLocales") || attribute.equals("standard") || attribute.equals("references")) {
            element = "[common]";
        } else if (attribute.equals("alt")) {
            int pos = attributeValue.indexOf("proposed");
            if (pos == 0) {
                return;
            }
            if (pos > 0) {
                attributeValue = attributeValue.substring(0, pos - 1);
            }
            element = "[common]";
        }
        Map<String, Set<String>[]> attribute_valueSet = this.element_attribute_valueSet.get(element);
        if (attribute_valueSet == null) {
            attribute_valueSet = new TreeMap<String, Set<String>[]>();
            this.element_attribute_valueSet.put(element, attribute_valueSet);
        }
        if ((valueSets = attribute_valueSet.get(attribute)) == null) {
            Comparator<String> c = DtdData.getAttributeValueComparator(element, attribute);
            valueSets = new Set[]{new TreeSet<String>(c), new TreeSet<String>()};
            attribute_valueSet.put(attribute, valueSets);
        }
        try {
            valueSets[dtd ? 1 : 0].add(attributeValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error with " + element + ", " + attribute + ", " + attributeValue + ", " + dtd, e);
        }
    }

    void show(PrintWriter pw) {
        pw.println("<html><head>");
        pw.println("<style>td,th { border-style: solid; border-width: 1; vertical-align: top }</style>");
        pw.println("</head><body>");
        pw.println("<p>Date: $Date$</p>");
        pw.println("<p>Version: " + ToolConstants.CHART_DISPLAY_VERSION + "</p>");
        pw.println("<table>");
        pw.println("<tr><th>Element</th><th>Attribute</th><th>Actual Attribute Values</th><th>Other DTD Attribute Values</th></tr>");
        for (String element : this.element_attribute_valueSet.keySet()) {
            Map<String, Set<String>[]> attribute_valueSet = this.element_attribute_valueSet.get(element);
            int size = attribute_valueSet.size();
            if (size == 0) continue;
            boolean first = true;
            for (String attribute : attribute_valueSet.keySet()) {
                Set<String>[] valueSets = attribute_valueSet.get(attribute);
                pw.print("<tr>");
                if (first) {
                    first = false;
                    pw.print("<td" + (String)(size == 1 ? "" : " rowSpan='" + attribute_valueSet.size() + "'") + ">" + element + "</td>");
                }
                pw.print("<td>" + attribute + "</td><td>");
                String defaultKey = element + "|" + attribute;
                pw.print(this.toString(valueSets[0], defaultKey));
                pw.println("</td><td>");
                TreeSet<String> toRemove = new TreeSet<String>(valueSets[0]);
                TreeSet<String> remainder = new TreeSet<String>(valueSets[1]);
                remainder.removeAll(toRemove);
                pw.print(this.toString(remainder, defaultKey));
                pw.println("</td></tr>");
            }
        }
        pw.println("</table>");
        pw.println("<script>\nvar gaJsHost = ((\"https:\" == document.location.protocol) ? \"https://ssl.\" : \"http://www.\");\ndocument.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));\n</script>\n<script>\ntry {\nvar pageTracker = _gat._getTracker(\"UA-7672775-1\");\npageTracker._trackPageview();\n} catch(err) {}</script>");
        pw.println("</body></html>");
    }

    private String toString(Collection<String> source, String defaultKey) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (String value : source) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            boolean isDefault = value.equals(this.defaults.get(defaultKey));
            if (isDefault) {
                result.append("<b>");
            }
            result.append(TransliteratorUtilities.toHTML.transform(value));
            if (!isDefault) continue;
            result.append("</b>");
        }
        return result.toString();
    }

    public Map<String, Map<String, Set<String>[]>> getElement_attribute_valueSet() {
        return this.element_attribute_valueSet;
    }

    class MyContentHandler
    implements ContentHandler {
        MyContentHandler() {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
            if (attributes == null) {
                return;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attribute = attributes.getQName(i);
                String value = attributes.getValue(i);
                GenerateAttributeList.this.add(qName, attribute, value, false);
            }
        }
    }

    class MyDeclHandler
    implements DeclHandler {
        Matcher idmatcher = PatternCache.get("[a-zA-Z][-_a-zA-Z0-9]*").matcher("");

        MyDeclHandler() {
        }

        @Override
        public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
            if (value != null) {
                GenerateAttributeList.this.add(eName, aName, value, true);
                GenerateAttributeList.this.defaults.put(eName + "|" + aName, value);
            }
            this.idmatcher.reset(type);
            while (this.idmatcher.find()) {
                GenerateAttributeList.this.add(eName, aName, this.idmatcher.group(), true);
            }
        }

        @Override
        public void elementDecl(String name, String model) throws SAXException {
        }

        @Override
        public void internalEntityDecl(String name, String value) throws SAXException {
        }

        @Override
        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        }
    }
}

