/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.DayPeriodInfo;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.With;
import org.unicode.cldr.util.XPathParts;

public class GenerateDayPeriods {
    static final SupplementalDataInfo SDI = SupplementalDataInfo.getInstance();
    private static final int MILLIS_PER_DAY = 86400000;

    public static void main(String[] args) throws IOException {
        try (PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY + "/supplemental", "dayPeriods.xml");){
            out.println(DtdType.supplementalData.header(MethodHandles.lookup().lookupClass()) + "\t<version number=\"$Revision$\"/>");
            Factory factory = CLDRConfig.getInstance().getCldrFactory();
            for (DayPeriodInfo.Type type : DayPeriodInfo.Type.values()) {
                out.println("\t<dayPeriodRuleSet" + (String)(type == DayPeriodInfo.Type.format ? "" : " type=\"" + type + "\"") + ">");
                for (String locale : SDI.getDayPeriodLocales(type)) {
                    DayPeriodInfo dayPeriodInfo = SDI.getDayPeriods(type, locale);
                    out.println("\t\t<dayPeriodRules locales=\"" + locale + "\">");
                    Map<DayPeriodInfo.DayPeriod, String> localizations = GenerateDayPeriods.getLocalizations(factory.make(locale, true));
                    for (DayPeriodInfo.DayPeriod dayPeriod : DayPeriodInfo.DayPeriod.values()) {
                        Set<DayPeriodInfo.Span> spanSet;
                        if ((dayPeriod == DayPeriodInfo.DayPeriod.am || dayPeriod == DayPeriodInfo.DayPeriod.pm) && !locale.equals("root") || (spanSet = dayPeriodInfo.getDayPeriodSpans(dayPeriod)) == null) continue;
                        DayPeriodInfo.Span span = GenerateDayPeriods.combineSpans(spanSet);
                        String localization = localizations.get((Object)dayPeriod);
                        out.println("\t\t\t<dayPeriodRule type=\"" + span.dayPeriod + (span.start == span.end ? "\" at=\"" + GenerateDayPeriods.format(span.start, false) + "\"" : "\" from=\"" + GenerateDayPeriods.format(span.start, false) + "\" before=\"" + GenerateDayPeriods.format(span.end, true) + "\"") + "/>" + (String)(localization == null ? "" : "\t<!-- " + localization + " -->"));
                    }
                    out.println("\t\t</dayPeriodRules>");
                }
                out.println("\t</dayPeriodRuleSet>");
            }
            out.println("</supplementalData>");
        }
    }

    private static String format(int start, boolean to) {
        return DayPeriodInfo.formatTime(to && start == 0 ? start + 86400000 : start);
    }

    static Map<DayPeriodInfo.DayPeriod, String> getLocalizations(CLDRFile localeFile) {
        TreeMap<DayPeriodInfo.DayPeriod, String> result = new TreeMap<DayPeriodInfo.DayPeriod, String>();
        String dayPeriodLocalization = "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dayPeriods/dayPeriodContext[@type=\"stand-alone\"]/dayPeriodWidth[@type=\"wide\"]";
        for (String path2 : With.in(localeFile.iterator())) {
            if (!path2.startsWith("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dayPeriods/dayPeriodContext[@type=\"stand-alone\"]/dayPeriodWidth[@type=\"wide\"]") || path2.endsWith("/alias")) continue;
            XPathParts parts = XPathParts.getFrozenInstance(path2);
            String type = parts.getAttributeValue(-1, "type");
            result.put(DayPeriodInfo.DayPeriod.valueOf(type), localeFile.getStringValue(path2));
        }
        return result;
    }

    private static DayPeriodInfo.Span combineSpans(Set<DayPeriodInfo.Span> info) {
        if (info.size() == 1) {
            return info.iterator().next();
        }
        int start = -1;
        int end = -1;
        DayPeriodInfo.DayPeriod dayPeriod = null;
        for (DayPeriodInfo.Span span : info) {
            if (start < 0) {
                start = span.start;
                end = span.end;
                dayPeriod = span.dayPeriod;
                continue;
            }
            if (GenerateDayPeriods.same(end, span.start)) {
                end = span.end;
                continue;
            }
            if (GenerateDayPeriods.same(start, span.end)) {
                start = span.start;
                continue;
            }
            throw new IllegalArgumentException("Failed to combine: " + info);
        }
        return new DayPeriodInfo.Span(start, end, dayPeriod);
    }

    private static boolean same(int a, int b) {
        return a % 86400000 == b % 86400000;
    }
}

