/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.personname.PersonNameFormatter;
import org.unicode.cldr.util.personname.SimpleNameObject;

public class GeneratePersonNameTest {
    private static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    private static final Factory FACTORY = CONFIG.getCldrFactory();

    public static void main(String[] args) {
        HashSet<String> seenAlready = new HashSet<String>();
        for (String locale : ImmutableList.of("ja", "zh", "zh_Hant", "yue", "th", "lo")) {
            CLDRFile cldrFile = FACTORY.make(locale, true);
            PersonNameFormatter pnf = new PersonNameFormatter(cldrFile);
            Map<PersonNameFormatter.SampleType, SimpleNameObject> sampleNames = PersonNameFormatter.loadSampleNames(cldrFile);
            if (sampleNames == null) {
                System.out.println("formatter; " + locale + "; NO SAMPLE NAMES\n");
                continue;
            }
            SimpleNameObject sampleName1 = sampleNames.get((Object)PersonNameFormatter.SampleType.given12Surname);
            if (sampleName1 == null) {
                System.out.println("formatter; " + locale + "; NO SAMPLE NAMES\n");
                continue;
            }
            Map<ULocale, PersonNameFormatter.Order> localeToOrder = pnf.getNamePatternData().getLocaleToOrder();
            TreeMultimap<PersonNameFormatter.Order, String> orderToLocales = TreeMultimap.create();
            for (Map.Entry<ULocale, PersonNameFormatter.Order> entry : localeToOrder.entrySet()) {
                orderToLocales.put(entry.getValue(), entry.getKey().toLanguageTag());
            }
            System.out.println(locale + ";\tgivenFirst; " + PersonNameFormatter.JOIN_SPACE.join(orderToLocales.get(PersonNameFormatter.Order.givenFirst)));
            System.out.println(locale + ";\tsurnameFirst; " + PersonNameFormatter.JOIN_SPACE.join(orderToLocales.get(PersonNameFormatter.Order.surnameFirst)));
            PersonNameFormatter.FallbackFormatter f = pnf.getFallbackInfo();
            String fsr = f.getForeignSpaceReplacement();
            for (PersonNameFormatter.SampleType sampleType : Arrays.asList(PersonNameFormatter.SampleType.given12Surname, PersonNameFormatter.SampleType.givenSurnameOnly)) {
                SimpleNameObject sampleName = sampleNames.get((Object)sampleType);
                System.out.println("\n" + locale + ";\tname; " + locale + "; " + SimpleNameObject.show(sampleName.getPatternData(), SimpleNameObject.ShowStyle.semicolon));
                seenAlready.clear();
                for (boolean hasSpace : Arrays.asList(true, false)) {
                    for (PersonNameFormatter.Order order : PersonNameFormatter.Order.ALL) {
                        for (PersonNameFormatter.Length length : PersonNameFormatter.Length.ALL) {
                            for (PersonNameFormatter.Usage usage : PersonNameFormatter.Usage.ALL) {
                                for (PersonNameFormatter.Formality formality : PersonNameFormatter.Formality.ALL) {
                                    PersonNameFormatter.FormatParameters parameters = new PersonNameFormatter.FormatParameters(order, length, usage, formality);
                                    String result = pnf.format(sampleName, parameters);
                                    if (seenAlready.contains(result = result.replace(" ", fsr)) || result.contains(" ") != hasSpace) continue;
                                    System.out.println(locale + ";\tformat; " + parameters.dashed() + ";\t" + result + "\t; " + (hasSpace ? "space" : ""));
                                    seenAlready.add(result);
                                }
                            }
                        }
                    }
                }
            }
            System.out.println();
        }
    }
}

