/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.tool.ShowPlurals;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRInfo;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CoreCoverageInfo;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Counter2;
import org.unicode.cldr.util.CoverageInfo;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LanguageTagCanonicalizer;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PathStarrer;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.VettingViewer;
import org.unicode.cldr.util.VoteResolver;

public class ShowLocaleCoverage {
    private static final double BASIC_THRESHOLD = 1.0;
    private static final double MODERATE_THRESHOLD = 0.995;
    private static final double MODERN_THRESHOLD = 0.995;
    private static final double THRESHOLD_HIGHER = 0.9;
    private static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    private static final String TSV_MISSING_SUMMARY_HEADER = "#Path Level\t#Locales\tLocales\tSection\tPage\tHeader\tCode";
    private static final String TSV_MISSING_HEADER = "#LCode\tEnglish Name\tScript\tLocale Level\tPath Level\tSTStatus\tBailey\tSection\tPage\tHeader\tCode\tST Link";
    private static final String PROPERTIES_HEADER = "#\tcoverageLevels.txt\t\n#\tCopyright \u00a9 2022 Unicode, Inc.\n#\tCLDR data files are interpreted according to the LDML specification (http://unicode.org/reports/tr35/)\n#\tFor terms of use, see http://www.unicode.org/copyright.html\n#\t\n#\tProvides the Coverage Level of locales at Basic or Above.\n#\tFor more info,see the Locale Coverage Chart for this version.\n#\tGenerated by ShowLocaleCoverage.\n#\t\n#Locale ;\tLevel";
    private static final String TSV_MISSING_BASIC_HEADER = "#Locale\tProv.\tUnconf.\tMissing\tPath*";
    private static final String TSV_MISSING_COUNTS_HEADER = "#Locale\tTargetLevel\t\u2116 Found\t\u2116 Unconfirmed\t\u2116 Missing";
    private static final boolean DEBUG = true;
    private static final char DEBUG_FILTER = '\u0000';
    private static final String LATEST = ToolConstants.CHART_VERSION;
    public static CLDRConfig testInfo = ToolConfig.getToolInstance();
    private static final StandardCodes SC = StandardCodes.make();
    private static final SupplementalDataInfo SUPPLEMENTAL_DATA_INFO = testInfo.getSupplementalDataInfo();
    private static final StandardCodes STANDARD_CODES = SC;
    static Factory factory = testInfo.getCommonAndSeedAndMainAndAnnotationsFactory();
    private static final CLDRFile ENGLISH = factory.make("en", true);
    static final RegexLookup<Boolean> HACK = RegexLookup.of(RegexLookup.LookupType.STANDARD, RegexLookup.RegexFinderTransformPath).add("//ldml/localeDisplayNames/keys/key[@type=\"(d0|em|fw|i0|k0|lw|m0|rg|s0|ss|t0|x0)\"]", Boolean.valueOf(true)).add("//ldml/localeDisplayNames/types/type[@key=\"(em|fw|kr|lw|ss)\"].*", (Boolean)true).add("//ldml/localeDisplayNames/languages/language[@type=\".*_.*\"]", (Boolean)true).add("//ldml/localeDisplayNames/languages/language[@type=\".*\"][@alt=\".*\"]", (Boolean)true).add("//ldml/localeDisplayNames/territories/territory[@type=\".*\"][@alt=\".*\"]", (Boolean)true).add("//ldml/localeDisplayNames/territories/territory[@type=\"EZ\"]", (Boolean)true);
    static final Option.Options myOptions = new Option.Options();
    static final RegexLookup<Boolean> SUPPRESS_PATHS_CAN_BE_EMPTY = new RegexLookup<Boolean>().add("\\[@alt=\"accounting\"]", Boolean.valueOf(true)).add("\\[@alt=\"variant\"]", (Boolean)true).add("^//ldml/localeDisplayNames/territories/territory.*@alt=\"short", (Boolean)true).add("^//ldml/localeDisplayNames/languages/language.*_", (Boolean)true).add("^//ldml/numbers/currencies/currency.*/symbol", (Boolean)true).add("^//ldml/characters/exemplarCharacters", (Boolean)true);
    static CLDRFile.DraftStatus minimumDraftStatus = CLDRFile.DraftStatus.unconfirmed;
    static final PathHeader.Factory pathHeaderFactory = PathHeader.getFactory(ENGLISH);
    static boolean RAW_DATA = true;
    private static Set<String> COMMON_LOCALES;
    static final List<ReleaseInfo> versionToYear;
    static final CoverageInfo coverageInfo;
    static final VoteResolver.VoterInfo dummyVoterInfo;
    static final CLDRInfo.UserInfo dummyUserInfo;
    static final CLDRInfo.PathValueInfo dummyPathValueInfo;
    static final Set<ULocale> ICU_Locales;

    public static void main(String[] args) throws IOException {
        myOptions.parse(MyOptions.filter, args, true);
        Matcher matcher = PatternCache.get(MyOptions.filter.option.getValue()).matcher("");
        if (MyOptions.chart.option.doesOccur()) {
            ShowLocaleCoverage.showCoverage(null, matcher);
            return;
        }
        if (MyOptions.growth.option.doesOccur()) {
            try (PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-growth.tsv");){
                ShowLocaleCoverage.doGrowth(matcher, out);
                return;
            }
        }
        Set<String> locales = null;
        String organization = MyOptions.organization.option.getValue();
        boolean useOrgLevel = MyOptions.organization.option.doesOccur();
        if (useOrgLevel) {
            locales = STANDARD_CODES.getLocaleCoverageLocales(organization);
        }
        if (MyOptions.version.option.doesOccur()) {
            Object number = MyOptions.version.option.getValue().trim();
            if (!((String)number).contains(".")) {
                number = (String)number + ".0";
            }
            factory = Factory.make(CLDRPaths.ARCHIVE_DIRECTORY + "cldr-" + (String)number + "/common/main/", ".*");
        } else if (MyOptions.directories.option.doesOccur()) {
            String directories = MyOptions.directories.option.getValue().trim();
            CLDRConfig cldrConfig = CONFIG;
            String base = null;
            int colonPos = directories.indexOf(58);
            if (colonPos >= 0) {
                base = directories.substring(0, colonPos).trim();
                directories = directories.substring(colonPos + 1).trim();
            } else {
                base = cldrConfig.getCldrBaseDirectory().toString();
            }
            String[] items = directories.split(",\\s*");
            File[] fullDirectories = new File[items.length];
            int i = 0;
            for (String item : items) {
                fullDirectories[i++] = new File(base + "/" + item + "/main");
            }
            factory = SimpleFactory.make(fullDirectories, ".*");
            COMMON_LOCALES = SimpleFactory.make(base + "/common/main", ".*").getAvailableLanguages();
        }
        ShowLocaleCoverage.fixCommonLocales();
        RAW_DATA = MyOptions.rawData.option.doesOccur();
        ShowLocaleCoverage.showCoverage(null, matcher, locales, useOrgLevel);
    }

    public static void fixCommonLocales() {
        if (COMMON_LOCALES == null) {
            COMMON_LOCALES = factory.getAvailableLanguages();
        }
    }

    private static void doGrowth(Matcher matcher, PrintWriter out) {
        TreeMap<String, List<Double>> growthData = new TreeMap<String, List<Double>>(Ordering.natural().reverse());
        Map<String, FoundAndTotal> latestData = null;
        for (ReleaseInfo versionNormalizedVersionAndYear : versionToYear) {
            VersionInfo version = versionNormalizedVersionAndYear.version;
            int year = versionNormalizedVersionAndYear.year;
            String dir = ToolConstants.getBaseDirectory(version.getVersionString(2, 3));
            Map<String, FoundAndTotal> currentData = ShowLocaleCoverage.addGrowth(factory, dir, matcher, false);
            long found = 0L;
            long total = 0L;
            for (Map.Entry<String, FoundAndTotal> entry : currentData.entrySet()) {
                found += (long)entry.getValue().found;
                total += (long)entry.getValue().total;
            }
            System.out.println("year\t" + year + "\tversion\t" + version + "\tlocales\t" + currentData.size() + "\tfound\t" + found + "\ttotal\t" + total + "\tdetails\t" + currentData);
            out.flush();
            if (latestData == null) {
                latestData = currentData;
            }
            Counter2<String> completionData = ShowLocaleCoverage.getCompletion(latestData, currentData);
            ShowLocaleCoverage.addCompletionList("" + year, completionData, growthData);
            System.out.println(currentData);
        }
        boolean first = true;
        for (Map.Entry entry : growthData.entrySet()) {
            if (first) {
                for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                    out.print("\t" + i);
                }
                out.println();
                first = false;
            }
            out.println((String)entry.getKey() + "\t" + Joiner.on("\t").join((Iterable)entry.getValue()));
        }
    }

    public static void addCompletionList(String version, Counter2<String> completionData, TreeMap<String, List<Double>> growthData) {
        ArrayList<Double> x = new ArrayList<Double>();
        for (String key : completionData.getKeysetSortedByCount(false)) {
            x.add(completionData.getCount(key));
        }
        growthData.put(version, x);
        System.out.println(version + "\t" + x.size());
    }

    public static Counter2<String> getCompletion(Map<String, FoundAndTotal> latestData, Map<String, FoundAndTotal> currentData) {
        Counter2<String> completionData = new Counter2<String>();
        for (Map.Entry<String, FoundAndTotal> entry : latestData.entrySet()) {
            double total;
            String locale = entry.getKey();
            FoundAndTotal currentRecord = currentData.get(locale);
            if (currentRecord == null || (total = (double)entry.getValue().total) == 0.0) continue;
            double completion = (double)currentRecord.found / total;
            completionData.add(locale, completion);
        }
        return completionData;
    }

    private static Map<String, FoundAndTotal> addGrowth(Factory latestFactory, String dir, Matcher matcher, boolean showMissing) {
        File[] fileArray;
        File mainDir = new File(dir + "/common/main/");
        File annotationDir = new File(dir + "/common/annotations/");
        if (annotationDir.exists()) {
            File[] fileArray2 = new File[2];
            fileArray2[0] = mainDir;
            fileArray = fileArray2;
            fileArray2[1] = annotationDir;
        } else {
            File[] fileArray3 = new File[1];
            fileArray = fileArray3;
            fileArray3[0] = mainDir;
        }
        File[] paths = fileArray;
        Factory newFactory = SimpleFactory.make(paths, ".*");
        HashMap<String, FoundAndTotal> data = new HashMap<String, FoundAndTotal>();
        char c = '\u0000';
        Set<String> latestAvailable = newFactory.getAvailableLanguages();
        for (String locale : newFactory.getAvailableLanguages()) {
            if (!matcher.reset(locale).matches() || !latestAvailable.contains(locale) || SUPPLEMENTAL_DATA_INFO.getDefaultContentLocales().contains(locale) || locale.equals("root") || locale.equals("und") || locale.equals("supplementalData")) continue;
            char nc = locale.charAt(0);
            if (nc != c) {
                System.out.println("\t" + locale);
                c = nc;
            }
            CLDRFile latestFile = null;
            try {
                latestFile = latestFactory.make(locale, true);
            }
            catch (Exception e2) {
                System.out.println("Can't make latest CLDRFile for: " + locale + "\tpast: " + mainDir + "\tlatest: " + Arrays.asList(latestFactory.getSourceDirectories()));
                continue;
            }
            CLDRFile file = null;
            try {
                file = newFactory.make(locale, true);
            }
            catch (Exception e2) {
                System.out.println("Can't make CLDRFile for: " + locale + "\tpast: " + mainDir);
                continue;
            }
            Counter<Level> foundCounter = new Counter<Level>();
            Counter<Level> unconfirmedCounter = new Counter<Level>();
            Counter<Level> missingCounter = new Counter<Level>();
            LinkedHashSet<String> unconfirmedPaths = null;
            Relation<VettingViewer.MissingStatus, String> missingPaths = null;
            unconfirmedPaths = new LinkedHashSet<String>();
            missingPaths = Relation.of(new LinkedHashMap(), LinkedHashSet.class);
            VettingViewer.getStatus(latestFile.fullIterable(), file, pathHeaderFactory, foundCounter, unconfirmedCounter, missingCounter, missingPaths, unconfirmedPaths);
            HashSet<Map.Entry<VettingViewer.MissingStatus, String>> missingRemovals = new HashSet<Map.Entry<VettingViewer.MissingStatus, String>>();
            for (Map.Entry<VettingViewer.MissingStatus, String> e : missingPaths.keyValueSet()) {
                if (e.getKey() != VettingViewer.MissingStatus.ABSENT) continue;
                String string = e.getValue();
                if (HACK.get(string) != null) {
                    missingRemovals.add(e);
                    missingCounter.add(Level.MODERN, -1L);
                    foundCounter.add(Level.MODERN, 1L);
                    continue;
                }
                CLDRFile.Status status = new CLDRFile.Status();
                String loc = file.getSourceLocaleID(string, status);
                boolean bl = false;
            }
            for (Map.Entry<VettingViewer.MissingStatus, String> e : missingRemovals) {
                missingPaths.remove(e.getKey(), e.getValue());
            }
            if (showMissing) {
                int count = 0;
                for (String string : unconfirmedPaths) {
                    System.out.println(++count + "\t" + locale + "\tunconfirmed\t" + string);
                }
                for (Map.Entry entry : missingPaths.keyValueSet()) {
                    String path = (String)entry.getValue();
                    CLDRFile.Status status = new CLDRFile.Status();
                    String loc = file.getSourceLocaleID(path, status);
                    boolean debug = false;
                    System.out.println(++count + "\t" + locale + "\t" + CldrUtility.toString(entry));
                }
                boolean bl = false;
            }
            data.put(locale, new FoundAndTotal(foundCounter, unconfirmedCounter, missingCounter));
        }
        return Collections.unmodifiableMap(data);
    }

    public static void showCoverage(FormattedFileWriter.Anchors anchors, Matcher matcher) throws IOException {
        ShowLocaleCoverage.showCoverage(anchors, matcher, null, false);
    }

    /*
     * WARNING - void declaration
     */
    public static void showCoverage(FormattedFileWriter.Anchors anchors, Matcher matcher, Set<String> locales, boolean useOrgLevel) throws IOException {
        String title = "Locale Coverage";
        try (PrintWriter pw = new PrintWriter(new FormattedFileWriter(null, "Locale Coverage", null, anchors));
             PrintWriter tsv_summary = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-coverage.tsv");
             PrintWriter tsv_missing = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-missing.tsv");
             PrintWriter tsv_missing_summary = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-missing-summary.tsv");
             PrintWriter tsv_missing_basic = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-missing-basic.tsv");
             PrintWriter tsv_missing_counts = FileUtilities.openUTF8Writer(CLDRPaths.CHART_DIRECTORY + "tsv/", "locale-missing-counts.tsv");
             PrintWriter propertiesCoverage = FileUtilities.openUTF8Writer(CLDRPaths.COMMON_DIRECTORY + "properties/", "coverageLevels.txt");){
            tsv_missing_summary.println(TSV_MISSING_SUMMARY_HEADER);
            tsv_missing.println(TSV_MISSING_HEADER);
            tsv_missing_basic.println(TSV_MISSING_BASIC_HEADER);
            tsv_missing_counts.println(TSV_MISSING_COUNTS_HEADER);
            propertiesCoverage.println(PROPERTIES_HEADER);
            Set<String> checkModernLocales = STANDARD_CODES.getLocaleCoverageLocales(Organization.cldr, EnumSet.of(Level.MODERN));
            TreeSet<String> availableLanguages = new TreeSet<String>(factory.getAvailableLanguages());
            availableLanguages.addAll(checkModernLocales);
            AbstractMultimap languageToRegion = TreeMultimap.create();
            LanguageTagParser ltp = new LanguageTagParser();
            LanguageTagCanonicalizer ltc = new LanguageTagCanonicalizer(true);
            for (String locale : factory.getAvailable()) {
                String country = ltp.set(locale).getRegion();
                if (country.isEmpty()) continue;
                languageToRegion.put(ltc.transform(ltp.getLanguageScript()), country);
            }
            languageToRegion = ImmutableMultimap.copyOf(languageToRegion);
            ShowLocaleCoverage.fixCommonLocales();
            System.out.println(Joiner.on("\n").join(languageToRegion.asMap().entrySet()));
            System.out.println("# Checking: " + availableLanguages);
            NumberFormat percentFormat = NumberFormat.getPercentInstance(Locale.ENGLISH);
            percentFormat.setMaximumFractionDigits(1);
            pw.println("<p style='text-align: left'>This chart shows the coverage levels in this release. Totals are listed after the main chart.</p>\n<blockquote><ul>\n<li><a href='#main_table'>Main Table</a></li>\n<li><a href='#level_counts'>Level Counts</a></li>\n</ul></blockquote>\n<h3>Column Key</h3>\n<table class='subtle' style='margin-left:3em; margin-right:3em'>\n<tr><th>Direct.</th><td>The CLDR source directory</td></tr>\n<tr><th>Default Region</th><td>The default region for locale code, based on likely subtags</td></tr>\n<tr><th>\u2116 Locales</th><td>Note that the coverage of regional locales inherits from their parents.</td></tr>\n<tr><th>Target Level</th><td>The default target Coverage Level in CLDR. Particular organizations may have different target levels. Languages with high levels of coverage are marked with \u2021, even though they are not tracked by the technical committee.</td></tr>\n<tr><th>\u225f</th><td>Indicates whether the Computed Level equals the CLDR Target or not.</td></tr>\n<tr><th>Computed Level</th><td>Computed from the percentage values, taking the first level that meets a threshold (currently \ud83c\udd3c " + percentFormat.format(0.995) + ", \u24dc " + percentFormat.format(0.995) + ", \u24d1 " + percentFormat.format(1.0) + ").</td></tr>\n<tr><th>ICU</th><td>Indicates whether included in the current version of ICU</td></tr>\n<tr><th>Confirmed</th><td>Confirmed items as a percentage of all supplied items. If low, the coverage can be improved by getting multiple organizations to confirm.</td></tr>\n<tr><th>\ud83c\udd3c%,\u00a0\u24dc%,\u00a0\u24d1%,\u00a0\u24d2%</th><td>Coverage at Levels: \ud83c\udd3c = Modern, \u24dc = Moderate, \u24d1 = Basic, \u24d2 = Core. The percentage of items at that level and below is computed from <i>confirmed_items/total_items</i>. A high-level summary of the meaning of the coverage values is at <a target='_blank' href='http://www.unicode.org/reports/tr35/tr35-info.html#Coverage_Levels'>Coverage Levels</a>. The Core values are described on <a target='_blank' href='https://cldr.unicode.org/index/cldr-spec/core-data-for-new-locales'>Core Data</a>. </td></tr>\n<tr><th>Missing Features</th><td>These are not single items, but rather specific features, such as plural rules or unit grammar info. They are listed if missing at the computed level.<br>Example: <i>\u24dc collation</i> means this feature should be supported at a Moderate level.<br><i>Except for Core, these are not accounted for in the percent values.</i></td></tr>\n<tr><th><a href='https://github.com/unicode-org/cldr-staging/tree/main/docs/charts/42/tsv'>TSV Files</a>:</th><td>\n<ul><li>locale-coverage.tsv \u2014 A version of this file, suitable for loading into a spreadsheet.</li>\n<li>locale-missing.tsv \u2014 Missing items for the CLDR target locales.</li>\n<li>locale-missing-summary.tsv \u2014 Summary of missing items for the CLDR target locales, by Section/Page/Header.</li>\n<li>locale-missing-basic.tsv \u2014 Missing items that keep locales from reaching the Basic level.</li></td></tr>\n<li>locale-missing-count.tsv \u2014 Counts of items per locale that are found, unconfirmed, or missing, at the target level. (Or at *basic, if there is no target level.)</li></td></tr>\n</table>\n");
            Relation<VettingViewer.MissingStatus, String> missingPaths = Relation.of(new EnumMap(VettingViewer.MissingStatus.class), TreeSet.class, CLDRFile.getComparator(DtdType.ldml));
            TreeSet<String> unconfirmed = new TreeSet<String>(CLDRFile.getComparator(DtdType.ldml));
            Set<String> defaultContents = SUPPLEMENTAL_DATA_INFO.getDefaultContentLocales();
            Counter<Level> foundCounter = new Counter<Level>();
            Counter<Level> unconfirmedCounter = new Counter<Level>();
            Counter<Level> missingCounter = new Counter<Level>();
            AbstractCollection levelsToShow = new ArrayList<Level>(EnumSet.allOf(Level.class));
            levelsToShow.remove((Object)Level.COMPREHENSIVE);
            levelsToShow.remove((Object)Level.UNDETERMINED);
            levelsToShow = ImmutableList.copyOf(levelsToShow);
            AbstractCollection reversedLevels = new ArrayList<Level>(levelsToShow);
            Collections.reverse(reversedLevels);
            reversedLevels = ImmutableList.copyOf(reversedLevels);
            int localeCount = 0;
            TablePrinter tablePrinter = new TablePrinter().addColumn("Direct.", "class='source'", null, "class='source'", true).setBreakSpans(true).setSpanRows(false).addColumn("Language", "class='source'", CldrUtility.getDoubleLinkMsg(), "class='source'", true).setBreakSpans(true).addColumn("English Name", "class='source'", null, "class='source'", true).setBreakSpans(true).addColumn("Native Name", "class='source'", null, "class='source'", true).setBreakSpans(true).addColumn("Script", "class='source'", null, "class='source'", true).setBreakSpans(true).addColumn("Default Region", "class='source'", null, "class='source'", true).setBreakSpans(true).addColumn("\u2116 Locales", "class='source'", null, "class='targetRight'", true).setBreakSpans(true).setCellPattern("{0,number}").addColumn("Target Level", "class='source'", null, "class='source'", true).setBreakSpans(true).addColumn("\u225f", "class='target'", null, "class='target'", true).setBreakSpans(true).setSortPriority(1).setSortAscending(false).addColumn("Computed Level", "class='target'", null, "class='target'", true).setBreakSpans(true).setSortPriority(0).setSortAscending(false).addColumn("ICU", "class='target'", null, "class='target'", true).setBreakSpans(true).addColumn("Confirmed", "class='target'", null, "class='targetRight' style='color:gray'", true).setBreakSpans(true).setCellPattern("{0,number,0.0%}");
            NumberFormat tsvPercent = NumberFormat.getPercentInstance(Locale.ENGLISH);
            tsvPercent.setMaximumFractionDigits(2);
            block50: for (Level level : reversedLevels) {
                String titleLevel = level.getAbbreviation() + "%";
                tablePrinter.addColumn(titleLevel, "class='target'", null, "class='targetRight'", true).setCellPattern("{0,number,0.0%}").setBreakSpans(true);
                switch (level) {
                    default: {
                        tablePrinter.setSortPriority(2).setSortAscending(false);
                        continue block50;
                    }
                    case BASIC: {
                        tablePrinter.setSortPriority(3).setSortAscending(false);
                        continue block50;
                    }
                    case MODERATE: {
                        tablePrinter.setSortPriority(4).setSortAscending(false);
                        continue block50;
                    }
                    case MODERN: 
                }
                tablePrinter.setSortPriority(5).setSortAscending(false);
            }
            tablePrinter.addColumn("Missing Features", "class='target'", null, "class='target'", true).setBreakSpans(true);
            long start = System.currentTimeMillis();
            LikelySubtags likelySubtags = new LikelySubtags();
            EnumMap<Level, Double> targetLevel = new EnumMap<Level, Double>(Level.class);
            targetLevel.put(Level.CORE, 0.02);
            targetLevel.put(Level.BASIC, 0.16);
            targetLevel.put(Level.MODERATE, 0.33);
            targetLevel.put(Level.MODERN, 1.0);
            TreeMultimap<String, String> pathToLocale = TreeMultimap.create();
            Counter<Level> computedLevels = new Counter<Level>();
            Counter<Level> computedSublocaleLevels = new Counter<Level>();
            for (String locale : availableLanguages) {
                try {
                    Level foundLevel;
                    Iterator<Map.Entry<String, StatusData>> goalLevel;
                    void var58_95;
                    String base;
                    if (locale.contains("supplemental") || locale.startsWith("sr_Latn") || locales != null && !locales.contains(locale) && !locales.contains(base = CLDRLocale.getInstance(locale).getLanguage()) || matcher != null && !matcher.reset(locale).matches() || defaultContents.contains(locale) || "root".equals(locale) || "und".equals(locale)) continue;
                    tsv_missing_summary.flush();
                    tsv_missing.flush();
                    tsv_missing_basic.flush();
                    tsv_missing_counts.flush();
                    boolean isSeed = new File(CLDRPaths.SEED_DIRECTORY, locale + ".xml").exists();
                    String region = ltp.set(locale).getRegion();
                    if (!region.isEmpty()) continue;
                    Level cldrLocaleLevelGoal = SC.getLocaleCoverageLevel(Organization.cldr, locale);
                    String string = ShowLocaleCoverage.getSpecialFlag(locale);
                    boolean bl = Level.CORE_TO_MODERN.contains((Object)cldrLocaleLevelGoal);
                    String max = likelySubtags.maximize(locale);
                    String script = ltp.set(max).getScript();
                    String defRegion = ltp.getRegion();
                    String language = likelySubtags.minimize(locale);
                    missingPaths.clear();
                    unconfirmed.clear();
                    CLDRFile file = factory.make(locale, true, minimumDraftStatus);
                    if (locale.equals("af")) {
                        boolean bl2 = false;
                    }
                    IterableFilter pathSource = new IterableFilter(file.fullIterable());
                    VettingViewer.getStatus(pathSource, file, pathHeaderFactory, foundCounter, unconfirmedCounter, missingCounter, missingPaths, unconfirmed);
                    long found = 0L;
                    long unconfirmedc = 0L;
                    long missing = 0L;
                    Object adjustedGoal = cldrLocaleLevelGoal.compareTo((Level)Level.BASIC) < 0 ? Level.BASIC : cldrLocaleLevelGoal;
                    Level[] levelArray = Level.values();
                    int n = levelArray.length;
                    boolean bl3 = false;
                    while (var58_95 < n) {
                        Level level = levelArray[var58_95];
                        if (level.compareTo(adjustedGoal) <= 0) {
                            found += foundCounter.get(level);
                            unconfirmedc += unconfirmedCounter.get(level);
                            missing += missingCounter.get(level);
                        }
                        ++var58_95;
                    }
                    String goalFlag = cldrLocaleLevelGoal == adjustedGoal ? "" : "*";
                    tsv_missing_counts.println(string + locale + "\t" + goalFlag + adjustedGoal + "\t" + found + "\t" + unconfirmedc + "\t" + missing);
                    Collection sublocales = languageToRegion.asMap().get(language);
                    if (sublocales == null) {
                        sublocales = Collections.emptySet();
                    }
                    sublocales = ImmutableSet.copyOf(sublocales);
                    String seedString = isSeed ? "seed" : "common";
                    EnumMap<Level, Integer> totals = new EnumMap<Level, Integer>(Level.class);
                    EnumMap<Level, Integer> confirmed = new EnumMap<Level, Integer>(Level.class);
                    EnumSet<CoreCoverageInfo.CoreItems> specialMissingPaths = EnumSet.noneOf(CoreCoverageInfo.CoreItems.class);
                    StatusCounter starredCounter = new StatusCounter();
                    TreeMultimap<CoreCoverageInfo.CoreItems, String> detailedErrors = TreeMultimap.create();
                    Iterator<Map.Entry<VettingViewer.MissingStatus, String>> coverage = CoreCoverageInfo.getCoreCoverageInfo(file, detailedErrors);
                    Iterator<Object> iterator = coverage.iterator();
                    while (iterator.hasNext()) {
                        CoreCoverageInfo.CoreItems coreItems = iterator.next();
                        foundCounter.add(coreItems.desiredLevel, 1L);
                    }
                    for (Map.Entry entry : detailedErrors.entries()) {
                        CoreCoverageInfo.CoreItems coreItem = (CoreCoverageInfo.CoreItems)((Object)entry.getKey());
                        String path = (String)entry.getValue();
                        specialMissingPaths.add(coreItem);
                        if (coreItem.desiredLevel == Level.BASIC) {
                            starredCounter.gatherStarred(path, null);
                        }
                        missingCounter.add(coreItem.desiredLevel, 1L);
                    }
                    if (bl) {
                        goalLevel = cldrLocaleLevelGoal;
                        for (Map.Entry<VettingViewer.MissingStatus, String> entry : missingPaths.entrySet()) {
                            String string2 = entry.getValue();
                            String status = entry.getKey().toString();
                            foundLevel = coverageInfo.getCoverageLevel(string2, locale);
                            if (((Enum)((Object)goalLevel)).compareTo((Map.Entry<String, StatusData>)((Object)foundLevel)) < 0) continue;
                            String line = ShowLocaleCoverage.spreadsheetLine(locale, language, script, string, file.getStringValue(string2), goalLevel, foundLevel, status, string2, file, pathToLocale);
                            tsv_missing.println(line);
                        }
                        for (String path : unconfirmed) {
                            Level level = coverageInfo.getCoverageLevel(path, locale);
                            if (((Enum)((Object)goalLevel)).compareTo((Map.Entry<String, StatusData>)((Object)level)) < 0) continue;
                            String line = ShowLocaleCoverage.spreadsheetLine(locale, language, script, string, file.getStringValue(path), goalLevel, level, "n/a", path, file, pathToLocale);
                            tsv_missing.println(line);
                        }
                    } else {
                        goalLevel = Level.BASIC;
                        for (Map.Entry<VettingViewer.MissingStatus, String> entry : missingPaths.entrySet()) {
                            String string3 = entry.getValue();
                            Level foundLevel3 = coverageInfo.getCoverageLevel(string3, locale);
                            if (((Enum)((Object)goalLevel)).compareTo((Map.Entry<String, StatusData>)((Object)foundLevel3)) < 0) continue;
                            starredCounter.gatherStarred(string3, null);
                        }
                        for (String path : unconfirmed) {
                            CLDRFile.DraftStatus draftStatus;
                            String string4 = file.getFullXPath(path);
                            CLDRFile.DraftStatus draftStatus2 = draftStatus = string4.contains("unconfirmed") ? CLDRFile.DraftStatus.unconfirmed : CLDRFile.DraftStatus.provisional;
                            foundLevel = coverageInfo.getCoverageLevel(path, locale);
                            if (((Enum)((Object)goalLevel)).compareTo((Map.Entry<String, StatusData>)((Object)foundLevel)) < 0) continue;
                            starredCounter.gatherStarred(path, draftStatus);
                        }
                    }
                    if (!starredCounter.starredPathToData.isEmpty()) {
                        for (Map.Entry<String, StatusData> starred : starredCounter.starredPathToData.entrySet()) {
                            String starredPath = starred.getKey();
                            StatusData statusData = starred.getValue();
                            tsv_missing_basic.println(string + locale + "\t" + statusData.missing + "\t" + statusData.provisional + "\t" + statusData.unconfirmed + "\t" + starredPath.replace("\"*\"", "'*'"));
                        }
                        tsv_missing_basic.println(string + locale + "\t" + starredCounter.missingTotal + "\t" + starredCounter.provisionalTotal + "\t" + starredCounter.unconfirmedTotal + "\tTotals");
                        tsv_missing_basic.println("\t\t\t");
                    }
                    int sumFound = 0;
                    int sumMissing = 0;
                    int sumUnconfirmed = 0;
                    for (Level level : levelsToShow) {
                        long foundCount = foundCounter.get(level);
                        long unconfirmedCount = unconfirmedCounter.get(level);
                        long missingCount = missingCounter.get(level);
                        sumFound = (int)((long)sumFound + foundCount);
                        sumUnconfirmed = (int)((long)sumUnconfirmed + unconfirmedCount);
                        sumMissing = (int)((long)sumMissing + missingCount);
                        confirmed.put(level, sumFound);
                        totals.put(level, sumFound + sumUnconfirmed + sumMissing);
                    }
                    EnumMap<Level, Integer> enumMap = new EnumMap<Level, Integer>(Level.class);
                    EnumMap<Level, Integer> accumConfirmed = new EnumMap<Level, Integer>(Level.class);
                    int currTotals = 0;
                    int currConfirmed = 0;
                    for (Level level : levelsToShow) {
                        accumConfirmed.put(level, currConfirmed += ((Integer)confirmed.get((Object)level)).intValue());
                        enumMap.put(level, currTotals += ((Integer)totals.get((Object)level)).intValue());
                    }
                    Level computed = Level.UNDETERMINED;
                    EnumMap<Level, Double> levelToProportion = new EnumMap<Level, Double>(Level.class);
                    for (Level level : reversedLevels) {
                        int confirmedCoverage = (Integer)accumConfirmed.get((Object)level);
                        double total = ((Integer)enumMap.get((Object)level)).intValue();
                        double proportion = (double)confirmedCoverage / total;
                        levelToProportion.put(level, proportion);
                        if (computed != Level.UNDETERMINED) continue;
                        switch (level) {
                            case MODERN: {
                                if (!(proportion >= 0.995)) break;
                                computed = level;
                                break;
                            }
                            case MODERATE: {
                                if (!(proportion >= 0.995)) break;
                                computed = level;
                                break;
                            }
                            case BASIC: {
                                if (!(proportion >= 1.0)) break;
                                computed = level;
                                break;
                            }
                        }
                    }
                    EnumSet<CoreCoverageInfo.CoreItems> shownMissingPaths = EnumSet.noneOf(CoreCoverageInfo.CoreItems.class);
                    Level computedWithCore = computed == Level.UNDETERMINED ? Level.CORE : computed;
                    for (CoreCoverageInfo.CoreItems item : specialMissingPaths) {
                        if (item.desiredLevel.compareTo(computedWithCore) <= 0) {
                            shownMissingPaths.add(item);
                            continue;
                        }
                        boolean bl4 = false;
                    }
                    String coreMissingString = Joiner.on(", ").join(shownMissingPaths);
                    String visibleComputed = computed == Level.UNDETERMINED ? "" : computed.toString();
                    computedLevels.add(computed, 1L);
                    computedSublocaleLevels.add(computed, sublocales.size());
                    tablePrinter.addRow().addCell((Comparable)((Object)seedString)).addCell((Comparable)((Object)language)).addCell((Comparable)((Object)ENGLISH.getName(language))).addCell((Comparable)((Object)file.getName(language))).addCell((Comparable)((Object)script)).addCell((Comparable)((Object)defRegion)).addCell(Integer.valueOf(sublocales.size())).addCell((Comparable)(cldrLocaleLevelGoal == Level.UNDETERMINED ? "" : string + cldrLocaleLevelGoal.toString())).addCell((Comparable)((Object)(computed == cldrLocaleLevelGoal ? " \u2261" : " \u2260"))).addCell((Comparable)((Object)visibleComputed)).addCell((Comparable)((Object)ShowLocaleCoverage.getIcuValue(language))).addCell(Double.valueOf((double)sumFound / (double)(sumFound + sumUnconfirmed)));
                    for (Level level : reversedLevels) {
                        tablePrinter.addCell((Comparable)levelToProportion.get((Object)level));
                    }
                    tablePrinter.addCell((Comparable)((Object)coreMissingString)).finishRow();
                    if (computed != Level.UNDETERMINED) {
                        propertiesCoverage.println(locale + " ;\t" + visibleComputed);
                    }
                    ++localeCount;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            propertiesCoverage.println("#EOF\t");
            pw.println("<h3><a name='main_table' href='#main_table'>Main Table</a></h3>");
            pw.println(tablePrinter.toTable());
            pw.println("<h3><a name='level_counts' href='#level_counts'>Level Counts</a></h3>\n<table class='subtle'><tr>\n<th style='text-align:left'>Level</th><th style='text-align:left'>Languages</th><th style='text-align:left'>Locales</th></tr>");
            long totalCount = 0L;
            long totalLocaleCount = 0L;
            for (Level level : Lists.reverse(Arrays.asList(Level.values()))) {
                long l = computedLevels.get(level);
                long localesCount = computedSublocaleLevels.get(level);
                if (l == 0L || level == Level.UNDETERMINED) continue;
                totalCount += l;
                totalLocaleCount += localesCount;
                Object visibleImputed = level == Level.UNDETERMINED ? "<" + Level.BASIC.toString() : level.toString();
                pw.println("<tr><th style='text-align:left'>" + (String)visibleImputed + "</th><td style='text-align:right'>" + l + "</td><td style='text-align:right'>" + localesCount + "</td></tr>");
            }
            pw.println("<tr><th style='text-align:left'>Total</th><td style='text-align:right'>" + totalCount + "</td><td style='text-align:right'>" + totalLocaleCount + "</td></tr>\n");
            pw.println("<tr><th style='text-align:left'>in dev.</th><td style='text-align:right'>" + computedLevels.get(Level.UNDETERMINED) + "</td><td style='text-align:right'>" + computedSublocaleLevels.get(Level.UNDETERMINED) + "</td></tr>\n</table>");
            TreeMultimap<Level, String> levelToLocales = TreeMultimap.create();
            for (Map.Entry entry : pathToLocale.asMap().entrySet()) {
                String path = (String)entry.getKey();
                Collection localeSet = entry.getValue();
                levelToLocales.clear();
                for (String locale : localeSet) {
                    Level foundLevel = coverageInfo.getCoverageLevel(path, locale);
                    levelToLocales.put(foundLevel, locale);
                }
                String phString = "n/a\tn/a\tn/a\tn/a";
                try {
                    PathHeader ph = pathHeaderFactory.fromPath(path);
                    phString = ph.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (Map.Entry entry2 : levelToLocales.asMap().entrySet()) {
                    Level level = (Level)((Object)entry2.getKey());
                    localeSet = entry2.getValue();
                    tsv_missing_summary.println(level + "\t" + localeSet.size() + "\t" + Joiner.on(" ").join(localeSet.stream().map(x -> x + ShowLocaleCoverage.getSpecialFlag(x)).collect(Collectors.toSet())) + "\t" + phString);
                }
            }
            tablePrinter.toTsv(tsv_summary);
            long l = System.currentTimeMillis();
            System.out.println(l - start + " millis = " + (l - start) / (long)localeCount + " millis/locale");
            ShowPlurals.appendBlanksForScrolling(pw);
        }
    }

    public static String getSpecialFlag(String locale) {
        return SC.getLocaleCoverageLevel(Organization.special, locale) == Level.UNDETERMINED ? "" : "\u2021";
    }

    private static String spreadsheetLine(String locale, String language, String script, String specialFlag, String nativeValue, Level cldrLocaleLevelGoal, Level itemLevel, String status, String path, CLDRFile resolvedFile, Multimap<String, String> pathToLocale) {
        if (pathToLocale != null) {
            pathToLocale.put(path, locale);
        }
        Enum surveyToolStatus = null;
        String bailey = resolvedFile == null ? "" : resolvedFile.getStringValue(path);
        Object phString = "na\tn/a\tn/a\t" + path;
        try {
            PathHeader ph = pathHeaderFactory.fromPath(path);
            phString = ph.toString();
        }
        catch (Exception ph) {
            // empty catch block
        }
        String line = specialFlag + language + "\t" + ENGLISH.getName(language) + "\t" + ENGLISH.getName("script", script) + "\t" + cldrLocaleLevelGoal + "\t" + itemLevel + "\t" + (surveyToolStatus == null ? "n/a" : surveyToolStatus.toString()) + "\t" + bailey + "\t" + (String)phString + "\t" + PathHeader.getUrlForLocalePath(locale, path);
        return line;
    }

    private static String getIcuValue(String locale) {
        return ICU_Locales.contains(new ULocale(locale)) ? "ICU" : "";
    }

    static {
        Object[][] mapping = new Object[][]{{VersionInfo.getInstance(42), 2022}, {VersionInfo.getInstance(40), 2021}, {VersionInfo.getInstance(38), 2020}, {VersionInfo.getInstance(36), 2019}, {VersionInfo.getInstance(34), 2018}, {VersionInfo.getInstance(32), 2017}, {VersionInfo.getInstance(30), 2016}, {VersionInfo.getInstance(28), 2015}, {VersionInfo.getInstance(26), 2014}, {VersionInfo.getInstance(24), 2013}, {VersionInfo.getInstance(22, 1), 2012}, {VersionInfo.getInstance(2, 0, 1), 2011}, {VersionInfo.getInstance(1, 9, 1), 2010}, {VersionInfo.getInstance(1, 7, 2), 2009}, {VersionInfo.getInstance(1, 6, 1), 2008}, {VersionInfo.getInstance(1, 5, 1), 2007}, {VersionInfo.getInstance(1, 4, 1), 2006}, {VersionInfo.getInstance(1, 3), 2005}, {VersionInfo.getInstance(1, 2), 2004}, {VersionInfo.getInstance(1, 1, 1), 2003}};
        ArrayList<ReleaseInfo> _versionToYear = new ArrayList<ReleaseInfo>();
        for (Object[] row : mapping) {
            _versionToYear.add(new ReleaseInfo((VersionInfo)row[0], (Integer)row[1]));
        }
        versionToYear = ImmutableList.copyOf(_versionToYear);
        coverageInfo = new CoverageInfo(SUPPLEMENTAL_DATA_INFO);
        dummyVoterInfo = new VoteResolver.VoterInfo(Organization.cldr, VoteResolver.Level.vetter, "somename");
        dummyUserInfo = new CLDRInfo.UserInfo(){

            @Override
            public VoteResolver.VoterInfo getVoterInfo() {
                return dummyVoterInfo;
            }
        };
        dummyPathValueInfo = new CLDRInfo.PathValueInfo(){

            @Override
            public Collection<? extends CLDRInfo.CandidateInfo> getValues() {
                throw new UnsupportedOperationException();
            }

            @Override
            public CLDRInfo.CandidateInfo getCurrentItem() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getBaselineValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Level getCoverageLevel() {
                return Level.MODERN;
            }

            @Override
            public boolean hadVotesSometimeThisRelease() {
                throw new UnsupportedOperationException();
            }

            @Override
            public CLDRLocale getLocale() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getXpath() {
                throw new UnsupportedOperationException();
            }
        };
        ICU_Locales = ImmutableSet.copyOf(ULocale.getAvailableLocales());
    }

    private static class IterableFilter
    implements Iterable<String> {
        private Iterable<String> source;
        static final Set<String> SUPPRESS_PATHS_AFTER_SUBMISSION = ImmutableSet.of("//ldml/personNames/nameOrderLocales[@order=\"givenFirst\"]", "//ldml/personNames/nameOrderLocales[@order=\"surnameFirst\"]", "//ldml/personNames/foreignSpaceReplacement[@xml:space=\"preserve\"]", "//ldml/personNames/initialPattern[@type=\"initial\"]", "//ldml/personNames/initialPattern[@type=\"initialSequence\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"long\"][@usage=\"referring\"][@formality=\"formal\"]/namePattern", new String[]{"//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"long\"][@usage=\"referring\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"long\"][@usage=\"addressing\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"long\"][@usage=\"addressing\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"long\"][@usage=\"monogram\"][@formality=\"formal\"]/namePattern", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"long\"][@usage=\"monogram\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='monogram'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"medium\"][@usage=\"referring\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"medium\"][@usage=\"referring\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"medium\"][@usage=\"addressing\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"medium\"][@usage=\"addressing\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"medium\"][@usage=\"monogram\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='monogram'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"medium\"][@usage=\"monogram\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='monogram'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"short\"][@usage=\"referring\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"short\"][@usage=\"referring\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"short\"][@usage=\"addressing\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"short\"][@usage=\"addressing\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"short\"][@usage=\"monogram\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='monogram'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"short\"][@usage=\"monogram\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='givenFirst'][@length='long'][@usage='monogram'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"long\"][@usage=\"referring\"][@formality=\"formal\"]/namePattern", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"long\"][@usage=\"referring\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"long\"][@usage=\"addressing\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"long\"][@usage=\"addressing\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"long\"][@usage=\"monogram\"][@formality=\"formal\"]/namePattern", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"long\"][@usage=\"monogram\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='monogram'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"medium\"][@usage=\"referring\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"medium\"][@usage=\"referring\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"medium\"][@usage=\"addressing\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"medium\"][@usage=\"addressing\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"medium\"][@usage=\"monogram\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='monogram'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"medium\"][@usage=\"monogram\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='monogram'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"short\"][@usage=\"referring\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"short\"][@usage=\"referring\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"short\"][@usage=\"addressing\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"short\"][@usage=\"addressing\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"short\"][@usage=\"monogram\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='monogram'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"surnameFirst\"][@length=\"short\"][@usage=\"monogram\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='surnameFirst'][@length='long'][@usage='monogram'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"sorting\"][@length=\"long\"][@usage=\"referring\"][@formality=\"formal\"]/namePattern", "//ldml/personNames/personName[@order=\"sorting\"][@length=\"long\"][@usage=\"referring\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='sorting'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"sorting\"][@length=\"medium\"][@usage=\"referring\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='sorting'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"sorting\"][@length=\"medium\"][@usage=\"referring\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='sorting'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"sorting\"][@length=\"short\"][@usage=\"referring\"][@formality=\"formal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='sorting'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/personName[@order=\"sorting\"][@length=\"short\"][@usage=\"referring\"][@formality=\"informal\"]/alias[@source=\"locale\"][@path=\"../personName[@order='sorting'][@length='long'][@usage='referring'][@formality='formal']\"]", "//ldml/personNames/sampleName[@item=\"givenOnly\"]/nameField[@type=\"given\"]", "//ldml/personNames/sampleName[@item=\"givenSurnameOnly\"]/nameField[@type=\"given\"]", "//ldml/personNames/sampleName[@item=\"givenSurnameOnly\"]/nameField[@type=\"surname\"]", "//ldml/personNames/sampleName[@item=\"given12Surname\"]/nameField[@type=\"given\"]", "//ldml/personNames/sampleName[@item=\"given12Surname\"]/nameField[@type=\"given2\"]", "//ldml/personNames/sampleName[@item=\"given12Surname\"]/nameField[@type=\"surname\"]", "//ldml/personNames/sampleName[@item=\"full\"]/nameField[@type=\"prefix\"]", "//ldml/personNames/sampleName[@item=\"full\"]/nameField[@type=\"given\"]", "//ldml/personNames/sampleName[@item=\"full\"]/nameField[@type=\"given-informal\"]", "//ldml/personNames/sampleName[@item=\"full\"]/nameField[@type=\"given2\"]", "//ldml/personNames/sampleName[@item=\"full\"]/nameField[@type=\"surname-prefix\"]", "//ldml/personNames/sampleName[@item=\"full\"]/nameField[@type=\"surname-core\"]", "//ldml/personNames/sampleName[@item=\"full\"]/nameField[@type=\"surname2\"]", "//ldml/personNames/sampleName[@item=\"full\"]/nameField[@type=\"suffix\"]"});

        IterableFilter(Iterable<String> source) {
            this.source = source;
        }

        @Override
        public Iterator<String> iterator() {
            return new IteratorFilter(this.source.iterator());
        }

        static class IteratorFilter
        implements Iterator<String> {
            Iterator<String> source;
            String peek;

            public IteratorFilter(Iterator<String> source) {
                this.source = source;
                this.fillPeek();
            }

            @Override
            public boolean hasNext() {
                return this.peek != null;
            }

            @Override
            public String next() {
                String result = this.peek;
                this.fillPeek();
                return result;
            }

            private void fillPeek() {
                this.peek = null;
                while (this.source.hasNext()) {
                    this.peek = this.source.next();
                    if (!SUPPRESS_PATHS_AFTER_SUBMISSION.contains(this.peek) && SUPPRESS_PATHS_CAN_BE_EMPTY.get(this.peek) != Boolean.TRUE) break;
                    this.peek = null;
                }
            }
        }
    }

    static class FoundAndTotal {
        final int found;
        final int total;

        @SafeVarargs
        public FoundAndTotal(Counter<Level> ... counters) {
            int[] count = new int[]{0, 0, 0};
            for (Level level : Level.values()) {
                if (level == Level.COMPREHENSIVE) continue;
                int i = 0;
                for (Counter<Level> counter : counters) {
                    int n = i++;
                    count[n] = (int)((long)count[n] + counter.get(level));
                }
            }
            this.found = count[0];
            this.total = this.found + count[1] + count[2];
        }

        public String toString() {
            return this.found + "/" + this.total;
        }
    }

    static final class ReleaseInfo {
        VersionInfo version;
        int year;

        public ReleaseInfo(VersionInfo versionInfo, int year) {
            this.version = versionInfo;
            this.year = year;
        }
    }

    static class StatusCounter {
        PathStarrer pathStarrer = new PathStarrer().setSubstitutionPattern("*");
        Map<String, StatusData> starredPathToData = new TreeMap<String, StatusData>();
        int missingTotal;
        int provisionalTotal;
        int unconfirmedTotal;

        StatusCounter() {
        }

        public void gatherStarred(String path, CLDRFile.DraftStatus draftStatus) {
            String starredPath = this.pathStarrer.set(path);
            StatusData statusData = this.starredPathToData.get(starredPath);
            if (statusData == null) {
                statusData = new StatusData();
                this.starredPathToData.put(starredPath, statusData);
            }
            if (draftStatus == null) {
                ++statusData.missing;
                ++this.missingTotal;
            } else {
                switch (draftStatus) {
                    case unconfirmed: {
                        ++statusData.unconfirmed;
                        ++this.unconfirmedTotal;
                        break;
                    }
                    case provisional: {
                        ++statusData.provisional;
                        ++this.provisionalTotal;
                        break;
                    }
                }
            }
        }
    }

    static class StatusData {
        int missing;
        int provisional;
        int unconfirmed;

        StatusData() {
        }
    }

    static enum MyOptions {
        filter(".+", ".*", "Filter the information based on id, using a regex argument."),
        chart(null, null, "chart only"),
        growth("true", "true", "Compute growth data"),
        organization(".+", null, "Only locales for organization"),
        version(".+", LATEST, "To get different versions"),
        rawData(null, null, "Output the raw data from all coverage levels"),
        targetDir(".*", CLDRPaths.GEN_DIRECTORY + "/statistics/", "target output file."),
        directories("(.*:)?[a-z]+(,[a-z]+)*", "common", "Space-delimited list of main source directories: common,seed,exemplar.\nOptional, <baseDir>:common,seed");

        final Option option;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = myOptions.add(this, (Object)argumentPattern, defaultArgument, helpText);
        }
    }
}

