/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.util.TimeZone;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.CountItems;
import org.unicode.cldr.tool.ShowData;
import org.unicode.cldr.util.ArrayComparator;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.Tabber;
import org.unicode.cldr.util.TimezoneFormatter;
import org.unicode.cldr.util.ZoneInflections;

public class ShowZoneEquivalences {
    public static void main(String[] args) throws Exception {
        double deltaTime = System.currentTimeMillis();
        try {
            ShowZoneEquivalences.getZoneEquivalences();
        }
        finally {
            deltaTime = (double)System.currentTimeMillis() - deltaTime;
            System.out.println("Elapsed: " + deltaTime / 1000.0 + " seconds");
            System.out.println("Done");
        }
    }

    public static void getZoneEquivalences() throws IOException, ParseException {
        TreeSet<String> needsTranslation = new TreeSet<String>(Arrays.asList("America/Buenos_Aires  America/Manaus America/Belem  America/Campo_Grande America/Sao_Paulo  Australia/Perth Australia/Darwin Australia/Brisbane Australia/Adelaide Australia/Sydney Australia/Hobart  America/Vancouver America/Edmonton America/Regina America/Winnipeg America/Toronto America/Halifax America/St_Johns  Asia/Jakarta  America/Tijuana America/Hermosillo America/Chihuahua America/Mexico_City  Europe/Moscow Europe/Kaliningrad Europe/Moscow Asia/Yekaterinburg Asia/Novosibirsk Asia/Yakutsk Asia/Vladivostok Pacific/Honolulu America/Indiana/Indianapolis America/Anchorage  America/Los_Angeles America/Phoenix America/Denver America/Chicago America/Indianapolis America/New_York".split("[,]?\\s+")));
        TreeSet<String> singleCountries = new TreeSet<String>(Arrays.asList("Africa/Bamako America/Godthab America/Santiago America/Guayaquil     Asia/Shanghai Asia/Tashkent Asia/Kuala_Lumpur Europe/Madrid Europe/Lisbon Europe/London Pacific/Auckland Pacific/Tahiti".split("\\s")));
        TreeSet<String> defaultItems = new TreeSet<String>(Arrays.asList("Antarctica/McMurdo America/Buenos_Aires Australia/Sydney America/Sao_Paulo America/Toronto Africa/Kinshasa America/Santiago Asia/Shanghai America/Guayaquil Europe/Madrid Europe/London America/Godthab Asia/Jakarta Africa/Bamako America/Mexico_City Asia/Kuala_Lumpur Pacific/Auckland Europe/Lisbon Europe/Moscow Europe/Kiev America/New_York Asia/Tashkent Pacific/Tahiti Pacific/Kosrae Pacific/Tarawa Asia/Almaty Pacific/Majuro Asia/Ulaanbaatar Arctic/Longyearbyen Pacific/Midway".split("\\s")));
        StandardCodes sc = StandardCodes.make();
        Set<String> codes = sc.getGoodAvailableCodes("tzid");
        TreeSet<String> extras = new TreeSet<String>();
        Map<String, Set<String>> m3 = sc.getZoneLinkNew_OldSet();
        for (String code : codes) {
            Collection s2 = m3.get(code);
            if (s2 == null) continue;
            extras.addAll(s2);
        }
        extras.addAll(codes);
        TreeSet<String> icu4jTZIDs = new TreeSet<String>(Arrays.asList(TimeZone.getAvailableIDs()));
        TreeSet<String> diff2 = new TreeSet<String>((Collection<String>)icu4jTZIDs);
        diff2.removeAll(extras);
        System.out.println("icu4jTZIDs - StandardCodes: " + diff2);
        diff2 = new TreeSet(extras);
        diff2.removeAll(icu4jTZIDs);
        System.out.println("StandardCodes - icu4jTZIDs: " + diff2);
        ArrayComparator ac = new ArrayComparator(ArrayComparator.COMPARABLE, ArrayComparator.COMPARABLE, ArrayComparator.COMPARABLE);
        Map<String, String> zone_countries = sc.getZoneToCounty();
        TreeSet<Object[]> country_inflection_names = new TreeSet<Object[]>(ac);
        PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "inflections.txt");
        TreeMap<Integer, TreeSet<String>> minOffsetMap = new TreeMap<Integer, TreeSet<String>>();
        TreeMap<Integer, TreeSet<String>> maxOffsetMap = new TreeMap<Integer, TreeSet<String>>();
        for (String zoneID : codes) {
            String country = zone_countries.get(zoneID);
            TimeZone zone = TimeZone.getTimeZone(zoneID);
            ZoneInflections zip = new ZoneInflections(zone);
            out.println(zoneID + "\t" + zip);
            country_inflection_names.add(new Object[]{country, zip, zoneID});
            TreeSet<String> s3 = (TreeSet<String>)minOffsetMap.get(zip.getMinOffset());
            if (s3 == null) {
                s3 = new TreeSet<String>();
                minOffsetMap.put(zip.getMinOffset(), s3);
            }
            s3.add(zone.getID());
            s3 = (TreeSet<String>)maxOffsetMap.get(zip.getMaxOffset());
            if (s3 == null) {
                s3 = new TreeSet<String>();
                maxOffsetMap.put(zip.getMaxOffset(), s3);
            }
            s3.add(zone.getID());
        }
        System.out.println("Minimum Offset: " + minOffsetMap);
        System.out.println("Maximum Offset: " + maxOffsetMap);
        out.close();
        out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "modernTimezoneEquivalents.html");
        out.println("<html><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'><title>Modern Equivalent Timezones</title><style>");
        out.println("td.top,td.topr { background-color: #EEEEFF }");
        out.println("td.r,td.topr { text-align:right }");
        out.println("td.gap { font-weight:bold; border-top: 3px solid #0000FF; border-bottom: 3px solid #0000FF; background-color: #CCCCCC }");
        out.println("</style></head><body><table border='1' cellspacing='0' cellpadding='2' style='border-collapse: collapse'>");
        Tabber.HTMLTabber tabber1 = new Tabber.HTMLTabber();
        tabber1.setParameters(4, "class='r'");
        tabber1.setParameters(5, "class='r'");
        Tabber.HTMLTabber tabber2 = new Tabber.HTMLTabber();
        tabber2.setParameters(0, "class='top'");
        tabber2.setParameters(1, "class='top'");
        tabber2.setParameters(2, "class='top'");
        tabber2.setParameters(3, "class='top'");
        tabber2.setParameters(4, "class='topr'");
        tabber2.setParameters(5, "class='topr'");
        Tabber.HTMLTabber tabber3 = new Tabber.HTMLTabber();
        tabber3.setParameters(0, "class='gap'");
        tabber3.setParameters(1, "class='gap'");
        tabber3.setParameters(2, "class='gap'");
        tabber3.setParameters(3, "class='gap'");
        tabber3.setParameters(4, "class='gap'");
        tabber3.setParameters(5, "class='gap'");
        long minimumDate = ICUServiceBuilder.isoDateParse("2000-1-1T00:00:00Z").getTime();
        out.println("<h1>Modern Equivalent Timezones: <a target='_blank' href='instructions.html'>Instructions</a></h1>");
        out.println(ShowData.dateFooter());
        out.println("<p>Zones identical after: " + ICUServiceBuilder.isoDateFormat(minimumDate) + "</p>");
        String lastCountry = "";
        ZoneInflections.OutputLong diff = new ZoneInflections.OutputLong(0L);
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        TimezoneFormatter tzf = new TimezoneFormatter(cldrFactory, "en", true);
        Map<String, Set<String>> country_zoneSet = sc.getCountryToZoneSet();
        boolean shortList = true;
        boolean first = true;
        int category = 1;
        Tabber.HTMLTabber tabber = tabber1;
        for (Object[] row : country_inflection_names) {
            String country = (String)row[0];
            if (country.equals("001") || shortList && country_zoneSet.get(country).size() < 2) continue;
            ZoneInflections zip = (ZoneInflections)row[1];
            String zoneID = (String)row[2];
            if (!country.equals(lastCountry)) {
                if (first) {
                    first = false;
                }
                category = 1;
                CountItems.subheader(out, tabber3);
            } else if (diff.value >= minimumDate) {
                tabber = tabber == tabber1 ? tabber2 : tabber1;
                ++category;
            }
            Object zoneIDShown = zoneID;
            if (needsTranslation.contains(zoneID)) {
                zoneIDShown = "<b>" + (String)zoneIDShown + "\u00b9</b>";
            }
            if (singleCountries.contains(zoneID)) {
                zoneIDShown = "<i>" + (String)zoneIDShown + "</i> \u00b2";
            }
            if (defaultItems.contains(zoneID)) {
                zoneIDShown = "<span style='background-color: #FFFF00'>" + (String)zoneIDShown + "</span> ?";
            }
            Object newCountry = country;
            String mapLink = CountItems.country_map.get(country);
            if (mapLink != null) {
                newCountry = "<a target='map' href='" + mapLink + "'>" + country + "</a>";
            }
            String minOffset = ZoneInflections.formatHours(zip.getMinOffset(minimumDate));
            String maxOffset = ZoneInflections.formatHours(zip.getMaxOffset(minimumDate));
            if (!icu4jTZIDs.contains(zoneID)) {
                maxOffset = "??";
                minOffset = "??";
            }
            out.println(tabber.process((String)newCountry + "\t<b>" + category + "</b>\t" + (String)zoneIDShown + "\t" + tzf.getFormattedZone(zoneID, "vvvv", minimumDate, false) + "\t" + minOffset + "\t" + maxOffset));
            lastCountry = country;
        }
        CountItems.subheader(out, tabber3);
        out.println("</table>");
        out.println("<script>\nvar gaJsHost = ((\"https:\" == document.location.protocol) ? \"https://ssl.\" : \"http://www.\");\ndocument.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));\n</script>\n<script>\ntry {\nvar pageTracker = _gat._getTracker(\"UA-7672775-1\");\npageTracker._trackPageview();\n} catch(err) {}</script>");
        out.println("</body></html>");
        out.close();
    }
}

