/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.impl.Row;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Validity;

public class LsrvCanonicalizer {
    public static final Set<StandardCodes.LstrType> LSRV = ImmutableSet.of(StandardCodes.LstrType.language, StandardCodes.LstrType.script, StandardCodes.LstrType.region, StandardCodes.LstrType.variant);
    public static final Joiner UNDERBAR_JOINER = Joiner.on('_');
    private Set<ReplacementRule> rules = new TreeSet<ReplacementRule>();
    private Multimap<StandardCodes.LstrType, String> inType = TreeMultimap.create();
    private Map<StandardCodes.LstrType, String> irrelevant = new TreeMap<StandardCodes.LstrType, String>();
    private static final LsrvCanonicalizer SINGLETON = LsrvCanonicalizer.load();

    public static <K, V> Multimap<K, V> removeAll(Multimap<K, V> result, K key, Iterable<V> value) {
        for (V type : value) {
            result.remove(key, type);
        }
        return result;
    }

    private void add(ReplacementRule replacementRule) {
        this.getRules().add(replacementRule);
    }

    public String canonicalize(StandardCodes.LstrType lstrType, String languageTag) {
        XLanguageTag newTag = this.canonicalizeToX(XLanguageTag.fromTag(lstrType, languageTag), null);
        return newTag.toString();
    }

    public XLanguageTag canonicalizeToX(XLanguageTag fromTag, List<ReplacementRule> rulesUsed) {
        if (rulesUsed != null) {
            rulesUsed.clear();
        }
        XLanguageTag newTag = fromTag;
        block0: while (true) {
            for (ReplacementRule rule : this.getRules()) {
                XLanguageTag temp;
                if (!newTag.containsAll(rule.getType()) || (temp = newTag.replacePartsFrom(rule.getType(), rule.getReplacement())).equals(newTag)) continue;
                newTag = temp;
                if (rulesUsed == null) continue;
                rulesUsed.add(rule);
                continue block0;
            }
            break;
        }
        return newTag;
    }

    public Set<XLanguageTag> decanonicalizeToX(XLanguageTag fromTag) {
        HashSet<XLanguageTag> result = new HashSet<XLanguageTag>();
        result.add(fromTag);
        HashSet<XLanguageTag> intermediate = new HashSet<XLanguageTag>();
        while (true) {
            for (ReplacementRule rule : this.getRules()) {
                if (!rule.getType().get(StandardCodes.LstrType.variant).isEmpty()) continue;
                for (XLanguageTag newTag : result) {
                    XLanguageTag changed;
                    if (!newTag.containsAll(rule.getReplacement()) || intermediate.contains(changed = newTag.replacePartsFrom(rule.getReplacement(), rule.getType())) || result.contains(changed)) continue;
                    intermediate.add(changed);
                }
            }
            if (intermediate.isEmpty()) {
                result.remove(fromTag);
                return result;
            }
            result.addAll(intermediate);
            intermediate.clear();
        }
    }

    public List<ReplacementRule> filter(StandardCodes.LstrType lstrType, String value) {
        ArrayList<ReplacementRule> result = new ArrayList<ReplacementRule>();
        for (ReplacementRule rule : this.getRules()) {
            Collection<String> items = rule.getType().get(lstrType);
            if ((value != null || items.isEmpty()) && (value == null || !items.contains(value))) continue;
            result.add(rule);
        }
        return result;
    }

    public static final LsrvCanonicalizer getInstance() {
        return SINGLETON;
    }

    private static LsrvCanonicalizer load() {
        Object type;
        SupplementalDataInfo SDI = CLDRConfig.getInstance().getSupplementalDataInfo();
        Map<String, Map<String, Row.R2<List<String>, String>>> aliases = SDI.getLocaleAliasInfo();
        LsrvCanonicalizer rrs = new LsrvCanonicalizer();
        for (Map.Entry<String, Map<String, Row.R2<List<String>, String>>> typeTagReplacement : aliases.entrySet()) {
            type = typeTagReplacement.getKey();
            if (((String)type).contains("-")) {
                throw new IllegalArgumentException("Bad format for alias: should have _ instead of -.");
            }
            StandardCodes.LstrType lstrType = StandardCodes.LstrType.fromString((String)type);
            if (!LSRV.contains((Object)lstrType)) continue;
            for (Map.Entry entry : typeTagReplacement.getValue().entrySet()) {
                String tag = (String)entry.getKey();
                if (tag.contains("-")) {
                    throw new IllegalArgumentException("Bad format for alias: should have _ instead of -.");
                }
                List replacement = (List)((Row.R2)entry.getValue()).get0();
                if (replacement == null) {
                    System.out.println("No replacement: " + entry);
                    continue;
                }
                String reason = (String)((Row.R2)entry.getValue()).get1();
                ReplacementRule replacementRule = ReplacementRule.from(lstrType, tag, replacement, reason);
                if (replacementRule == null) continue;
                rrs.add(replacementRule);
            }
        }
        rrs.rules = ImmutableSet.copyOf(rrs.rules);
        for (ReplacementRule rule : rrs.rules) {
            type = rule.getType();
            XLanguageTag replacement = rule.getReplacement();
            for (StandardCodes.LstrType lstrType : LSRV) {
                rrs.inType.putAll(lstrType, ((XLanguageTag)type).get(lstrType));
                rrs.inType.putAll(lstrType, replacement.get(lstrType));
            }
        }
        rrs.inType = ImmutableMultimap.copyOf(rrs.inType);
        for (StandardCodes.LstrType lstrType : LSRV) {
            LinkedHashSet all = new LinkedHashSet(Validity.getInstance().getStatusToCodes(lstrType).get((Object)Validity.Status.regular));
            all.removeAll(rrs.inType.get(lstrType));
            if (lstrType == StandardCodes.LstrType.variant && all.contains("fonipa")) {
                rrs.irrelevant.put(lstrType, "fonipa");
                continue;
            }
            rrs.irrelevant.put(lstrType, (String)all.iterator().next());
        }
        rrs.irrelevant = ImmutableMap.copyOf(rrs.irrelevant);
        return rrs;
    }

    public Set<ReplacementRule> getRules() {
        return this.rules;
    }

    public Map<TestDataTypes, Map<String, String>> getTestData(Set<TestDataTypes> testDataTypes) {
        String toTest;
        TreeMap<String, String> testData2;
        TreeMap<TestDataTypes, Map<String, String>> result = new TreeMap();
        if (testDataTypes == null) {
            testDataTypes = EnumSet.allOf(TestDataTypes.class);
        }
        TreeSet allToTest = new TreeSet();
        if (testDataTypes.contains((Object)TestDataTypes.explicit)) {
            String[][] tests;
            testData2 = new TreeMap<String, String>();
            for (String[] row : tests = new String[][]{{"hye_arevmda", "hyw"}, {"art_lojban", "jbo"}, {"en_arevela", "en"}, {"hy_arevela", "hy"}, {"en_arevmda_arevela", "en"}, {"hy_arevmda", "hyw"}, {"hy_arevmda_arevela", "hyw"}, {"en_lojban", "en"}, {"en_US_polytoni", "en_US_polyton"}, {"en_US_heploc", "en_US_alalc97"}, {"en_US_aaland", "en_US"}, {"en_aaland", "en_AX"}, {"no_nynorsk_bokmal", "no"}, {"no_bokmal_nynorsk", "no"}, {"zh_guoyu_hakka_xiang", "hak"}, {"zh_hakka_xiang", "hak"}}) {
                toTest = row[0];
                String expected = row[1];
                testData2.put(toTest, expected);
            }
            allToTest.addAll(testData2.keySet());
            result.put(TestDataTypes.explicit, ImmutableMap.copyOf(testData2));
        }
        if (testDataTypes.contains((Object)TestDataTypes.fromAliases)) {
            testData2 = new TreeMap();
            for (ReplacementRule rule : this.getRules()) {
                String toTest2 = rule.getType().toLocaleString();
                String expected = rule.getReplacement().toLocaleString();
                if (allToTest.contains(toTest2)) continue;
                testData2.put(toTest2, expected);
            }
            allToTest.addAll(testData2.keySet());
            result.put(TestDataTypes.fromAliases, ImmutableMap.copyOf(testData2));
        }
        if (testDataTypes.contains((Object)TestDataTypes.decanonicalized)) {
            testData2 = new TreeMap();
            for (String testItem : allToTest) {
                for (XLanguageTag decon : this.decanonicalizeToX(XLanguageTag.fromTag(StandardCodes.LstrType.language, testItem))) {
                    XLanguageTag newTag = this.canonicalizeToX(decon, null);
                    toTest = decon.toLocaleString();
                    if (allToTest.contains(toTest)) continue;
                    testData2.put(toTest, newTag.toLocaleString());
                }
            }
            allToTest.addAll(testData2.keySet());
            result.put(TestDataTypes.decanonicalized, ImmutableMap.copyOf(testData2));
        }
        if (testDataTypes.contains((Object)TestDataTypes.withIrrelevants)) {
            testData2 = new TreeMap();
            for (String testItem : allToTest) {
                XLanguageTag fluffedUp = LsrvCanonicalizer.fluff(XLanguageTag.fromTag(StandardCodes.LstrType.language, testItem), this.irrelevant);
                XLanguageTag newTag = this.canonicalizeToX(fluffedUp, null);
                String toTest3 = fluffedUp.toLocaleString();
                if (allToTest.contains(toTest3)) continue;
                testData2.put(toTest3, newTag.toLocaleString());
            }
            allToTest.addAll(testData2.keySet());
            result.put(TestDataTypes.withIrrelevants, ImmutableMap.copyOf(testData2));
        }
        result = ImmutableMap.copyOf(result);
        return result;
    }

    private static XLanguageTag fluff(XLanguageTag type, Map<StandardCodes.LstrType, String> toAddIfMissing) {
        XLanguageTag newTag = type;
        for (StandardCodes.LstrType lstrType : LSRV) {
            if (!type.get(lstrType).isEmpty() && lstrType != StandardCodes.LstrType.variant) continue;
            newTag = newTag.set(lstrType, toAddIfMissing.get((Object)lstrType));
        }
        return newTag;
    }

    public Collection<String> getInType(StandardCodes.LstrType language) {
        return this.inType.get(language);
    }

    public String getIrrelevantField(StandardCodes.LstrType language) {
        return this.irrelevant.get((Object)language);
    }

    public static enum TestDataTypes {
        explicit,
        fromAliases,
        decanonicalized,
        withIrrelevants;

    }

    public static class ReplacementRule
    implements Comparable<ReplacementRule> {
        private final XLanguageTag typeParts;
        final XLanguageTag replacementParts;
        final List<XLanguageTag> secondaryReplacementSet;
        final String reason;
        final boolean regular;

        private ReplacementRule(StandardCodes.LstrType lstrType, String type, XLanguageTag typeParts, XLanguageTag replacementParts, List<XLanguageTag> secondaryReplacementSet, String reason) {
            this.typeParts = typeParts;
            this.replacementParts = replacementParts;
            this.secondaryReplacementSet = secondaryReplacementSet;
            this.reason = reason;
            this.regular = typeParts.keys().equals(replacementParts.keys()) && typeParts.get(StandardCodes.LstrType.variant).size() == replacementParts.get(StandardCodes.LstrType.variant).size();
        }

        static ReplacementRule from(StandardCodes.LstrType lstrType, String type, List<String> replacement, String reason) {
            XLanguageTag typeParts = XLanguageTag.fromTag(lstrType, type);
            if (typeParts == null) {
                return null;
            }
            XLanguageTag replacementParts = XLanguageTag.fromTag(lstrType, replacement.get(0));
            if (replacementParts == null) {
                return null;
            }
            ArrayList<XLanguageTag> secondaryReplacementSet = new ArrayList<XLanguageTag>();
            for (int i = 1; i < replacement.size(); ++i) {
                secondaryReplacementSet.add(XLanguageTag.fromTag(lstrType, replacement.get(i)));
            }
            return new ReplacementRule(lstrType, type, typeParts, replacementParts, secondaryReplacementSet, reason);
        }

        @Override
        public int compareTo(ReplacementRule o) {
            return ComparisonChain.start().compare(-this.getType().keys().size(), -o.getType().keys().size()).compare((Comparable<?>)((Object)this.getType().toString()), (Comparable<?>)((Object)o.getType().toString())).result();
        }

        public boolean equals(Object obj) {
            return this.compareTo((ReplacementRule)obj) == 0;
        }

        public int hashCode() {
            return Objects.hashCode(this.getType());
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("type", this.getType()).add("replacement", this.replacementParts).toString();
        }

        public XLanguageTag getType() {
            return this.typeParts;
        }

        public XLanguageTag getReplacement() {
            return this.replacementParts;
        }
    }

    public static class XLanguageTag {
        final Multimap<StandardCodes.LstrType, String> data;

        private XLanguageTag(Multimap<StandardCodes.LstrType, String> result) {
            this.data = ImmutableMultimap.copyOf(result);
        }

        public Set<StandardCodes.LstrType> keys() {
            return this.data.keySet();
        }

        public Collection<String> get(StandardCodes.LstrType lstrType) {
            return this.data.get(lstrType);
        }

        public String toLocaleString() {
            StringBuilder buffer = new StringBuilder();
            Collection<String> region = this.data.get(StandardCodes.LstrType.language);
            if (!region.isEmpty()) {
                buffer.append(UNDERBAR_JOINER.join(region));
            } else {
                buffer.append("und");
            }
            this.addItem(buffer, StandardCodes.LstrType.script, "", "_", UNDERBAR_JOINER);
            this.addItem(buffer, StandardCodes.LstrType.region, "", "_", UNDERBAR_JOINER);
            this.addItem(buffer, StandardCodes.LstrType.variant, "", "_", UNDERBAR_JOINER);
            return buffer.toString();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            this.addItem(buffer, StandardCodes.LstrType.language, "", "L:", UNDERBAR_JOINER);
            this.addItem(buffer, StandardCodes.LstrType.script, ";", "S:", UNDERBAR_JOINER);
            this.addItem(buffer, StandardCodes.LstrType.region, ";", "R:", UNDERBAR_JOINER);
            this.addItem(buffer, StandardCodes.LstrType.variant, ";", "V:", UNDERBAR_JOINER);
            return buffer.toString();
        }

        public void addItem(StringBuilder buffer, StandardCodes.LstrType lstrType, String separator, String prefix, Joiner dashJoiner) {
            Collection<String> region = this.data.get(lstrType);
            if (!region.isEmpty()) {
                if (buffer.length() > 0) {
                    buffer.append(separator);
                }
                buffer.append(prefix).append(dashJoiner.join(region));
            }
        }

        public static XLanguageTag fromTag(StandardCodes.LstrType lstrType, String tag) {
            TreeMultimap<StandardCodes.LstrType, String> result = TreeMultimap.create();
            LanguageTagParser source = new LanguageTagParser();
            boolean isLanguage = lstrType == StandardCodes.LstrType.language;
            String prefix = isLanguage ? "" : "und_";
            try {
                source.set(prefix + tag);
            }
            catch (Exception e) {
                return null;
            }
            if (!source.getLanguage().isEmpty() && !source.getLanguage().contains("und")) {
                result.put(StandardCodes.LstrType.language, source.getLanguage());
            }
            if (!source.getScript().isEmpty()) {
                result.put(StandardCodes.LstrType.script, source.getScript());
            }
            if (!source.getRegion().isEmpty()) {
                result.put(StandardCodes.LstrType.region, source.getRegion());
            }
            if (!source.getVariants().isEmpty()) {
                result.putAll(StandardCodes.LstrType.variant, source.getVariants());
            }
            return new XLanguageTag(result);
        }

        public boolean equals(Object obj) {
            return this.data.equals(((XLanguageTag)obj).data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public XLanguageTag set(StandardCodes.LstrType lstrType, String string) {
            TreeMultimap<StandardCodes.LstrType, String> result = TreeMultimap.create(this.data);
            if (lstrType != StandardCodes.LstrType.variant) {
                result.removeAll((Object)lstrType);
            }
            result.put(lstrType, string);
            return new XLanguageTag(result);
        }

        public boolean containsAll(XLanguageTag type) {
            for (StandardCodes.LstrType lstrType : LSRV) {
                Collection<String> types;
                Collection<String> sources = this.get(lstrType);
                if (sources.containsAll(types = type.get(lstrType))) continue;
                return false;
            }
            return true;
        }

        public XLanguageTag replacePartsFrom(XLanguageTag typeParts, XLanguageTag replacementParts) {
            TreeMultimap<StandardCodes.LstrType, String> result = TreeMultimap.create();
            for (StandardCodes.LstrType lstrType : LSRV) {
                Collection<String> sources = this.get(lstrType);
                Collection<String> types = typeParts.get(lstrType);
                Collection<String> replacements = replacementParts.get(lstrType);
                result.putAll(lstrType, sources);
                if (!types.isEmpty() && !replacements.isEmpty()) {
                    LsrvCanonicalizer.removeAll(result, lstrType, types);
                    result.putAll(lstrType, replacements);
                    continue;
                }
                if (!types.isEmpty() && replacements.isEmpty()) {
                    LsrvCanonicalizer.removeAll(result, lstrType, types);
                    continue;
                }
                if (!types.isEmpty() || replacements.isEmpty() || !sources.isEmpty()) continue;
                result.putAll(lstrType, replacements);
            }
            return new XLanguageTag(result);
        }
    }
}

