/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.text.UCharacterIterator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.MatchResult;

public class CharacterListCompressor {
    public static final String ascii = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!#$%()*+,-.:;<=>?@[]^_`{|}~";

    public static List<Integer> unicode2Base88(int code) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int rem = code % 88;
        list.add(rem);
        if ((code /= 88) != 0) {
            rem = code % 88;
            list.add(rem);
            code /= 88;
        }
        if (code != 0) {
            rem = code % 88;
            list.add(rem);
            rem = (code /= 88) % 88;
            list.add(rem);
            code /= 88;
        }
        return list;
    }

    public static int byteCount4Base88(int code) {
        int count = 0;
        if ((code /= 88) != 0) {
            count = 1;
            code /= 88;
        }
        if (code != 0) {
            count = 2;
        }
        return count;
    }

    public static List<Integer> compressPair2Base88(List<Integer> pair) {
        int value = pair.get(0);
        int type = pair.get(1);
        int code = value * 8 + type * 3;
        code += CharacterListCompressor.byteCount4Base88(code);
        return CharacterListCompressor.unicode2Base88(code);
    }

    public static List<List<Integer>> decodeBase88ToValueTypePairs(String str) {
        int leng;
        List<Integer> list = CharacterListCompressor.str2list(str);
        int metawindowsize = 8;
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
        for (int i = 0; i < list.size(); i += leng) {
            int c = list.get(i);
            int meta = c % metawindowsize;
            int type = meta / 3;
            leng = meta % 3 + 1;
            if (leng == 3) {
                ++leng;
            }
            int value = CharacterListCompressor.getCodeFromListAt(list, i, leng) / metawindowsize;
            CharacterListCompressor.addPair(result, value, type);
        }
        return result;
    }

    public static int getCodeFromListAt(List<Integer> list, int start, int leng) {
        int result = 0;
        for (int i = 0; i < leng; ++i) {
            int c = list.get(start + i);
            result = (int)((double)result + (double)c * Math.pow(88.0, i));
        }
        return result;
    }

    public static void addPair(List<List<Integer>> pairs, int value, int type) {
        ArrayList<Integer> pair = new ArrayList<Integer>();
        pair.add(value);
        pair.add(type);
        pairs.add(pair);
    }

    public static String encodeValueTypePairs2Base88(List<List<Integer>> pairs) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < pairs.size(); ++i) {
            List<Integer> pair = pairs.get(i);
            result.addAll(CharacterListCompressor.compressPair2Base88(pair));
        }
        return CharacterListCompressor.list2str(result);
    }

    public static String list2str(List<Integer> list) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            int code = list.get(i);
            str.append(ascii.charAt(code));
        }
        return str.toString();
    }

    public static List<Integer> str2list(String str) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            int code = ascii.indexOf(ch);
            list.add(code);
        }
        return list;
    }

    public static String base88EncodeList(List<Interval> intervalList) {
        List<List<Integer>> pairs = CharacterListCompressor.getValueTypePairsFromStrRangeList(intervalList);
        String encoded = CharacterListCompressor.encodeValueTypePairs2Base88(pairs);
        return encoded;
    }

    public static List<Interval> base88DecodeList(String base88String) {
        List<List<Integer>> pairs = CharacterListCompressor.decodeBase88ToValueTypePairs(base88String);
        List<Interval> decoded = CharacterListCompressor.getStrRangeListFromValueTypePairs(pairs);
        return decoded;
    }

    public static List<List<Integer>> getValueTypePairsFromStrRangeList(List<Interval> ilist) {
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
        int lastCode = 0;
        for (int i = 0; i < ilist.size(); ++i) {
            int value = 0;
            int first = ilist.get((int)i).first;
            int last = ilist.get((int)i).last;
            if (lastCode < first) {
                CharacterListCompressor.addPair(result, first - lastCode - 1, 0);
            } else if (lastCode > first) {
                CharacterListCompressor.addPair(result, lastCode - first - 1, 1);
            } else if (lastCode == first) {
                System.out.println("I am not expecting two contiguous chars to be the same");
            }
            lastCode = first;
            if (first >= last) continue;
            value = last - first - 1;
            int rangesize = 968;
            while (value >= rangesize) {
                CharacterListCompressor.addPair(result, rangesize - 1, 2);
                value -= rangesize;
                lastCode += rangesize;
            }
            CharacterListCompressor.addPair(result, value, 2);
            lastCode = last;
        }
        return result;
    }

    public static List<Interval> getStrRangeListFromValueTypePairs(List<List<Integer>> pairs) {
        ArrayList<Interval> result = new ArrayList<Interval>();
        int lastCode = 0;
        for (int i = 0; i < pairs.size(); ++i) {
            List<Integer> pair = pairs.get(i);
            int value = pair.get(0);
            int type = pair.get(1);
            if (type == 0) {
                CharacterListCompressor.addInterval(result, lastCode += value + 1, lastCode);
                continue;
            }
            if (type == 1) {
                CharacterListCompressor.addInterval(result, lastCode -= value + 1, lastCode);
                continue;
            }
            if (type != 2) continue;
            int first = lastCode + 1;
            int last = first + value;
            CharacterListCompressor.addInterval(result, first, last);
            lastCode += value + 1;
        }
        return result;
    }

    public static void addInterval(List<Interval> list, int first, int last) {
        Interval i = new Interval(first, last);
        list.add(i);
    }

    public static List<Interval> getStrRangeListFromRangeStr(String str) {
        int first;
        ArrayList<Interval> result = new ArrayList<Interval>();
        UCharacterIterator it = UCharacterIterator.getInstance(str);
        while ((first = it.nextCodePoint()) != -1) {
            int last = it.nextCodePoint();
            CharacterListCompressor.addInterval(result, first, last);
        }
        return result;
    }

    public static String strRangeList2string(List<Interval> ilist) {
        StringBuilder sbuild = new StringBuilder();
        for (int i = 0; i < ilist.size(); ++i) {
            int first = ilist.get((int)i).first;
            int last = ilist.get((int)i).last;
            for (int j = first; j <= last; ++j) {
                sbuild.appendCodePoint(j);
            }
        }
        return sbuild.toString();
    }

    public static String rangeString2string(String rstr) {
        int first;
        StringBuilder sbuild = new StringBuilder();
        UCharacterIterator it = UCharacterIterator.getInstance(rstr);
        while ((first = it.nextCodePoint()) != -1) {
            int last = it.nextCodePoint();
            for (int j = first; j <= last; ++j) {
                sbuild.appendCodePoint(j);
            }
        }
        return sbuild.toString();
    }

    public static boolean isStringsEqual(String s1, String s2) {
        UCharacterIterator it1 = UCharacterIterator.getInstance(s1);
        UCharacterIterator it2 = UCharacterIterator.getInstance(s2);
        int c1 = 0;
        int c2 = 0;
        int count = 0;
        while (c1 == c2 && c1 != -1) {
            ++count;
            c1 = it1.nextCodePoint();
            c2 = it2.nextCodePoint();
            System.out.print("Comparing c1 = c2 = ");
            System.out.print(c1);
            System.out.print((char)c1);
            System.out.print(" ; count = ");
            System.out.println(count);
        }
        System.out.print(count);
        System.out.println(" characters compared");
        if (c1 != c2) {
            System.out.print("Mismatch at c1 = ");
            System.out.print(c1);
            System.out.print(" c2 = ");
            System.out.println(c2);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        StringBuilder strBuild = new StringBuilder();
        try {
            Scanner sc = new Scanner(new File("/home/cibu/CharData.java"), "UTF-8");
            while (sc.hasNext()) {
                if (sc.findInLine("\\/\\*.*,\"(.*)\"},\\s*") != null) {
                    MatchResult match = sc.match();
                    String str = match.group(1);
                    str = str.replaceAll("\\\\(.)", "$1");
                    System.out.println(str);
                    strBuild.append(str);
                    continue;
                }
                sc.next();
            }
            sc.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        String str = strBuild.toString();
        if (str.length() == 0) {
            str = "\udbff\udc00\udbff\udffd\u0001\u0001";
        }
        List<Interval> ilist = CharacterListCompressor.getStrRangeListFromRangeStr(str);
        String encodedStr = CharacterListCompressor.base88EncodeList(ilist);
        List<Interval> decodedStrRangeList = CharacterListCompressor.base88DecodeList(encodedStr);
        String str1 = CharacterListCompressor.rangeString2string(str);
        String str2 = CharacterListCompressor.strRangeList2string(decodedStrRangeList);
        CharacterListCompressor.isStringsEqual(str1, str2);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter("/tmp/compressed.txt"));
            out.write(encodedStr);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static class Interval {
        int first;
        int last;

        public Interval(int first, int last) {
            this.first = first;
            this.last = last;
        }

        public String toString() {
            return "\u00ab" + this.first + "-" + this.last + "\u00bb";
        }

        public int first() {
            return this.first;
        }

        public int last() {
            return this.last;
        }
    }
}

