/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.Transliterator;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import org.unicode.cldr.util.CLDRTransforms;
import org.unicode.cldr.util.CldrUtility;

public class TestTransforms {
    public static void main(String[] args) throws IOException {
        boolean verbose = CldrUtility.getProperty("verbose", false);
        PrintWriter out = verbose ? new PrintWriter(System.out, true) : null;
        CLDRTransforms.verifyNullFilter("halfwidth-fullwidth");
        CLDRTransforms.registerCldrTransforms(null, ".*", out, false);
        if (out != null) {
            out.flush();
        }
        CLDRTransforms.verifyNullFilter("halfwidth-fullwidth");
        try {
            Class<?> ta = Class.forName("com.ibm.icu.dev.test.translit.TestAll");
            Object testAll = ta.newInstance();
            Method m3 = ta.getDeclaredMethod("main", String[].class);
            System.out.println("Starting ICU Test");
            m3.invoke(ta, new Object[]{args});
        }
        catch (Exception ex) {
            System.err.println("Could not load TestAll. Encountered exception: " + ex.toString());
            ex.printStackTrace();
        }
    }

    private static void checkRegistry() {
        CLDRTransforms.verifyNullFilter("halfwidth-fullwidth");
        Transliterator t = Transliterator.createFromRules("foo", "a > b; ::[:greek:] halfwidth-fullwidth;", 0);
        CLDRTransforms.verifyNullFilter("halfwidth-fullwidth");
        Transliterator.registerInstance(t);
        CLDRTransforms.verifyNullFilter("halfwidth-fullwidth");
    }

    private static void checkString(String id) {
        int dir1 = 0;
        int dir2 = 1;
        if (!id.startsWith("Latin")) {
            if (id.endsWith("Latin")) {
                dir2 = 0;
                dir1 = 1;
            } else {
                return;
            }
        }
        Transliterator t = Transliterator.getInstance(id, dir1);
        String test = t.transliterate("abcde");
        System.out.println("Test\t" + id + "\t" + dir1 + "\t" + test);
        Transliterator t2 = Transliterator.getInstance(id, dir2);
        String test2 = t2.transliterate(test);
        System.out.println("Test\t" + id + "\t" + dir2 + "\t" + test2);
    }
}

