/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.tool.Chart;
import org.unicode.cldr.tool.FormattedFileWriter;
import org.unicode.cldr.tool.TablePrinter;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileCopier;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class ChartCollation
extends Chart {
    static final String NOT_TAILORED = "notTailored";
    static final String NOT_EXEMPLARS = "notExemplars";
    private static final String KNOWN_PROBLEMS = "<ul>" + LS + "<li>The characters used in the illustration are:" + LS + "<ol>" + LS + "<li>those <span class='notTailored'>not tailored</span> (added from standard exemplars for context)</li>" + LS + "<li>those <span class='notExemplars'>tailored</span>, but not in any exemplars (standard, aux, punctuation)</li>" + LS + "<li>those both tailored and in exemplars</li>" + LS + "</ol>" + LS + "<li>The tailored characters may include:" + LS + "<ol>" + LS + "<li>some longer strings (contractions) from the rules</li>" + LS + "<li>generated Unicode characters (for <i>canonical closure</i>)</li>" + LS + "</ol>" + LS + "</li>" + LS + "</ul>" + LS;
    private static final Factory CLDR_FACTORY = CLDRConfig.getInstance().getCldrFactory();
    private static final boolean DEBUG = false;
    private static final String DIR = CLDRPaths.CHART_DIRECTORY + "collation/";

    public static void main(String[] args) {
        new ChartCollation().writeChart(null);
    }

    @Override
    public String getDirectory() {
        return DIR;
    }

    @Override
    public String getTitle() {
        return "Collation Charts";
    }

    @Override
    public String getFileName() {
        return "index";
    }

    @Override
    public String getExplanation() {
        return "<p>Collation tailorings provide language or locale-specific modifications of the standard Unicode CLDR collation order, which is based on <a target='_blank' href='http://unicode.org/charts/collation/'>Unicode default collation charts</a>. Locales that just use the standard CLDR order (<a href='root.html'>Root</a>) are not listed.</p>" + ChartCollation.dataScrapeMessage("/tr35-collation.html", "common/testData/units/unitsTest.txt", "common/collation") + LS;
    }

    @Override
    public void writeContents(FormattedFileWriter pw) throws IOException {
        FileCopier.ensureDirectoryExists(DIR);
        FileCopier.copy(Chart.class, "index.css", DIR);
        FormattedFileWriter.copyIncludeHtmls(DIR);
        FormattedFileWriter.Anchors anchors = new FormattedFileWriter.Anchors();
        this.writeSubcharts(anchors);
        pw.setIndex("Main Chart Index", "../index.html");
        pw.write(anchors.toString());
    }

    public void writeSubcharts(FormattedFileWriter.Anchors anchors) throws IOException {
        Matcher settingsMatcher = PatternCache.get("//ldml/collations/collation\\[@type=\"([^\"]+)\"](.*)?/(settings|import|cr)(.*)").matcher("");
        Splitter settingSplitter = Splitter.onPattern("[\\[\\]@]").omitEmptyStrings().trimResults();
        File baseDir = new File(CLDRPaths.COMMON_DIRECTORY + "collation/");
        Transliterator fromUnicode = Transliterator.getInstance("Hex-Any");
        ArrayList<Pair<String, String>> pathValueList = new ArrayList<Pair<String, String>>();
        HashSet<String> mainAvailable = new HashSet<String>(CLDR_FACTORY.getAvailable());
        for (String xmlName : baseDir.list()) {
            if (!xmlName.endsWith(".xml")) continue;
            String locale = xmlName.substring(0, xmlName.length() - 4);
            if (!mainAvailable.contains(locale)) {
                System.out.println("Skipping locale not in main: " + locale);
                continue;
            }
            pathValueList.clear();
            XMLFileReader.loadPathValues(CLDRPaths.COMMON_DIRECTORY + "collation/" + xmlName, pathValueList, true);
            TreeMap<String, Data> data = new TreeMap<String, Data>();
            for (Pair pair : pathValueList) {
                String path = (String)pair.getFirst();
                String value = (String)pair.getSecond();
                if (path.startsWith("//ldml/identity/")) continue;
                if (path.equals("//ldml/collations/defaultCollation")) {
                    this.addCollator(data, value, "defaultCollation", Arrays.asList("true"));
                    continue;
                }
                if (xmlName.equals("root.xml") && path.equals("//ldml/collations/collation[@type=\"standard\"]")) continue;
                XPathParts xpp = XPathParts.getFrozenInstance(path);
                CLDRFile.DraftStatus status = CLDRFile.DraftStatus.forString(xpp.findFirstAttributeValue("draft"));
                if (status == CLDRFile.DraftStatus.unconfirmed) {
                    System.out.println("Skipping " + path + " in: " + xmlName + " due to draft status = " + status.toString());
                    continue;
                }
                if (!settingsMatcher.reset(path).matches()) {
                    System.out.println("Failure in " + xmlName + " with: " + path);
                    continue;
                }
                String type = settingsMatcher.group(1);
                String otherAttributes = settingsMatcher.group(2);
                String leaf = settingsMatcher.group(3);
                String values = settingsMatcher.group(4);
                if (leaf.equals("settings") || leaf.equals("import")) {
                    List<String> settings = settingSplitter.splitToList(values);
                    this.addCollator(data, type, leaf, settings);
                    continue;
                }
                String rules = value;
                if (!rules.contains("'#\u20e3'")) {
                    rules = rules.replace("#\u20e3", "'#\u20e3'").replace("*\u20e3", "'*\u20e3'");
                }
                rules = fromUnicode.transform(rules);
                try {
                    RuleBasedCollator col = new RuleBasedCollator(rules);
                    col.setStrength(15);
                    col.freeze();
                    this.addCollator(data, type, col);
                }
                catch (Exception e) {
                    System.out.println("*** Skipping " + locale + ":" + type + ", " + e);
                }
            }
            if (data.isEmpty()) continue;
            if (!data.containsKey("standard")) {
                this.addCollator(data, "standard", null);
            }
            new Subchart(ENGLISH.getName(locale, true, CLDRFile.SHORT_ALTS), locale, data).writeChart(anchors);
        }
    }

    private void addCollator(Map<String, Data> data, String type, String leaf, List<String> settings) {
        Data dataItem;
        if (((String)type).startsWith("private-")) {
            type = "\uffff" + (String)type;
        }
        if ((dataItem = data.get(type)) == null) {
            dataItem = new Data();
            data.put((String)type, dataItem);
        }
        dataItem.settings.add(leaf + ":" + Joiner.on(";").join(settings));
    }

    private void addCollator(Map<String, Data> data, String type, RuleBasedCollator col) {
        if (((String)type).startsWith("private-")) {
            type = "\uffff\uffff" + (String)type;
        } else if (((String)type).equals("search")) {
            type = "\uffff" + (String)type;
        }
        Data dataItem = data.get(type);
        if (dataItem == null) {
            dataItem = new Data();
            data.put((String)type, dataItem);
        }
        dataItem.collator = col;
    }

    private class Subchart
    extends Chart {
        private static final String HIGH_COLLATION_PRIMARY = "\uffff";
        String title;
        String file;
        private Map<String, Data> data;

        @Override
        public boolean getShowDate() {
            return false;
        }

        public Subchart(String title, String file, Map<String, Data> data2) {
            this.title = title;
            this.file = file;
            this.data = data2;
        }

        @Override
        public String getDirectory() {
            return DIR;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getFileName() {
            return this.file;
        }

        @Override
        public String getExplanation() {
            return "<p>The following illustrates the ordering for the " + this.title + " collation tailorings. It does not show the <i>strength differences</i>, such as where case is ignored where there are letter differences.  The <i>search</i> order is special: it only used for comparing characters for similarity, so the order among the characters does not matter.  Where a type is not present, such as <i>emoji</i> or <i>search</i>, it defaults to the <a href='root.html'>Root</a> type.</p>" + LS + KNOWN_PROBLEMS + Subchart.dataScrapeMessage("/tr35-collation.html", null, "common/collation") + LS;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void writeContents(FormattedFileWriter pw) throws IOException {
            CLDRFile cldrFile = CLDR_FACTORY.make(this.file, true);
            UnicodeSet exemplars_all = new UnicodeSet();
            for (CLDRFile.ExemplarType exemplarType : CLDRFile.ExemplarType.values()) {
                UnicodeSet possExemplars = cldrFile.getExemplarSet(exemplarType, CLDRFile.WinningChoice.WINNING).freeze();
                exemplars_all.addAll(possExemplars);
            }
            for (Enum enum_ : CLDRFile.NumberingSystem.values()) {
                UnicodeSet exemplars_numeric = cldrFile.getExemplarsNumeric((CLDRFile.NumberingSystem)enum_);
                if (exemplars_numeric == null) continue;
                exemplars_all.addAll(exemplars_numeric);
            }
            exemplars_all.freeze();
            TablePrinter tablePrinter = new TablePrinter().addColumn("Type", "class='source'", null, "class='source'", true).addColumn("Ordering", "class='target'", null, "class='target_nofont'", true);
            for (Map.Entry<String, Data> entry : this.data.entrySet()) {
                void var7_15;
                String string = entry.getKey();
                if (string.startsWith(HIGH_COLLATION_PRIMARY)) {
                    String string2 = string.substring(1);
                }
                RuleBasedCollator col = entry.getValue().collator;
                Set<String> settings = entry.getValue().settings;
                StringBuilder list = new StringBuilder();
                if (!settings.isEmpty()) {
                    list.append(Joiner.on("<br>").join(settings));
                    list.append("<br><b><i>plus</i></b><br>");
                }
                if (col == null) {
                    list.append("<i>CLDR default character order</i>");
                } else {
                    UnicodeSet tailored = new UnicodeSet(col.getTailoredSet());
                    TreeSet<Object> sorted = new TreeSet<Object>(col);
                    exemplars_all.addAllTo(sorted);
                    tailored.addAllTo(sorted);
                    boolean first = true;
                    for (String string3 : sorted) {
                        if (first) {
                            first = false;
                        } else {
                            list.append(' ');
                        }
                        if (string3.startsWith("\ufdd0")) {
                            int len = list.length();
                            if (len <= 4 || !list.substring(len - 4, len).equals("<br>")) continue;
                            list.append("<br>");
                            continue;
                        }
                        if (!tailored.contains(string3)) {
                            list.append("<span class='notTailored'>").append(string3).append("</span>");
                            continue;
                        }
                        if (!exemplars_all.containsAll(string3) && !this.file.equals("root")) {
                            list.append("<span class='notExemplars'>").append(string3).append("</span>");
                            continue;
                        }
                        list.append(string3);
                    }
                }
                tablePrinter.addRow().addCell((Comparable)var7_15).addCell((Comparable)((Object)list.toString()));
                tablePrinter.finishRow();
            }
            pw.write(tablePrinter.toTable());
        }
    }

    static class Data {
        RuleBasedCollator collator;
        Set<String> settings = new LinkedHashSet<String>();

        Data() {
        }
    }
}

