/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.ibm.icu.dev.util.UnicodeMap;
import com.ibm.icu.dev.util.UnicodeMapIterator;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.Transform;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.ShowZoneEquivalences;
import org.unicode.cldr.tool.ToolConfig;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Iso639Data;
import org.unicode.cldr.util.IsoCurrencyParser;
import org.unicode.cldr.util.IsoRegionData;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Tabber;
import org.unicode.cldr.util.TimezoneFormatter;
import org.unicode.cldr.util.UnicodeSetPrettyPrinter;
import org.unicode.cldr.util.XPathParts;
import org.unicode.cldr.util.props.ICUPropertyFactory;

public class CountItems {
    private static final Collator ROOT_PRIMARY_COLLATOR = Collator.getInstance(ULocale.ROOT).setStrength2(0);
    static final String needsTranslationString = "America/Buenos_Aires  America/Manaus America/Belem  America/Campo_Grande America/Sao_Paulo  Australia/Perth Australia/Darwin Australia/Brisbane Australia/Adelaide Australia/Sydney Australia/Hobart  America/Vancouver America/Edmonton America/Regina America/Winnipeg America/Toronto America/Halifax America/St_Johns  Asia/Jakarta  America/Tijuana America/Hermosillo America/Chihuahua America/Mexico_City  Europe/Moscow Europe/Kaliningrad Europe/Moscow Asia/Yekaterinburg Asia/Novosibirsk Asia/Yakutsk Asia/Vladivostok Pacific/Honolulu America/Indiana/Indianapolis America/Anchorage  America/Los_Angeles America/Phoenix America/Denver America/Chicago America/Indianapolis America/New_York";
    static final ImmutableMap<String, String> country_map = ImmutableMap.builder().put("AQ", "http://www.worldtimezone.com/time-antarctica24.php").put("AR", "http://www.worldtimezone.com/time-south-america24.php").put("AU", "http://www.worldtimezone.com/time-australia24.php").put("BR", "http://www.worldtimezone.com/time-south-america24.php").put("CA", "http://www.worldtimezone.com/time-canada24.php").put("CD", "http://www.worldtimezone.com/time-africa24.php").put("CL", "http://www.worldtimezone.com/time-south-america24.php").put("CN", "http://www.worldtimezone.com/time-cis24.php").put("EC", "http://www.worldtimezone.com/time-south-america24.php").put("ES", "http://www.worldtimezone.com/time-europe24.php").put("FM", "http://www.worldtimezone.com/time-oceania24.php").put("GL", "http://www.worldtimezone.com/index24.php").put("ID", "http://www.worldtimezone.com/time-asia24.php").put("KI", "http://www.worldtimezone.com/time-oceania24.php").put("KZ", "http://www.worldtimezone.com/time-cis24.php").put("MH", "http://www.worldtimezone.com/time-oceania24.php").put("MN", "http://www.worldtimezone.com/time-cis24.php").put("MX", "http://www.worldtimezone.com/index24.php").put("MY", "http://www.worldtimezone.com/time-asia24.php").put("NZ", "http://www.worldtimezone.com/time-oceania24.php").put("PF", "http://www.worldtimezone.com/time-oceania24.php").put("PT", "http://www.worldtimezone.com/time-europe24.php").put("RU", "http://www.worldtimezone.com/time-russia24.php").put("SJ", "http://www.worldtimezone.com/index24.php").put("UA", "http://www.worldtimezone.com/time-cis24.php").put("UM", "http://www.worldtimezone.com/time-oceania24.php").put("US", "http://www.worldtimezone.com/time-usa24.php").put("UZ", "http://www.worldtimezone.com/time-cis24.php").build();
    static final SupplementalDataInfo supplementalData = SupplementalDataInfo.getInstance(CLDRPaths.SUPPLEMENTAL_DIRECTORY);
    static final StandardCodes sc = StandardCodes.make();
    private static final Pattern BreakerPattern = PatternCache.get("([-_A-Za-z0-9])[-/+_A-Za-z0-9]*");
    static final NumberFormat decimal = NumberFormat.getNumberInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        double deltaTime = System.currentTimeMillis();
        try {
            String methodName = System.getProperty("method");
            if (methodName != null) {
                CldrUtility.callMethod(methodName, CountItems.class);
            } else {
                ShowZoneEquivalences.getZoneEquivalences();
            }
        }
        finally {
            deltaTime = (double)System.currentTimeMillis() - deltaTime;
            System.out.println("Elapsed: " + deltaTime / 1000.0 + " seconds");
            System.out.println("Done");
        }
    }

    static void subheader(PrintWriter out, Tabber tabber) {
        out.println(tabber.process("Cnty\tGrp\tZoneID\tFormatted ID\tMaxOffset\tMinOffset"));
    }

    private static void getPatternBlocks() {
        UnicodeSet patterns = new UnicodeSet("[:pattern_syntax:]");
        UnicodeSet unassigned = new UnicodeSet("[:unassigned:]");
        UnicodeSet punassigned = new UnicodeSet(patterns).retainAll(unassigned);
        UnicodeMap blocks = ICUPropertyFactory.make().getProperty("block").getUnicodeMap();
        blocks.setMissing("<Reserved-Block>");
        UnicodeMapIterator it = new UnicodeMapIterator(blocks);
        while (it.nextRange()) {
            boolean show;
            UnicodeSet range = new UnicodeSet(it.codepoint, it.codepointEnd);
            boolean hasPat = range.containsSome(patterns);
            String prefix = !hasPat ? "Not-Syntax" : (!range.containsSome(unassigned) ? "Closed" : (!range.containsSome(punassigned) ? "Closed2" : "Open"));
            boolean bl = show = prefix.equals("Open") || prefix.equals("Closed2");
            if (show) {
                System.out.println();
            }
            System.out.println(prefix + "\t" + range + "\t" + (String)it.value);
            if (!show) continue;
            System.out.println(new UnicodeMap<String>().putAll(unassigned, "<reserved>").putAll(punassigned, "<reserved-for-syntax>").setMissing("<assigned>").putAll(range.complement(), null));
        }
    }

    private static void showExemplars() throws IOException {
        PrintWriter out = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY, "fixed_exemplars.txt");
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        Set<String> locales = cldrFactory.getAvailable();
        Iterator<String> it = locales.iterator();
        while (it.hasNext()) {
            UnicodeSet exemplars;
            System.out.print('.');
            String locale = it.next();
            CLDRFile cldrfile = cldrFactory.make(locale, false);
            String v = cldrfile.getStringValue("//ldml/characters/exemplarCharacters");
            if (v == null || (exemplars = new UnicodeSet(v)).size() == 0 || exemplars.size() >= 500) continue;
            Collator col = Collator.getInstance(new ULocale(locale));
            Collator spaceCol = Collator.getInstance(new ULocale(locale));
            spaceCol.setStrength(0);
            out.println(locale + ":\t\u200e" + v + "\u200e");
            String fixed = new UnicodeSetPrettyPrinter().setOrdering(col != null ? col : Collator.getInstance(ULocale.ROOT)).setSpaceComparator(spaceCol != null ? spaceCol : ROOT_PRIMARY_COLLATOR).setCompressRanges(true).format(exemplars);
            out.println(" =>\t\u200e" + fixed + "\u200e");
            CountItems.verifyEquality(exemplars, new UnicodeSet(fixed));
            out.flush();
        }
        out.close();
    }

    private static void verifyEquality(UnicodeSet exemplars, UnicodeSet others) {
        if (others.equals(exemplars)) {
            return;
        }
        System.out.println("FAIL\ta-b\t" + new UnicodeSet(exemplars).removeAll(others));
        System.out.println("\tb-a\t" + new UnicodeSet(others).removeAll(exemplars));
    }

    public static void generateSupplementalCurrencyItems() {
        IsoCurrencyParser isoCurrencyParser = IsoCurrencyParser.getInstance();
        Relation<String, IsoCurrencyParser.Data> codeList = isoCurrencyParser.getCodeList();
        TreeMap<CallSite, String> numericTocurrencyCode = new TreeMap<CallSite, String>();
        StringBuffer list = new StringBuffer();
        for (String currencyCode : codeList.keySet()) {
            int numericCode = -1;
            Set<IsoCurrencyParser.Data> dataSet = codeList.getAll(currencyCode);
            boolean first = true;
            for (IsoCurrencyParser.Data data : dataSet) {
                if (first) {
                    first = false;
                }
                numericCode = data.getNumericCode();
            }
            String strNumCode = "" + numericCode;
            String otherCode = (String)numericTocurrencyCode.get(strNumCode);
            if (otherCode != null) {
                System.out.println("Warning: duplicate code " + otherCode + "for " + numericCode);
            }
            numericTocurrencyCode.put((CallSite)((Object)strNumCode), currencyCode);
            if (list.length() != 0) {
                list.append(" ");
            }
            String currencyLine = "<currencyCodes type=\"" + currencyCode + "\" numeric=\"" + numericCode + "\"/>";
            list.append(currencyLine);
            System.out.println(currencyLine);
        }
        System.out.println();
    }

    public static void generateCurrencyItems() {
        IsoCurrencyParser isoCurrencyParser = IsoCurrencyParser.getInstance();
        Relation<String, IsoCurrencyParser.Data> codeList = isoCurrencyParser.getCodeList();
        StringBuffer list = new StringBuffer();
        for (String currencyCode : codeList.keySet()) {
            Set<IsoCurrencyParser.Data> dataSet = codeList.getAll(currencyCode);
            boolean first = true;
            for (IsoCurrencyParser.Data data : dataSet) {
                if (first) {
                    System.out.print(currencyCode);
                    first = false;
                }
                System.out.println("\t" + data);
            }
            if (list.length() != 0) {
                list.append(" ");
            }
            list.append(currencyCode);
        }
        System.out.println();
        String sep = "\n\t\t\t\t";
        String broken = CldrUtility.breakLines(list.toString(), sep, PatternCache.get("([A-Z])[A-Z][A-Z]").matcher(""), 80);
        assert (list.toString().equals(broken.replace(sep, " ")));
        Set<String> isoTextFileCodes = StandardCodes.make().getAvailableCodes("currency");
        TreeSet<String> temp = new TreeSet<String>(codeList.keySet());
        temp.removeAll(isoTextFileCodes);
        if (temp.size() != 0) {
            throw new IllegalArgumentException("Missing from ISO4217.txt file: " + temp);
        }
    }

    public static void genSupplementalZoneData() throws IOException {
        CountItems.genSupplementalZoneData(false);
    }

    public static void genSupplementalZoneData(boolean skipUnaliased) throws IOException {
        RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance();
        col.setNumericCollation(true);
        StandardCodes sc = StandardCodes.make();
        Map<String, String> zone_country = sc.getZoneToCounty();
        Map<String, Set<String>> country_zone = sc.getCountryToZoneSet();
        Factory cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        CLDRFile english = cldrFactory.make("en", true);
        CountItems.writeZonePrettyPath(col, zone_country, english);
        CountItems.writeMetazonePrettyPath();
        Map<String, String> old_new = sc.getZoneLinkold_new();
        TreeMap<String, TreeSet<String>> new_old = new TreeMap<String, TreeSet<String>>();
        for (String old : old_new.keySet()) {
            String newOne = old_new.get(old);
            TreeSet<String> oldSet = (TreeSet<String>)new_old.get(newOne);
            if (oldSet == null) {
                oldSet = new TreeSet<String>();
                new_old.put(newOne, oldSet);
            }
            oldSet.add(old);
        }
        TreeMap<Object, String> fullMap = new TreeMap<Object, String>(col);
        for (String zone : zone_country.keySet()) {
            String defaultName = TimezoneFormatter.getFallbackName(zone);
            Object already = fullMap.get(defaultName);
            if (already != null) {
                System.out.println("CONFLICT: " + already + ", " + zone);
            }
            fullMap.put(defaultName, zone);
        }
        System.out.println("<!-- Generated by org.unicode.cldr.tool.CountItems -->");
        System.out.println("<supplementalData>");
        System.out.println("\t<timezoneData>");
        System.out.println();
        TreeSet<String> multizone = new TreeSet<String>();
        for (String country : country_zone.keySet()) {
            Set<String> zones = country_zone.get(country);
            if (zones == null || zones.size() == 1) continue;
            multizone.add(country);
        }
        System.out.println("\t\t<zoneFormatting multizone=\"" + CountItems.toString(multizone, " ") + "\" tzidVersion=\"" + sc.getZoneVersion() + "\">");
        TreeSet<Object> orderedSet = new TreeSet<Object>(col);
        orderedSet.addAll(zone_country.keySet());
        orderedSet.addAll(sc.getDeprecatedZoneIDs());
        StringBuffer tzid = new StringBuffer();
        for (String string : orderedSet) {
            if (tzid.length() != 0) {
                tzid.append(' ');
            }
            tzid.append(string);
            String country = zone_country.get(string);
            if (country == null) continue;
            TreeSet aliases = (TreeSet)new_old.get(string);
            if (aliases != null) {
                aliases = new TreeSet(aliases);
                aliases.remove(string);
            }
            if (skipUnaliased && (aliases == null || aliases.size() == 0)) continue;
            System.out.println("\t\t\t<zoneItem type=\"" + string + "\" territory=\"" + country + "\"" + (String)(aliases != null && aliases.size() > 0 ? " aliases=\"" + CountItems.toString(aliases, " ") + "\"" : "") + "/>");
        }
        System.out.println("\t\t</zoneFormatting>");
        System.out.println();
        System.out.println("\t</timezoneData>");
        System.out.println("</supplementalData>");
        System.out.println();
        String sep = "\n\t\t\t\t";
        String string = CldrUtility.breakLines(tzid, sep, PatternCache.get("((?:[-+_A-Za-z0-9]+[/])+[-+_A-Za-z0-9])[-+_A-Za-z0-9]*").matcher(""), 80);
        assert (tzid.toString().equals(string.replace(sep, " ")));
        System.out.println("\t\t\t<variable id=\"$tzid\" type=\"choice\">" + string + "\n\t\t\t</variable>");
    }

    public static void writeMetazonePrettyPath() {
        CLDRConfig testInfo = ToolConfig.getToolInstance();
        Map<String, Map<String, String>> map = testInfo.getSupplementalDataInfo().getMetazoneToRegionToZone();
        Map<String, String> zoneToCountry = StandardCodes.make().getZoneToCounty();
        TreeSet<Pair<CallSite, String>> results = new TreeSet<Pair<CallSite, String>>();
        Map<String, String> countryToContinent = CountItems.getCountryToContinent(testInfo.getSupplementalDataInfo(), testInfo.getEnglish());
        for (String string : map.keySet()) {
            Map<String, String> regionToZone = map.get(string);
            String zone = regionToZone.get("001");
            if (zone == null) {
                throw new IllegalArgumentException("Missing 001 for metazone " + string);
            }
            String continent = zone.split("/")[0];
            String country = zoneToCountry.get(zone);
            results.add(new Pair<CallSite, String>((CallSite)((Object)(continent + "\t" + country + "\t" + countryToContinent.get(country) + "\t" + string)), string));
        }
        for (Pair pair : results) {
            System.out.println("'" + (String)pair.getSecond() + "'\t>\t'\t" + (String)pair.getFirst() + "\t'");
        }
    }

    private static Map<String, String> getCountryToContinent(SupplementalDataInfo supplementalDataInfo, CLDRFile english) {
        Relation<String, String> countryToContinent = Relation.of(new TreeMap(), TreeSet.class);
        HashSet<String> continents = new HashSet<String>(Arrays.asList("002", "019", "142", "150", "009"));
        for (String continent : continents) {
            Set<String> subcontinents = supplementalDataInfo.getContained(continent);
            countryToContinent.putAll(subcontinents, continent);
            for (String subcontinent : subcontinents) {
                if (subcontinent.equals("EU")) continue;
                Set<String> countries = supplementalDataInfo.getContained(subcontinent);
                countryToContinent.putAll(countries, continent);
            }
        }
        TreeMap<String, String> results = new TreeMap<String, String>();
        for (String item : countryToContinent.keySet()) {
            Set containees = countryToContinent.getAll(item);
            if (containees.size() != 1) {
                throw new IllegalArgumentException(item + "\t" + containees);
            }
            results.put(item, english.getName(2, (String)containees.iterator().next()));
        }
        return results;
    }

    private static void writeZonePrettyPath(RuleBasedCollator col, Map<String, String> zone_country, CLDRFile english) throws IOException {
        System.out.println("Writing zonePrettyPath");
        HashSet<String> masked = new HashSet<String>();
        TreeMap<Object, String> zoneNew_Old = new TreeMap<Object, String>(col);
        String lastZone = "XXX";
        for (String zone : new TreeSet<String>(zone_country.keySet())) {
            Object newName;
            Object[] parts = zone.split("/");
            String newPrefix = zone_country.get(zone);
            if (newPrefix.equals("001")) {
                newPrefix = "ZZ";
            }
            parts[0] = newPrefix;
            if (parts.length > 2) {
                System.out.println("\tMultifield: " + zone);
                newName = parts.length == 3 && ((String)parts[1]).equals("Argentina") ? (String)parts[0] + "/" + (String)parts[1] : CldrUtility.join(parts, "/");
            } else {
                newName = CldrUtility.join(parts, "/");
            }
            zoneNew_Old.put(newName, zone);
            if (zone.startsWith(lastZone)) {
                masked.add(zone);
                continue;
            }
            lastZone = zone;
        }
        Log.setLog(CLDRPaths.GEN_DIRECTORY + "/supplemental/prettyPathZone.txt");
        String lastCountry = "";
        for (int i = 0; i < 2; ++i) {
            Set orderedList = zoneNew_Old.keySet();
            if (i == 0) {
                Log.println("# Short IDs for zone names: country code + last part of TZID");
                Log.println("# First are items that would be masked, and are moved forwards and sorted in reverse order");
                Log.println();
                TreeSet<Object> temp = new TreeSet<Object>(new ReverseComparator<Object>(col));
                temp.addAll(orderedList);
                orderedList = temp;
            } else {
                Log.println();
                Log.println("# Normal items, sorted by country code");
                Log.println();
            }
            for (Object newName : orderedList) {
                String oldName = (String)zoneNew_Old.get(newName);
                if (masked.contains(oldName) != (i == 0)) continue;
                String newCountry = ((String)newName).split("/")[0];
                if (!newCountry.equals(lastCountry)) {
                    Log.println("# " + newCountry + "\t" + english.getName("territory", newCountry));
                    lastCountry = newCountry;
                }
                Log.println("\t'" + oldName + "'\t>\t'" + (String)newName + "';");
            }
        }
        Log.close();
        System.out.println("Done Writing zonePrettyPath");
    }

    public static void getSubtagVariables2() throws IOException {
        Log.setLogNoBOM(CLDRPaths.GEN_DIRECTORY + "/supplemental", "supplementalMetadata.xml");
        BufferedReader oldFile = FileUtilities.openUTF8Reader(CLDRPaths.SUPPLEMENTAL_DIRECTORY, "supplementalMetadata.xml");
        CldrUtility.copyUpTo(oldFile, PatternCache.get("\\s*<!-- start of data generated with CountItems.*"), Log.getLog(), true);
        Map<String, String> variableSubstitutions = CountItems.getVariables(VariableType.partial);
        for (Map.Entry<String, String> type : variableSubstitutions.entrySet()) {
            Log.println(type.getValue());
        }
        CldrUtility.copyUpTo(oldFile, PatternCache.get("\\s<!-- end of data generated by CountItems.*"), null, true);
        CldrUtility.copyUpTo(oldFile, null, Log.getLog(), true);
        Log.close();
        oldFile.close();
    }

    /*
     * WARNING - void declaration
     */
    public static void getSubtagVariables() {
        String alpha3;
        String numeric;
        List replacements;
        String biblio;
        System.out.println("Language aliases");
        System.out.println("Cut/paste into supplementalMetadata.xml under the line");
        System.out.println("<!-- start of data generated with CountItems tool ...");
        Map<String, Map<String, String>> languageReplacement = StandardCodes.getLStreg().get("language");
        Map<String, Map<String, Row.R2<List<String>, String>>> localeAliasInfo = supplementalData.getLocaleAliasInfo();
        Map<String, Row.R2<List<String>, String>> languageAliasInfo = localeAliasInfo.get("language");
        Set<String> available = Iso639Data.getAvailable();
        HashSet<String> bad3letter = new HashSet<String>();
        for (String string : available) {
            void var10_13;
            if (string.length() != 2) continue;
            String target = string;
            Map<String, String> lstregData = languageReplacement.get(string);
            if (lstregData == null) {
                throw new IllegalArgumentException("illegal language code");
            }
            String replacement = lstregData.get("Preferred-Value");
            if (replacement != null) {
                target = replacement;
            }
            String alpha32 = Iso639Data.toAlpha3(string);
            bad3letter.add(alpha32);
            if (languageAliasInfo.containsKey(target)) {
                String string2 = Joiner.on(" ").join((Iterable)languageAliasInfo.get(target).get0());
            } else {
                String string3 = target;
            }
            System.out.println("\t\t\t<languageAlias type=\"" + alpha32 + "\" replacement=\"" + (String)var10_13 + "\" reason=\"overlong\"/> <!-- " + Iso639Data.getNames(target) + " -->");
        }
        System.out.println("\t\t\t<!-- Bibliographic -->");
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        for (String hasBiblio : Iso639Data.hasBiblio3()) {
            biblio = Iso639Data.toBiblio3(hasBiblio);
            sorted.put(biblio, hasBiblio);
        }
        for (Map.Entry entry : sorted.entrySet()) {
            biblio = (String)entry.getKey();
            String hasBiblio = (String)entry.getValue();
            System.out.println("\t\t\t<languageAlias type=\"" + biblio + "\" replacement=\"" + (String)hasBiblio + "\" reason=\"bibliographic\"/> <!-- " + Iso639Data.getNames(hasBiblio) + " -->");
        }
        System.out.println("<!-- end of Language alises generated with CountItems tool ...");
        Set<String> set = Iso639Data.getEncompassed();
        Set<String> macros = Iso639Data.getMacros();
        HashMap<String, String> encompassed_macro = new HashMap<String, String>();
        for (Map.Entry entry : languageAliasInfo.entrySet()) {
            Iterator<String> replacement;
            String type = (String)entry.getKey();
            Row.R2 data = (Row.R2)entry.getValue();
            replacements = (List)data.get0();
            if (!set.contains(type) || replacements == null || replacements.size() != 1 || !macros.contains(replacement = (String)replacements.get(0))) continue;
            encompassed_macro.put(type, (String)((Object)replacement));
        }
        TreeSet<String> missing = new TreeSet<String>();
        missing.addAll(macros);
        missing.remove("no");
        missing.remove("sh");
        missing.removeAll(encompassed_macro.values());
        if (missing.size() != 0) {
            for (String missingMacro : missing) {
                System.err.println("ERROR: Missing <languageAlias type=\"???\" replacement=\"" + missingMacro + "\"/> <!-- ??? => " + Iso639Data.getNames(missingMacro) + " -->");
                System.out.println("\tOptions for ???:");
                for (String enc : Iso639Data.getEncompassedForMacro(missingMacro)) {
                    System.out.println("\t" + enc + "\t// " + Iso639Data.getNames(enc));
                }
            }
        }
        for (Map.Entry<String, Row.R2<List<String>, String>> typeAndData : languageAliasInfo.entrySet()) {
            String type = typeAndData.getKey();
            replacements = (List)typeAndData.getValue().get0();
            if (replacements == null) continue;
            for (String replacement : replacements) {
                if (!bad3letter.contains(replacement)) continue;
                System.err.println("ERROR: Replacement(s) for type=\"" + type + "\" contains " + replacement + ", which should be: " + Iso639Data.fromAlpha3(replacement));
            }
        }
        Factory factory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        CLDRFile english = factory.make("en", true);
        TreeSet<String> territories = new TreeSet<String>();
        Relation<String, String> containers = supplementalData.getTerritoryToContained();
        for (String region : sc.getAvailableCodes("territory")) {
            if (containers.containsKey(region)) continue;
            territories.add(region);
        }
        System.out.println();
        System.out.println("Territory aliases");
        System.out.println("Cut/paste into supplementalMetadata.xml under the line");
        System.out.println("<!-- start of data generated with CountItems tool ...");
        CountItems.addRegions(english, territories, "alpha3", "EA,EU,IC".split(","), new Transform<String, String>(){

            @Override
            public String transform(String region) {
                return IsoRegionData.get_alpha3(region);
            }
        });
        CountItems.addRegions(english, territories, "numeric", "AC,CP,DG,EA,EU,IC,TA".split(","), new Transform<String, String>(){

            @Override
            public String transform(String region) {
                return IsoRegionData.getNumeric(region);
            }
        });
        System.out.println("<!-- end of Territory alises generated with CountItems tool ...");
        System.out.println();
        System.out.println("Deprecated codes check (informational)");
        Map<String, Map<String, Map<String, String>>> fullData = StandardCodes.getLStreg();
        CountItems.checkCodes("language", sc, localeAliasInfo, fullData);
        CountItems.checkCodes("script", sc, localeAliasInfo, fullData);
        CountItems.checkCodes("territory", sc, localeAliasInfo, fullData);
        System.out.println("End of Deprecated codes check...");
        System.out.println();
        System.out.println("Mapping equivalences - (Informational only...)");
        System.out.println("{ bib , tech , bcp47 }");
        TreeSet<Row.R3<String, String, String>> rows = new TreeSet<Row.R3<String, String, String>>();
        for (String string : Iso639Data.getAvailable()) {
            String bib = Iso639Data.toBiblio3(string);
            String tech = Iso639Data.toAlpha3(string);
            Row.R3<String, String, String> row = Row.of(tech, bib, string);
            rows.add(row);
        }
        for (Row.R3 r3 : rows) {
            String tech = (String)r3.get0();
            String bib = (String)r3.get1();
            String lang = (String)r3.get2();
            String name = Iso639Data.getNames(lang).iterator().next();
            if ((bib == null || lang.equals(bib)) && (tech == null || lang.equals(tech))) continue;
            System.out.println("  { \"" + bib + "\", \"" + tech + "\", \"" + lang + "\" },  // " + name);
        }
        System.out.println("End of Mapping equivalences...");
        System.out.println();
        System.out.println("Code Mappings");
        System.out.println("Cut/paste into supplementaData.xml under the line");
        System.out.println("<!-- start of data generated with CountItems tool ...");
        ArrayList warnings = new ArrayList();
        territories.add("QO");
        territories.add("EU");
        Relation<String, String> relation = Relation.of(new HashMap(), TreeSet.class);
        Relation<String, String> alpha32region = Relation.of(new HashMap(), TreeSet.class);
        for (String region : territories) {
            numeric = IsoRegionData.getNumeric(region);
            alpha3 = IsoRegionData.get_alpha3(region);
            relation.put(numeric, region);
            alpha32region.put(alpha3, region);
        }
        System.out.println("    <codeMappings>");
        for (String region : territories) {
            numeric = IsoRegionData.getNumeric(region);
            alpha3 = IsoRegionData.get_alpha3(region);
            String fips10 = IsoRegionData.get_fips10(region);
            System.out.println("        <territoryCodes type=\"" + region + "\"" + (String)(numeric == null ? "" : " numeric=\"" + numeric + "\"") + (String)(alpha3 == null ? "" : " alpha3=\"" + alpha3 + "\"") + (String)(fips10 == null || fips10.equals(region) ? "" : " fips10=\"" + fips10 + "\"") + "/>");
        }
        System.out.println("    </codeMappings>");
        System.out.println("<!-- end of Code Mappings generated with CountItems tool ...");
        System.out.println(Joiner.on("\n").join(warnings));
    }

    public static Map<String, String> getVariables(VariableType variableType) {
        String sep = "\n\t\t\t\t";
        LinkedHashMap<String, String> variableSubstitutions = new LinkedHashMap<String, String>();
        for (String type : new String[]{"legacy", "territory", "script", "variant"}) {
            Set<String> i = variableType == VariableType.full || type.equals("legacy") ? sc.getAvailableCodes(type) : sc.getGoodAvailableCodes(type);
            CountItems.addVariable(variableSubstitutions, type, i, sep);
        }
        Relation<String, String> bcp47Keys = supplementalData.getBcp47Keys();
        Relation<Row.R2<String, String>, String> aliases = supplementalData.getBcp47Aliases();
        for (String key : bcp47Keys.keySet()) {
            Set<String> keyAliases = aliases.getAll(Row.of(key, ""));
            Set<String> rawsubtypes = bcp47Keys.getAll(key);
            TreeSet<String> subtypes = new TreeSet<String>();
            for (String subtype : rawsubtypes) {
                Set<String> keySubtypeAliases = aliases.getAll(Row.of(key, subtype));
                if (keySubtypeAliases == null) continue;
                subtypes.addAll(keySubtypeAliases);
            }
            subtypes.addAll(rawsubtypes);
            String alias = (keyAliases == null ? key : keyAliases.iterator().next()) + "_XXX";
            CountItems.addVariable(variableSubstitutions, alias, subtypes, sep);
        }
        return variableSubstitutions;
    }

    private static void addVariable(Map<String, String> variableSubstitutions, String type, Set<String> sinput, String sep) {
        TreeSet<Object> s2 = new TreeSet<Object>(ROOT_PRIMARY_COLLATOR);
        s2.addAll(sinput);
        StringBuffer b = new StringBuffer();
        for (String string : s2) {
            if (b.length() != 0) {
                b.append(' ');
            }
            b.append(string);
        }
        String broken = CldrUtility.breakLines(b, sep, BreakerPattern.matcher(""), 80);
        assert (b.toString().equals(broken.replace(sep, " ")));
        variableSubstitutions.put(type, "\t\t\t<variable id=\"$" + type + "\" type=\"choice\">" + broken + "\n\t\t\t</variable>");
    }

    private static void checkCodes(String type, StandardCodes sc, Map<String, Map<String, Row.R2<List<String>, String>>> localeAliasInfo, Map<String, Map<String, Map<String, String>>> fullData) {
        Map<String, Map<String, String>> typeData = fullData.get("territory".equals(type) ? "region" : type);
        Map<String, Row.R2<List<String>, String>> aliasInfo = localeAliasInfo.get(type);
        for (String code : sc.getAvailableCodes(type)) {
            Map<String, String> subdata = typeData.get(code);
            String deprecated = subdata.get("Deprecated");
            if (deprecated == null) continue;
            String replacement = subdata.get("Preferred-Value");
            Row.R2<List<String>, String> supplementalReplacements = aliasInfo.get(code);
            if (supplementalReplacements != null) continue;
            System.out.println("Deprecated in LSTR, but not in supplementalData: " + type + "\t" + code + "\t" + replacement);
        }
    }

    private static void addRegions(CLDRFile english, Set<String> availableCodes, String codeType, String[] exceptions, Transform<String, String> trans) {
        TreeSet<String> missingRegions = new TreeSet<String>();
        HashSet<String> exceptionSet = new HashSet<String>(Arrays.asList(exceptions));
        ArrayList<CallSite> duplicateDestroyer = new ArrayList<CallSite>();
        for (String region : availableCodes) {
            String name;
            if (exceptionSet.contains(region)) continue;
            String alpha3 = trans.transform(region);
            if (alpha3 == null) {
                missingRegions.add(region);
                continue;
            }
            Map<String, Row.R2<List<String>, String>> territoryAliasInfo = supplementalData.getLocaleAliasInfo().get("territory");
            String result = territoryAliasInfo.containsKey(region) ? Joiner.on(" ").join((Iterable)territoryAliasInfo.get(region).get0()) : region;
            if (duplicateDestroyer.contains(alpha3 + result + (name = english.getName(2, result)))) continue;
            duplicateDestroyer.add((CallSite)((Object)(alpha3 + result + name)));
            System.out.println("\t\t\t<territoryAlias type=\"" + alpha3 + "\" replacement=\"" + result + "\" reason=\"overlong\"/> <!-- " + name + " -->");
        }
        for (String region : missingRegions) {
            String name = english.getName(2, region);
            System.err.println("ERROR: Missing " + codeType + " code for " + region + "\t" + name);
        }
    }

    private static String toString(Collection aliases, String separator) {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        for (Object item : aliases) {
            if (first) {
                first = false;
            } else {
                result.append(separator);
            }
            result.append(item);
        }
        return result.toString();
    }

    public static void showZoneInfo() throws IOException {
        StandardCodes sc = StandardCodes.make();
        Map<String, String> m3 = sc.getZoneLinkold_new();
        int i = 0;
        System.out.println("/* Generated by org.unicode.cldr.tool.CountItems */");
        System.out.println();
        i = 0;
        System.out.println("/* zoneID, canonical zoneID */");
        for (String old : m3.keySet()) {
            String newOne = m3.get(old);
            System.out.println("{\"" + old + "\", \"" + newOne + "\"},");
            ++i;
        }
        System.out.println("/* Total: " + i + " */");
        System.out.println();
        i = 0;
        System.out.println("/* All canonical zoneIDs */");
        for (String old : sc.getZoneData().keySet()) {
            System.out.println("\"" + old + "\",");
            ++i;
        }
        System.out.println("/* Total: " + i + " */");
        Factory mainCldrFactory = Factory.make(CLDRPaths.COMMON_DIRECTORY + "main" + File.separator, ".*");
        CLDRFile desiredLocaleFile = mainCldrFactory.make("root", true);
        String temp = desiredLocaleFile.getFullXPath("//ldml/dates/timeZoneNames/singleCountries");
        XPathParts parts = XPathParts.getFrozenInstance(temp);
        String singleCountriesList = parts.findAttributes("singleCountries").get("list");
        TreeSet<String> singleCountriesSet = new TreeSet<String>(CldrUtility.splitList(singleCountriesList, ' '));
        Map<String, String> zone_countries = StandardCodes.make().getZoneToCounty();
        Map<String, Set<String>> countries_zoneSet = StandardCodes.make().getCountryToZoneSet();
        System.out.println();
        i = 0;
        System.out.println("/* zoneID, country, isSingle */");
        for (String old : zone_countries.keySet()) {
            String newOne = zone_countries.get(old);
            Set<String> s2 = countries_zoneSet.get(newOne);
            String isSingle = s2 != null && s2.size() == 1 || singleCountriesSet.contains(old) ? "T" : "F";
            System.out.println("{\"" + old + "\", \"" + newOne + "\", \"" + isSingle + "\"},");
            ++i;
        }
        System.out.println("/* Total: " + i + " */");
    }

    public static void countItems() {
        String dir = CldrUtility.getProperty("source", CLDRPaths.MAIN_DIRECTORY);
        Factory cldrFactory = Factory.make(dir, ".*");
        CountItems.countItems(cldrFactory, false);
    }

    private static int countItems(Factory cldrFactory, boolean resolved) {
        int count = 0;
        int resolvedCount = 0;
        Set<String> locales = cldrFactory.getAvailable();
        HashSet<String> keys = new HashSet<String>();
        HashSet<String> values = new HashSet<String>();
        HashSet<String> fullpaths = new HashSet<String>();
        Matcher alt = CLDRFile.ALT_PROPOSED_PATTERN.matcher("");
        HashSet<String> temp = new HashSet<String>();
        for (String locale : locales) {
            if (CLDRFile.isSupplementalName(locale)) continue;
            CLDRFile item = cldrFactory.make(locale, false);
            temp.clear();
            for (String path : item) {
                if (alt.reset(path).matches()) continue;
                temp.add(path);
                keys.add(path);
                values.add(item.getStringValue(path));
                fullpaths.add(item.getFullXPath(path));
            }
            int current = temp.size();
            CLDRFile itemResolved = cldrFactory.make(locale, true);
            temp.clear();
            itemResolved.forEach(temp::add);
            int resolvedCurrent = temp.size();
            System.out.println(locale + "\tPlain:\t" + current + "\tResolved:\t" + resolvedCurrent + "\tUnique Paths:\t" + keys.size() + "\tUnique Values:\t" + values.size() + "\tUnique Full Paths:\t" + fullpaths.size());
            count += current;
            resolvedCount += resolvedCurrent;
        }
        System.out.println("Total Items\t" + decimal.format(count));
        System.out.println("Total Resolved Items\t" + decimal.format(resolvedCount));
        System.out.println("Unique Paths\t" + decimal.format(keys.size()));
        System.out.println("Unique Values\t" + decimal.format(values.size()));
        System.out.println("Unique Full Paths\t" + decimal.format(fullpaths.size()));
        return count;
    }

    static {
        decimal.setGroupingUsed(true);
    }

    static enum VariableType {
        full,
        partial;

    }

    public static class ReverseComparator<T>
    implements Comparator<T> {
        Comparator<T> other;

        public ReverseComparator(Comparator<T> other) {
            this.other = other;
        }

        @Override
        public int compare(T o1, T o2) {
            return this.other.compare(o2, o1);
        }
    }
}

