/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableSet;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.ChainedMap;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.VoteResolver;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class ReadSql {
    static final boolean DEBUG = false;
    static UserMap umap = new UserMap(CLDRPaths.DATA_DIRECTORY + "cldr/users.xml");
    static Organization organization;
    static boolean verbose;
    static final Pattern INSERT;
    static final DateFormat df;

    public static void main(String[] args) throws IOException {
        MyOptions.parse(args, true);
        organization = Organization.valueOf(MyOptions.organization.option.getValue());
        verbose = MyOptions.verbose.option.doesOccur();
        long max = Long.MAX_VALUE;
        long maxItems = 10L;
        boolean inCreate = false;
        try (BufferedReader r = FileUtilities.openFile(CLDRPaths.DATA_DIRECTORY, "cldr/cldr-DUMP-20160817.sql");){
            while (--max > 0L) {
                String line = r.readLine();
                if (line == null) {
                    break;
                }
                if (line.startsWith("INSERT")) {
                    Data.parseLine(line, maxItems);
                    continue;
                }
                if (line.startsWith("CREATE")) {
                    inCreate = true;
                    if (!verbose) continue;
                    System.out.println(line);
                    continue;
                }
                if (!inCreate) continue;
                if (verbose) {
                    System.out.println(line);
                }
                if (!line.startsWith(") ENGINE")) continue;
                inCreate = false;
            }
        }
        Counter<String> keys = Data.getKeys();
        for (Row.R2<Long, String> e : keys.getEntrySetSortedByCount(false, null)) {
            if ((Long)e.get0() <= 0L) continue;
            System.out.println(CldrUtility.toString(e));
        }
        Data.show("_30");
    }

    private static String trunc(String line, int len) {
        return line.length() <= len ? line : line.substring(0, len) + "\u2026";
    }

    static {
        INSERT = Pattern.compile("INSERT\\s+INTO\\s+`([^`]+)`\\s+VALUES\\s*");
        df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    static class UserMap {
        Map<Integer, User> map = new HashMap<Integer, User>();

        UserMap(String filename) {
            ArrayList<Pair<String, String>> data = new ArrayList<Pair<String, String>>();
            XMLFileReader.loadPathValues(filename, data, false);
            for (Pair pair : data) {
                String path = (String)pair.getFirst();
                XPathParts parts = XPathParts.getFrozenInstance(path);
                User user = new User(parts);
                this.map.put(user.id, user);
            }
        }

        public User get(String string) {
            return this.map.get(Integer.valueOf(string));
        }
    }

    static class User {
        final int id;
        final String email;
        final VoteResolver.Level level;
        final String name;
        final Organization org;
        final Set<String> locales;

        public User(XPathParts parts) {
            this.id = Integer.parseInt(parts.getAttributeValue(-1, "id"));
            this.email = parts.getAttributeValue(-1, "email");
            this.level = VoteResolver.Level.valueOf(parts.getAttributeValue(-1, "level"));
            this.name = parts.getAttributeValue(-1, "name");
            this.org = Organization.fromString(parts.getAttributeValue(-1, "org"));
            this.locales = ImmutableSet.copyOf(Arrays.asList(parts.getAttributeValue(-1, "locales").split("[, ]+")));
        }

        public String toString() {
            return "id: " + this.id + "; email: " + this.email + "; name: " + this.name + "; level: " + this.level + "; org: " + this.org + "; locales: " + this.locales;
        }
    }

    static class Data {
        final String key;
        final List<Items> dataItems = new ArrayList<Items>();
        static Map<String, Data> map = new TreeMap<String, Data>();

        public Data(String key) {
            this.key = key;
        }

        public static Counter<String> getKeys() {
            Counter<String> items = new Counter<String>();
            for (Map.Entry<String, Data> e : map.entrySet()) {
                items.add(e.getKey(), e.getValue().dataItems.size());
            }
            return items;
        }

        public static void show(String regex) {
            Matcher m3 = Pattern.compile(regex).matcher("");
            for (Map.Entry<String, Data> e : map.entrySet()) {
                Data data = e.getValue();
                if (!m3.reset(data.key).find()) continue;
                Counter<User> counter = new Counter<User>();
                HashMap<User, DateMap> dateMaps = new HashMap<User, DateMap>();
                for (Items items : data.dataItems) {
                    if (items.owner.org != organization) continue;
                    counter.add(items.owner, 1L);
                    DateMap dateMap = (DateMap)dateMaps.get(items.owner);
                    if (dateMap == null) {
                        dateMap = new DateMap();
                        dateMaps.put(items.owner, dateMap);
                    }
                    dateMap.add(items.date);
                }
                for (Row.R2 r2 : counter.getEntrySetSortedByCount(false, null)) {
                    Long count = (Long)r2.get0();
                    User user = (User)r2.get1();
                    System.out.println("key: " + data.key + "; count: " + count + "; " + user + "\t" + dateMaps.get(user));
                }
            }
        }

        public String toString() {
            return this.key + "=" + CldrUtility.toString(this.dataItems);
        }

        public Items add(ArrayList<String> items) {
            Items items2 = Items.of(this.key, items);
            if (items2 != null && items2.owner != null) {
                this.dataItems.add(items2);
                return items2;
            }
            return null;
        }

        static void parseLine(String line, long maxItems) {
            Matcher m3 = INSERT.matcher(line);
            if (!m3.lookingAt()) {
                throw new IllegalArgumentException();
            }
            String key = m3.group(1);
            int i = m3.end();
            if (key.equals("FEEDBACK") || key.equals("sf_fora")) {
                return;
            }
            boolean inQuote = false;
            boolean skipComma = true;
            StringBuilder buffer = new StringBuilder();
            ArrayList<String> items = new ArrayList<String>();
            Data current = map.get(key);
            if (current == null) {
                current = new Data(key);
                map.put(key, current);
            }
            ArrayList rows = new ArrayList();
            block11: while (i < line.length()) {
                int cp = line.codePointAt(i);
                i += Character.charCount(cp);
                if (inQuote) {
                    switch (cp) {
                        case 39: {
                            inQuote = false;
                            continue block11;
                        }
                        case 92: {
                            cp = line.codePointAt(i);
                            i += Character.charCount(cp);
                        }
                    }
                    buffer.appendCodePoint(cp);
                    continue;
                }
                switch (cp) {
                    case 39: {
                        inQuote = true;
                        continue block11;
                    }
                    case 44: {
                        if (skipComma) continue block11;
                        items.add(buffer.toString());
                        buffer.setLength(0);
                        continue block11;
                    }
                    case 9: 
                    case 10: 
                    case 32: 
                    case 40: {
                        skipComma = false;
                        continue block11;
                    }
                    case 41: {
                        skipComma = true;
                        items.add(buffer.toString());
                        buffer.setLength(0);
                        Items lastItem = current.add(items);
                        if (--maxItems > 0L && lastItem != null && verbose) {
                            System.out.println(key + "\t" + lastItem);
                        }
                        items = new ArrayList();
                        continue block11;
                    }
                    case 92: {
                        cp = line.codePointAt(i);
                        i += Character.charCount(cp);
                    }
                }
                buffer.appendCodePoint(cp);
            }
        }
    }

    static class DateMap {
        ChainedMap.M5<Integer, Integer, Integer, Integer, Boolean> yearMonthDays = ChainedMap.of(new TreeMap(), new TreeMap(), new TreeMap(), new TreeMap(), Boolean.class);
        int current = 0;
        static DateFormat monthFormat = new SimpleDateFormat("MMM");

        DateMap() {
        }

        void add(Date d) {
            this.yearMonthDays.put(d.getYear() + 1900, d.getMonth() + 1, d.getDate(), this.current++, Boolean.TRUE);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            int years = 0;
            for (Map.Entry<Integer, Map<Integer, Map<Integer, Map<Integer, Boolean>>>> entry : this.yearMonthDays) {
                if (years++ > 0) {
                    result.append("; ");
                }
                int year = entry.getKey();
                result.append(year);
                result.append(": ");
                int months = 0;
                for (Map.Entry<Integer, Map<Integer, Map<Integer, Boolean>>> monthDay : entry.getValue().entrySet()) {
                    if (months++ > 0) {
                        result.append("; ");
                    }
                    int month = monthDay.getKey();
                    result.append(monthFormat.format(new Date(year - 1900, month - 1, 1)));
                    result.append(": ");
                    int days = 0;
                    for (Map.Entry<Integer, Map<Integer, Boolean>> dayCount : monthDay.getValue().entrySet()) {
                        if (days++ > 0) {
                            result.append(", ");
                        }
                        int day = dayCount.getKey();
                        result.append(day);
                        int count = dayCount.getValue().size();
                        if (count <= 1) continue;
                        result.append('(');
                        result.append(count);
                        result.append(")");
                    }
                }
            }
            return result.toString();
        }
    }

    static class Items {
        final Date date;
        final User owner;
        final List<String> raw;

        public static Items of(String key, List<String> raw) {
            try {
                return new Items(key, raw);
            }
            catch (Exception e) {
                System.out.println("No user for: " + key + ": " + raw);
                return null;
            }
        }

        private Items(String key, List<String> raw) {
            Date temp;
            try {
                temp = df.parse(raw.get(raw.size() - 1));
            }
            catch (ParseException e) {
                temp = null;
            }
            this.date = temp;
            this.raw = raw;
            if (temp == null) {
                this.owner = null;
            } else {
                String ownerField;
                switch (key) {
                    case "FEEDBACK": {
                        ownerField = raw.get(1);
                        break;
                    }
                    default: {
                        ownerField = raw.get(2);
                    }
                }
                this.owner = umap.get(ownerField);
            }
        }

        public String toString() {
            return (this.date == null ? "???" : df.format(this.date)) + ";\t" + this.owner + ";\t" + CldrUtility.toString(this.raw);
        }
    }

    static enum MyOptions {
        organization(".*", "google", "organization"),
        verbose("", "", "verbose");

        final Option option;
        static Option.Options options;

        private MyOptions(String argumentPattern, String defaultArgument, String helpText) {
            this.option = new Option(this, argumentPattern, defaultArgument, helpText);
        }

        private static Set<String> parse(String[] args, boolean showArguments) {
            return options.parse(MyOptions.values()[0], args, true);
        }

        static {
            options = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                options.add(option, option.option);
            }
        }
    }
}

