/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.base.Joiner;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Timer;

public class DtdDataCheck {
    static SupplementalDataInfo SUPPLEMENTAL = SupplementalDataInfo.getInstance();
    static final Set<Row.R4<DtdType, String, String, String>> DEPRECATED = new LinkedHashSet<Row.R4<DtdType, String, String, String>>();
    static final Map<Row.R2<DtdType, String>, Relation<Boolean, String>> TYPE_ATTRIBUTE_TO_DIST_ELEMENTS = new TreeMap<Row.R2<DtdType, String>, Relation<Boolean, String>>();
    private static final boolean CHECK_CORRECTNESS = false;
    static final int LOOP = 100;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            DtdType[] args2 = DtdType.values();
            args = new String[args2.length];
            int i = 0;
            for (DtdType dtdType : args2) {
                args[i++] = dtdType.name();
            }
        }
        Timer timer = new Timer();
        int n = 0;
        String[] i = args;
        int n2 = i.length;
        if (n < n2) {
            String arg = i[n];
            timer.start();
            DtdType dtdType = DtdType.valueOf(arg);
            DtdData dtdData = DtdData.getInstance(dtdType);
            PrintWriter printWriter = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY + "dataproj/src/temp/", dtdType + "-gen.dtd");
            printWriter.append(dtdData.toString());
            printWriter.close();
            timer.stop();
            System.out.println("Time: " + timer);
            return;
        }
        for (String arg : args) {
            timer.start();
            DtdType dtdType = DtdType.valueOf(arg);
            DtdData dtdData = DtdData.getInstance(dtdType);
            timer.stop();
            System.out.println("Time: " + timer);
        }
        int i2 = 0;
        System.out.println("        <distinguishing>");
        TreeSet<String> allElements = new TreeSet<String>();
        allElements.add("_q");
        DtdType lastType = null;
        for (Map.Entry<Row.R2<DtdType, String>, Relation<Boolean, String>> entry : TYPE_ATTRIBUTE_TO_DIST_ELEMENTS.entrySet()) {
            Row.R2<DtdType, String> typeAttribute = entry.getKey();
            Relation<Boolean, String> relation = entry.getValue();
            Set<String> areDisting = relation.get(true);
            if (areDisting == null) continue;
            DtdType type2 = (DtdType)((Object)typeAttribute.get0());
            if (lastType != type2) {
                if (lastType != null) {
                    DtdDataCheck.showAll(lastType, allElements);
                }
                lastType = type2;
            }
            String attribute = (String)typeAttribute.get1();
            Set<String> areNotDisting = relation.get(false);
            if (areNotDisting == null) {
                allElements.add(attribute);
                continue;
            }
            System.out.println("            <distinguishingItems type=\"" + type2 + "\" elements=\"" + Joiner.on(" ").join(areDisting) + "\" attributes=\"" + attribute + "\"/>\n            <!-- NONDISTINGUISH. TYPE=\"" + type2 + "\" ELEMENTS=\"" + Joiner.on(" ").join(areNotDisting) + "\" ATTRIBUTES=\"" + attribute + "\" -->");
        }
        DtdDataCheck.showAll(lastType, allElements);
        System.out.println("        </distinguishing>");
        i2 = 0;
        for (Row.R4 r4 : DEPRECATED) {
            System.out.println(++i2 + "\tDEPRECATED\t" + r4);
        }
        for (Iterator<Object> iterator : args) {
            DtdType type3 = DtdType.valueOf(iterator);
            DtdData dtdData = DtdData.getInstance(type3);
            System.out.println("\n" + iterator);
            new Walker(dtdData).showSuppressed();
        }
    }

    public static void showAll(DtdType type, Set<String> allElements) {
        System.out.println("            <distinguishingItems type=\"" + type + "\" elements=\"*\" attributes=\"" + Joiner.on(" ").join(allElements) + "\"/>");
        allElements.clear();
        allElements.add("_q");
    }

    private static void checkCost(String title, String[] sortedArray, Comparator<String> comp) {
        Timer timer = new Timer();
        for (int i = 0; i < 100; ++i) {
            String lastPath = null;
            for (String currentPath : sortedArray) {
                if (lastPath != null) {
                    int n = comp.compare(lastPath, currentPath);
                }
                lastPath = currentPath;
            }
        }
        timer.stop();
        System.out.println(title + "\tTime:\t" + timer.toString(100L));
    }

    private static class Walker {
        HashSet<DtdData.Element> seen = new HashSet();
        Set<DtdData.Element> elementsMissingDraft = new LinkedHashSet<DtdData.Element>();
        Set<DtdData.Element> elementsMissingAlt = new LinkedHashSet<DtdData.Element>();
        static final Set<String> SKIP_ATTRIBUTES = new HashSet<String>(Arrays.asList("draft", "alt", "standard", "references"));
        static final Set<String> SKIP_ELEMENTS = new HashSet<String>(Arrays.asList("alias", "special"));
        Set<DtdData.Attribute> attributesWithDefaultValues = new LinkedHashSet<DtdData.Attribute>();
        private DtdData dtdData;

        public Walker(DtdData dtdData) {
            this.dtdData = dtdData;
        }

        private void showSuppressed() {
            for (Map.Entry<String, DtdData.Element> ee : this.dtdData.getElementFromName().entrySet()) {
                DtdData.Element element = ee.getValue();
                for (Map.Entry<DtdData.Attribute, Integer> ae : element.getAttributes().entrySet()) {
                    DtdData.Attribute a = ae.getKey();
                    if (a.defaultValue == null) continue;
                    System.out.println(this.dtdData.ROOT + "\t" + element.name + "\t" + a.name + "\t" + a.defaultValue);
                }
            }
        }

        private void show(DtdData.Element element) {
            this.show(element, "");
            System.out.println();
            if (this.dtdData.dtdType == DtdType.ldml && this.elementsMissingDraft.size() != 0) {
                System.out.println("*Elements missing draft:\t" + this.elementsMissingDraft);
                System.out.println();
            }
            if (this.dtdData.dtdType == DtdType.ldml && this.elementsMissingAlt.size() != 0) {
                System.out.println("*Elements missing alt:\t" + this.elementsMissingAlt);
                System.out.println();
            }
            if (this.attributesWithDefaultValues.size() != 0) {
                System.out.println("*Attributes with default values:");
                for (DtdData.Attribute a : this.attributesWithDefaultValues) {
                    System.out.println("\t" + a + "\t" + a.features());
                }
                System.out.println();
            }
            StringBuilder diff = new StringBuilder();
            for (Map.Entry<String, Set<DtdData.Attribute>> entry : this.dtdData.getAttributesFromName().keyValuesSet()) {
                Relation<String, String> featuresToElements = Relation.of(new TreeMap(), LinkedHashSet.class);
                for (DtdData.Attribute attribute : entry.getValue()) {
                    featuresToElements.put(attribute.features(), attribute.element.name);
                }
                if (featuresToElements.size() == 1) continue;
                diff.append("\t" + entry.getKey() + "\n");
                for (Map.Entry entry2 : featuresToElements.keyValuesSet()) {
                    diff.append("\t\t" + (String)entry2.getKey() + "\n");
                    diff.append("\t\t\t on " + entry2.getValue() + "\n");
                }
            }
            if (diff.length() != 0) {
                System.out.println("*Attributes with different features by element:");
                System.out.println(diff);
                System.out.println();
            }
        }

        private void show(DtdData.Element element, String indent) {
            if (this.seen.contains(element)) {
                System.out.println((String)indent + element.name + "*");
            } else {
                this.seen.add(element);
                if (!element.containsAttribute("draft")) {
                    this.elementsMissingDraft.add(element);
                }
                if (!element.containsAttribute("alt")) {
                    this.elementsMissingAlt.add(element);
                }
                DtdData.ElementType type = element.getType();
                System.out.println((String)indent + element.name + (String)(type == DtdData.ElementType.CHILDREN ? "" : "\t" + type));
                indent = (String)indent + "\t";
                for (DtdData.Attribute a : element.getAttributes().keySet()) {
                    if (a.defaultValue != null) {
                        this.attributesWithDefaultValues.add(a);
                    }
                    if (SKIP_ATTRIBUTES.contains(a.name)) continue;
                    Object special = "";
                    boolean allDeprecated = false;
                    if (SUPPLEMENTAL.isDeprecated(this.dtdData.dtdType, element.name, a.name, "*")) {
                        special = (String)special + "\t#DEPRECATED#";
                        allDeprecated = true;
                        DEPRECATED.add(Row.of(this.dtdData.dtdType, element.name, a.name, "*"));
                    } else if (a.type == DtdData.AttributeType.ENUMERATED_TYPE) {
                        for (String value : a.values.keySet()) {
                            if (!SUPPLEMENTAL.isDeprecated(this.dtdData.dtdType, element.name, a.name, value)) continue;
                            special = (String)special + "\t#DEPRECATED:" + value + "#";
                            DEPRECATED.add(Row.of(this.dtdData.dtdType, element.name, a.name, value));
                        }
                    }
                    if (!allDeprecated) {
                        Row.R2<DtdType, String> key = Row.of(this.dtdData.dtdType, a.name);
                        boolean isDisting = CLDRFile.isDistinguishing(this.dtdData.dtdType, element.name, a.name);
                        special = (String)special + "\t#DISTINGUISHING#";
                        Relation<Boolean, String> info = TYPE_ATTRIBUTE_TO_DIST_ELEMENTS.get(key);
                        if (info == null) {
                            info = Relation.of(new TreeMap(), TreeSet.class);
                            TYPE_ATTRIBUTE_TO_DIST_ELEMENTS.put(key, info);
                        }
                        info.put(isDisting, element.name);
                    }
                    System.out.println((String)indent + "@" + a.name + "\t" + a.features() + (String)special);
                }
                for (DtdData.Element e : element.getChildren().keySet()) {
                    if (SKIP_ELEMENTS.contains(e.name)) continue;
                    this.show(e, (String)indent);
                }
            }
        }
    }
}

