/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.Transform;
import com.ibm.icu.util.Output;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.RegexUtilities;
import org.unicode.cldr.util.XPathParts;

public class GlossonymConstructor {
    public static final String PATH_PREFIX = "//ldml/localeDisplayNames/languages/language[@type=\"";
    private static final String CODE_SEPARATOR = "_";
    public static final String PSEUDO_PATH = "constructed";
    private final CLDRFile cldrFile;

    public static boolean pathIsEligible(String xpath) {
        return xpath.startsWith(PATH_PREFIX) && xpath.contains(CODE_SEPARATOR);
    }

    public static boolean valueIsBogus(String value) {
        return value == null || value.contains(CODE_SEPARATOR) || RegexUtilities.PATTERN_3_OR_4_DIGITS.matcher(value).find();
    }

    public GlossonymConstructor(CLDRFile cldrFile) {
        this.cldrFile = cldrFile;
        if (!cldrFile.isResolved()) {
            throw new IllegalArgumentException("Unresolved CLDRFile in GlossonymConstructor constructor");
        }
    }

    public String getValueAndTrack(String xpath, Output<String> pathWhereFound, Output<String> localeWhereFound) {
        String constructedValue = this.getValue(xpath);
        if (constructedValue != null) {
            if (localeWhereFound != null) {
                localeWhereFound.value = this.cldrFile.getLocaleID();
            }
            if (pathWhereFound != null) {
                pathWhereFound.value = PSEUDO_PATH;
            }
            return constructedValue;
        }
        return null;
    }

    public String getValue(String xpath) {
        if (GlossonymConstructor.pathIsEligible(xpath)) {
            return this.reallyGetValue(xpath);
        }
        return null;
    }

    private synchronized String reallyGetValue(String xpath) {
        String alt;
        CLDRFile.SimpleAltPicker altPicker;
        String value;
        XPathParts parts = XPathParts.getFrozenInstance(xpath);
        String type = parts.getAttributeValue(-1, "type");
        if (type.contains(CODE_SEPARATOR) && !GlossonymConstructor.valueIsBogus(value = this.cldrFile.getName(type, true, (Transform<String, String>)(altPicker = (alt = parts.getAttributeValue(-1, "alt")) == null ? null : new CLDRFile.SimpleAltPicker(alt))))) {
            return value;
        }
        return null;
    }
}

