/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.PatternPlaceholders;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class PathDescription {
    private static final String pathDescriptionString = "^//ldml/localeDisplayNames/territories/territory\\[@type=\"(CD|DG|CG|003|021|ZA|018|FK|MK|MM|TW|HK|MO)\"]; ROOT territory; Warning - the region {0} requires special attention! Note: before translating, be sure to read https://cldr.unicode.org/translation/displaynames/countryregion-territory-names.\n^//ldml/localeDisplayNames/scripts/script\\[@type=\"(Z[^\"]*)\"]; ROOT script; The name of the script (writing system) with Unicode script code = {0}. Note: before translating, be sure to read https://cldr.unicode.org/translation/displaynames/script-names.\n^//ldml/dates/timeZoneNames/zone\\[@type=\"([^\"]*)\"]/exemplarCity; ROOT timezone; The name of {0}. For more information, see https://cldr.unicode.org/translation/time-zones-and-city-names.\n^//ldml/localeDisplayNames/languages/language\\[@type=\"([^\"]*)\"]; ROOT language; The name of the language with Unicode language code = {0}. For more information, see https://cldr.unicode.org/translation/displaynames/languagelocale-names.\n^//ldml/localeDisplayNames/scripts/script\\[@type=\"([^\"]*)\"]; ROOT script; The name of the script (writing system) with Unicode script code = {0}. For more information, see https://cldr.unicode.org/translation/displaynames/script-names.\n^//ldml/localeDisplayNames/territories/territory\\[@type=\"([^\"]*)\"]; ROOT territory; The name of the country or region with Unicode region code = {0}. For more information, see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names.\n^//ldml/localeDisplayNames/subdivisions/subdivision\\[@type=\"([^\"]*)\"]; ROOT territory; The name of the country subdivision with Unicode subdivision code = {0}. For more information, see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names.\n^//ldml/numbers/currencies/currency\\[@type=\"([^\"]*)\"]/symbol$; ROOT currency; The symbol for the currency with the ISO currency code = {0}. For more information, see https://cldr.unicode.org/translation/currency-names-and-symbols.\n^//ldml/numbers/currencies/currency\\[@type=\"([^\"]*)\"]/symbol\\[@alt=\"narrow\"]; ROOT currency; The NARROW form of the symbol used for the currency with the ISO currency code = {0}, when the known context is already enough to distinguish the symbol from other currencies that may use the same symbol. Normally, this does not need to be changed from the inherited value. For more information, see https://cldr.unicode.org/translation/currency-names-and-symbols.\n^//ldml/numbers/currencies/currency\\[@type=\"([^\"]*)\"]/symbol\\[@alt=\"([^\"]++)\"]; ROOT currency; An alternative form of the symbol used for the currency with the ISO currency code = {0}.  Usually occurs shortly after a new currency symbol is introduced. For more information, see https://cldr.unicode.org/translation/currency-names-and-symbols.\n^//ldml/numbers/currencies/currency\\[@type=\"([^\"]*)\"]/displayName; ROOT currency; The name of the currency with the ISO currency code = {0}. For more information, see https://cldr.unicode.org/translation/currency-names-and-symbols.\n^//ldml/dates/timeZoneNames/metazone\\[@type=\"([^\"]*)\"](.*)/(.*); ROOT metazone; The name of the timezone for \u201c{0}\u201d. Note: before translating, be sure to read https://cldr.unicode.org/translation/time-zones-and-city-names.\n^//ldml/localeDisplayNames/types/type\\[@key=\"collation\"]\\[@type=\"([^\"]*)\"]; The name of \u201c{1} collation\u201d (sorting order). For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/types/type\\[@key=\"numbers\"]\\[@type=\"([^\"]*)\"]; The name of \u201c{1} number system\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/types/type\\[@key=\"calendar\"]\\[@type=\"roc\"]; The name of \u201croc calendar\u201d (common names include \u201cMinguo Calendar\u201d, \u201cRepublic of China Calendar\u201d, and \u201cRepublican Calendar\u201d). For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/types/type\\[@key=\"calendar\"]\\[@type=\"([^\"]*)\"]; The name of \u201c{1} calendar\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/types/type\\[@key=\"em\"]\\[@type=\"([^\"]*)\"]; The name of \u201cemoji presentation style {1}\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/types/type\\[@key=\"fw\"]\\[@type=\"([^\"]*)\"]; The name of \u201cfirst day of the week is {1}\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/types/type\\[@key=\"lb\"]\\[@type=\"([^\"]*)\"]; The name of \u201c{1} line break style\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/types/type\\[@key=\"([^\"]*)\"]\\[@type=\"([^\"]*)\"]; The name of the \u201c{2} {1}\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/keys/key\\[@type=\"([^\"]*)\"]; The name of the system for \u201c{1}\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/variants/variant[@type=\"([^\"]*)\"]; The name of the language variant with code {1}\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/languagelocale-names.\n^//ldml/characters/exemplarCharacters$; Defines the set of characters used in your language. You may not edit or vote on this item at this time. Before filing any tickets to request changes, be sure to read https://cldr.unicode.org/translation/core-data/exemplars.\n^//ldml/characters/exemplarCharacters\\[@type=\"([^\"]*)\"]; Defines the set of characters used in your language for the \u201c{1}\u201d category.  You may not edit or vote on this item at this time. Before filing any tickets to request changes, be sure to read https://cldr.unicode.org/translation/core-data/exemplars.\n^//ldml/characters/parseLenients; Defines sets of characters that are treated as equivalent in parsing.  You may not edit or vote on this item at this time. Before filing any tickets to request changes, be sure to read https://cldr.unicode.org/translation/core-data/characters#h.j3x0cwalqgqt.\n^//ldml/characters/ellipsis\\[@type=\"([^\"]*)\"]; Supply the ellipsis pattern for when the {1} part of a string is omitted. Note: before translating, be sure to read https://cldr.unicode.org/translation/characters.\n^//ldml/characters/moreInformation; The character or short string used to indicate that more information is available. Note: before translating, be sure to read https://cldr.unicode.org/translation/characters.\n^//ldml/delimiters/alternateQuotationEnd; Supply the (alternate) ending quotation mark (the right mark except in BIDI languages). Note: before translating, be sure to read https://cldr.unicode.org/translation/characters.\n^//ldml/delimiters/alternateQuotationStart; Supply the (alternate) starting quotation mark (the left mark except in BIDI languages). Note: before translating, be sure to read https://cldr.unicode.org/translation/characters.\n^//ldml/delimiters/quotationEnd; Supply the ending quotation mark (the right mark except in BIDI languages). Note: before translating, be sure to read https://cldr.unicode.org/translation/characters.\n^//ldml/delimiters/quotationStart; Supply the starting quotation mark (the left mark except in BIDI languages). Note: before translating, be sure to read https://cldr.unicode.org/translation/characters.\n^//ldml/localeDisplayNames/localeDisplayPattern/localePattern; The pattern used to compose locale (language) names. Note: before translating, be sure to read https://cldr.unicode.org/translation/displaynames/languagelocale-name-patterns.\n^//ldml/localeDisplayNames/localeDisplayPattern/localeSeparator; The separator used to compose modifiers in locale (language) names. Note: before translating, be sure to read https://cldr.unicode.org/translation/displaynames/languagelocale-name-patterns.\n^//ldml/localeDisplayNames/localeDisplayPattern/localeKeyTypePattern; The pattern used to compose key-type values in locale (language) names. Note: before translating, be sure to read https://cldr.unicode.org/translation/displaynames/languagelocale-name-patterns.\n^//ldml/layout/orientation/characterOrder; Specifies the horizontal direction of text in the language. Valid values are \"left-to-right\" or \"right-to-left\". For more information, see https://cldr.unicode.org/translation/units.\n^//ldml/layout/orientation/lineOrder; Specifies the vertical direction of text in the language. Valid values are \"top-to-bottom\" or \"bottom-to-top\". For more information, see https://cldr.unicode.org/translation/units.\n^//ldml/numbers/symbols/(\\w++); The {1} symbol used in the localized form of numbers. Note: before translating, be sure to read https://cldr.unicode.org/translation/currency-names-and-symbols.\n^//ldml/numbers/symbols\\[@numberSystem=\"([a-z]*)\"]/(\\w++); The {2} symbol used in the {1} numbering system. NOTE: especially for the decimal and grouping symbol, before translating, be sure to read https://cldr.unicode.org/translation/currency-names-and-symbols.\n^//ldml/numbers/defaultNumberingSystem; The default numbering system used in this locale. For more information, please see https://cldr.unicode.org/translation/core-data/numbering-systems.\n^//ldml/numbers/minimumGroupingDigits; The default minimum number of digits before a grouping separator used in this locale. For more information, please see https://cldr.unicode.org/translation/core-data/numbering-systems.\n^//ldml/numbers/otherNumberingSystems/(\\w++); The {1} numbering system used in this locale. For more information, please see https://cldr.unicode.org/translation/core-data/numbering-systems.\n^//ldml/dates/timeZoneNames/regionFormat\\[@type=\"standard\"]; The pattern used to compose standard (winter) fallback time zone names, such as 'Germany Winter Time'. Note: before translating, be sure to read https://cldr.unicode.org/translation/time-zones-and-city-names.\n^//ldml/dates/timeZoneNames/regionFormat\\[@type=\"daylight\"]; The pattern used to compose daylight (summer) fallback time zone names, such as 'Germany Summer Time'. Note: before translating, be sure to read https://cldr.unicode.org/translation/time-zones-and-city-names.\n^//ldml/dates/timeZoneNames/regionFormat; The pattern used to compose generic fallback time zone names, such as 'Germany Time'. Note: before translating, be sure to read https://cldr.unicode.org/translation/time-zones-and-city-names.\n^//ldml/dates/timeZoneNames/(fallback|fallbackRegion|gmtZero|gmt|hour|region)Format; The {1} pattern used to compose time zone names. Note: before translating, be sure to read https://cldr.unicode.org/translation/time-zones-and-city-names.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/compoundUnit\\[@type=\"([^\"]*)\"]/compoundUnitPattern1; Special pattern used to compose powers of a unit, such as meters squared. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/compoundUnit\\[@type=\"([^\"]*)\"]/compoundUnitPattern; Special pattern used to compose forms of two units, such as meters per second. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/compoundUnit\\[@type=\"([^\"]*)\"]/unitPrefixPattern; Special pattern used to compose a metric prefix with a unit, such as kilo{0} with meters to produce kilometers. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/coordinateUnit/displayName; Display name ({1} form) for the type of direction used in latitude and longitude, such as north or east. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/coordinateUnit/coordinateUnitPattern\\[@type=\"([^\"]*)\"]; Special pattern used in latitude and longitude, such as 12\u00b0N. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"area-acre\"]/displayName; Display name ({1} form) for \u201carea-acre\u201d, referring specifically to an English acre. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"duration-day\"]/displayName; Display name ({1} form) for \u201cduration-day\u201d, meaning a time duration of 24 hours (not a calendar day). Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"energy-calorie\"]/displayName; Display name ({1} form) for \u201cenergy-calorie\u201d, calories as used in chemistry, not the same as food calorie. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"energy-foodcalorie\"]/displayName; Display name ({1} form) for \u201cenergy-foodcalorie\u201d, kilocalories for food energy; may have same translation as energy-kilocalorie. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"energy-kilocalorie\"]/displayName; Display name ({1} form) for \u201cenergy-kilocalorie\u201d, kilocalories for uses not specific to food energy, such as chemistry. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"graphics-em\"]/displayName; Display name ({1} form) for \u201cgraphics-em\u201d, referring to typographic length equal to a font\u2019s point size. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"graphics-pixel\"]/displayName; Display name ({1} form) for \u201cgraphics-pixel\u201d, used for counting the individual elements in bitmap image. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"graphics-megapixel\"]/displayName; Display name ({1} form) for \u201cgraphics-megapixel\u201d, used for counting the individual elements in bitmap image. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"graphics-pixel-per-centimeter\"]/displayName; Display name ({1} form) for \u201cgraphics-pixel-per-centimeter\u201d, typically used for display resolution. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"graphics-pixel-per-inch\"]/displayName; Display name ({1} form) for \u201cgraphics-pixel-per-inch\u201d, typically used for display resolution. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"graphics-dot-per-centimeter\"]/displayName; Display name ({1} form) for \u201cgraphics-dot-per-centimeter\u201d, typically used for printer resolution. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"graphics-dot-per-inch\"]/displayName; Display name ({1} form) for \u201cgraphics-dot-per-inch\u201d, typically used for printer resolution. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"length-point\"]/displayName; Display name ({1} form) for \u201clength-point\u201d, referring to a typographic point, 1/72 inch. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"mass-stone\"]/displayName; Display name ({1} form) for \u201cmass-stone\u201d, used in UK/Ireland for body weight, equal to 14 pounds. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"mass-ton\"]/displayName; Display name ({1} form) for \u201cmass-ton\u201d, meaning U.S. short ton, not U.K. long ton or metric ton. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"([^\"]*)\"]/displayName; Display name ({1} form) for \u201c{2}\u201d. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"([^\"]*)\"]/unitPattern; [ICU Syntax] Special pattern used to compose plural for {1} forms of \u201c{2}\u201d. Note: before translating, be sure to read https://cldr.unicode.org/translation/getting-started/plurals.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"([^\"]*)\"]/perUnitPattern; Special pattern ({1} form) used to compose values per unit, such as \u201cmeters per {2}\u201d. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/durationUnit\\[@type=\"(hms|hm|ms)\"]; [ICU Syntax] Special pattern used to compose duration units. Note: before translating, be sure to read https://cldr.unicode.org/translation/getting-started/plurals.\n^//ldml/numbers/decimalFormats/decimalFormatLength\\[@type=\"([^\"]*)\"]/decimalFormat\\[@type=\"([^\"]*)\"]/pattern\\[@type=\"([^\"]*)\"]; Special pattern used for a short version of numbers with the same number of digits as {3}. Note: before translating, be sure to read https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.eradhhuxzqqz.\n^//ldml/numbers/currencyFormats\\[@numberSystem=\"([^\"]*)\"]/currencyFormatLength\\[@type=\"short\"]/currencyFormat\\[@type=\"standard\"]/pattern\\[@type=\"(\\d+)\"]\\[@count=\"([^\"]+)\"]; Special currency pattern used to obtain the abbreviated plural forms of numbers with the same number of digits as {2}. See https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.eradhhuxzqqz for details.\n^//ldml/numbers/decimalFormats\\[@numberSystem=\"([^\"]*)\"]/decimalFormatLength\\[@type=\"short\"]/decimalFormat\\[@type=\"standard\"]/pattern\\[@type=\"(\\d+)\"]\\[@count=\"([^\"]+)\"]; Special decimal pattern used to obtain the abbreviated plural forms of numbers with the same number of digits as {2}. See https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.eradhhuxzqqz for details.\n^//ldml/numbers/decimalFormats\\[@numberSystem=\"([^\"]*)\"]/decimalFormatLength\\[@type=\"long\"]/decimalFormat\\[@type=\"standard\"]/pattern\\[@type=\"(\\d+)\"]\\[@count=\"([^\"]+)\"]; Special decimal pattern used to obtain the long plural forms of numbers with the same number of digits as {2}. See https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.mnb2fmj0pt72 for details.\n^//ldml/numbers/currencyFormats/currencyPatternAppendISO; Pattern used to combine a regular currency format with an ISO 4217 code (\u00a4\u00a4). For more information, please see https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/numbers/currencyFormats\\[@numberSystem=\"([^\"]*)\"]/currencyPatternAppendISO; Pattern used to combine a regular currency format with an ISO 4217 code (\u00a4\u00a4). For more information, please see https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/numbers/currencyFormats\\[@numberSystem=\"([^\"]*)\"]/unitPattern\\[@count=\"(\\w++)\"]; Currency format used for numbers of type {2}. For more information, please see https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/numbers/miscPatterns\\[@numberSystem=\"([^\"]*)\"]/pattern\\[@type=\"range\"]; Format used to indicate a range of numbers. The '{'0'}' and '{'1'}' in the pattern represent the lowest and highest numbers in the range, respectively. For more information, please see https://cldr.unicode.org/translation/units.\n^//ldml/numbers/miscPatterns\\[@numberSystem=\"([^\"]*)\"]/pattern\\[@type=\"atLeast\"]; Format used to indicate a number is at least a certain value, often combined with other patterns to produce examples such as \u201c\u226512kg\u201d. For more information, please see https://cldr.unicode.org/translation/units.\n^//ldml/numbers/miscPatterns\\[@numberSystem=\"([^\"]*)\"]/pattern\\[@type=\"atMost\"]; Format used to indicate a number is at most a certain value, often combined with other patterns to produce examples such as \u201c\u226412kg\u201d. For more information, please see https://cldr.unicode.org/translation/units.\n^//ldml/numbers/miscPatterns\\[@numberSystem=\"([^\"]*)\"]/pattern\\[@type=\"approximately\"]; Format used to indicate a number is approximately a given value, often combined with other patterns to produce examples such as \u201c~12kg\u201d. For more information, please see https://cldr.unicode.org/translation/units.\n^//ldml/numbers/minimalPairs/ordinalMinimalPairs\\[@ordinal=\"([^\"]*)\"]; Minimal pairs for ordinals. For more information, please see https://cldr.unicode.org/translation/getting-started/plurals#h.pnla5cp3nl4l.\n^//ldml/numbers/minimalPairs/pluralMinimalPairs\\[@count=\"([^\"]*)\"]; Minimal pairs for plurals (cardinals). For more information, please see https://cldr.unicode.org/translation/getting-started/plurals#h.pnla5cp3nl4l.\n^//ldml/numbers/minimalPairs/caseMinimalPairs\\[@case=\"([^\"]*)\"]; Minimal pairs for cases used in the language. For more information, please see https://cldr.unicode.org/translation/grammatical-inflection.\n^//ldml/numbers/minimalPairs/genderMinimalPairs\\[@gender=\"([^\"]*)\"]; Minimal pairs for genders. For more information, please see https://cldr.unicode.org/translation/grammatical-inflection.\n^//ldml/personNames/nameOrderLocales\\[@order=\"([^\"]*)\"]; Person name order for locales. If there are none with a particular direction, insert \u276eEMPTY\u276f. For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/personNames/foreignSpaceReplacement; For foreign personal names displayed in your locale, any special character that replaces a space (defaults to regular space). If spaces are to be removed, insert \u276eEMPTY\u276f. For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/personNames/initialPattern\\[@type=\"initial\"]; The pattern used for a single initial in person name formats. For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/personNames/initialPattern\\[@type=\"initialSequence\"]; The pattern used to compose sequences of initials in person name formats. For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/personNames/personName\\[@order=\"([^\"]*)\"]\\[@length=\"([^\"]*)\"]\\[@usage=\"referring\"]\\[@formality=\"([^\"]*)\"]; Person name formats for referring to a person (with a particular order, length, formality). For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/personNames/personName\\[@order=\"([^\"]*)\"]\\[@length=\"([^\"]*)\"]\\[@usage=\"addressing\"]\\[@formality=\"([^\"]*)\"]; Person name format for addressing a person (with a particular order, length, formality). For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/personNames/personName\\[@order=\"([^\"]*)\"]\\[@length=\"([^\"]*)\"]\\[@usage=\"monogram\"]\\[@formality=\"([^\"]*)\"]; Person name formats for monograms (with a particular order, length, formality). For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/personNames/sampleName; Sample names for person name format examples (enter \u2205\u2205\u2205 for optional unused fields). For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/numbers/([a-z]*)Formats(\\[@numberSystem=\"([^\"]*)\"])?/\\1FormatLength/\\1Format\\[@type=\"standard\"]/pattern\\[@type=\"standard\"]$; Special pattern used to compose {1} numbers. Note: before translating, be sure to read https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/numbers/currencyFormats\\[@numberSystem=\"([^\"]*)\"]/currencyFormatLength/currencyFormat\\[@type=\"standard\"]/pattern\\[@type=\"standard\"]\\[@alt=\"alphaNextToNumber\"]; Special pattern used to compose currency values when the currency symbol has a letter adjacent to the number. Note: before translating, be sure to read https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/numbers/currencyFormats\\[@numberSystem=\"([^\"]*)\"]/currencyFormatLength/currencyFormat\\[@type=\"standard\"]/pattern\\[@type=\"standard\"]\\[@alt=\"noCurrency\"]; Special pattern used to compose currency values for which no currency symbol should be shown. Note: before translating, be sure to read https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/numbers/currencyFormats\\[@numberSystem=\"([^\"]*)\"]/currencyFormatLength/currencyFormat\\[@type=\"accounting\"]/pattern; Special pattern used to compose currency values for accounting purposes. Note: before translating, be sure to read https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/numbers/currencyFormats/currencySpacing/([a-zA-Z]*)/([a-zA-Z]*); Special pattern used to compose currency signs ($1/$2) with numbers. Note: before translating, be sure to read https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/listPatterns/listPattern/listPatternPart\\[@type=\"2\"]; Special pattern used to make an \u201cand\u201d list out of two standard elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make a \u201cand\u201d list out of more than two standard elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"standard-short\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make a short-style \u201cand\u201d list out of two standard elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"standard-short\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make a short-style \u201cand\u201d list out of more than two standard elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"standard-narrow\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make a short-style \u201cand\u201d list out of two standard elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"standard-narrow\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make a short-style \u201cand\u201d list out of more than two standard elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"or\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make an \u201cor\u201d list out of two standard elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"or\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make an \u201cor\u201d list out of more than two standard elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"or-short\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make an \u201cor\u201d list out of two standard elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"or-short\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make an \u201cor\u201d list out of more than two standard elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"or-narrow\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make an \u201cor\u201d list out of two standard elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"or-narrow\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make an \u201cor\u201d list out of more than two standard elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"unit\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make a list out of two unit elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"unit\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make a list out of more than two unit elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"unit-short\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make a list out of two abbreviated unit elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"unit-short\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make a list out of more than two abbreviated unit elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"unit-narrow\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make a list out of two narrow unit elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"unit-narrow\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make a list out of more than two narrow unit elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dayPeriods/dayPeriodContext\\[@type=\"(format)\"]/dayPeriodWidth\\[@type=\"([^\"]*)\"]/dayPeriod\\[@type=\"([^\"]*)\"]; Provide the {3}, {2} version of the name for the day period code \u201c{4}\u201d. This version must have the right inflection/prepositions/etc. for adding after a number, such as \u201cin the morning\u201d for use in \u201c10:00 in the morning\u201d. To see the time spans for these codes, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.ewzjebmpoi4k\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dayPeriods/dayPeriodContext\\[@type=\"([^\"]*)\"]/dayPeriodWidth\\[@type=\"([^\"]*)\"]/dayPeriod\\[@type=\"([^\"]*)\"]; Provide the {3}, {2} version of the name for the day period code \u201c{4}\u201d. To see the time spans for these codes, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.ewzjebmpoi4k\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/days/dayContext\\[@type=\"([^\"]*)\"]/dayWidth\\[@type=\"([^\"]*)\"]/day\\[@type=\"([^\"]*)\"]; Provide the {2} and {3} version of the name for day-of-the-week {4}. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/eras/eraAbbr/era\\[@type=\"([^\"]*)\"]; Provide the format-abbreviated version of the name for era {4}. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/eras/eraNames/era\\[@type=\"([^\"]*)\"]; Provide the format-wide version of the name for era {4}. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/eras/eraNarrow/era\\[@type=\"([^\"]*)\"]; Provide the format-narrow version of the name for era {4}. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/months/monthContext\\[@type=\"([^\"]*)\"]/monthWidth\\[@type=\"([^\"]*)\"]/month\\[@type=\"([^\"]*)\"]; Provide the {2} and {3} version of the name for month {4}. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/quarters/quarterContext\\[@type=\"([^\"]*)\"]/quarterWidth\\[@type=\"([^\"]*)\"]/quarter\\[@type=\"([^\"]*)\"]; Provide the {2} and {3} version of the name for quarter {4}. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/fields/field\\[@type=\"([^\"]*)\"]/displayName; Provide the name (as it would appear in menus) for the field \u201c{1}\u201d. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.8wfk3599ck9x.\n^//ldml/dates/fields/field\\[@type=\"day\"]/relative\\[@type=\"0\"]; Provide the name for today. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.aevw0tiix80v.\n^//ldml/dates/fields/field\\[@type=\"day\"]/relative\\[@type=\"-([^\"]*)\"]; Provide a name for the day, {1} before today. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.aevw0tiix80v.\n^//ldml/dates/fields/field\\[@type=\"day\"]/relative\\[@type=\"([^\"]*)\"]; Provide a name for the day, {1} after today. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.aevw0tiix80v.\n^//ldml/dates/fields/field\\[@type=\"([^\"]*)\"]/relative\\[@type=\"0\"]; Provide the name for \u201cthis {2}\u201d. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.aevw0tiix80v.\n^//ldml/dates/fields/field\\[@type=\"([^\"]*)\"]/relative\\[@type=\"-1\"]; Provide a name for \u201clast {1}\u201d. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.aevw0tiix80v.\n^//ldml/dates/fields/field\\[@type=\"([^\"]*)\"]/relative\\[@type=\"1\"]; Provide a name for \u201cnext {1}\u201d. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.aevw0tiix80v.\n^//ldml/dates/fields/field\\[@type=\"([^\"]*)\"]/relativeTime\\[@type=\"future\"]/relativeTimePattern\\[@count=\"([^\"]*)\"]; Provide a pattern used to display times in the future. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/fields/field\\[@type=\"([^\"]*)\"]/relativeTime\\[@type=\"past\"]/relativeTimePattern\\[@count=\"([^\"]*)\"]; Provide a pattern used to display times in the past. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/fields/field\\[@type=\"([^\"]*)\"]/relativePeriod; Provide a name for \u201cthe {1} of SOME_DATE\u201d. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dateTimeFormats/dateTimeFormatLength\\[@type=\"([^\"]*)\"]/dateTimeFormat\\[@type=\"standard\"]/pattern\\[@type=\"([^\"]*)\"]; Provide the {2} version of the date-time pattern suitable for most use cases, including combining a date with a time range. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dateTimeFormats/dateTimeFormatLength\\[@type=\"([^\"]*)\"]/dateTimeFormat\\[@type=\"atTime\"]/pattern\\[@type=\"([^\"]*)\"]; Provide the {2} version of the date-time pattern suitable for expressing a date at a specific time. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dateFormats/dateFormatLength\\[@type=\"([^\"]*)\"]/dateFormat\\[@type=\"([^\"]*)\"]/pattern\\[@type=\"([^\"]*)\"]; Provide the {2} version of the basic date pattern. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/timeFormats/timeFormatLength\\[@type=\"([^\"]*)\"]/timeFormat\\[@type=\"([^\"]*)\"]/pattern\\[@type=\"([^\"]*)\"]; Provide the {2} version of the basic time pattern. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dateTimeFormats/availableFormats/dateFormatItem\\[@id=\"([^\"]*)\"]; Provide the pattern used in your language for the skeleton \u201c{2}\u201d. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dateTimeFormats/appendItems/appendItem\\[@request=\"([^\"]*)\"]; Provide the pattern used in your language to append a \u201c{2}\u201d to another format. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dateTimeFormats/intervalFormats/intervalFormatFallback; The pattern used for \u201cfallback\u201d with date/time intervals. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dateTimeFormats/intervalFormats/intervalFormatItem\\[@id=\"([^\"]*)\"]/greatestDifference\\[@id=\"([^\"]*)\"]; The pattern used for the date/time interval skeleton \u201c{2}\u201d when the greatest difference is \u201c{3}\u201d. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"[^\"]*\"]/cyclicNameSets/cyclicNameSet\\[@type=\"([^\"]*)\"]/cyclicNameContext\\[@type=\"([^\"]*)\"]/cyclicNameWidth\\[@type=\"([^\"]*)\"]/cyclicName\\[@type=\"([^\"]*)\"]; Provide the {2} and {3} version of type {4} in the {1} name cycle. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.h0vy2eyzcj0n.\n^//ldml/dates/calendars/calendar\\[@type=\"[^\"]*\"]/monthPatterns/monthPatternContext\\[@type=\"([^\"]*)\"]/monthPatternWidth\\[@type=\"([^\"]*)\"]/monthPattern\\[@type=\"([^\"]*)\"]; Provide the {1} and {2} version of the name for {3} month types. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.fww3pfyk0uwn.\n^//ldml/localeDisplayNames/transformNames/transformName\\[@type=\"([^\"]*)\"]; The name of the transform \u201c{1}\u201d. For more information, please see https://cldr.unicode.org/translation/transforms.\n^//ldml/localeDisplayNames/codePatterns/codePattern[@type=\"([^\"]*)\"]; The pattern to be used when displaying a name for a character {1}. For more information, please see https://cldr.unicode.org/translation/displaynames/languagelocale-name-patterns.\n^//ldml/localeDisplayNames/measurementSystemNames/measurementSystemName\\[@type=\"([^\"]*)\"]; The name of the measurement system \u201c{1}\u201d.  For more information, please see https://cldr.unicode.org/translation/units.\n^//ldml/posix/messages/(no|yes)str; The word for \u201c{1}\u201d, lowercased, plus any abbreviations separated by a colon. For more information, see https://cldr.unicode.org/translation/units.\n^//ldml/localeDisplayNames/annotationPatterns/annotationPattern[@type=\"([^\"]*)\"]; The pattern to be used when displaying a {1}. For more information, please see https://cldr.unicode.org/translation/displaynames/languagelocale-name-patterns.\n^//ldml/characters/stopwords/stopwordList\\[@type=\"([^\"]*)\"]; The words that should be ignored in sorting in your language.  For more information, see https://cldr.unicode.org/translation/units.\n^//ldml/dates/timeZoneNames/zone\\[@type=\"([^\"]*)\"]/([^/]*)/(.*); Override for the $3-$2 timezone name for $1.  For more information, see https://cldr.unicode.org/translation/time-zones-and-city-names.\n^//ldml/typographicNames/axisName[@type=\"([^\"]*)\"]; A label for a typographic design axis, such as \u201cWidth\u201d or \u201cWeight\u201d.  For more information, see https://cldr.unicode.org/translation/characters/typographic-names.\n^//ldml/typographicNames/styleName[@type=\"([^\"]*)\"][@subtype=\"([^\"]*)\"]; A label for a typographic style, such as \u201cNarrow\u201d or \u201cSemibold\u201d.  For more information, see https://cldr.unicode.org/translation/characters/typographic-names.\n^//ldml/typographicNames/featureName[@type=\"([^\"]*)\"]; A label for a typographic feature, such as \u201cSmall Capitals\u201d.  For more information, see https://cldr.unicode.org/translation/characters/typographic-names.\n^//ldml/characterLabels/characterLabelPattern\\[@type=\"([^\"]*)\"]\\[@count=\"([^\"]*)\"]; A label for a set of characters that has a numeric placeholder, such as \u201c1 Stroke\u201d, \u201c2 Strokes\u201d.  For more information, see https://cldr.unicode.org/translation/characters/character-labels.\n^//ldml/characterLabels/characterLabelPattern\\[@type=\"([^\"]*)\"]; A modifier composed with a label for a set of characters.  For more information, see https://cldr.unicode.org/translation/characters/character-labels.\n^//ldml/characterLabels/characterLabel\\[@type=\"([^\"]*)\"]; A label for a set of characters.  For more information, see https://cldr.unicode.org/translation/characters/character-labels.\n^//ldml/annotations/annotation\\[@cp=\"([^\"]*)\"]\\[@type=\"tts\"]; A name for a character or sequence. For more information, see https://cldr.unicode.org/translation/characters/short-names-and-keywords#h.4a8wthj27m74.\n^//ldml/annotations/annotation\\[@cp=\"([^\"]*)\"]; A set of keywords for a character or sequence.  For more information, see https://cldr.unicode.org/translation/characters/short-names-and-keywords#h.4a8wthj27m74.\n";
    private static final Logger logger = Logger.getLogger(PathDescription.class.getName());
    public static final Set<String> EXTRA_LANGUAGES = new TreeSet<String>(Arrays.asList("ach|af|ak|ak|am|ar|az|be|bem|bg|bh|bn|br|bs|ca|chr|ckb|co|crs|cs|cy|da|de|de_AT|de_CH|ee|el|en|en_AU|en_CA|en_GB|en_US|eo|es|es_419|es_ES|et|eu|fa|fi|fil|fo|fr|fr_CA|fr_CH|fy|ga|gaa|gd|gl|gn|gsw|gu|ha|haw|he|hi|hr|ht|hu|hy|ia|id|ig|io|is|it|ja|jv|ka|kg|kk|km|kn|ko|kri|ku|ky|la|lg|ln|lo|loz|lt|lua|lv|mfe|mg|mi|mk|ml|mn|mr|ms|mt|my|nb|ne|nl|nl_BE|nn|no|nso|ny|nyn|oc|om|or|pa|pcm|pl|ps|pt|pt_BR|pt_PT|qu|rm|rn|ro|ro|ro_MD|ru|rw|sd|si|sk|sl|sn|so|sq|sr|sr_Latn|sr_ME|st|su|sv|sw|ta|te|tg|th|ti|tk|tlh|tn|to|tr|tt|tum|ug|uk|und|ur|uz|vi|wo|xh|yi|yo|zh|zh_Hans|zh_Hant|zh_HK|zu|zxx".split("\\|")));
    private static final Pattern METAZONE_PATTERN = Pattern.compile("//ldml/dates/timeZoneNames/metazone\\[@type=\"([^\"]*)\"]/(.*)/(.*)");
    private static final Pattern STAR_ATTRIBUTE_PATTERN = PatternCache.get("=\"([^\"]*)\"");
    private static final StandardCodes STANDARD_CODES = StandardCodes.make();
    private static final Map<String, String> ZONE2COUNTRY = PathDescription.STANDARD_CODES.zoneParser.getZoneToCounty();
    private static final RegexLookup<String> pathHandling = new RegexLookup().loadFromString("^//ldml/localeDisplayNames/territories/territory\\[@type=\"(CD|DG|CG|003|021|ZA|018|FK|MK|MM|TW|HK|MO)\"]; ROOT territory; Warning - the region {0} requires special attention! Note: before translating, be sure to read https://cldr.unicode.org/translation/displaynames/countryregion-territory-names.\n^//ldml/localeDisplayNames/scripts/script\\[@type=\"(Z[^\"]*)\"]; ROOT script; The name of the script (writing system) with Unicode script code = {0}. Note: before translating, be sure to read https://cldr.unicode.org/translation/displaynames/script-names.\n^//ldml/dates/timeZoneNames/zone\\[@type=\"([^\"]*)\"]/exemplarCity; ROOT timezone; The name of {0}. For more information, see https://cldr.unicode.org/translation/time-zones-and-city-names.\n^//ldml/localeDisplayNames/languages/language\\[@type=\"([^\"]*)\"]; ROOT language; The name of the language with Unicode language code = {0}. For more information, see https://cldr.unicode.org/translation/displaynames/languagelocale-names.\n^//ldml/localeDisplayNames/scripts/script\\[@type=\"([^\"]*)\"]; ROOT script; The name of the script (writing system) with Unicode script code = {0}. For more information, see https://cldr.unicode.org/translation/displaynames/script-names.\n^//ldml/localeDisplayNames/territories/territory\\[@type=\"([^\"]*)\"]; ROOT territory; The name of the country or region with Unicode region code = {0}. For more information, see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names.\n^//ldml/localeDisplayNames/subdivisions/subdivision\\[@type=\"([^\"]*)\"]; ROOT territory; The name of the country subdivision with Unicode subdivision code = {0}. For more information, see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names.\n^//ldml/numbers/currencies/currency\\[@type=\"([^\"]*)\"]/symbol$; ROOT currency; The symbol for the currency with the ISO currency code = {0}. For more information, see https://cldr.unicode.org/translation/currency-names-and-symbols.\n^//ldml/numbers/currencies/currency\\[@type=\"([^\"]*)\"]/symbol\\[@alt=\"narrow\"]; ROOT currency; The NARROW form of the symbol used for the currency with the ISO currency code = {0}, when the known context is already enough to distinguish the symbol from other currencies that may use the same symbol. Normally, this does not need to be changed from the inherited value. For more information, see https://cldr.unicode.org/translation/currency-names-and-symbols.\n^//ldml/numbers/currencies/currency\\[@type=\"([^\"]*)\"]/symbol\\[@alt=\"([^\"]++)\"]; ROOT currency; An alternative form of the symbol used for the currency with the ISO currency code = {0}.  Usually occurs shortly after a new currency symbol is introduced. For more information, see https://cldr.unicode.org/translation/currency-names-and-symbols.\n^//ldml/numbers/currencies/currency\\[@type=\"([^\"]*)\"]/displayName; ROOT currency; The name of the currency with the ISO currency code = {0}. For more information, see https://cldr.unicode.org/translation/currency-names-and-symbols.\n^//ldml/dates/timeZoneNames/metazone\\[@type=\"([^\"]*)\"](.*)/(.*); ROOT metazone; The name of the timezone for \u201c{0}\u201d. Note: before translating, be sure to read https://cldr.unicode.org/translation/time-zones-and-city-names.\n^//ldml/localeDisplayNames/types/type\\[@key=\"collation\"]\\[@type=\"([^\"]*)\"]; The name of \u201c{1} collation\u201d (sorting order). For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/types/type\\[@key=\"numbers\"]\\[@type=\"([^\"]*)\"]; The name of \u201c{1} number system\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/types/type\\[@key=\"calendar\"]\\[@type=\"roc\"]; The name of \u201croc calendar\u201d (common names include \u201cMinguo Calendar\u201d, \u201cRepublic of China Calendar\u201d, and \u201cRepublican Calendar\u201d). For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/types/type\\[@key=\"calendar\"]\\[@type=\"([^\"]*)\"]; The name of \u201c{1} calendar\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/types/type\\[@key=\"em\"]\\[@type=\"([^\"]*)\"]; The name of \u201cemoji presentation style {1}\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/types/type\\[@key=\"fw\"]\\[@type=\"([^\"]*)\"]; The name of \u201cfirst day of the week is {1}\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/types/type\\[@key=\"lb\"]\\[@type=\"([^\"]*)\"]; The name of \u201c{1} line break style\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/types/type\\[@key=\"([^\"]*)\"]\\[@type=\"([^\"]*)\"]; The name of the \u201c{2} {1}\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/keys/key\\[@type=\"([^\"]*)\"]; The name of the system for \u201c{1}\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/countryregion-territory-names#h.x27jspwj91af.\n^//ldml/localeDisplayNames/variants/variant[@type=\"([^\"]*)\"]; The name of the language variant with code {1}\u201d. For more information, please see https://cldr.unicode.org/translation/displaynames/languagelocale-names.\n^//ldml/characters/exemplarCharacters$; Defines the set of characters used in your language. You may not edit or vote on this item at this time. Before filing any tickets to request changes, be sure to read https://cldr.unicode.org/translation/core-data/exemplars.\n^//ldml/characters/exemplarCharacters\\[@type=\"([^\"]*)\"]; Defines the set of characters used in your language for the \u201c{1}\u201d category.  You may not edit or vote on this item at this time. Before filing any tickets to request changes, be sure to read https://cldr.unicode.org/translation/core-data/exemplars.\n^//ldml/characters/parseLenients; Defines sets of characters that are treated as equivalent in parsing.  You may not edit or vote on this item at this time. Before filing any tickets to request changes, be sure to read https://cldr.unicode.org/translation/core-data/characters#h.j3x0cwalqgqt.\n^//ldml/characters/ellipsis\\[@type=\"([^\"]*)\"]; Supply the ellipsis pattern for when the {1} part of a string is omitted. Note: before translating, be sure to read https://cldr.unicode.org/translation/characters.\n^//ldml/characters/moreInformation; The character or short string used to indicate that more information is available. Note: before translating, be sure to read https://cldr.unicode.org/translation/characters.\n^//ldml/delimiters/alternateQuotationEnd; Supply the (alternate) ending quotation mark (the right mark except in BIDI languages). Note: before translating, be sure to read https://cldr.unicode.org/translation/characters.\n^//ldml/delimiters/alternateQuotationStart; Supply the (alternate) starting quotation mark (the left mark except in BIDI languages). Note: before translating, be sure to read https://cldr.unicode.org/translation/characters.\n^//ldml/delimiters/quotationEnd; Supply the ending quotation mark (the right mark except in BIDI languages). Note: before translating, be sure to read https://cldr.unicode.org/translation/characters.\n^//ldml/delimiters/quotationStart; Supply the starting quotation mark (the left mark except in BIDI languages). Note: before translating, be sure to read https://cldr.unicode.org/translation/characters.\n^//ldml/localeDisplayNames/localeDisplayPattern/localePattern; The pattern used to compose locale (language) names. Note: before translating, be sure to read https://cldr.unicode.org/translation/displaynames/languagelocale-name-patterns.\n^//ldml/localeDisplayNames/localeDisplayPattern/localeSeparator; The separator used to compose modifiers in locale (language) names. Note: before translating, be sure to read https://cldr.unicode.org/translation/displaynames/languagelocale-name-patterns.\n^//ldml/localeDisplayNames/localeDisplayPattern/localeKeyTypePattern; The pattern used to compose key-type values in locale (language) names. Note: before translating, be sure to read https://cldr.unicode.org/translation/displaynames/languagelocale-name-patterns.\n^//ldml/layout/orientation/characterOrder; Specifies the horizontal direction of text in the language. Valid values are \"left-to-right\" or \"right-to-left\". For more information, see https://cldr.unicode.org/translation/units.\n^//ldml/layout/orientation/lineOrder; Specifies the vertical direction of text in the language. Valid values are \"top-to-bottom\" or \"bottom-to-top\". For more information, see https://cldr.unicode.org/translation/units.\n^//ldml/numbers/symbols/(\\w++); The {1} symbol used in the localized form of numbers. Note: before translating, be sure to read https://cldr.unicode.org/translation/currency-names-and-symbols.\n^//ldml/numbers/symbols\\[@numberSystem=\"([a-z]*)\"]/(\\w++); The {2} symbol used in the {1} numbering system. NOTE: especially for the decimal and grouping symbol, before translating, be sure to read https://cldr.unicode.org/translation/currency-names-and-symbols.\n^//ldml/numbers/defaultNumberingSystem; The default numbering system used in this locale. For more information, please see https://cldr.unicode.org/translation/core-data/numbering-systems.\n^//ldml/numbers/minimumGroupingDigits; The default minimum number of digits before a grouping separator used in this locale. For more information, please see https://cldr.unicode.org/translation/core-data/numbering-systems.\n^//ldml/numbers/otherNumberingSystems/(\\w++); The {1} numbering system used in this locale. For more information, please see https://cldr.unicode.org/translation/core-data/numbering-systems.\n^//ldml/dates/timeZoneNames/regionFormat\\[@type=\"standard\"]; The pattern used to compose standard (winter) fallback time zone names, such as 'Germany Winter Time'. Note: before translating, be sure to read https://cldr.unicode.org/translation/time-zones-and-city-names.\n^//ldml/dates/timeZoneNames/regionFormat\\[@type=\"daylight\"]; The pattern used to compose daylight (summer) fallback time zone names, such as 'Germany Summer Time'. Note: before translating, be sure to read https://cldr.unicode.org/translation/time-zones-and-city-names.\n^//ldml/dates/timeZoneNames/regionFormat; The pattern used to compose generic fallback time zone names, such as 'Germany Time'. Note: before translating, be sure to read https://cldr.unicode.org/translation/time-zones-and-city-names.\n^//ldml/dates/timeZoneNames/(fallback|fallbackRegion|gmtZero|gmt|hour|region)Format; The {1} pattern used to compose time zone names. Note: before translating, be sure to read https://cldr.unicode.org/translation/time-zones-and-city-names.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/compoundUnit\\[@type=\"([^\"]*)\"]/compoundUnitPattern1; Special pattern used to compose powers of a unit, such as meters squared. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/compoundUnit\\[@type=\"([^\"]*)\"]/compoundUnitPattern; Special pattern used to compose forms of two units, such as meters per second. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/compoundUnit\\[@type=\"([^\"]*)\"]/unitPrefixPattern; Special pattern used to compose a metric prefix with a unit, such as kilo{0} with meters to produce kilometers. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/coordinateUnit/displayName; Display name ({1} form) for the type of direction used in latitude and longitude, such as north or east. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/coordinateUnit/coordinateUnitPattern\\[@type=\"([^\"]*)\"]; Special pattern used in latitude and longitude, such as 12\u00b0N. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"area-acre\"]/displayName; Display name ({1} form) for \u201carea-acre\u201d, referring specifically to an English acre. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"duration-day\"]/displayName; Display name ({1} form) for \u201cduration-day\u201d, meaning a time duration of 24 hours (not a calendar day). Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"energy-calorie\"]/displayName; Display name ({1} form) for \u201cenergy-calorie\u201d, calories as used in chemistry, not the same as food calorie. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"energy-foodcalorie\"]/displayName; Display name ({1} form) for \u201cenergy-foodcalorie\u201d, kilocalories for food energy; may have same translation as energy-kilocalorie. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"energy-kilocalorie\"]/displayName; Display name ({1} form) for \u201cenergy-kilocalorie\u201d, kilocalories for uses not specific to food energy, such as chemistry. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"graphics-em\"]/displayName; Display name ({1} form) for \u201cgraphics-em\u201d, referring to typographic length equal to a font\u2019s point size. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"graphics-pixel\"]/displayName; Display name ({1} form) for \u201cgraphics-pixel\u201d, used for counting the individual elements in bitmap image. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"graphics-megapixel\"]/displayName; Display name ({1} form) for \u201cgraphics-megapixel\u201d, used for counting the individual elements in bitmap image. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"graphics-pixel-per-centimeter\"]/displayName; Display name ({1} form) for \u201cgraphics-pixel-per-centimeter\u201d, typically used for display resolution. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"graphics-pixel-per-inch\"]/displayName; Display name ({1} form) for \u201cgraphics-pixel-per-inch\u201d, typically used for display resolution. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"graphics-dot-per-centimeter\"]/displayName; Display name ({1} form) for \u201cgraphics-dot-per-centimeter\u201d, typically used for printer resolution. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"graphics-dot-per-inch\"]/displayName; Display name ({1} form) for \u201cgraphics-dot-per-inch\u201d, typically used for printer resolution. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"length-point\"]/displayName; Display name ({1} form) for \u201clength-point\u201d, referring to a typographic point, 1/72 inch. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"mass-stone\"]/displayName; Display name ({1} form) for \u201cmass-stone\u201d, used in UK/Ireland for body weight, equal to 14 pounds. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"mass-ton\"]/displayName; Display name ({1} form) for \u201cmass-ton\u201d, meaning U.S. short ton, not U.K. long ton or metric ton. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"([^\"]*)\"]/displayName; Display name ({1} form) for \u201c{2}\u201d. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"([^\"]*)\"]/unitPattern; [ICU Syntax] Special pattern used to compose plural for {1} forms of \u201c{2}\u201d. Note: before translating, be sure to read https://cldr.unicode.org/translation/getting-started/plurals.\n^//ldml/units/unitLength\\[@type=\"([^\"]*)\"]/unit\\[@type=\"([^\"]*)\"]/perUnitPattern; Special pattern ({1} form) used to compose values per unit, such as \u201cmeters per {2}\u201d. Note: before translating, be sure to read https://cldr.unicode.org/translation/units.\n^//ldml/units/durationUnit\\[@type=\"(hms|hm|ms)\"]; [ICU Syntax] Special pattern used to compose duration units. Note: before translating, be sure to read https://cldr.unicode.org/translation/getting-started/plurals.\n^//ldml/numbers/decimalFormats/decimalFormatLength\\[@type=\"([^\"]*)\"]/decimalFormat\\[@type=\"([^\"]*)\"]/pattern\\[@type=\"([^\"]*)\"]; Special pattern used for a short version of numbers with the same number of digits as {3}. Note: before translating, be sure to read https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.eradhhuxzqqz.\n^//ldml/numbers/currencyFormats\\[@numberSystem=\"([^\"]*)\"]/currencyFormatLength\\[@type=\"short\"]/currencyFormat\\[@type=\"standard\"]/pattern\\[@type=\"(\\d+)\"]\\[@count=\"([^\"]+)\"]; Special currency pattern used to obtain the abbreviated plural forms of numbers with the same number of digits as {2}. See https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.eradhhuxzqqz for details.\n^//ldml/numbers/decimalFormats\\[@numberSystem=\"([^\"]*)\"]/decimalFormatLength\\[@type=\"short\"]/decimalFormat\\[@type=\"standard\"]/pattern\\[@type=\"(\\d+)\"]\\[@count=\"([^\"]+)\"]; Special decimal pattern used to obtain the abbreviated plural forms of numbers with the same number of digits as {2}. See https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.eradhhuxzqqz for details.\n^//ldml/numbers/decimalFormats\\[@numberSystem=\"([^\"]*)\"]/decimalFormatLength\\[@type=\"long\"]/decimalFormat\\[@type=\"standard\"]/pattern\\[@type=\"(\\d+)\"]\\[@count=\"([^\"]+)\"]; Special decimal pattern used to obtain the long plural forms of numbers with the same number of digits as {2}. See https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.mnb2fmj0pt72 for details.\n^//ldml/numbers/currencyFormats/currencyPatternAppendISO; Pattern used to combine a regular currency format with an ISO 4217 code (\u00a4\u00a4). For more information, please see https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/numbers/currencyFormats\\[@numberSystem=\"([^\"]*)\"]/currencyPatternAppendISO; Pattern used to combine a regular currency format with an ISO 4217 code (\u00a4\u00a4). For more information, please see https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/numbers/currencyFormats\\[@numberSystem=\"([^\"]*)\"]/unitPattern\\[@count=\"(\\w++)\"]; Currency format used for numbers of type {2}. For more information, please see https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/numbers/miscPatterns\\[@numberSystem=\"([^\"]*)\"]/pattern\\[@type=\"range\"]; Format used to indicate a range of numbers. The '{'0'}' and '{'1'}' in the pattern represent the lowest and highest numbers in the range, respectively. For more information, please see https://cldr.unicode.org/translation/units.\n^//ldml/numbers/miscPatterns\\[@numberSystem=\"([^\"]*)\"]/pattern\\[@type=\"atLeast\"]; Format used to indicate a number is at least a certain value, often combined with other patterns to produce examples such as \u201c\u226512kg\u201d. For more information, please see https://cldr.unicode.org/translation/units.\n^//ldml/numbers/miscPatterns\\[@numberSystem=\"([^\"]*)\"]/pattern\\[@type=\"atMost\"]; Format used to indicate a number is at most a certain value, often combined with other patterns to produce examples such as \u201c\u226412kg\u201d. For more information, please see https://cldr.unicode.org/translation/units.\n^//ldml/numbers/miscPatterns\\[@numberSystem=\"([^\"]*)\"]/pattern\\[@type=\"approximately\"]; Format used to indicate a number is approximately a given value, often combined with other patterns to produce examples such as \u201c~12kg\u201d. For more information, please see https://cldr.unicode.org/translation/units.\n^//ldml/numbers/minimalPairs/ordinalMinimalPairs\\[@ordinal=\"([^\"]*)\"]; Minimal pairs for ordinals. For more information, please see https://cldr.unicode.org/translation/getting-started/plurals#h.pnla5cp3nl4l.\n^//ldml/numbers/minimalPairs/pluralMinimalPairs\\[@count=\"([^\"]*)\"]; Minimal pairs for plurals (cardinals). For more information, please see https://cldr.unicode.org/translation/getting-started/plurals#h.pnla5cp3nl4l.\n^//ldml/numbers/minimalPairs/caseMinimalPairs\\[@case=\"([^\"]*)\"]; Minimal pairs for cases used in the language. For more information, please see https://cldr.unicode.org/translation/grammatical-inflection.\n^//ldml/numbers/minimalPairs/genderMinimalPairs\\[@gender=\"([^\"]*)\"]; Minimal pairs for genders. For more information, please see https://cldr.unicode.org/translation/grammatical-inflection.\n^//ldml/personNames/nameOrderLocales\\[@order=\"([^\"]*)\"]; Person name order for locales. If there are none with a particular direction, insert \u276eEMPTY\u276f. For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/personNames/foreignSpaceReplacement; For foreign personal names displayed in your locale, any special character that replaces a space (defaults to regular space). If spaces are to be removed, insert \u276eEMPTY\u276f. For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/personNames/initialPattern\\[@type=\"initial\"]; The pattern used for a single initial in person name formats. For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/personNames/initialPattern\\[@type=\"initialSequence\"]; The pattern used to compose sequences of initials in person name formats. For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/personNames/personName\\[@order=\"([^\"]*)\"]\\[@length=\"([^\"]*)\"]\\[@usage=\"referring\"]\\[@formality=\"([^\"]*)\"]; Person name formats for referring to a person (with a particular order, length, formality). For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/personNames/personName\\[@order=\"([^\"]*)\"]\\[@length=\"([^\"]*)\"]\\[@usage=\"addressing\"]\\[@formality=\"([^\"]*)\"]; Person name format for addressing a person (with a particular order, length, formality). For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/personNames/personName\\[@order=\"([^\"]*)\"]\\[@length=\"([^\"]*)\"]\\[@usage=\"monogram\"]\\[@formality=\"([^\"]*)\"]; Person name formats for monograms (with a particular order, length, formality). For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/personNames/sampleName; Sample names for person name format examples (enter \u2205\u2205\u2205 for optional unused fields). For more information, please see https://cldr.unicode.org/translation/miscellaneous-person-name-formats.\n^//ldml/numbers/([a-z]*)Formats(\\[@numberSystem=\"([^\"]*)\"])?/\\1FormatLength/\\1Format\\[@type=\"standard\"]/pattern\\[@type=\"standard\"]$; Special pattern used to compose {1} numbers. Note: before translating, be sure to read https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/numbers/currencyFormats\\[@numberSystem=\"([^\"]*)\"]/currencyFormatLength/currencyFormat\\[@type=\"standard\"]/pattern\\[@type=\"standard\"]\\[@alt=\"alphaNextToNumber\"]; Special pattern used to compose currency values when the currency symbol has a letter adjacent to the number. Note: before translating, be sure to read https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/numbers/currencyFormats\\[@numberSystem=\"([^\"]*)\"]/currencyFormatLength/currencyFormat\\[@type=\"standard\"]/pattern\\[@type=\"standard\"]\\[@alt=\"noCurrency\"]; Special pattern used to compose currency values for which no currency symbol should be shown. Note: before translating, be sure to read https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/numbers/currencyFormats\\[@numberSystem=\"([^\"]*)\"]/currencyFormatLength/currencyFormat\\[@type=\"accounting\"]/pattern; Special pattern used to compose currency values for accounting purposes. Note: before translating, be sure to read https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/numbers/currencyFormats/currencySpacing/([a-zA-Z]*)/([a-zA-Z]*); Special pattern used to compose currency signs ($1/$2) with numbers. Note: before translating, be sure to read https://cldr.unicode.org/translation/number-currency-formats/number-and-currency-patterns#h.j899g3kk2p1z.\n^//ldml/listPatterns/listPattern/listPatternPart\\[@type=\"2\"]; Special pattern used to make an \u201cand\u201d list out of two standard elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make a \u201cand\u201d list out of more than two standard elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"standard-short\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make a short-style \u201cand\u201d list out of two standard elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"standard-short\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make a short-style \u201cand\u201d list out of more than two standard elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"standard-narrow\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make a short-style \u201cand\u201d list out of two standard elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"standard-narrow\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make a short-style \u201cand\u201d list out of more than two standard elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"or\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make an \u201cor\u201d list out of two standard elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"or\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make an \u201cor\u201d list out of more than two standard elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"or-short\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make an \u201cor\u201d list out of two standard elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"or-short\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make an \u201cor\u201d list out of more than two standard elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"or-narrow\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make an \u201cor\u201d list out of two standard elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"or-narrow\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make an \u201cor\u201d list out of more than two standard elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"unit\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make a list out of two unit elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"unit\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make a list out of more than two unit elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"unit-short\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make a list out of two abbreviated unit elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"unit-short\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make a list out of more than two abbreviated unit elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"unit-narrow\"]/listPatternPart\\[@type=\"2\"]; Special pattern used to make a list out of two narrow unit elements. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/listPatterns/listPattern\\[@type=\"unit-narrow\"]/listPatternPart\\[@type=\"([^\"]*)\"]; Special pattern used to make a list out of more than two narrow unit elements. This is used for the {1} portion of the list. Note: before translating, be sure to read https://cldr.unicode.org/translation/miscellaneous-displaying-lists.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dayPeriods/dayPeriodContext\\[@type=\"(format)\"]/dayPeriodWidth\\[@type=\"([^\"]*)\"]/dayPeriod\\[@type=\"([^\"]*)\"]; Provide the {3}, {2} version of the name for the day period code \u201c{4}\u201d. This version must have the right inflection/prepositions/etc. for adding after a number, such as \u201cin the morning\u201d for use in \u201c10:00 in the morning\u201d. To see the time spans for these codes, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.ewzjebmpoi4k\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dayPeriods/dayPeriodContext\\[@type=\"([^\"]*)\"]/dayPeriodWidth\\[@type=\"([^\"]*)\"]/dayPeriod\\[@type=\"([^\"]*)\"]; Provide the {3}, {2} version of the name for the day period code \u201c{4}\u201d. To see the time spans for these codes, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.ewzjebmpoi4k\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/days/dayContext\\[@type=\"([^\"]*)\"]/dayWidth\\[@type=\"([^\"]*)\"]/day\\[@type=\"([^\"]*)\"]; Provide the {2} and {3} version of the name for day-of-the-week {4}. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/eras/eraAbbr/era\\[@type=\"([^\"]*)\"]; Provide the format-abbreviated version of the name for era {4}. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/eras/eraNames/era\\[@type=\"([^\"]*)\"]; Provide the format-wide version of the name for era {4}. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/eras/eraNarrow/era\\[@type=\"([^\"]*)\"]; Provide the format-narrow version of the name for era {4}. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/months/monthContext\\[@type=\"([^\"]*)\"]/monthWidth\\[@type=\"([^\"]*)\"]/month\\[@type=\"([^\"]*)\"]; Provide the {2} and {3} version of the name for month {4}. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/quarters/quarterContext\\[@type=\"([^\"]*)\"]/quarterWidth\\[@type=\"([^\"]*)\"]/quarter\\[@type=\"([^\"]*)\"]; Provide the {2} and {3} version of the name for quarter {4}. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/fields/field\\[@type=\"([^\"]*)\"]/displayName; Provide the name (as it would appear in menus) for the field \u201c{1}\u201d. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.8wfk3599ck9x.\n^//ldml/dates/fields/field\\[@type=\"day\"]/relative\\[@type=\"0\"]; Provide the name for today. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.aevw0tiix80v.\n^//ldml/dates/fields/field\\[@type=\"day\"]/relative\\[@type=\"-([^\"]*)\"]; Provide a name for the day, {1} before today. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.aevw0tiix80v.\n^//ldml/dates/fields/field\\[@type=\"day\"]/relative\\[@type=\"([^\"]*)\"]; Provide a name for the day, {1} after today. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.aevw0tiix80v.\n^//ldml/dates/fields/field\\[@type=\"([^\"]*)\"]/relative\\[@type=\"0\"]; Provide the name for \u201cthis {2}\u201d. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.aevw0tiix80v.\n^//ldml/dates/fields/field\\[@type=\"([^\"]*)\"]/relative\\[@type=\"-1\"]; Provide a name for \u201clast {1}\u201d. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.aevw0tiix80v.\n^//ldml/dates/fields/field\\[@type=\"([^\"]*)\"]/relative\\[@type=\"1\"]; Provide a name for \u201cnext {1}\u201d. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.aevw0tiix80v.\n^//ldml/dates/fields/field\\[@type=\"([^\"]*)\"]/relativeTime\\[@type=\"future\"]/relativeTimePattern\\[@count=\"([^\"]*)\"]; Provide a pattern used to display times in the future. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/fields/field\\[@type=\"([^\"]*)\"]/relativeTime\\[@type=\"past\"]/relativeTimePattern\\[@count=\"([^\"]*)\"]; Provide a pattern used to display times in the past. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/fields/field\\[@type=\"([^\"]*)\"]/relativePeriod; Provide a name for \u201cthe {1} of SOME_DATE\u201d. For more information, please see https://cldr.unicode.org/translation/date-time/datetime-names.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dateTimeFormats/dateTimeFormatLength\\[@type=\"([^\"]*)\"]/dateTimeFormat\\[@type=\"standard\"]/pattern\\[@type=\"([^\"]*)\"]; Provide the {2} version of the date-time pattern suitable for most use cases, including combining a date with a time range. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dateTimeFormats/dateTimeFormatLength\\[@type=\"([^\"]*)\"]/dateTimeFormat\\[@type=\"atTime\"]/pattern\\[@type=\"([^\"]*)\"]; Provide the {2} version of the date-time pattern suitable for expressing a date at a specific time. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dateFormats/dateFormatLength\\[@type=\"([^\"]*)\"]/dateFormat\\[@type=\"([^\"]*)\"]/pattern\\[@type=\"([^\"]*)\"]; Provide the {2} version of the basic date pattern. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/timeFormats/timeFormatLength\\[@type=\"([^\"]*)\"]/timeFormat\\[@type=\"([^\"]*)\"]/pattern\\[@type=\"([^\"]*)\"]; Provide the {2} version of the basic time pattern. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dateTimeFormats/availableFormats/dateFormatItem\\[@id=\"([^\"]*)\"]; Provide the pattern used in your language for the skeleton \u201c{2}\u201d. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dateTimeFormats/appendItems/appendItem\\[@request=\"([^\"]*)\"]; Provide the pattern used in your language to append a \u201c{2}\u201d to another format. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dateTimeFormats/intervalFormats/intervalFormatFallback; The pattern used for \u201cfallback\u201d with date/time intervals. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"([^\"]*)\"]/dateTimeFormats/intervalFormats/intervalFormatItem\\[@id=\"([^\"]*)\"]/greatestDifference\\[@id=\"([^\"]*)\"]; The pattern used for the date/time interval skeleton \u201c{2}\u201d when the greatest difference is \u201c{3}\u201d. Note: before translating, be sure to read https://cldr.unicode.org/translation/date-time/date-time-patterns.\n^//ldml/dates/calendars/calendar\\[@type=\"[^\"]*\"]/cyclicNameSets/cyclicNameSet\\[@type=\"([^\"]*)\"]/cyclicNameContext\\[@type=\"([^\"]*)\"]/cyclicNameWidth\\[@type=\"([^\"]*)\"]/cyclicName\\[@type=\"([^\"]*)\"]; Provide the {2} and {3} version of type {4} in the {1} name cycle. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.h0vy2eyzcj0n.\n^//ldml/dates/calendars/calendar\\[@type=\"[^\"]*\"]/monthPatterns/monthPatternContext\\[@type=\"([^\"]*)\"]/monthPatternWidth\\[@type=\"([^\"]*)\"]/monthPattern\\[@type=\"([^\"]*)\"]; Provide the {1} and {2} version of the name for {3} month types. For more information, please see https://cldr.unicode.org/translation/date-time/date-time-names#h.fww3pfyk0uwn.\n^//ldml/localeDisplayNames/transformNames/transformName\\[@type=\"([^\"]*)\"]; The name of the transform \u201c{1}\u201d. For more information, please see https://cldr.unicode.org/translation/transforms.\n^//ldml/localeDisplayNames/codePatterns/codePattern[@type=\"([^\"]*)\"]; The pattern to be used when displaying a name for a character {1}. For more information, please see https://cldr.unicode.org/translation/displaynames/languagelocale-name-patterns.\n^//ldml/localeDisplayNames/measurementSystemNames/measurementSystemName\\[@type=\"([^\"]*)\"]; The name of the measurement system \u201c{1}\u201d.  For more information, please see https://cldr.unicode.org/translation/units.\n^//ldml/posix/messages/(no|yes)str; The word for \u201c{1}\u201d, lowercased, plus any abbreviations separated by a colon. For more information, see https://cldr.unicode.org/translation/units.\n^//ldml/localeDisplayNames/annotationPatterns/annotationPattern[@type=\"([^\"]*)\"]; The pattern to be used when displaying a {1}. For more information, please see https://cldr.unicode.org/translation/displaynames/languagelocale-name-patterns.\n^//ldml/characters/stopwords/stopwordList\\[@type=\"([^\"]*)\"]; The words that should be ignored in sorting in your language.  For more information, see https://cldr.unicode.org/translation/units.\n^//ldml/dates/timeZoneNames/zone\\[@type=\"([^\"]*)\"]/([^/]*)/(.*); Override for the $3-$2 timezone name for $1.  For more information, see https://cldr.unicode.org/translation/time-zones-and-city-names.\n^//ldml/typographicNames/axisName[@type=\"([^\"]*)\"]; A label for a typographic design axis, such as \u201cWidth\u201d or \u201cWeight\u201d.  For more information, see https://cldr.unicode.org/translation/characters/typographic-names.\n^//ldml/typographicNames/styleName[@type=\"([^\"]*)\"][@subtype=\"([^\"]*)\"]; A label for a typographic style, such as \u201cNarrow\u201d or \u201cSemibold\u201d.  For more information, see https://cldr.unicode.org/translation/characters/typographic-names.\n^//ldml/typographicNames/featureName[@type=\"([^\"]*)\"]; A label for a typographic feature, such as \u201cSmall Capitals\u201d.  For more information, see https://cldr.unicode.org/translation/characters/typographic-names.\n^//ldml/characterLabels/characterLabelPattern\\[@type=\"([^\"]*)\"]\\[@count=\"([^\"]*)\"]; A label for a set of characters that has a numeric placeholder, such as \u201c1 Stroke\u201d, \u201c2 Strokes\u201d.  For more information, see https://cldr.unicode.org/translation/characters/character-labels.\n^//ldml/characterLabels/characterLabelPattern\\[@type=\"([^\"]*)\"]; A modifier composed with a label for a set of characters.  For more information, see https://cldr.unicode.org/translation/characters/character-labels.\n^//ldml/characterLabels/characterLabel\\[@type=\"([^\"]*)\"]; A label for a set of characters.  For more information, see https://cldr.unicode.org/translation/characters/character-labels.\n^//ldml/annotations/annotation\\[@cp=\"([^\"]*)\"]\\[@type=\"tts\"]; A name for a character or sequence. For more information, see https://cldr.unicode.org/translation/characters/short-names-and-keywords#h.4a8wthj27m74.\n^//ldml/annotations/annotation\\[@cp=\"([^\"]*)\"]; A set of keywords for a character or sequence.  For more information, see https://cldr.unicode.org/translation/characters/short-names-and-keywords#h.4a8wthj27m74.\n");
    private final CLDRFile english;
    private final Map<String, String> extras;
    private final ErrorHandling errorHandling;
    private final Map<String, List<Set<String>>> starredPaths;
    private final Set<String> allMetazones;
    private final Matcher metazoneMatcher = METAZONE_PATTERN.matcher("");
    private String starredPathOutput;
    private final Output<String[]> pathArguments = new Output();
    private final EnumSet<Status> status = EnumSet.noneOf(Status.class);
    public static final String MISSING_DESCRIPTION = "Before translating, please see https://cldr.unicode.org/translation/.";

    public PathDescription(SupplementalDataInfo supplementalDataInfo, CLDRFile english, Map<String, String> extras, Map<String, List<Set<String>>> starredPaths, ErrorHandling errorHandling) {
        this.english = english;
        this.extras = extras == null ? new HashMap() : extras;
        this.starredPaths = starredPaths == null ? new HashMap() : starredPaths;
        this.allMetazones = supplementalDataInfo.getAllMetazones();
        this.errorHandling = errorHandling;
    }

    public String getStarredPathOutput() {
        return this.starredPathOutput;
    }

    public EnumSet<Status> getStatus() {
        return this.status;
    }

    public String getRawDescription(String path, Object context) {
        this.status.clear();
        return pathHandling.get(path, context, this.pathArguments);
    }

    public String getDescription(String path, String value, Object context) {
        String type;
        this.status.clear();
        String description = pathHandling.get(path, context, this.pathArguments);
        if (description == null) {
            description = MISSING_DESCRIPTION;
        } else if ("SKIP".equals(description)) {
            this.status.add(Status.SKIP);
            if (this.errorHandling == ErrorHandling.SKIP) {
                return null;
            }
        }
        if (value == null) {
            String xpath = this.extras.get(path);
            if (xpath != null) {
                value = this.english.getStringValue(xpath);
            } else if (path.contains("/metazone") && this.metazoneMatcher.reset(path).matches()) {
                String name = this.metazoneMatcher.group(1);
                type = this.metazoneMatcher.group(3);
                value = name.replace('_', ' ') + (type.equals("generic") ? "" : (type.equals("daylight") ? " Summer" : " Winter")) + " Time";
            }
            if (value == null) {
                this.status.add(Status.NULL_VALUE);
                if (this.errorHandling == ErrorHandling.SKIP) {
                    return null;
                }
            }
        }
        if (value != null && ((String)value).length() == 0) {
            this.status.add(Status.EMPTY_CONTENT);
            if (this.errorHandling == ErrorHandling.SKIP) {
                return null;
            }
        }
        List<String> attributes = this.addStarredInfo(this.starredPaths, path);
        if (description.startsWith("ROOT")) {
            int typeEnd = description.indexOf(59);
            type = description.substring(4, typeEnd).trim();
            description = description.substring(typeEnd + 1).trim();
            boolean isMetazone = type.equals("metazone");
            Object code = attributes.get(0);
            boolean isRootCode = PathDescription.isRootCode((String)code, this.allMetazones, type, isMetazone);
            if (!isRootCode) {
                this.status.add(Status.NOT_REQUIRED);
                if (this.errorHandling == ErrorHandling.SKIP) {
                    return null;
                }
            }
            if (isMetazone) {
                XPathParts parts = XPathParts.getFrozenInstance(path);
                String daylightType = parts.getElement(-1);
                daylightType = daylightType.equals("daylight") ? "summer" : (daylightType.equals("standard") ? "winter" : daylightType);
                String length = parts.getElement(-2);
                length = length.equals("long") ? "" : "abbreviated ";
                code = (String)code + ", " + length + daylightType + " form";
            } else if (type.equals("timezone")) {
                String countryName;
                String country = ZONE2COUNTRY.get(code);
                int lastSlash = ((String)code).lastIndexOf(47);
                String codeName = lastSlash < 0 ? code : ((String)code).substring(lastSlash + 1).replace('_', ' ');
                boolean found = false;
                if ("001".equals(country)) {
                    code = "the timezone \u201c" + codeName + "\u201d";
                    found = true;
                } else if (country != null && (countryName = this.english.getName("territory", country)) != null) {
                    code = !codeName.equals(countryName) ? "the city \u201c" + codeName + "\u201d (in " + countryName + ")" : "the country \u201c" + codeName + "\u201d";
                    found = true;
                }
                if (!found) {
                    logger.warning("Missing country for timezone " + (String)code);
                }
            }
            description = MessageFormat.format(MessageFormat.autoQuoteApostrophe(description), code);
        } else if (path.contains("exemplarCity")) {
            String regionCode = ZONE2COUNTRY.get(attributes.get(0));
            String englishRegionName = this.english.getName(2, regionCode);
            description = MessageFormat.format(MessageFormat.autoQuoteApostrophe(description), englishRegionName);
        } else if (!MISSING_DESCRIPTION.equals(description)) {
            description = MessageFormat.format(MessageFormat.autoQuoteApostrophe(description), (Object[])this.pathArguments.value);
        }
        return description;
    }

    public String getPlaceholderDescription(String path) {
        Map<String, PatternPlaceholders.PlaceholderInfo> placeholders = PatternPlaceholders.getInstance().get(path);
        if (placeholders != null && placeholders.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("<table>");
            buffer.append("<tr><th>Placeholder</th><th>Meaning</th><th>Example</th></tr>");
            for (Map.Entry<String, PatternPlaceholders.PlaceholderInfo> entry : placeholders.entrySet()) {
                PatternPlaceholders.PlaceholderInfo info = entry.getValue();
                buffer.append("<tr>");
                buffer.append("<td>").append(entry.getKey()).append("</td>");
                buffer.append("<td>").append(info.name).append("</td>");
                buffer.append("<td>").append(info.example).append("</td>");
                buffer.append("</tr>");
            }
            buffer.append("</table>");
            return buffer.toString();
        }
        return "";
    }

    private static boolean isRootCode(String code, Set<String> allMetazones, String type, boolean isMetazone) {
        boolean isRootCode;
        Set<String> codes = isMetazone ? allMetazones : (type.equals("timezone") ? PathDescription.STANDARD_CODES.zoneParser.getZoneData().keySet() : STANDARD_CODES.getSurveyToolDisplayCodes(type));
        boolean bl = isRootCode = codes.contains(code) || code.contains("_");
        if (!isRootCode && type.equals("language") && EXTRA_LANGUAGES.contains(code)) {
            isRootCode = true;
        }
        return isRootCode;
    }

    private List<String> addStarredInfo(Map<String, List<Set<String>>> starredPaths, String path) {
        String starredPathString;
        Matcher starAttributeMatcher = STAR_ATTRIBUTE_PATTERN.matcher(path);
        StringBuilder starredPath = new StringBuilder();
        ArrayList<String> attributes = new ArrayList<String>();
        int lastEnd = 0;
        while (starAttributeMatcher.find()) {
            int start = starAttributeMatcher.start(1);
            int end = starAttributeMatcher.end(1);
            starredPath.append(path, lastEnd, start);
            starredPath.append(".*");
            attributes.add(path.substring(start, end));
            lastEnd = end;
        }
        starredPath.append(path.substring(lastEnd));
        this.starredPathOutput = starredPathString = starredPath.toString().intern();
        List attributeList = starredPaths.computeIfAbsent(starredPathString, k -> new ArrayList());
        int i = 0;
        for (String attribute : attributes) {
            Set<String> subset;
            if (attributeList.size() <= i) {
                subset = new TreeSet<String>();
                ((TreeSet)subset).add(attribute);
                attributeList.add(subset);
            } else {
                subset = (Set)attributeList.get(i);
                subset.add(attribute);
            }
            ++i;
        }
        return attributes;
    }

    public static enum Status {
        SKIP,
        NULL_VALUE,
        EMPTY_CONTENT,
        NOT_REQUIRED;

    }

    public static enum ErrorHandling {
        SKIP,
        CONTINUE;

    }
}

