/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.unicode.cldr.util.CompactStringByteConverter;
import org.unicode.cldr.util.Dictionary;
import org.unicode.cldr.util.IntMap;
import org.unicode.cldr.util.StateDictionary;
import org.unicode.cldr.util.StringByteConverter;

public class StateDictionaryBuilder<T>
implements Dictionary.DictionaryBuilder<T> {
    private static final boolean SHOW_SIZE = true;
    private StateDictionary.Row buildingCurrentAddRow;
    private int builtTotalBytes;
    private int builtTotalStrings;
    private ArrayList<StateDictionary.Row> builtRows;
    private StateDictionary.Row builtBaseRow;
    private IntMap<T> builtResults;
    private int builtMaxByteLength;
    private StringByteConverter byteConverter = new CompactStringByteConverter(true);
    private IntMap.IntMapFactory<T> intMapFactory = new IntMap.BasicIntMapFactory();
    static final Comparator<byte[]> SHORTER_BYTE_ARRAY_COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] o1, byte[] o2) {
            int minLen = o1.length;
            if (minLen > o2.length) {
                minLen = o2.length;
            }
            for (int i = 0; i < minLen; ++i) {
                if (o1[i] == o2[i]) continue;
                return o1[i] < o2[i] ? -1 : 1;
            }
            return o1.length < o2.length ? -1 : (o1.length > o2.length ? 1 : 0);
        }
    };

    public IntMap.IntMapFactory<T> getIntMapFactory() {
        return this.intMapFactory;
    }

    public StateDictionaryBuilder<T> setIntMapFactory(IntMap.IntMapFactory<T> intMapFactory) {
        this.intMapFactory = intMapFactory;
        return this;
    }

    public StringByteConverter getByteConverter() {
        return this.byteConverter;
    }

    public StateDictionaryBuilder<T> setByteConverter(StringByteConverter byteConverter) {
        this.byteConverter = byteConverter;
        return this;
    }

    @Override
    public StateDictionary<T> make(Map<CharSequence, T> source) {
        this.buildingCurrentAddRow = null;
        this.builtMaxByteLength = 0;
        this.builtTotalStrings = 0;
        this.builtTotalBytes = 0;
        this.builtRows = new ArrayList();
        this.builtBaseRow = this.makeRow();
        this.builtResults = this.intMapFactory.make(source.values());
        System.out.println("***VALUE STORAGE: " + this.builtResults.approximateStorage());
        Map<T, Integer> valueToInt = this.builtResults.getValueMap();
        TreeMap<byte[], Integer> sorted = new TreeMap<byte[], Integer>(SHORTER_BYTE_ARRAY_COMPARATOR);
        for (CharSequence text : source.keySet()) {
            sorted.put(this.byteConverter.toBytes(text), valueToInt.get(source.get(text)));
        }
        for (byte[] key : sorted.keySet()) {
            this.addMapping(key, (Integer)sorted.get(key));
        }
        HashMap<StateDictionary.Row, StateDictionary.Row> replacements = new HashMap<StateDictionary.Row, StateDictionary.Row>();
        TreeMap<StateDictionary.Row, StateDictionary.Row> equivalents = new TreeMap<StateDictionary.Row, StateDictionary.Row>(StateDictionary.rowComparator);
        for (StateDictionary.Row row : this.builtRows) {
            StateDictionary.Row cardinal = (StateDictionary.Row)equivalents.get(row);
            if (cardinal == null) {
                equivalents.put(row, row);
                continue;
            }
            replacements.put(row, cardinal);
        }
        System.out.println("***ROWS: " + this.builtRows.size() + "\t REPLACEMENTS: " + replacements.size());
        for (StateDictionary.Row row : this.builtRows) {
            for (Byte key : row.byteToCell.keySet()) {
                StateDictionary.Cell cell = row.byteToCell.get(key);
                StateDictionary.Row newRow = (StateDictionary.Row)replacements.get(cell.nextRow);
                if (newRow == null) continue;
                cell.nextRow = newRow;
            }
        }
        ArrayList<StateDictionary.Row> newRows = new ArrayList<StateDictionary.Row>();
        for (StateDictionary.Row row : this.builtRows) {
            if (replacements.containsKey(row)) continue;
            newRows.add(row);
        }
        this.setUniqueValues(this.builtBaseRow);
        this.builtRows = newRows;
        System.out.println("***ROWS: " + this.builtRows.size());
        return new StateDictionary<T>(this.builtBaseRow, this.builtRows, this.builtResults, this.builtMaxByteLength, this.byteConverter);
    }

    private StateDictionary.Row makeRow() {
        StateDictionary.Row row = new StateDictionary.Row(this.builtRows.size());
        this.builtRows.add(row);
        return row;
    }

    private void addMapping(byte[] key, int result) {
        this.buildingCurrentAddRow = this.builtBaseRow;
        int lastIndex = key.length - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            result = this.add(key[i], result, i == lastIndex);
        }
        this.builtTotalBytes += key.length;
        ++this.builtTotalStrings;
        if (this.builtMaxByteLength < key.length) {
            this.builtMaxByteLength = key.length;
        }
    }

    private int add(byte key, int result, boolean last) {
        StateDictionary.Cell matchingCell = this.buildingCurrentAddRow.byteToCell.get(key);
        if (matchingCell != null) {
            if (matchingCell.nextRow == null && !last) {
                matchingCell.nextRow = this.makeRow();
                --this.buildingCurrentAddRow.terminatingReturnCount;
            }
            this.buildingCurrentAddRow = matchingCell.nextRow;
            return result - matchingCell.deltaResult;
        }
        StateDictionary.Cell cell = new StateDictionary.Cell();
        this.buildingCurrentAddRow.byteToCell.put(key, cell);
        cell.deltaResult = result;
        if (last) {
            cell.returns = true;
            ++this.buildingCurrentAddRow.returnCount;
            ++this.buildingCurrentAddRow.terminatingReturnCount;
        } else {
            cell.nextRow = this.buildingCurrentAddRow = this.makeRow();
        }
        return 0;
    }

    private boolean setUniqueValues(StateDictionary.Row currentRow) {
        if (currentRow.hasUniqueValue == StateDictionary.Row.Uniqueness.UNIQUE) {
            return true;
        }
        for (StateDictionary.Cell cell : currentRow.byteToCell.values()) {
            if (cell.nextRow != null && !this.setUniqueValues(cell.nextRow)) {
                currentRow.hasUniqueValue = StateDictionary.Row.Uniqueness.AMBIGUOUS;
                continue;
            }
            if (cell.deltaResult == 0) continue;
            currentRow.hasUniqueValue = StateDictionary.Row.Uniqueness.AMBIGUOUS;
        }
        if (currentRow.hasUniqueValue == StateDictionary.Row.Uniqueness.AMBIGUOUS) {
            return false;
        }
        currentRow.hasUniqueValue = StateDictionary.Row.Uniqueness.UNIQUE;
        return true;
    }
}

