/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.VettingViewer;
import org.unicode.cldr.util.VoteResolver;
import org.unicode.cldr.util.VoterInfoList;
import org.unicode.cldr.util.XMLSource;

public class VotelessUsersChoice
implements VettingViewer.UsersChoice<Organization> {
    final PathHeader.Factory phf = PathHeader.getFactory();
    static final VoterInfoList noUsers = new VoterInfoList();

    @Override
    public String getWinningValueForUsersOrganization(CLDRFile cldrFile, String path, Organization org) {
        CLDRLocale loc = CLDRLocale.getInstance(cldrFile.getLocaleID());
        return this.getVoteResolver(cldrFile, loc, path).getOrgVote(org);
    }

    @Override
    public VettingViewer.VoteStatus getStatusForUsersOrganization(CLDRFile cldrFile, String path, Organization org) {
        CLDRLocale loc = CLDRLocale.getInstance(cldrFile.getLocaleID());
        return this.getVoteResolver(cldrFile, loc, path).getStatusForOrganization(org);
    }

    @Override
    public VoteResolver<String> getVoteResolver(CLDRFile cldrFile, CLDRLocale loc, String path) {
        VoteResolver<String> r = new VoteResolver<String>(noUsers);
        r.setLocale(loc, this.phf.fromPath(path));
        String baileyValue = cldrFile.getBaileyValue(path, null, null);
        r.setBaileyValue(baileyValue);
        XMLSource xmlSource = cldrFile.dataSource;
        String baselineValue = xmlSource.isHere(path) ? xmlSource.getValueAtDPath(path) : null;
        VoteResolver.Status status = VoteResolver.calculateStatus(cldrFile, path);
        r.setBaseline(baselineValue, status);
        return r;
    }

    @Override
    public boolean userDidVote(int userId, CLDRLocale loc, String path) {
        return false;
    }
}

