/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.CanonicalIterator;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ShortestCanonicalForm {
    static final UnicodeSet trailing = new UnicodeSet();
    static final UnicodeSet leading = new UnicodeSet();
    static final UnicodeSet leading3 = new UnicodeSet();
    static UTF16.StringComparator cpCompare = new UTF16.StringComparator(true, false, 0);
    static final Map<Integer, Set<String>> leadToTrail = new TreeMap<Integer, Set<String>>();
    static UnicodeSet skip = new UnicodeSet("[[:hangulsyllabletype=l:][:hangulsyllabletype=v:][:hangulsyllabletype=t:]]");
    static Map<String, String> restoreExclusions = new TreeMap<String, String>();
    static UnicodeSet breakingTrail = new UnicodeSet();
    CanonicalIterator ci = new CanonicalIterator("");

    private static String shortNFC(String trial) {
        String result = Normalizer.normalize(trial, Normalizer.NFC);
        result = result.replace("\u0308\u0301", "\u0344");
        for (String exclusion : restoreExclusions.keySet()) {
            result = result.replace(exclusion, restoreExclusions.get(exclusion));
        }
        return result;
    }

    private static String getShortest(String trial, String nfc) {
        String best = nfc;
        int bestLength = nfc.codePointCount(0, nfc.length());
        CanonicalIterator ci = new CanonicalIterator(trial);
        String s2 = ci.next();
        while (s2 != null) {
            int currentLength = s2.codePointCount(0, s2.length());
            if (currentLength < bestLength) {
                bestLength = currentLength;
                best = s2;
            }
            s2 = ci.next();
        }
        return best;
    }

    public String normalize(String input) {
        int cp;
        StringBuffer b = new StringBuffer();
        boolean inProblem = false;
        int start = 0;
        int len = input.length();
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = input.codePointAt(i);
            boolean isNFD = trailing.contains(cp);
            if (isNFD) {
                if (inProblem) continue;
                b.append(this.process(input, start, i));
                start = i;
                continue;
            }
            inProblem = true;
        }
        if (start < len) {
            b.append(this.process(input, start, len));
        }
        return b.toString();
    }

    private String process(String input, int start, int end) {
        String piece = input.substring(start, end);
        String nfc = ShortestCanonicalForm.shortNFC(piece);
        int nfcLength = nfc.codePointCount(0, nfc.length());
        if (nfcLength == 1) {
            return piece;
        }
        this.ci.setSource(piece);
        String best = null;
        int bestLength = Integer.MAX_VALUE;
        String trial = this.ci.next();
        while (trial != null) {
            int len = trial.codePointCount(0, trial.length());
            if (len < bestLength) {
                best = trial;
                bestLength = len;
            }
            trial = this.ci.next();
        }
        if (nfcLength <= bestLength) {
            return nfc;
        }
        return best;
    }

    public static void main(String[] args) {
        ShortestCanonicalForm scf = new ShortestCanonicalForm();
        for (int i = 0; i <= 0x10FFFF; ++i) {
            String s2 = UTF16.valueOf(i);
            String nfc = ShortestCanonicalForm.shortNFC(s2);
            String shortest = scf.normalize(nfc);
            if (shortest.equals(nfc)) continue;
            System.out.println("NFC not shortest: " + shortest + ", " + nfc);
        }
    }

    static {
        for (int i = 0; i <= 0x10FFFF; ++i) {
            int nfdLen;
            String nfd = Normalizer.normalize(i, Normalizer.NFD);
            if (skip.containsAll(nfd)) continue;
            String nfc = Normalizer.normalize(i, Normalizer.NFC);
            if (nfc.codePointCount(0, nfc.length()) > 1) {
                restoreExclusions.put(nfc, UTF16.valueOf(i));
                int first = nfc.codePointAt(0);
                String trailingString = nfc.substring(first > 65535 ? 2 : 1);
                breakingTrail.addAll(trailingString);
            }
            if ((nfdLen = nfd.codePointCount(0, nfd.length())) <= 1) continue;
            int first = nfd.codePointAt(0);
            leading.add(first);
            String trailingString = nfd.substring(first > 65535 ? 2 : 1);
            trailing.addAll(trailingString);
            Set<String> trails = leadToTrail.get(first);
            if (trails == null) {
                trails = new TreeSet<String>(cpCompare);
                leadToTrail.put(first, trails);
            }
            trails.add(trailingString);
            if (UScript.getScript(i) == 18 || trailingString.codePointCount(0, trailingString.length()) <= 1) continue;
            leading3.add(first);
        }
        leading.freeze();
        trailing.freeze();
        for (int first : leadToTrail.keySet()) {
            if (!leading3.contains(first)) continue;
            for (String trail : leadToTrail.get(first)) {
                System.out.println(Utility.hex(first, 4) + "," + Utility.hex(trail, 4, ",") + "\t" + UTF16.valueOf(first) + trail);
            }
        }
        System.out.println("Breaking Trail:\t" + breakingTrail);
        System.out.println("Lead-only: " + new UnicodeSet(leading).removeAll(trailing));
        System.out.println("Trail-only: " + new UnicodeSet(trailing).removeAll(leading));
        System.out.println("Lead and trail: " + new UnicodeSet(leading).retainAll(trailing));
        UnicodeSet blockers = new UnicodeSet();
        for (int lead : leadToTrail.keySet()) {
            String leadStr = UTF16.valueOf(lead);
            System.out.println("Testing: " + leadStr);
            Set<String> trails = leadToTrail.get(lead);
            for (String trail1 : trails) {
                for (String trail2 : trails) {
                    if (trail1.length() >= trail2.length()) continue;
                    SubstringIterator it = new SubstringIterator(trail1);
                    while (it.hasNext()) {
                        int blocker;
                        String nfc;
                        String sub = (String)it.next();
                        String trial = leadStr + sub + trail2;
                        String shortest = ShortestCanonicalForm.getShortest(trial, nfc = ShortestCanonicalForm.shortNFC(trial));
                        if (shortest.equals(nfc) || blockers.contains(blocker = nfc.codePointAt(0))) continue;
                        blockers.add(blocker);
                        System.out.println("Adding blocker: " + Utility.hex(blocker, 4) + "\t" + UTF16.valueOf(blocker));
                        System.out.println("\tNFC: " + Utility.hex(nfc) + "\t" + nfc);
                        System.out.println("\tShort: " + Utility.hex(shortest) + "\t" + shortest);
                    }
                }
            }
        }
        System.out.println("Blockers: " + blockers);
    }

    static class SubstringIterator
    implements Iterator<String> {
        String string;
        int start;
        int end;

        public SubstringIterator(String s2) {
            this.string = s2;
            this.start = 0;
            this.end = UCharacter.charCount(this.string.codePointAt(this.start));
        }

        @Override
        public boolean hasNext() {
            return this.start < this.string.length();
        }

        @Override
        public String next() {
            String result = this.string.substring(this.start, this.end);
            if (this.end < this.string.length()) {
                this.end += UCharacter.charCount(this.string.codePointAt(this.end));
            } else {
                this.start += UCharacter.charCount(this.string.codePointAt(this.start));
                if (this.start < this.string.length()) {
                    this.end = this.start + UCharacter.charCount(this.string.codePointAt(this.start));
                }
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

